/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document.mongo;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.Striped;
import com.google.common.util.concurrent.UncheckedExecutionException;
import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.MongoClientURI;
import com.mongodb.MongoException;
import com.mongodb.QueryBuilder;
import com.mongodb.ReadPreference;
import com.mongodb.WriteConcern;
import com.mongodb.WriteResult;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.jackrabbit.oak.cache.CacheStats;
import org.apache.jackrabbit.oak.cache.CacheValue;
import org.apache.jackrabbit.oak.plugins.document.CachedNodeDocument;
import org.apache.jackrabbit.oak.plugins.document.Collection;
import org.apache.jackrabbit.oak.plugins.document.Document;
import org.apache.jackrabbit.oak.plugins.document.DocumentMK;
import org.apache.jackrabbit.oak.plugins.document.DocumentStore;
import org.apache.jackrabbit.oak.plugins.document.DocumentStoreException;
import org.apache.jackrabbit.oak.plugins.document.NodeDocument;
import org.apache.jackrabbit.oak.plugins.document.Revision;
import org.apache.jackrabbit.oak.plugins.document.StableRevisionComparator;
import org.apache.jackrabbit.oak.plugins.document.UpdateOp;
import org.apache.jackrabbit.oak.plugins.document.UpdateUtils;
import org.apache.jackrabbit.oak.plugins.document.cache.CacheInvalidationStats;
import org.apache.jackrabbit.oak.plugins.document.cache.ForwardingListener;
import org.apache.jackrabbit.oak.plugins.document.cache.NodeDocOffHeapCache;
import org.apache.jackrabbit.oak.plugins.document.cache.OffHeapCache;
import org.apache.jackrabbit.oak.plugins.document.mongo.CacheInvalidator;
import org.apache.jackrabbit.oak.plugins.document.mongo.RevisionEntry;
import org.apache.jackrabbit.oak.plugins.document.util.StringValue;
import org.apache.jackrabbit.oak.plugins.document.util.Utils;
import org.apache.jackrabbit.oak.stats.Clock;
import org.apache.jackrabbit.oak.util.PerfLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoDocumentStore
implements DocumentStore {
    private static final Logger LOG = LoggerFactory.getLogger(MongoDocumentStore.class);
    private static final PerfLogger PERFLOG = new PerfLogger(LoggerFactory.getLogger((String)(MongoDocumentStore.class.getName() + ".perf")));
    private static final DBObject BY_ID_ASC = new BasicDBObject("_id", (Object)1);
    public static final int IN_CLAUSE_BATCH_SIZE = 500;
    private final DBCollection nodes;
    private final DBCollection clusterNodes;
    private final DBCollection settings;
    private long timeSum;
    private final Cache<CacheValue, NodeDocument> nodesCache;
    private final CacheStats cacheStats;
    private final Striped<Lock> locks = Striped.lock((int)128);
    private final Striped<ReadWriteLock> parentLocks = Striped.readWriteLock((int)64);
    private final Comparator<Revision> comparator = StableRevisionComparator.REVERSE;
    private Clock clock = Clock.SIMPLE;
    private final long maxReplicationLagMillis;
    private final long maxDeltaForModTimeIdxSecs = Long.getLong("oak.mongo.maxDeltaForModTimeIdxSecs", 60L);
    private final boolean disableIndexHint = Boolean.getBoolean("oak.mongo.disableIndexHint");
    private final long maxQueryTimeMS = Long.getLong("oak.mongo.maxQueryTimeMS", TimeUnit.MINUTES.toMillis(1L));
    private String lastReadWriteMode;
    private final Map<String, String> metadata;

    public MongoDocumentStore(DB db, DocumentMK.Builder builder) {
        String version = MongoDocumentStore.checkVersion(db);
        this.metadata = ImmutableMap.builder().put((Object)"type", (Object)"mongo").put((Object)"version", (Object)version).build();
        this.nodes = db.getCollection(Collection.NODES.toString());
        this.clusterNodes = db.getCollection(Collection.CLUSTER_NODES.toString());
        this.settings = db.getCollection(Collection.SETTINGS.toString());
        this.maxReplicationLagMillis = builder.getMaxReplicationLagMillis();
        BasicDBObject index = new BasicDBObject();
        index.put("_modified", (Object)-1L);
        BasicDBObject options = new BasicDBObject();
        options.put("unique", (Object)Boolean.FALSE);
        this.nodes.ensureIndex((DBObject)index, (DBObject)options);
        index = new BasicDBObject();
        index.put("_bin", (Object)1);
        options = new BasicDBObject();
        options.put("unique", (Object)Boolean.FALSE);
        options.put("sparse", (Object)Boolean.TRUE);
        this.nodes.ensureIndex((DBObject)index, (DBObject)options);
        index = new BasicDBObject();
        index.put("_deletedOnce", (Object)1);
        options = new BasicDBObject();
        options.put("unique", (Object)Boolean.FALSE);
        options.put("sparse", (Object)Boolean.TRUE);
        this.nodes.ensureIndex((DBObject)index, (DBObject)options);
        index = new BasicDBObject();
        index.put("_sdType", (Object)1);
        options = new BasicDBObject();
        options.put("unique", (Object)Boolean.FALSE);
        options.put("sparse", (Object)Boolean.TRUE);
        this.nodes.ensureIndex((DBObject)index, (DBObject)options);
        this.nodesCache = builder.useOffHeapCache() ? this.createOffHeapCache(builder) : builder.buildDocumentCache(this);
        this.cacheStats = new CacheStats(this.nodesCache, "Document-Documents", builder.getWeigher(), builder.getDocumentCacheSize());
        LOG.info("Configuration maxReplicationLagMillis {}, maxDeltaForModTimeIdxSecs {}, disableIndexHint {}", new Object[]{this.maxReplicationLagMillis, this.maxDeltaForModTimeIdxSecs, this.disableIndexHint});
    }

    private static String checkVersion(DB db) {
        String version = db.command("buildInfo").getString("version");
        Matcher m = Pattern.compile("^(\\d+)\\.(\\d+)\\..*").matcher(version);
        if (!m.matches()) {
            throw new IllegalArgumentException("Malformed MongoDB version: " + version);
        }
        int major = Integer.parseInt(m.group(1));
        int minor = Integer.parseInt(m.group(2));
        if (major > 2) {
            return version;
        }
        if (minor < 6) {
            String msg = "MongoDB version 2.6.0 or higher required. Currently connected to a MongoDB with version: " + version;
            throw new RuntimeException(msg);
        }
        return version;
    }

    private Cache<CacheValue, NodeDocument> createOffHeapCache(DocumentMK.Builder builder) {
        ForwardingListener<CacheValue, NodeDocument> listener = ForwardingListener.newInstance();
        Cache primaryCache = CacheBuilder.newBuilder().weigher(builder.getWeigher()).maximumWeight(builder.getDocumentCacheSize()).removalListener(listener).recordStats().build();
        return new NodeDocOffHeapCache((Cache<CacheValue, NodeDocument>)primaryCache, listener, builder, this);
    }

    public void finalize() throws Throwable {
        super.finalize();
        this.dispose();
    }

    @Override
    public CacheInvalidationStats invalidateCache() {
        return CacheInvalidator.createHierarchicalInvalidator(this).invalidateCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends Document> void invalidateCache(Collection<T> collection, String key) {
        if (collection == Collection.NODES) {
            TreeLock lock = this.acquire(key);
            try {
                this.nodesCache.invalidate((Object)new StringValue(key));
            }
            finally {
                lock.unlock();
            }
        }
    }

    public <T extends Document> void invalidateCache(Collection<T> collection, List<String> keys) {
        for (String key : keys) {
            this.invalidateCache(collection, key);
        }
    }

    @Override
    public <T extends Document> T find(Collection<T> collection, String key) {
        long start = PERFLOG.start();
        T result = this.find(collection, key, true, -1);
        PERFLOG.end(start, 1L, "find: preferCached=true, key={}", (Object)key);
        return result;
    }

    @Override
    public <T extends Document> T find(Collection<T> collection, String key, int maxCacheAge) {
        long start = PERFLOG.start();
        T result = this.find(collection, key, false, maxCacheAge);
        PERFLOG.end(start, 1L, "find: preferCached=false, key={}", (Object)key);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends Document> T find(final Collection<T> collection, final String key, boolean preferCached, final int maxCacheAge) {
        Throwable t;
        NodeDocument doc;
        if (collection != Collection.NODES) {
            return this.findUncachedWithRetry(collection, key, DocumentReadPreference.PRIMARY, 2);
        }
        StringValue cacheKey = new StringValue(key);
        if ((maxCacheAge > 0 || preferCached) && (doc = (NodeDocument)this.nodesCache.getIfPresent((Object)cacheKey)) != null && (preferCached || this.getTime() - doc.getCreated() < (long)maxCacheAge)) {
            if (doc == NodeDocument.NULL) {
                return null;
            }
            return (T)doc;
        }
        try {
            TreeLock lock = this.acquire(key);
            try {
                if (maxCacheAge == 0) {
                    this.invalidateCache(collection, key);
                }
                while (true) {
                    doc = (NodeDocument)this.nodesCache.get((Object)cacheKey, (Callable)new Callable<NodeDocument>(){

                        @Override
                        public NodeDocument call() throws Exception {
                            NodeDocument doc = (NodeDocument)MongoDocumentStore.this.findUncachedWithRetry(collection, key, MongoDocumentStore.this.getReadPreference(maxCacheAge), 2);
                            if (doc == null) {
                                doc = NodeDocument.NULL;
                            }
                            return doc;
                        }
                    });
                    if (maxCacheAge == 0) break;
                    if (preferCached) {
                        break;
                    }
                    if (this.getTime() - doc.getCreated() < (long)maxCacheAge) {
                        break;
                    }
                    this.invalidateCache(collection, key);
                }
            }
            finally {
                lock.unlock();
            }
            if (doc == NodeDocument.NULL) {
                return null;
            }
            return (T)doc;
        }
        catch (UncheckedExecutionException e) {
            t = e.getCause();
        }
        catch (ExecutionException e) {
            t = e.getCause();
        }
        throw new DocumentStoreException("Failed to load document with " + key, t);
    }

    @CheckForNull
    private <T extends Document> T findUncachedWithRetry(Collection<T> collection, String key, DocumentReadPreference docReadPref, int retries) {
        Preconditions.checkArgument((retries >= 0 ? 1 : 0) != 0, (Object)"retries must not be negative");
        int numAttempts = retries + 1;
        MongoException ex = null;
        for (int i = 0; i < numAttempts; ++i) {
            if (i > 0) {
                LOG.warn("Retrying read of " + key);
            }
            try {
                return this.findUncached(collection, key, docReadPref);
            }
            catch (MongoException e) {
                ex = e;
                continue;
            }
        }
        if (ex != null) {
            throw ex;
        }
        throw new IllegalStateException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CheckForNull
    protected <T extends Document> T findUncached(Collection<T> collection, String key, DocumentReadPreference docReadPref) {
        MongoDocumentStore.log("findUncached", new Object[]{key, docReadPref});
        DBCollection dbCollection = this.getDBCollection(collection);
        long start = PERFLOG.start();
        boolean isSlaveOk = false;
        try {
            DBObject obj;
            ReadPreference readPreference = this.getMongoReadPreference(collection, Utils.getParentId(key), docReadPref);
            if (readPreference.isSlaveOk()) {
                LOG.trace("Routing call to secondary for fetching [{}]", (Object)key);
                isSlaveOk = true;
            }
            if ((obj = dbCollection.findOne(MongoDocumentStore.getByKeyQuery(key).get(), null, null, readPreference)) == null && readPreference.isSlaveOk()) {
                obj = dbCollection.findOne(MongoDocumentStore.getByKeyQuery(key).get(), null, null, ReadPreference.primary());
            }
            if (obj == null) {
                T t = null;
                return t;
            }
            T doc = this.convertFromDBObject(collection, obj);
            if (doc != null) {
                ((Document)doc).seal();
            }
            T t = doc;
            return t;
        }
        finally {
            PERFLOG.end(start, 1L, "findUncached on key={}, isSlaveOk={}", (Object)key, (Object)isSlaveOk);
        }
    }

    @Override
    @Nonnull
    public <T extends Document> List<T> query(Collection<T> collection, String fromKey, String toKey, int limit) {
        return this.query(collection, fromKey, toKey, null, 0L, limit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public <T extends Document> List<T> query(Collection<T> collection, String fromKey, String toKey, String indexedProperty, long startValue, int limit) {
        MongoDocumentStore.log("query", fromKey, toKey, indexedProperty, startValue, limit);
        DBCollection dbCollection = this.getDBCollection(collection);
        QueryBuilder queryBuilder = QueryBuilder.start((String)"_id");
        queryBuilder.greaterThan((Object)fromKey);
        queryBuilder.lessThan((Object)toKey);
        BasicDBObject hint = new BasicDBObject("_id", (Object)1);
        if (indexedProperty != null) {
            if ("_deletedOnce".equals(indexedProperty)) {
                if (startValue != 1L) {
                    throw new DocumentStoreException("unsupported value for property _deletedOnce");
                }
                queryBuilder.and(indexedProperty);
                queryBuilder.is((Object)true);
            } else {
                queryBuilder.and(indexedProperty);
                queryBuilder.greaterThanEquals((Object)startValue);
                if ("_modified".equals(indexedProperty) && this.canUseModifiedTimeIdx(startValue)) {
                    hint = new BasicDBObject("_modified", (Object)-1);
                }
            }
        }
        DBObject query = queryBuilder.get();
        String parentId = Utils.getParentIdFromLowerLimit(fromKey);
        TreeLock lock = this.acquireExclusive(parentId != null ? parentId : "");
        long start = PERFLOG.start();
        try {
            ArrayList<T> list;
            ReadPreference readPreference;
            DBCursor cursor = dbCollection.find(query).sort(BY_ID_ASC);
            if (!this.disableIndexHint) {
                cursor.hint((DBObject)hint);
            }
            if (this.maxQueryTimeMS > 0L) {
                cursor.maxTime(this.maxQueryTimeMS, TimeUnit.MILLISECONDS);
            }
            if ((readPreference = this.getMongoReadPreference(collection, parentId, this.getDefaultReadPreference(collection))).isSlaveOk()) {
                LOG.trace("Routing call to secondary for fetching children from [{}] to [{}]", (Object)fromKey, (Object)toKey);
            }
            cursor.setReadPreference(readPreference);
            try {
                list = new ArrayList<T>();
                for (int i = 0; i < limit && cursor.hasNext(); ++i) {
                    DBObject o = cursor.next();
                    T doc = this.convertFromDBObject(collection, o);
                    if (collection == Collection.NODES && doc != null) {
                        ((Document)doc).seal();
                        String id = ((Document)doc).getId();
                        StringValue cacheKey = new StringValue(id);
                        NodeDocument cached = (NodeDocument)this.nodesCache.getIfPresent((Object)cacheKey);
                        if (cached != null && cached != NodeDocument.NULL) {
                            Number cachedModCount = cached.getModCount();
                            Number modCount = ((Document)doc).getModCount();
                            if (cachedModCount == null || modCount == null) {
                                throw new IllegalStateException("Missing _modCount");
                            }
                            if (modCount.longValue() > cachedModCount.longValue()) {
                                this.nodesCache.put((Object)cacheKey, (Object)((NodeDocument)doc));
                            }
                        } else {
                            this.nodesCache.put((Object)cacheKey, (Object)((NodeDocument)doc));
                        }
                    }
                    list.add(doc);
                }
            }
            finally {
                cursor.close();
            }
            ArrayList<T> arrayList = list;
            return arrayList;
        }
        finally {
            lock.unlock();
            PERFLOG.end(start, 1L, "query for children from [{}] to [{}]", (Object)fromKey, (Object)toKey);
        }
    }

    boolean canUseModifiedTimeIdx(long modifiedTimeInSecs) {
        if (this.maxDeltaForModTimeIdxSecs < 0L) {
            return false;
        }
        return NodeDocument.getModifiedInSecs(this.getTime()) - modifiedTimeInSecs <= this.maxDeltaForModTimeIdxSecs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends Document> void remove(Collection<T> collection, String key) {
        MongoDocumentStore.log("remove", key);
        DBCollection dbCollection = this.getDBCollection(collection);
        long start = PERFLOG.start();
        try {
            WriteResult writeResult = dbCollection.remove(MongoDocumentStore.getByKeyQuery(key).get());
            this.invalidateCache(collection, key);
            if (writeResult.getError() != null) {
                throw new DocumentStoreException("Remove failed: " + writeResult.getError());
            }
        }
        finally {
            PERFLOG.end(start, 1L, "remove key={}", (Object)key);
        }
    }

    @Override
    public <T extends Document> void remove(Collection<T> collection, List<String> keys) {
        MongoDocumentStore.log("remove", keys);
        DBCollection dbCollection = this.getDBCollection(collection);
        for (List keyBatch : Lists.partition(keys, (int)500)) {
            DBObject query = QueryBuilder.start((String)"_id").in((Object)keyBatch).get();
            WriteResult writeResult = dbCollection.remove(query);
            this.invalidateCache(collection, keyBatch);
            if (writeResult.getError() == null) continue;
            throw new DocumentStoreException("Remove failed: " + writeResult.getError());
        }
    }

    @CheckForNull
    private <T extends Document> T findAndModify(Collection<T> collection, UpdateOp updateOp, boolean upsert, boolean checkConditions) {
        DBCollection dbCollection = this.getDBCollection(collection);
        updateOp = updateOp.copy();
        DBObject update = MongoDocumentStore.createUpdate(updateOp);
        TreeLock lock = this.acquire(updateOp.getId());
        long start = PERFLOG.start();
        try {
            DBObject oldNode;
            QueryBuilder query;
            Document doc;
            Number modCount = null;
            Document cachedDoc = null;
            if (collection == Collection.NODES && (cachedDoc = (doc = (Document)this.nodesCache.getIfPresent((Object)new StringValue(updateOp.getId())))) != null) {
                modCount = cachedDoc.getModCount();
            }
            if (modCount != null) {
                query = MongoDocumentStore.createQueryForUpdate(updateOp, checkConditions);
                query.and("_modCount").is(modCount);
                BasicDBObject fields = new BasicDBObject();
                fields.put("_id", (Object)1);
                oldNode = dbCollection.findAndModify(query.get(), (DBObject)fields, null, false, update, false, false);
                if (oldNode != null) {
                    this.applyToCache(collection, cachedDoc, updateOp);
                    Document document = cachedDoc;
                    return (T)document;
                }
            }
            query = MongoDocumentStore.createQueryForUpdate(updateOp, checkConditions);
            DBObject oldNode2 = dbCollection.findAndModify(query.get(), null, null, false, update, false, upsert);
            if (checkConditions && oldNode2 == null) {
                oldNode = null;
                return (T)oldNode;
            }
            T oldDoc = this.convertFromDBObject(collection, oldNode2);
            this.applyToCache(collection, oldDoc, updateOp);
            if (oldDoc != null) {
                ((Document)oldDoc).seal();
            }
            T t = oldDoc;
            return t;
        }
        catch (Exception e) {
            throw DocumentStoreException.convert(e);
        }
        finally {
            lock.unlock();
            PERFLOG.end(start, 1L, "findAndModify [{}]", (Object)updateOp.getId());
        }
    }

    @Override
    @CheckForNull
    public <T extends Document> T createOrUpdate(Collection<T> collection, UpdateOp update) throws DocumentStoreException {
        MongoDocumentStore.log("createOrUpdate", update);
        T doc = this.findAndModify(collection, update, true, false);
        MongoDocumentStore.log("createOrUpdate returns ", doc);
        return doc;
    }

    @Override
    public <T extends Document> T findAndUpdate(Collection<T> collection, UpdateOp update) throws DocumentStoreException {
        MongoDocumentStore.log("findAndUpdate", update);
        T doc = this.findAndModify(collection, update, false, true);
        MongoDocumentStore.log("findAndUpdate returns ", doc);
        return doc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends Document> boolean create(Collection<T> collection, List<UpdateOp> updateOps) {
        MongoDocumentStore.log("create", updateOps);
        ArrayList<T> docs = new ArrayList<T>();
        DBObject[] inserts = new DBObject[updateOps.size()];
        for (int i = 0; i < updateOps.size(); ++i) {
            inserts[i] = new BasicDBObject();
            UpdateOp update = updateOps.get(i);
            T target = collection.newDocument(this);
            UpdateUtils.applyChanges(target, update, this.comparator);
            docs.add(target);
            for (Map.Entry<UpdateOp.Key, UpdateOp.Operation> entry : update.getChanges().entrySet()) {
                UpdateOp.Key k = entry.getKey();
                UpdateOp.Operation op = entry.getValue();
                switch (op.type) {
                    case SET: 
                    case MAX: 
                    case INCREMENT: {
                        inserts[i].put(k.toString(), op.value);
                        break;
                    }
                    case SET_MAP_ENTRY: {
                        Revision r = k.getRevision();
                        if (r == null) {
                            throw new IllegalStateException("SET_MAP_ENTRY must not have null revision");
                        }
                        RevisionEntry value = new RevisionEntry(r, op.value);
                        inserts[i].put(k.getName(), (Object)value);
                        break;
                    }
                    case REMOVE_MAP_ENTRY: {
                        break;
                    }
                }
            }
            if (inserts[i].containsField("_modCount")) continue;
            inserts[i].put("_modCount", (Object)1L);
            ((Document)target).put("_modCount", 1L);
        }
        DBCollection dbCollection = this.getDBCollection(collection);
        long start = PERFLOG.start();
        try {
            WriteResult writeResult = dbCollection.insert(inserts);
            if (writeResult.getError() != null) {
                boolean entry = false;
                return entry;
            }
            if (collection == Collection.NODES) {
                for (Document doc : docs) {
                    TreeLock lock = this.acquire(doc.getId());
                    try {
                        this.addToCache((NodeDocument)doc);
                    }
                    finally {
                        lock.unlock();
                    }
                }
            }
            boolean bl = true;
            return bl;
        }
        catch (MongoException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            PERFLOG.end(start, 1L, "create", new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends Document> void update(Collection<T> collection, List<String> keys, UpdateOp updateOp) {
        MongoDocumentStore.log("update", keys, updateOp);
        DBCollection dbCollection = this.getDBCollection(collection);
        QueryBuilder query = QueryBuilder.start((String)"_id").in(keys);
        updateOp = updateOp.copy();
        DBObject update = MongoDocumentStore.createUpdate(updateOp);
        long start = PERFLOG.start();
        try {
            HashMap cachedDocs = Collections.emptyMap();
            if (collection == Collection.NODES) {
                cachedDocs = Maps.newHashMap();
                for (String key : keys) {
                    cachedDocs.put(key, this.nodesCache.getIfPresent((Object)new StringValue(key)));
                }
            }
            try {
                WriteResult writeResult = dbCollection.update(query.get(), update, false, true);
                if (writeResult.getError() != null) {
                    throw new DocumentStoreException("Update failed: " + writeResult.getError());
                }
                if (collection == Collection.NODES) {
                    for (Map.Entry entry : cachedDocs.entrySet()) {
                        TreeLock lock = this.acquire((String)entry.getKey());
                        try {
                            if (entry.getValue() == null || entry.getValue() == NodeDocument.NULL) {
                                this.nodesCache.invalidate((Object)new StringValue((String)entry.getKey()));
                                continue;
                            }
                            this.applyToCache(Collection.NODES, (Document)entry.getValue(), updateOp.shallowCopy((String)entry.getKey()));
                        }
                        finally {
                            lock.unlock();
                        }
                    }
                }
            }
            catch (MongoException e) {
                throw DocumentStoreException.convert(e);
            }
        }
        finally {
            PERFLOG.end(start, 1L, "update", new Object[0]);
        }
    }

    DocumentReadPreference getReadPreference(int maxCacheAge) {
        if (maxCacheAge >= 0 && (long)maxCacheAge < this.maxReplicationLagMillis) {
            return DocumentReadPreference.PRIMARY;
        }
        if (maxCacheAge == Integer.MAX_VALUE) {
            return DocumentReadPreference.PREFER_SECONDARY;
        }
        return DocumentReadPreference.PREFER_SECONDARY_IF_OLD_ENOUGH;
    }

    DocumentReadPreference getDefaultReadPreference(Collection col) {
        return col == Collection.NODES ? DocumentReadPreference.PREFER_SECONDARY_IF_OLD_ENOUGH : DocumentReadPreference.PRIMARY;
    }

    <T extends Document> ReadPreference getMongoReadPreference(Collection<T> collection, String parentId, DocumentReadPreference preference) {
        switch (preference) {
            case PRIMARY: {
                return ReadPreference.primary();
            }
            case PREFER_PRIMARY: {
                return ReadPreference.primaryPreferred();
            }
            case PREFER_SECONDARY: {
                return this.getConfiguredReadPreference(collection);
            }
            case PREFER_SECONDARY_IF_OLD_ENOUGH: {
                if (collection != Collection.NODES) {
                    return ReadPreference.primary();
                }
                ReadPreference readPreference = ReadPreference.primary();
                if (parentId != null) {
                    long replicationSafeLimit = this.getTime() - this.maxReplicationLagMillis;
                    NodeDocument cachedDoc = (NodeDocument)this.getIfCached(collection, parentId);
                    if (cachedDoc != null && !cachedDoc.hasBeenModifiedSince(replicationSafeLimit)) {
                        readPreference = this.getConfiguredReadPreference(collection);
                    }
                }
                return readPreference;
            }
        }
        throw new IllegalArgumentException("Unsupported usage " + (Object)((Object)preference));
    }

    ReadPreference getConfiguredReadPreference(Collection collection) {
        return this.getDBCollection(collection).getReadPreference();
    }

    @CheckForNull
    protected <T extends Document> T convertFromDBObject(@Nonnull Collection<T> collection, @Nullable DBObject n) {
        Document copy = null;
        if (n != null) {
            copy = (Document)collection.newDocument(this);
            for (String key : n.keySet()) {
                Object o = n.get(key);
                if (o instanceof String) {
                    copy.put(key, o);
                    continue;
                }
                if (o instanceof Long) {
                    copy.put(key, o);
                    continue;
                }
                if (o instanceof Integer) {
                    copy.put(key, o);
                    continue;
                }
                if (o instanceof Boolean) {
                    copy.put(key, o);
                    continue;
                }
                if (!(o instanceof BasicDBObject)) continue;
                copy.put(key, this.convertMongoMap((BasicDBObject)o));
            }
        }
        return (T)copy;
    }

    @Nonnull
    private Map<Revision, Object> convertMongoMap(@Nonnull BasicDBObject obj) {
        TreeMap<Revision, Object> map = new TreeMap<Revision, Object>(this.comparator);
        for (Map.Entry entry : obj.entrySet()) {
            map.put(Revision.fromString((String)entry.getKey()), entry.getValue());
        }
        return map;
    }

    <T extends Document> DBCollection getDBCollection(Collection<T> collection) {
        if (collection == Collection.NODES) {
            return this.nodes;
        }
        if (collection == Collection.CLUSTER_NODES) {
            return this.clusterNodes;
        }
        if (collection == Collection.SETTINGS) {
            return this.settings;
        }
        throw new IllegalArgumentException("Unknown collection: " + collection.toString());
    }

    private static QueryBuilder getByKeyQuery(String key) {
        return QueryBuilder.start((String)"_id").is((Object)key);
    }

    @Override
    public void dispose() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("MongoDB time: " + this.timeSum);
        }
        this.nodes.getDB().getMongo().close();
        if (this.nodesCache instanceof Closeable) {
            try {
                ((Closeable)this.nodesCache).close();
            }
            catch (IOException e) {
                LOG.warn("Error occurred while closing Off Heap Cache", (Throwable)e);
            }
        }
    }

    @Override
    public CacheStats getCacheStats() {
        return this.cacheStats;
    }

    @Override
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    long getMaxDeltaForModTimeIdxSecs() {
        return this.maxDeltaForModTimeIdxSecs;
    }

    boolean getDisableIndexHint() {
        return this.disableIndexHint;
    }

    Iterable<? extends Map.Entry<CacheValue, ? extends CachedNodeDocument>> getCacheEntries() {
        if (this.nodesCache instanceof OffHeapCache) {
            return Iterables.concat(this.nodesCache.asMap().entrySet(), ((OffHeapCache)this.nodesCache).offHeapEntriesMap().entrySet());
        }
        return this.nodesCache.asMap().entrySet();
    }

    CachedNodeDocument getCachedNodeDoc(String id) {
        if (this.nodesCache instanceof OffHeapCache) {
            return ((OffHeapCache)this.nodesCache).getCachedDocument(id);
        }
        return (CachedNodeDocument)this.nodesCache.getIfPresent((Object)new StringValue(id));
    }

    private static void log(String message, Object ... args) {
        if (LOG.isDebugEnabled()) {
            String argList = Arrays.toString(args);
            if (argList.length() > 10000) {
                argList = argList.length() + ": " + argList;
            }
            LOG.debug(message + argList);
        }
    }

    @Override
    public <T extends Document> T getIfCached(Collection<T> collection, String key) {
        if (collection != Collection.NODES) {
            return null;
        }
        Document doc = (Document)this.nodesCache.getIfPresent((Object)new StringValue(key));
        return (T)doc;
    }

    private <T extends Document> void applyToCache(@Nonnull Collection<T> collection, @Nullable T oldDoc, @Nonnull UpdateOp updateOp) {
        if (collection == Collection.NODES) {
            NodeDocument cached;
            StringValue key = new StringValue(updateOp.getId());
            NodeDocument newDoc = (NodeDocument)collection.newDocument(this);
            if (oldDoc != null) {
                cached = (NodeDocument)this.nodesCache.getIfPresent((Object)key);
                if (cached == null) {
                    return;
                }
                oldDoc.deepCopy(newDoc);
            }
            UpdateUtils.applyChanges(newDoc, updateOp, this.comparator);
            newDoc.seal();
            cached = this.addToCache(newDoc);
            if (cached == newDoc) {
                return;
            }
            if (oldDoc == null) {
                return;
            }
            if (Objects.equal((Object)cached.getModCount(), (Object)oldDoc.getModCount())) {
                this.nodesCache.put((Object)key, (Object)newDoc);
            } else {
                this.nodesCache.invalidate((Object)key);
            }
        }
    }

    @Nonnull
    private NodeDocument addToCache(final @Nonnull NodeDocument doc) {
        if (doc == NodeDocument.NULL) {
            throw new IllegalArgumentException("doc must not be NULL document");
        }
        doc.seal();
        try {
            StringValue key = new StringValue(doc.getId());
            while (true) {
                NodeDocument cached;
                if ((cached = (NodeDocument)this.nodesCache.get((Object)key, (Callable)new Callable<NodeDocument>(){

                    @Override
                    public NodeDocument call() {
                        return doc;
                    }
                })) != NodeDocument.NULL) {
                    return cached;
                }
                this.nodesCache.invalidate((Object)key);
            }
        }
        catch (ExecutionException e) {
            throw new IllegalStateException(e);
        }
    }

    @Nonnull
    private static QueryBuilder createQueryForUpdate(UpdateOp updateOp, boolean checkConditions) {
        QueryBuilder query = MongoDocumentStore.getByKeyQuery(updateOp.getId());
        for (Map.Entry<UpdateOp.Key, UpdateOp.Operation> entry : updateOp.getChanges().entrySet()) {
            UpdateOp.Key k = entry.getKey();
            UpdateOp.Operation op = entry.getValue();
            switch (op.type) {
                case CONTAINS_MAP_ENTRY: {
                    if (!checkConditions) break;
                    query.and(k.toString()).exists(op.value);
                }
            }
        }
        return query;
    }

    @Nonnull
    private static DBObject createUpdate(UpdateOp updateOp) {
        BasicDBObject setUpdates = new BasicDBObject();
        BasicDBObject maxUpdates = new BasicDBObject();
        BasicDBObject incUpdates = new BasicDBObject();
        BasicDBObject unsetUpdates = new BasicDBObject();
        updateOp.increment("_modCount", 1L);
        for (Map.Entry<UpdateOp.Key, UpdateOp.Operation> entry : updateOp.getChanges().entrySet()) {
            UpdateOp.Key k = entry.getKey();
            if (k.getName().equals("_id")) continue;
            UpdateOp.Operation op = entry.getValue();
            switch (op.type) {
                case SET: 
                case SET_MAP_ENTRY: {
                    setUpdates.append(k.toString(), op.value);
                    break;
                }
                case MAX: {
                    maxUpdates.append(k.toString(), op.value);
                    break;
                }
                case INCREMENT: {
                    incUpdates.append(k.toString(), op.value);
                    break;
                }
                case REMOVE_MAP_ENTRY: {
                    unsetUpdates.append(k.toString(), (Object)"1");
                }
            }
        }
        BasicDBObject update = new BasicDBObject();
        if (!setUpdates.isEmpty()) {
            update.append("$set", (Object)setUpdates);
        }
        if (!maxUpdates.isEmpty()) {
            update.append("$max", (Object)maxUpdates);
        }
        if (!incUpdates.isEmpty()) {
            update.append("$inc", (Object)incUpdates);
        }
        if (!unsetUpdates.isEmpty()) {
            update.append("$unset", (Object)unsetUpdates);
        }
        return update;
    }

    @Nonnull
    private static String getParentId(@Nonnull String id) {
        String parentId = Utils.getParentId((String)Preconditions.checkNotNull((Object)id));
        if (parentId == null) {
            parentId = "";
        }
        return parentId;
    }

    private TreeLock acquire(String key) {
        return TreeLock.shared((ReadWriteLock)this.parentLocks.get((Object)MongoDocumentStore.getParentId(key)), (Lock)this.locks.get((Object)key));
    }

    private TreeLock acquireExclusive(String parentKey) {
        return TreeLock.exclusive((ReadWriteLock)this.parentLocks.get((Object)parentKey));
    }

    @Override
    public void setReadWriteMode(String readWriteMode) {
        if (readWriteMode == null || readWriteMode.equals(this.lastReadWriteMode)) {
            return;
        }
        this.lastReadWriteMode = readWriteMode;
        try {
            WriteConcern writeConcern;
            MongoClientURI uri;
            ReadPreference readPref;
            String rwModeUri = readWriteMode;
            if (!readWriteMode.startsWith("mongodb://")) {
                rwModeUri = String.format("mongodb://localhost/?%s", readWriteMode);
            }
            if (!(readPref = (uri = new MongoClientURI(rwModeUri)).getOptions().getReadPreference()).equals(this.nodes.getReadPreference())) {
                this.nodes.setReadPreference(readPref);
                LOG.info("Using ReadPreference {} ", (Object)readPref);
            }
            if (!(writeConcern = uri.getOptions().getWriteConcern()).equals((Object)this.nodes.getWriteConcern())) {
                this.nodes.setWriteConcern(writeConcern);
                LOG.info("Using WriteConcern " + writeConcern);
            }
        }
        catch (Exception e) {
            LOG.error("Error setting readWriteMode " + readWriteMode, (Throwable)e);
        }
    }

    private long getTime() {
        return this.clock.getTime();
    }

    void setClock(Clock clock) {
        this.clock = clock;
    }

    private static final class TreeLock {
        private final Lock parentLock;
        private final Lock lock;

        private TreeLock(Lock parentLock, Lock lock) {
            this.parentLock = parentLock;
            this.lock = lock;
        }

        static TreeLock shared(ReadWriteLock parentLock, Lock lock) {
            return new TreeLock(parentLock.readLock(), lock).lock();
        }

        static TreeLock exclusive(ReadWriteLock parentLock) {
            return new TreeLock(parentLock.writeLock(), null).lock();
        }

        private TreeLock lock() {
            this.parentLock.lock();
            if (this.lock != null) {
                this.lock.lock();
            }
            return this;
        }

        private void unlock() {
            if (this.lock != null) {
                this.lock.unlock();
            }
            this.parentLock.unlock();
        }
    }

    static enum DocumentReadPreference {
        PRIMARY,
        PREFER_PRIMARY,
        PREFER_SECONDARY,
        PREFER_SECONDARY_IF_OLD_ENOUGH;

    }
}

