/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document.persistentCache;

import com.google.common.cache.Cache;
import java.io.File;
import java.util.ArrayList;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeStore;
import org.apache.jackrabbit.oak.plugins.document.DocumentStore;
import org.apache.jackrabbit.oak.plugins.document.persistentCache.BlobCache;
import org.apache.jackrabbit.oak.plugins.document.persistentCache.CacheMap;
import org.apache.jackrabbit.oak.plugins.document.persistentCache.CacheType;
import org.apache.jackrabbit.oak.plugins.document.persistentCache.MapFactory;
import org.apache.jackrabbit.oak.plugins.document.persistentCache.NodeCache;
import org.apache.jackrabbit.oak.spi.blob.GarbageCollectableBlobStore;
import org.h2.mvstore.FileStore;
import org.h2.mvstore.MVMap;
import org.h2.mvstore.MVStore;
import org.h2.mvstore.MVStoreTool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistentCache {
    static final Logger LOG = LoggerFactory.getLogger(PersistentCache.class);
    private static final String FILE_PREFIX = "cache-";
    private static final String FILE_SUFFIX = ".data";
    private static final AtomicInteger COUNTER = new AtomicInteger();
    private boolean cacheNodes = true;
    private boolean cacheChildren = true;
    private boolean cacheDiff = true;
    private boolean cacheDocs;
    private boolean cacheDocChildren;
    private boolean compactOnClose;
    private boolean compress = true;
    private ArrayList<GenerationCache> caches = new ArrayList();
    private final String directory;
    private MapFactory writeStore;
    private MapFactory readStore;
    private int maxSizeMB = 1024;
    private int readGeneration = -1;
    private int writeGeneration;
    private long maxBinaryEntry = 0x100000L;
    private int autoCompact = 50;
    private boolean appendOnly;
    private boolean manualCommit;

    public PersistentCache(String url) {
        LOG.info("start version 1");
        String[] parts = url.split(",");
        String dir = parts[0];
        for (String p : parts) {
            if (p.equals("+docs")) {
                this.cacheDocs = true;
                continue;
            }
            if (p.equals("+docChildren")) {
                this.cacheDocChildren = true;
                continue;
            }
            if (p.equals("-nodes")) {
                this.cacheNodes = false;
                continue;
            }
            if (p.equals("-children")) {
                this.cacheChildren = false;
                continue;
            }
            if (p.equals("-diff")) {
                this.cacheDiff = false;
                continue;
            }
            if (p.equals("+all")) {
                this.cacheDocs = true;
                this.cacheDocChildren = true;
                continue;
            }
            if (p.equals("-compact")) {
                this.compactOnClose = false;
                continue;
            }
            if (p.equals("+compact")) {
                this.compactOnClose = true;
                continue;
            }
            if (p.equals("-compress")) {
                this.compress = false;
                continue;
            }
            if (p.endsWith("time")) {
                dir = dir + "-" + System.currentTimeMillis() + "-" + COUNTER.getAndIncrement();
                continue;
            }
            if (p.startsWith("size=")) {
                this.maxSizeMB = Integer.parseInt(p.split("=")[1]);
                continue;
            }
            if (p.startsWith("binary=")) {
                this.maxBinaryEntry = Long.parseLong(p.split("=")[1]);
                continue;
            }
            if (p.startsWith("autoCompact=")) {
                this.autoCompact = Integer.parseInt(p.split("=")[1]);
                continue;
            }
            if (p.equals("appendOnly")) {
                this.appendOnly = true;
                continue;
            }
            if (!p.equals("manualCommit")) continue;
            this.manualCommit = true;
        }
        this.directory = dir;
        if (dir.length() == 0) {
            this.readGeneration = -1;
            this.writeGeneration = 0;
            this.writeStore = this.createMapFactory(this.writeGeneration, false);
            return;
        }
        File dr = new File(dir);
        if (!dr.exists()) {
            dr.mkdirs();
        }
        if (dr.exists() && !dr.isDirectory()) {
            throw new IllegalArgumentException("A file exists at cache directory " + dir);
        }
        File[] list = dr.listFiles();
        TreeSet<Integer> generations = new TreeSet<Integer>();
        if (list != null) {
            for (File f : list) {
                String fn = f.getName();
                if (!fn.startsWith(FILE_PREFIX) || !fn.endsWith(FILE_SUFFIX)) continue;
                String g = fn.substring(FILE_PREFIX.length(), fn.indexOf(FILE_SUFFIX));
                try {
                    File f2;
                    int gen = Integer.parseInt(g);
                    if (gen < 0 || !fn.equals((f2 = new File(this.getFileName(gen))).getName())) continue;
                    generations.add(gen);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        while (generations.size() > 2) {
            Integer oldest = (Integer)generations.first();
            File oldFile = new File(this.getFileName(oldest));
            if (!oldFile.canWrite()) {
                LOG.info("Ignoring old, read-only generation " + oldFile.getAbsolutePath());
            } else {
                LOG.info("Removing old generation " + oldFile.getAbsolutePath());
                oldFile.delete();
            }
            generations.remove(oldest);
        }
        this.readGeneration = generations.size() > 1 ? (Integer)generations.first() : -1;
        int n = this.writeGeneration = generations.size() > 0 ? (Integer)generations.last() : 0;
        if (this.readGeneration >= 0) {
            this.readStore = this.createMapFactory(this.readGeneration, true);
        }
        this.writeStore = this.createMapFactory(this.writeGeneration, false);
    }

    private String getFileName(int generation) {
        if (this.directory.length() == 0) {
            return null;
        }
        return this.directory + "/" + FILE_PREFIX + generation + FILE_SUFFIX;
    }

    private MapFactory createMapFactory(final int generation, final boolean readOnly) {
        MapFactory f = new MapFactory(){
            final String fileName;
            MVStore store;
            {
                this.fileName = PersistentCache.this.getFileName(generation);
            }

            @Override
            void openStore() {
                if (this.store != null) {
                    return;
                }
                MVStore.Builder builder = new MVStore.Builder();
                try {
                    if (PersistentCache.this.compress) {
                        builder.compress();
                    }
                    if (PersistentCache.this.manualCommit) {
                        builder.autoCommitDisabled();
                    }
                    if (this.fileName != null) {
                        builder.fileName(this.fileName);
                    }
                    if (readOnly) {
                        builder.readOnly();
                    }
                    if (PersistentCache.this.maxSizeMB < 10) {
                        builder.cacheSize(PersistentCache.this.maxSizeMB);
                    }
                    if (PersistentCache.this.autoCompact >= 0) {
                        builder.autoCompactFillRate(PersistentCache.this.autoCompact);
                    }
                    builder.backgroundExceptionHandler(new Thread.UncaughtExceptionHandler(){

                        @Override
                        public void uncaughtException(Thread t, Throwable e) {
                            MapFactory.LOG.debug("Error in the background thread of the persistent cache", e);
                            MapFactory.LOG.warn("Error in the background thread of the persistent cache: " + e);
                        }
                    });
                    this.store = builder.open();
                    if (PersistentCache.this.appendOnly) {
                        this.store.setReuseSpace(false);
                    }
                }
                catch (Exception e) {
                    LOG.warn("Could not open the store " + this.fileName, (Throwable)e);
                }
            }

            @Override
            synchronized void closeStore() {
                if (this.store == null) {
                    return;
                }
                boolean compact = PersistentCache.this.compactOnClose;
                try {
                    if (this.store.getFileStore().isReadOnly()) {
                        compact = false;
                    }
                    Thread.interrupted();
                    this.store.close();
                }
                catch (Exception e) {
                    LOG.debug("Could not close the store", (Throwable)e);
                    LOG.warn("Could not close the store: " + e);
                    this.store.closeImmediately();
                }
                if (compact) {
                    try {
                        MVStoreTool.compact((String)this.fileName, (boolean)true);
                    }
                    catch (Exception e) {
                        LOG.debug("Could not compact the store", (Throwable)e);
                        LOG.warn("Could not compact the store: " + e);
                    }
                }
                this.store = null;
            }

            @Override
            <K, V> Map<K, V> openMap(String name, MVMap.Builder<K, V> builder) {
                try {
                    if (builder == null) {
                        return this.store.openMap(name);
                    }
                    return this.store.openMap(name, builder);
                }
                catch (Exception e) {
                    LOG.warn("Could not open the map", (Throwable)e);
                    return null;
                }
            }

            @Override
            long getFileSize() {
                try {
                    FileStore fs = this.store.getFileStore();
                    if (fs == null) {
                        return 0L;
                    }
                    return fs.size();
                }
                catch (Exception e) {
                    LOG.warn("Could not retrieve the map size", (Throwable)e);
                    return 0L;
                }
            }
        };
        f.openStore();
        return f;
    }

    public void close() {
        if (this.writeStore != null) {
            this.writeStore.closeStore();
        }
        if (this.readStore != null) {
            this.readStore.closeStore();
        }
    }

    public synchronized GarbageCollectableBlobStore wrapBlobStore(GarbageCollectableBlobStore base) {
        BlobCache c = new BlobCache(this, base);
        this.initGenerationCache(c);
        return c;
    }

    public synchronized <K, V> Cache<K, V> wrap(DocumentNodeStore docNodeStore, DocumentStore docStore, Cache<K, V> base, CacheType type) {
        boolean wrap;
        switch (type) {
            case NODE: {
                wrap = this.cacheNodes;
                break;
            }
            case CHILDREN: {
                wrap = this.cacheChildren;
                break;
            }
            case DIFF: {
                wrap = this.cacheDiff;
                break;
            }
            case CONSOLIDATED_DIFF: {
                wrap = this.cacheDiff;
                break;
            }
            case DOC_CHILDREN: {
                wrap = this.cacheDocChildren;
                break;
            }
            case DOCUMENT: {
                wrap = this.cacheDocs;
                break;
            }
            default: {
                wrap = false;
            }
        }
        if (wrap) {
            NodeCache<K, V> c = new NodeCache<K, V>(this, base, docNodeStore, docStore, type);
            this.initGenerationCache(c);
            return c;
        }
        return base;
    }

    private void initGenerationCache(GenerationCache c) {
        this.caches.add(c);
        if (this.readGeneration >= 0) {
            c.addGeneration(this.readGeneration, true);
        }
        c.addGeneration(this.writeGeneration, false);
    }

    public synchronized <K, V> CacheMap<K, V> openMap(int generation, String name, MVMap.Builder<K, V> builder) {
        MapFactory s;
        if (generation == this.readGeneration) {
            s = this.readStore;
        } else if (generation == this.writeGeneration) {
            s = this.writeStore;
        } else {
            throw new IllegalArgumentException("Unknown generation: " + generation);
        }
        return new CacheMap<K, V>(s, name, builder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void switchGenerationIfNeeded() {
        if (!this.needSwitch()) {
            return;
        }
        PersistentCache persistentCache = this;
        synchronized (persistentCache) {
            MapFactory w;
            if (!this.needSwitch()) {
                return;
            }
            int oldReadGeneration = this.readGeneration;
            MapFactory oldRead = this.readStore;
            this.readStore = this.writeStore;
            this.readGeneration = this.writeGeneration;
            this.writeStore = w = this.createMapFactory(this.writeGeneration + 1, false);
            ++this.writeGeneration;
            for (GenerationCache c : this.caches) {
                c.addGeneration(this.writeGeneration, false);
                if (oldReadGeneration < 0) continue;
                c.removeGeneration(oldReadGeneration);
            }
            if (oldRead != null) {
                oldRead.closeStore();
                new File(this.getFileName(oldReadGeneration)).delete();
            }
        }
    }

    private boolean needSwitch() {
        long size = this.writeStore.getFileSize();
        return size / 1024L / 1024L > (long)this.maxSizeMB;
    }

    public int getMaxSize() {
        return this.maxSizeMB;
    }

    public long getMaxBinaryEntrySize() {
        return this.maxBinaryEntry;
    }

    public int getOpenCount() {
        return this.writeStore.getOpenCount();
    }

    static interface GenerationCache {
        public void addGeneration(int var1, boolean var2);

        public void removeGeneration(int var1);
    }
}

