/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document.rdb;

import java.util.Locale;
import javax.annotation.Nonnull;

public class RDBJDBCTools {
    protected static String jdbctype(String jdbcurl) {
        if (jdbcurl == null) {
            return null;
        }
        String t = jdbcurl.toLowerCase(Locale.ENGLISH);
        if (!t.startsWith("jdbc:")) {
            return null;
        }
        int p = (t = t.substring("jbdc:".length())).indexOf(":");
        if (p <= 0) {
            return t;
        }
        return t.substring(0, p);
    }

    protected static String driverForDBType(String type) {
        if ("h2".equals(type)) {
            return "org.h2.Driver";
        }
        if ("postgresql".equals(type)) {
            return "org.postgresql.Driver";
        }
        if ("db2".equals(type)) {
            return "com.ibm.db2.jcc.DB2Driver";
        }
        if ("mysql".equals(type)) {
            return "com.mysql.jdbc.Driver";
        }
        if ("oracle".equals(type)) {
            return "oracle.jdbc.OracleDriver";
        }
        if ("sqlserver".equals(type)) {
            return "com.microsoft.sqlserver.jdbc.SQLServerDriver";
        }
        return "";
    }

    @Nonnull
    private static String checkLegalTableName(@Nonnull String tableName) throws IllegalArgumentException {
        for (int i = 0; i < tableName.length(); ++i) {
            char c = tableName.charAt(i);
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '_') continue;
            throw new IllegalArgumentException("Invalid character '" + c + "' in table name '" + tableName + "'");
        }
        return tableName;
    }

    @Nonnull
    protected static String createTableName(@Nonnull String prefix, @Nonnull String basename) throws IllegalArgumentException {
        String p = RDBJDBCTools.checkLegalTableName(prefix);
        String b = RDBJDBCTools.checkLegalTableName(basename);
        if (p.length() != 0 && !p.endsWith("_")) {
            p = p + "_";
        }
        return p + b;
    }
}

