/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document.util;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.jackrabbit.oak.cache.CacheStats;
import org.apache.jackrabbit.oak.plugins.document.Collection;
import org.apache.jackrabbit.oak.plugins.document.Document;
import org.apache.jackrabbit.oak.plugins.document.DocumentStore;
import org.apache.jackrabbit.oak.plugins.document.DocumentStoreException;
import org.apache.jackrabbit.oak.plugins.document.UpdateOp;
import org.apache.jackrabbit.oak.plugins.document.cache.CacheInvalidationStats;

public class TimingDocumentStoreWrapper
implements DocumentStore {
    private static final boolean DEBUG = Boolean.parseBoolean(System.getProperty("base.debug", "true"));
    private static final AtomicInteger NEXT_ID = new AtomicInteger();
    private final DocumentStore base;
    private final int id = NEXT_ID.getAndIncrement();
    private long startTime;
    private final Map<String, Count> counts = new HashMap<String, Count>();
    private long lastLogTime;
    private long totalLogTime;
    private final Map<String, Integer> slowCalls = new ConcurrentHashMap<String, Integer>();
    private int callCount;

    public TimingDocumentStoreWrapper(DocumentStore base) {
        this.base = base;
        this.lastLogTime = TimingDocumentStoreWrapper.now();
    }

    private boolean logCommonCall() {
        return this.callCount % 10 == 0;
    }

    @Override
    @CheckForNull
    public <T extends Document> T find(Collection<T> collection, String key) {
        try {
            long start = TimingDocumentStoreWrapper.now();
            T result = this.base.find(collection, key);
            this.updateAndLogTimes("find", start, 0, TimingDocumentStoreWrapper.size(result));
            if (this.logCommonCall()) {
                this.logCommonCall(start, "find " + collection + " " + key);
            }
            return result;
        }
        catch (Exception e) {
            throw TimingDocumentStoreWrapper.convert(e);
        }
    }

    @Override
    @CheckForNull
    public <T extends Document> T find(Collection<T> collection, String key, int maxCacheAge) {
        try {
            long start = TimingDocumentStoreWrapper.now();
            T result = this.base.find(collection, key, maxCacheAge);
            this.updateAndLogTimes("find2", start, 0, TimingDocumentStoreWrapper.size(result));
            if (this.logCommonCall()) {
                this.logCommonCall(start, "find2 " + collection + " " + key);
            }
            return result;
        }
        catch (Exception e) {
            throw TimingDocumentStoreWrapper.convert(e);
        }
    }

    @Override
    @Nonnull
    public <T extends Document> List<T> query(Collection<T> collection, String fromKey, String toKey, int limit) {
        try {
            long start = TimingDocumentStoreWrapper.now();
            List<T> result = this.base.query(collection, fromKey, toKey, limit);
            if (result.size() == 0) {
                this.updateAndLogTimes("query, result=0", start, 0, TimingDocumentStoreWrapper.size(result));
            } else if (result.size() == 1) {
                this.updateAndLogTimes("query, result=1", start, 0, TimingDocumentStoreWrapper.size(result));
            } else {
                this.updateAndLogTimes("query, result>1", start, 0, TimingDocumentStoreWrapper.size(result));
            }
            if (this.logCommonCall()) {
                this.logCommonCall(start, "query " + collection + " " + fromKey + " " + toKey + " " + limit);
            }
            return result;
        }
        catch (Exception e) {
            throw TimingDocumentStoreWrapper.convert(e);
        }
    }

    @Override
    @Nonnull
    public <T extends Document> List<T> query(Collection<T> collection, String fromKey, String toKey, String indexedProperty, long startValue, int limit) {
        try {
            long start = TimingDocumentStoreWrapper.now();
            List<T> result = this.base.query(collection, fromKey, toKey, indexedProperty, startValue, limit);
            this.updateAndLogTimes("query2", start, 0, TimingDocumentStoreWrapper.size(result));
            if (this.logCommonCall()) {
                this.logCommonCall(start, "query2 " + collection + " " + fromKey + " " + toKey + " " + indexedProperty + " " + startValue + " " + limit);
            }
            return result;
        }
        catch (Exception e) {
            throw TimingDocumentStoreWrapper.convert(e);
        }
    }

    @Override
    public <T extends Document> void remove(Collection<T> collection, String key) {
        try {
            long start = TimingDocumentStoreWrapper.now();
            this.base.remove(collection, key);
            this.updateAndLogTimes("remove", start, 0, 0);
            if (this.logCommonCall()) {
                this.logCommonCall(start, "remove " + collection + " " + key);
            }
        }
        catch (Exception e) {
            throw TimingDocumentStoreWrapper.convert(e);
        }
    }

    @Override
    public <T extends Document> void remove(Collection<T> collection, List<String> keys) {
        for (String key : keys) {
            this.remove(collection, key);
        }
    }

    @Override
    public <T extends Document> boolean create(Collection<T> collection, List<UpdateOp> updateOps) {
        try {
            long start = TimingDocumentStoreWrapper.now();
            boolean result = this.base.create(collection, updateOps);
            this.updateAndLogTimes("create", start, 0, 0);
            if (this.logCommonCall()) {
                this.logCommonCall(start, "create " + collection);
            }
            return result;
        }
        catch (Exception e) {
            throw TimingDocumentStoreWrapper.convert(e);
        }
    }

    @Override
    public <T extends Document> void update(Collection<T> collection, List<String> keys, UpdateOp updateOp) {
        try {
            long start = TimingDocumentStoreWrapper.now();
            this.base.update(collection, keys, updateOp);
            this.updateAndLogTimes("update", start, 0, 0);
            if (this.logCommonCall()) {
                this.logCommonCall(start, "update " + collection);
            }
        }
        catch (Exception e) {
            throw TimingDocumentStoreWrapper.convert(e);
        }
    }

    @Override
    @CheckForNull
    public <T extends Document> T createOrUpdate(Collection<T> collection, UpdateOp update) {
        try {
            long start = TimingDocumentStoreWrapper.now();
            T result = this.base.createOrUpdate(collection, update);
            this.updateAndLogTimes("createOrUpdate", start, 0, TimingDocumentStoreWrapper.size(result));
            if (this.logCommonCall()) {
                this.logCommonCall(start, "createOrUpdate " + collection + " " + update.getId());
            }
            return result;
        }
        catch (Exception e) {
            throw TimingDocumentStoreWrapper.convert(e);
        }
    }

    @Override
    @CheckForNull
    public <T extends Document> T findAndUpdate(Collection<T> collection, UpdateOp update) {
        try {
            long start = TimingDocumentStoreWrapper.now();
            T result = this.base.findAndUpdate(collection, update);
            this.updateAndLogTimes("findAndUpdate", start, 0, TimingDocumentStoreWrapper.size(result));
            if (this.logCommonCall()) {
                this.logCommonCall(start, "findAndUpdate " + collection + " " + update.getId());
            }
            return result;
        }
        catch (Exception e) {
            throw TimingDocumentStoreWrapper.convert(e);
        }
    }

    @Override
    public CacheInvalidationStats invalidateCache() {
        try {
            long start = TimingDocumentStoreWrapper.now();
            CacheInvalidationStats result = this.base.invalidateCache();
            this.updateAndLogTimes("invalidateCache", start, 0, 0);
            return result;
        }
        catch (Exception e) {
            throw TimingDocumentStoreWrapper.convert(e);
        }
    }

    @Override
    public <T extends Document> void invalidateCache(Collection<T> collection, String key) {
        try {
            long start = TimingDocumentStoreWrapper.now();
            this.base.invalidateCache(collection, key);
            this.updateAndLogTimes("invalidateCache2", start, 0, 0);
        }
        catch (Exception e) {
            throw TimingDocumentStoreWrapper.convert(e);
        }
    }

    @Override
    public void dispose() {
        try {
            long start = TimingDocumentStoreWrapper.now();
            this.base.dispose();
            this.updateAndLogTimes("dispose", start, 0, 0);
        }
        catch (Exception e) {
            throw TimingDocumentStoreWrapper.convert(e);
        }
    }

    @Override
    public <T extends Document> T getIfCached(Collection<T> collection, String key) {
        try {
            long start = TimingDocumentStoreWrapper.now();
            T result = this.base.getIfCached(collection, key);
            this.updateAndLogTimes("isCached", start, 0, 0);
            return result;
        }
        catch (Exception e) {
            throw TimingDocumentStoreWrapper.convert(e);
        }
    }

    @Override
    public void setReadWriteMode(String readWriteMode) {
        try {
            long start = TimingDocumentStoreWrapper.now();
            this.base.setReadWriteMode(readWriteMode);
            this.updateAndLogTimes("setReadWriteMode", start, 0, 0);
        }
        catch (Exception e) {
            throw TimingDocumentStoreWrapper.convert(e);
        }
    }

    @Override
    public CacheStats getCacheStats() {
        try {
            long start = TimingDocumentStoreWrapper.now();
            CacheStats result = this.base.getCacheStats();
            this.updateAndLogTimes("getCacheStats", start, 0, 0);
            return result;
        }
        catch (Exception e) {
            throw TimingDocumentStoreWrapper.convert(e);
        }
    }

    @Override
    public Map<String, String> getMetadata() {
        return this.base.getMetadata();
    }

    private void logCommonCall(long start, String key) {
        int time = (int)(System.currentTimeMillis() - start);
        if (time <= 0) {
            return;
        }
        Map<String, Integer> map = this.slowCalls;
        Integer oldCount = map.get(key);
        if (oldCount == null) {
            map.put(key, time);
        } else {
            map.put(key, oldCount + time);
        }
        int maxElements = 1000;
        int minCount = 1;
        while (map.size() > maxElements) {
            Iterator<Map.Entry<String, Integer>> ei = map.entrySet().iterator();
            while (ei.hasNext()) {
                Map.Entry<String, Integer> e = ei.next();
                if (e.getValue() > minCount) continue;
                ei.remove();
            }
            if (map.size() <= maxElements) continue;
            ++minCount;
        }
    }

    private static RuntimeException convert(Exception e) {
        if (e instanceof RuntimeException) {
            return (RuntimeException)e;
        }
        return new DocumentStoreException("Unexpected exception: " + e.toString(), e);
    }

    private void log(String message) {
        if (DEBUG) {
            System.out.println("[" + this.id + "] " + message);
        }
    }

    private static <T extends Document> int size(List<T> list) {
        int result = 0;
        for (Document doc : list) {
            result += doc.getMemory();
        }
        return result;
    }

    private static int size(@Nullable Document document) {
        if (document == null) {
            return 0;
        }
        return document.getMemory();
    }

    private static long now() {
        return System.currentTimeMillis();
    }

    private void updateAndLogTimes(String operation, long start, int paramSize, int resultSize) {
        Count c;
        long now = TimingDocumentStoreWrapper.now();
        if (this.startTime == 0L) {
            this.startTime = now;
        }
        if ((c = this.counts.get(operation)) == null) {
            c = new Count();
            this.counts.put(operation, c);
        }
        c.update(now - start, paramSize, resultSize);
        long t = now - this.lastLogTime;
        if (t >= 10000L) {
            this.totalLogTime += t;
            this.lastLogTime = now;
            long totalCount = 0L;
            long totalTime = 0L;
            for (Count count : this.counts.values()) {
                totalCount += count.count;
                totalTime += count.total;
            }
            totalCount = Math.max(1L, totalCount);
            totalTime = Math.max(1L, totalTime);
            for (Map.Entry entry : this.counts.entrySet()) {
                c = (Count)entry.getValue();
                long count = c.count;
                long total = c.total;
                long l = c.paramSize / 1024L / 1024L;
                long out = c.resultSize / 1024L / 1024L;
                if (count <= 0L) continue;
                this.log((String)entry.getKey() + " count " + count + " " + 100L * count / totalCount + "%" + " in " + l + " out " + out + " time " + total + " " + 100L * total / totalTime + "%");
            }
            this.log("all count " + totalCount + " time " + totalTime + " " + 100L * totalTime / this.totalLogTime + "%");
            Map<String, Integer> map = this.slowCalls;
            int n = 10;
            int max = Integer.MAX_VALUE;
            int i = 0;
            while (i < n) {
                int best = 0;
                Iterator<Object> i$ = map.values().iterator();
                while (i$.hasNext()) {
                    int n2 = i$.next();
                    if (n2 >= max || n2 <= best) continue;
                    best = n2;
                }
                for (Map.Entry entry : map.entrySet()) {
                    if ((Integer)entry.getValue() < best || (Integer)entry.getValue() >= max) continue;
                    this.log("slow call " + entry.getValue() + " millis: " + (String)entry.getKey());
                    if (++i < n) continue;
                    break;
                }
                if (i >= map.size()) break;
                max = best;
            }
            this.slowCalls.clear();
            this.log("------");
        }
    }

    static class Count {
        public long count;
        public long max;
        public long total;
        public long paramSize;
        public long resultSize;

        Count() {
        }

        void update(long time, int paramSize, int resultSize) {
            ++this.count;
            if (time > this.max) {
                this.max = time;
            }
            this.total += time;
            this.paramSize += (long)paramSize;
            this.resultSize += (long)resultSize;
        }
    }
}

