/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.identifier;

import java.util.UUID;
import javax.annotation.CheckForNull;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.spi.commit.CommitInfo;
import org.apache.jackrabbit.oak.spi.commit.EmptyHook;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStore;

public class ClusterRepositoryInfo {
    public static final String CLUSTER_CONFIG_NODE = ":clusterConfig";
    public static final String CLUSTER_ID_PROP = ":clusterId";

    public static String createId(NodeStore store) throws CommitFailedException {
        NodeBuilder root = store.getRoot().builder();
        if (!root.hasChildNode(CLUSTER_CONFIG_NODE)) {
            String id = UUID.randomUUID().toString();
            root.child(CLUSTER_CONFIG_NODE).setProperty(CLUSTER_ID_PROP, id);
            store.merge(root, EmptyHook.INSTANCE, CommitInfo.EMPTY);
            return id;
        }
        return root.getChildNode(CLUSTER_CONFIG_NODE).getProperty(CLUSTER_ID_PROP).getValue(Type.STRING);
    }

    @CheckForNull
    public static String getId(NodeStore store) {
        NodeState state = store.getRoot().getChildNode(CLUSTER_CONFIG_NODE);
        if (state.hasProperty(CLUSTER_ID_PROP)) {
            return state.getProperty(CLUSTER_ID_PROP).getValue(Type.STRING);
        }
        return null;
    }
}

