/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.counter;

import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Service;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.plugins.index.IndexEditorProvider;
import org.apache.jackrabbit.oak.plugins.index.IndexUpdateCallback;
import org.apache.jackrabbit.oak.plugins.index.counter.NodeCounterEditor;
import org.apache.jackrabbit.oak.spi.commit.Editor;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;

@Component
@Service(value={IndexEditorProvider.class})
public class NodeCounterEditorProvider
implements IndexEditorProvider {
    public static final String TYPE = "counter";
    public static final String RESOLUTION = "resolution";

    @Override
    @CheckForNull
    public Editor getIndexEditor(@Nonnull String type, @Nonnull NodeBuilder definition, @Nonnull NodeState root, @Nonnull IndexUpdateCallback callback) throws CommitFailedException {
        if (!TYPE.equals(type)) {
            return null;
        }
        NodeCounterEditor.NodeCounterRoot rootData = new NodeCounterEditor.NodeCounterRoot();
        rootData.callback = callback;
        rootData.definition = definition;
        rootData.root = root;
        PropertyState s = definition.getProperty(RESOLUTION);
        if (s != null) {
            rootData.resolution = s.getValue(Type.LONG).intValue();
        }
        return new NodeCounterEditor(rootData, null, "/");
    }
}

