/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.property;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.PropertyValue;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.plugins.index.property.OrderedIndex;
import org.apache.jackrabbit.oak.plugins.index.property.OrderedPropertyIndex;
import org.apache.jackrabbit.oak.plugins.index.property.PropertyIndex;
import org.apache.jackrabbit.oak.plugins.index.property.strategy.OrderedContentMirrorStoreStrategy;
import org.apache.jackrabbit.oak.spi.query.Filter;
import org.apache.jackrabbit.oak.spi.query.QueryIndex;
import org.apache.jackrabbit.oak.spi.state.ChildNodeEntry;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrderedPropertyIndexLookup {
    private static final Logger LOG = LoggerFactory.getLogger(OrderedPropertyIndexLookup.class);
    private static final OrderedContentMirrorStoreStrategy STORE = new OrderedContentMirrorStoreStrategy();
    private static final OrderedContentMirrorStoreStrategy REVERSED_STORE = new OrderedContentMirrorStoreStrategy(OrderedIndex.OrderDirection.DESC);
    private static final double COST_OVERHEAD = 3.0;
    private static final int MAX_COST = 100;
    private NodeState root;
    private String name;
    private OrderedPropertyIndexLookup parent;

    public OrderedPropertyIndexLookup(NodeState root) {
        this(root, "", null);
    }

    public OrderedPropertyIndexLookup(NodeState root, String name, OrderedPropertyIndexLookup parent) {
        this.root = root;
        this.name = name;
        this.parent = parent;
    }

    @Nullable
    NodeState getIndexNode(NodeState node, String propertyName, Filter filter) {
        NodeState fallback = null;
        NodeState state = node.getChildNode("oak:index");
        for (ChildNodeEntry childNodeEntry : state.getChildNodeEntries()) {
            NodeState indexContent;
            NodeState index = childNodeEntry.getNodeState();
            PropertyState type = index.getProperty("type");
            if (type == null || type.isArray() || !this.getType().equals(type.getValue(Type.STRING)) || !Iterables.contains(index.getNames("propertyNames"), (Object)propertyName) || !(indexContent = index.getChildNode(":index")).exists()) continue;
            Set<String> supertypes = OrderedPropertyIndexLookup.getSuperTypes(filter);
            if (index.hasProperty("declaringNodeTypes")) {
                if (supertypes == null) continue;
                for (String typeName : index.getNames("declaringNodeTypes")) {
                    if (!supertypes.contains(typeName)) continue;
                    return index;
                }
                continue;
            }
            if (supertypes == null) {
                return index;
            }
            if (fallback != null) continue;
            fallback = index;
        }
        return fallback;
    }

    private static Set<String> getSuperTypes(Filter filter) {
        if (filter != null && !filter.matchesAllTypes()) {
            return filter.getSupertypes();
        }
        return null;
    }

    static OrderedContentMirrorStoreStrategy getStrategy(NodeState indexMeta) {
        if (OrderedIndex.OrderDirection.isAscending(indexMeta)) {
            return STORE;
        }
        return REVERSED_STORE;
    }

    public boolean isAscending(NodeState root, String propertyName, Filter filter) {
        NodeState indexMeta = this.getIndexNode(root, propertyName, filter);
        return OrderedIndex.OrderDirection.isAscending(indexMeta);
    }

    String getType() {
        return "ordered";
    }

    public double getCost(Filter filter, String propertyName, PropertyValue value) {
        double cost = Double.POSITIVE_INFINITY;
        NodeState indexMeta = this.getIndexNode(this.root, propertyName, filter);
        if (indexMeta != null) {
            cost = 3.0 + (double)OrderedPropertyIndexLookup.getStrategy(indexMeta).count(this.root, indexMeta, PropertyIndex.encode(value), 100);
        }
        return cost;
    }

    public Iterable<String> query(Filter filter, String propertyName, PropertyValue value) {
        NodeState indexMeta = this.getIndexNode(this.root, propertyName, filter);
        if (indexMeta == null) {
            throw new IllegalArgumentException("No index for " + propertyName);
        }
        return OrderedPropertyIndexLookup.getStrategy(indexMeta).query(filter, propertyName, indexMeta, PropertyIndex.encode(value));
    }

    public Iterable<String> query(Filter filter, String propertyName, Filter.PropertyRestriction pr) {
        NodeState indexMeta = this.getIndexNode(this.root, propertyName, filter);
        if (indexMeta == null) {
            throw new IllegalArgumentException("No index for " + propertyName);
        }
        return OrderedPropertyIndexLookup.getStrategy(indexMeta).query(filter, propertyName, indexMeta, pr, "");
    }

    void collectPlans(Filter filter, String path, QueryIndex.OrderEntry oe, List<QueryIndex.IndexPlan> plans) {
        String propertyName = PathUtils.getName(oe.getPropertyName());
        NodeState definition = this.getIndexNode(this.root, propertyName, filter);
        if (definition != null) {
            QueryIndex.OrderEntry.Order order = OrderedIndex.OrderDirection.isAscending(definition) ? QueryIndex.OrderEntry.Order.ASCENDING : QueryIndex.OrderEntry.Order.DESCENDING;
            long entryCount = OrderedPropertyIndexLookup.getStrategy(definition).count(definition, null, 100);
            QueryIndex.IndexPlan.Builder b = OrderedPropertyIndex.getIndexPlanBuilder(filter);
            b.setSortOrder((List<QueryIndex.OrderEntry>)ImmutableList.of((Object)new QueryIndex.OrderEntry(oe.getPropertyName(), Type.UNDEFINED, order)));
            b.setEstimatedEntryCount(entryCount);
            b.setDefinition(definition);
            b.setPathPrefix(this.getPath());
            QueryIndex.IndexPlan plan = b.build();
            LOG.debug("plan: {}", (Object)plan);
            plans.add(plan);
        }
        String remainder = "";
        OrderedPropertyIndexLookup lookup = null;
        for (String element : PathUtils.elements(path)) {
            if (lookup == null) {
                lookup = new OrderedPropertyIndexLookup(this.root.getChildNode(element), element, this);
                continue;
            }
            remainder = PathUtils.concat(remainder, element);
        }
        if (lookup != null) {
            lookup.collectPlans(filter, remainder, oe, plans);
        }
    }

    void collectPlans(Filter filter, String path, Filter.PropertyRestriction pr, List<QueryIndex.IndexPlan> plans) {
        String propertyName = PathUtils.getName(pr.propertyName);
        NodeState definition = this.getIndexNode(this.root, propertyName, filter);
        if (definition != null) {
            boolean createPlan = false;
            if (pr.isNotNullRestriction() || pr.list != null) {
                createPlan = true;
            } else if (pr.first != null && pr.first.equals(pr.last) && pr.firstIncluding && pr.lastIncluding) {
                createPlan = true;
            } else if (pr.first != null && !pr.first.equals(pr.last)) {
                createPlan = true;
            } else if (pr.last != null && !pr.last.equals(pr.first)) {
                createPlan = true;
            }
            if (createPlan) {
                QueryIndex.OrderEntry.Order order = OrderedIndex.OrderDirection.isAscending(definition) ? QueryIndex.OrderEntry.Order.ASCENDING : QueryIndex.OrderEntry.Order.DESCENDING;
                QueryIndex.IndexPlan.Builder b = OrderedPropertyIndex.getIndexPlanBuilder(filter);
                b.setDefinition(definition);
                b.setSortOrder((List<QueryIndex.OrderEntry>)ImmutableList.of((Object)new QueryIndex.OrderEntry(propertyName, Type.UNDEFINED, order)));
                long count = OrderedPropertyIndexLookup.getStrategy(definition).count(definition, pr, 100);
                b.setEstimatedEntryCount(count);
                b.setPropertyRestriction(pr);
                b.setPathPrefix(this.getPath());
                QueryIndex.IndexPlan plan = b.build();
                LOG.debug("plan: {}", (Object)plan);
                plans.add(plan);
            }
        }
        String remainder = "";
        OrderedPropertyIndexLookup lookup = null;
        for (String element : PathUtils.elements(path)) {
            if (lookup == null) {
                lookup = new OrderedPropertyIndexLookup(this.root.getChildNode(element), element, this);
                continue;
            }
            remainder = PathUtils.concat(remainder, element);
        }
        if (lookup != null) {
            lookup.collectPlans(filter, remainder, pr, plans);
        }
    }

    private String getPath() {
        return this.buildPath(new StringBuilder()).toString();
    }

    private StringBuilder buildPath(StringBuilder sb) {
        if (this.parent != null) {
            this.parent.buildPath(sb);
            sb.append("/").append(this.name);
        }
        return sb;
    }
}

