/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.property;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashSet;
import java.util.Set;
import org.apache.jackrabbit.oak.api.PropertyValue;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.plugins.index.property.PropertyIndexPlan;
import org.apache.jackrabbit.oak.spi.query.Cursor;
import org.apache.jackrabbit.oak.spi.query.Filter;
import org.apache.jackrabbit.oak.spi.query.QueryIndex;
import org.apache.jackrabbit.oak.spi.state.ChildNodeEntry;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PropertyIndex
implements QueryIndex {
    private static final String PROPERTY = "property";
    private static final int MAX_STRING_LENGTH = 100;
    private static final String EMPTY_TOKEN = ":";
    private static final Logger LOG = LoggerFactory.getLogger(PropertyIndex.class);

    PropertyIndex() {
    }

    static Set<String> encode(PropertyValue value) {
        if (value == null) {
            return null;
        }
        HashSet<String> values = new HashSet<String>();
        for (String v : value.getValue(Type.STRINGS)) {
            try {
                if (v.length() > 100) {
                    v = v.substring(0, 100);
                }
                v = v.isEmpty() ? EMPTY_TOKEN : URLEncoder.encode(v, Charsets.UTF_8.name());
                values.add(v);
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalStateException("UTF-8 is unsupported", e);
            }
        }
        return values;
    }

    private static PropertyIndexPlan plan(NodeState root, Filter filter) {
        PropertyIndexPlan bestPlan = null;
        NodeState state = root.getChildNode("oak:index");
        for (ChildNodeEntry childNodeEntry : state.getChildNodeEntries()) {
            PropertyIndexPlan plan;
            NodeState definition = childNodeEntry.getNodeState();
            if (!PROPERTY.equals(definition.getString("type")) || !definition.hasChildNode(":index") || (plan = new PropertyIndexPlan(childNodeEntry.getName(), root, definition, filter)).getCost() == Double.POSITIVE_INFINITY) continue;
            LOG.debug("property cost for {} is {}", (Object)plan.getName(), (Object)plan.getCost());
            if (bestPlan != null && !(plan.getCost() < bestPlan.getCost())) continue;
            bestPlan = plan;
        }
        return bestPlan;
    }

    @Override
    public String getIndexName() {
        return PROPERTY;
    }

    @Override
    public double getCost(Filter filter, NodeState root) {
        if (filter.getFullTextConstraint() != null) {
            return Double.POSITIVE_INFINITY;
        }
        if (filter.containsNativeConstraint()) {
            return Double.POSITIVE_INFINITY;
        }
        PropertyIndexPlan plan = PropertyIndex.plan(root, filter);
        if (plan != null) {
            return plan.getCost();
        }
        return Double.POSITIVE_INFINITY;
    }

    @Override
    public Cursor query(Filter filter, NodeState root) {
        PropertyIndexPlan plan = PropertyIndex.plan(root, filter);
        Preconditions.checkState((plan != null ? 1 : 0) != 0, (Object)("Property index is used even when no index is available for filter " + filter));
        return plan.execute();
    }

    @Override
    public String getPlan(Filter filter, NodeState root) {
        PropertyIndexPlan plan = PropertyIndex.plan(root, filter);
        if (plan != null) {
            return plan.toString();
        }
        return "property index not applicable";
    }
}

