/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.property;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.jackrabbit.oak.api.PropertyValue;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.plugins.index.property.PropertyIndex;
import org.apache.jackrabbit.oak.plugins.index.property.strategy.ContentMirrorStoreStrategy;
import org.apache.jackrabbit.oak.plugins.index.property.strategy.IndexStoreStrategy;
import org.apache.jackrabbit.oak.plugins.index.property.strategy.UniqueEntryStoreStrategy;
import org.apache.jackrabbit.oak.query.QueryEngineSettings;
import org.apache.jackrabbit.oak.query.ast.ComparisonImpl;
import org.apache.jackrabbit.oak.query.ast.ConstraintImpl;
import org.apache.jackrabbit.oak.query.ast.DynamicOperandImpl;
import org.apache.jackrabbit.oak.query.ast.InImpl;
import org.apache.jackrabbit.oak.query.ast.Operator;
import org.apache.jackrabbit.oak.query.ast.OrImpl;
import org.apache.jackrabbit.oak.query.ast.PropertyValueImpl;
import org.apache.jackrabbit.oak.query.ast.StaticOperandImpl;
import org.apache.jackrabbit.oak.spi.query.Cursor;
import org.apache.jackrabbit.oak.spi.query.Cursors;
import org.apache.jackrabbit.oak.spi.query.Filter;
import org.apache.jackrabbit.oak.spi.state.NodeState;

public class PropertyIndexPlan {
    private static final double COST_OVERHEAD = 2.0;
    static final int MAX_COST = 100;
    private static final IndexStoreStrategy MIRROR = new ContentMirrorStoreStrategy();
    private static final IndexStoreStrategy UNIQUE = new UniqueEntryStoreStrategy();
    private final NodeState root;
    private final NodeState definition;
    private final String name;
    private final Set<String> properties;
    private final IndexStoreStrategy strategy;
    private final Filter filter;
    private boolean matchesAllTypes;
    private boolean matchesNodeTypes;
    private final double cost;
    private final Set<String> values;
    private final int depth;

    PropertyIndexPlan(String name, NodeState root, NodeState definition, Filter filter) {
        this.name = name;
        this.root = root;
        this.definition = definition;
        this.properties = Sets.newHashSet(definition.getNames("propertyNames"));
        this.strategy = definition.getBoolean("unique") ? UNIQUE : MIRROR;
        this.filter = filter;
        Iterable<String> types = definition.getNames("declaringNodeTypes");
        this.matchesAllTypes = !definition.hasProperty("declaringNodeTypes");
        this.matchesNodeTypes = this.matchesAllTypes || Iterables.any(types, (Predicate)Predicates.in(filter.getSupertypes()));
        double bestCost = Double.POSITIVE_INFINITY;
        Set<Object> bestValues = Collections.emptySet();
        int bestDepth = 1;
        if (this.matchesNodeTypes) {
            for (String property : this.properties) {
                Set<String> values;
                double cost;
                Filter.PropertyRestriction restriction = filter.getPropertyRestriction(property);
                int depth = 1;
                if (restriction == null) {
                    String suffix = "/" + property;
                    for (Filter.PropertyRestriction relative : filter.getPropertyRestrictions()) {
                        if (!relative.propertyName.endsWith(suffix)) continue;
                        restriction = relative;
                        depth = PathUtils.getDepth(relative.propertyName);
                    }
                }
                if (restriction == null || restriction.isNullRestriction() || !((cost = (double)this.strategy.count(filter, root, definition, values = PropertyIndexPlan.getValues(restriction), 100)) < bestCost)) continue;
                bestDepth = depth;
                bestValues = values;
                bestCost = cost;
            }
            for (ConstraintImpl constraint : filter.getSelector().getSelectorConstraints()) {
                double cost;
                Set<String> values;
                if (!(constraint instanceof OrImpl) || (values = this.findMultiProperty((OrImpl)constraint)) == null || !((cost = (double)this.strategy.count(filter, root, definition, values, 100)) < bestCost)) continue;
                bestDepth = 1;
                bestValues = values;
                bestCost = cost;
            }
        }
        this.depth = bestDepth;
        this.values = bestValues;
        this.cost = 2.0 + bestCost;
    }

    private Set<String> findMultiProperty(OrImpl or) {
        LinkedHashSet values = Sets.newLinkedHashSet();
        for (ConstraintImpl constraint : or.getConstraints()) {
            if (constraint instanceof ComparisonImpl) {
                ComparisonImpl comparison = (ComparisonImpl)constraint;
                if (this.isIndexed(comparison.getOperand1()) && comparison.getOperator() == Operator.EQUAL) {
                    values.addAll(PropertyIndex.encode(comparison.getOperand2().currentValue()));
                    continue;
                }
                return null;
            }
            if (constraint instanceof InImpl) {
                InImpl in = (InImpl)constraint;
                if (this.isIndexed(in.getOperand1())) {
                    for (StaticOperandImpl operand : in.getOperand2()) {
                        values.addAll(PropertyIndex.encode(operand.currentValue()));
                    }
                    continue;
                }
                return null;
            }
            return null;
        }
        return values;
    }

    private boolean isIndexed(DynamicOperandImpl operand) {
        if (operand instanceof PropertyValueImpl) {
            PropertyValueImpl property = (PropertyValueImpl)operand;
            return this.properties.contains(property.getPropertyName());
        }
        return false;
    }

    private static Set<String> getValues(Filter.PropertyRestriction restriction) {
        if (restriction.firstIncluding && restriction.lastIncluding && restriction.first != null && restriction.first.equals(restriction.last)) {
            return PropertyIndex.encode(restriction.first);
        }
        if (restriction.list != null) {
            LinkedHashSet values = Sets.newLinkedHashSet();
            for (PropertyValue value : restriction.list) {
                values.addAll(PropertyIndex.encode(value));
            }
            return values;
        }
        return null;
    }

    String getName() {
        return this.name;
    }

    double getCost() {
        return this.cost;
    }

    Cursor execute() {
        QueryEngineSettings settings = this.filter.getQueryEngineSettings();
        Cursor cursor = Cursors.newPathCursor(this.strategy.query(this.filter, this.name, this.definition, this.values), settings);
        if (this.depth > 1) {
            cursor = Cursors.newAncestorCursor(cursor, this.depth - 1, settings);
        }
        return cursor;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder("property ");
        buffer.append(this.name);
        if (this.values == null) {
            buffer.append(" IS NOT NULL");
        } else if (this.values.isEmpty()) {
            buffer.append(" NOT APPLICABLE");
        } else if (this.values.size() == 1) {
            buffer.append(" = ");
            buffer.append(this.values.iterator().next());
        } else {
            buffer.append(" IN (");
            boolean comma = false;
            for (String value : this.values) {
                if (comma) {
                    buffer.append(", ");
                }
                buffer.append(value);
                comma = true;
            }
            buffer.append(")");
        }
        return buffer.toString();
    }
}

