/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.memory;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.plugins.memory.MemoryChildNodeEntry;
import org.apache.jackrabbit.oak.plugins.memory.MemoryNodeBuilder;
import org.apache.jackrabbit.oak.plugins.memory.MemoryNodeState;
import org.apache.jackrabbit.oak.plugins.memory.MutableNodeState;
import org.apache.jackrabbit.oak.spi.state.AbstractNodeState;
import org.apache.jackrabbit.oak.spi.state.ChildNodeEntry;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStateDiff;

public class ModifiedNodeState
extends AbstractNodeState {
    private final NodeState base;
    private final Map<String, PropertyState> properties;
    private final Map<String, NodeState> nodes;

    static NodeState unwrap(@Nonnull NodeState base, @Nonnull Map<String, PropertyState> properties, @Nonnull Map<String, MutableNodeState> nodes) {
        properties.clear();
        for (Map.Entry<String, MutableNodeState> entry : nodes.entrySet()) {
            entry.getValue().reset(base.getChildNode(entry.getKey()));
        }
        if (base instanceof ModifiedNodeState) {
            ModifiedNodeState modified = (ModifiedNodeState)base;
            properties.putAll(modified.properties);
            for (Map.Entry<String, NodeState> entry : modified.nodes.entrySet()) {
                String name = entry.getKey();
                if (nodes.containsKey(name)) continue;
                nodes.put(name, new MutableNodeState(entry.getValue()));
            }
            return modified.base;
        }
        return base;
    }

    public static NodeState squeeze(NodeState state) {
        if (state instanceof ModifiedNodeState) {
            HashMap properties = Maps.newHashMap();
            for (PropertyState propertyState : state.getProperties()) {
                properties.put(propertyState.getName(), propertyState);
            }
            HashMap nodes = Maps.newHashMap();
            for (ChildNodeEntry childNodeEntry : state.getChildNodeEntries()) {
                nodes.put(childNodeEntry.getName(), ModifiedNodeState.squeeze(childNodeEntry.getNodeState()));
            }
            state = new MemoryNodeState(properties, nodes);
        }
        return state;
    }

    static long getPropertyCount(NodeState base, Map<String, PropertyState> properties) {
        long count = 0L;
        if (base.exists()) {
            count = base.getPropertyCount();
            for (Map.Entry<String, PropertyState> entry : properties.entrySet()) {
                if (base.hasProperty(entry.getKey())) {
                    --count;
                }
                if (entry.getValue() == null) continue;
                ++count;
            }
        }
        return count;
    }

    static boolean hasProperty(NodeState base, Map<String, PropertyState> properties, String name) {
        if (properties.containsKey(name)) {
            return properties.get(name) != null;
        }
        return base.hasProperty(name);
    }

    static PropertyState getProperty(NodeState base, Map<String, PropertyState> properties, String name) {
        PropertyState property = properties.get(name);
        if (property == null && !properties.containsKey(name)) {
            property = base.getProperty(name);
        }
        return property;
    }

    static Iterable<? extends PropertyState> getProperties(NodeState base, Map<String, PropertyState> properties, boolean copy) {
        if (!base.exists()) {
            return Collections.emptyList();
        }
        if (properties.isEmpty()) {
            return base.getProperties();
        }
        if (copy) {
            properties = Maps.newHashMap(properties);
        }
        Predicate predicate = Predicates.compose((Predicate)Predicates.not((Predicate)Predicates.in(properties.keySet())), PropertyState.GET_NAME);
        return Iterables.concat((Iterable)Iterables.filter(base.getProperties(), (Predicate)predicate), (Iterable)Iterables.filter(properties.values(), (Predicate)Predicates.notNull()));
    }

    static long getChildNodeCount(NodeState base, Map<String, ? extends NodeState> nodes, long max) {
        if (!base.exists()) {
            return 0L;
        }
        long deleted = 0L;
        long added = 0L;
        for (Map.Entry<String, ? extends NodeState> entry : nodes.entrySet()) {
            if (!base.hasChildNode(entry.getKey())) {
                ++added;
            }
            if (entry.getValue().exists()) continue;
            ++deleted;
        }
        max = max + deleted < 0L ? Long.MAX_VALUE : (max += deleted);
        long count = base.getChildNodeCount(max);
        count = count + added - deleted < 0L ? Long.MAX_VALUE : count + added - deleted;
        return count;
    }

    static Iterable<String> getChildNodeNames(NodeState base, Map<String, ? extends NodeState> nodes, boolean copy) {
        if (!base.exists()) {
            return Collections.emptyList();
        }
        if (nodes.isEmpty()) {
            return base.getChildNodeNames();
        }
        if (copy) {
            nodes = Maps.newHashMap(nodes);
        }
        return Iterables.concat((Iterable)Iterables.filter(base.getChildNodeNames(), (Predicate)Predicates.not((Predicate)Predicates.in(nodes.keySet()))), Maps.filterValues((Map)nodes, NodeState.EXISTS).keySet());
    }

    ModifiedNodeState(@Nonnull NodeState base, @Nonnull Map<String, PropertyState> properties, @Nonnull Map<String, MutableNodeState> nodes) {
        this.base = (NodeState)Preconditions.checkNotNull((Object)base);
        this.properties = ((Map)Preconditions.checkNotNull(properties)).isEmpty() ? Collections.emptyMap() : Maps.newHashMap(properties);
        if (((Map)Preconditions.checkNotNull(nodes)).isEmpty()) {
            this.nodes = Collections.emptyMap();
        } else {
            this.nodes = Maps.newHashMap();
            for (Map.Entry<String, MutableNodeState> entry : nodes.entrySet()) {
                this.nodes.put(entry.getKey(), entry.getValue().snapshot());
            }
        }
    }

    @Nonnull
    public NodeState getBaseState() {
        return this.base;
    }

    @Override
    @Nonnull
    public NodeBuilder builder() {
        return new MemoryNodeBuilder(this);
    }

    @Override
    public boolean exists() {
        return this.base.exists();
    }

    @Override
    public long getPropertyCount() {
        return ModifiedNodeState.getPropertyCount(this.base, this.properties);
    }

    @Override
    public boolean hasProperty(@Nonnull String name) {
        return ModifiedNodeState.hasProperty(this.base, this.properties, name);
    }

    @Override
    public PropertyState getProperty(@Nonnull String name) {
        return ModifiedNodeState.getProperty(this.base, this.properties, name);
    }

    @Override
    @Nonnull
    public Iterable<? extends PropertyState> getProperties() {
        return ModifiedNodeState.getProperties(this.base, this.properties, false);
    }

    @Override
    public long getChildNodeCount(long max) {
        return ModifiedNodeState.getChildNodeCount(this.base, this.nodes, max);
    }

    @Override
    public boolean hasChildNode(@Nonnull String name) {
        NodeState child = this.nodes.get(name);
        if (child != null) {
            return child.exists();
        }
        return this.base.hasChildNode(name);
    }

    @Override
    @Nonnull
    public NodeState getChildNode(@Nonnull String name) {
        NodeState child = this.nodes.get(name);
        if (child == null) {
            child = this.base.getChildNode(name);
        }
        return child;
    }

    @Override
    public Iterable<String> getChildNodeNames() {
        return ModifiedNodeState.getChildNodeNames(this.base, this.nodes, false);
    }

    @Override
    @Nonnull
    public Iterable<? extends ChildNodeEntry> getChildNodeEntries() {
        if (!this.base.exists()) {
            return Collections.emptyList();
        }
        if (this.nodes.isEmpty()) {
            return this.base.getChildNodeEntries();
        }
        Predicate predicate = Predicates.compose((Predicate)Predicates.not((Predicate)Predicates.in(this.nodes.keySet())), ChildNodeEntry.GET_NAME);
        return Iterables.concat((Iterable)Iterables.filter(this.base.getChildNodeEntries(), (Predicate)predicate), MemoryChildNodeEntry.iterable(Maps.filterValues(this.nodes, NodeState.EXISTS).entrySet()));
    }

    @Override
    public boolean compareAgainstBaseState(NodeState base, final NodeStateDiff diff) {
        if (this == base) {
            return true;
        }
        for (Map.Entry<String, PropertyState> entry : this.properties.entrySet()) {
            PropertyState before = base.getProperty(entry.getKey());
            PropertyState after = entry.getValue();
            if (!(after == null ? before != null && !diff.propertyDeleted(before) : (before == null ? !diff.propertyAdded(after) : !before.equals(after) && !diff.propertyChanged(before, after)))) continue;
            return false;
        }
        for (Map.Entry<String, Object> entry : this.nodes.entrySet()) {
            String name = entry.getKey();
            NodeState before = base.getChildNode(name);
            NodeState after = (NodeState)entry.getValue();
            if (!(!after.exists() ? before.exists() && !diff.childNodeDeleted(name, before) : (!before.exists() ? !diff.childNodeAdded(name, after) : before != after && !diff.childNodeChanged(name, before, after)))) continue;
            return false;
        }
        return this.base.compareAgainstBaseState(base, new NodeStateDiff(){

            @Override
            public boolean propertyAdded(PropertyState after) {
                return ModifiedNodeState.this.properties.containsKey(after.getName()) || diff.propertyAdded(after);
            }

            @Override
            public boolean propertyChanged(PropertyState before, PropertyState after) {
                return ModifiedNodeState.this.properties.containsKey(before.getName()) || diff.propertyChanged(before, after);
            }

            @Override
            public boolean propertyDeleted(PropertyState before) {
                return ModifiedNodeState.this.properties.containsKey(before.getName()) || diff.propertyDeleted(before);
            }

            @Override
            public boolean childNodeAdded(String name, NodeState after) {
                return ModifiedNodeState.this.nodes.containsKey(name) || diff.childNodeAdded(name, after);
            }

            @Override
            public boolean childNodeChanged(String name, NodeState before, NodeState after) {
                return ModifiedNodeState.this.nodes.containsKey(name) || diff.childNodeChanged(name, before, after);
            }

            @Override
            public boolean childNodeDeleted(String name, NodeState before) {
                return ModifiedNodeState.this.nodes.containsKey(name) || diff.childNodeDeleted(name, before);
            }
        });
    }
}

