/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.nodetype.write;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.plugins.index.IndexUtils;
import org.apache.jackrabbit.oak.plugins.memory.EmptyNodeState;
import org.apache.jackrabbit.oak.plugins.memory.MemoryNodeStore;
import org.apache.jackrabbit.oak.plugins.memory.ModifiedNodeState;
import org.apache.jackrabbit.oak.plugins.name.NamespaceEditorProvider;
import org.apache.jackrabbit.oak.plugins.name.Namespaces;
import org.apache.jackrabbit.oak.plugins.nodetype.NodeTypeConstants;
import org.apache.jackrabbit.oak.plugins.nodetype.TypeEditorProvider;
import org.apache.jackrabbit.oak.plugins.nodetype.write.NodeTypeRegistry;
import org.apache.jackrabbit.oak.plugins.tree.RootFactory;
import org.apache.jackrabbit.oak.spi.commit.CompositeEditorProvider;
import org.apache.jackrabbit.oak.spi.commit.EditorHook;
import org.apache.jackrabbit.oak.spi.lifecycle.RepositoryInitializer;
import org.apache.jackrabbit.oak.spi.state.ApplyDiff;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;

public class InitialContent
implements RepositoryInitializer,
NodeTypeConstants {
    public static final NodeState INITIAL_CONTENT = InitialContent.createInitialContent();
    private boolean prePopulateVS = false;

    private static NodeState createInitialContent() {
        NodeBuilder builder = EmptyNodeState.EMPTY_NODE.builder();
        new InitialContent().initialize(builder);
        return ModifiedNodeState.squeeze(builder.getNodeState());
    }

    @Override
    public void initialize(@Nonnull NodeBuilder builder) {
        builder.setProperty("jcr:primaryType", "rep:root", Type.NAME);
        if (!builder.hasChildNode("jcr:system")) {
            NodeBuilder system = builder.child("jcr:system");
            system.setProperty("jcr:primaryType", "rep:system", Type.NAME);
            system.child("jcr:versionStorage").setProperty("jcr:primaryType", "rep:versionStorage", Type.NAME);
            system.child("jcr:nodeTypes").setProperty("jcr:primaryType", "rep:nodeTypes", Type.NAME);
            system.child("jcr:activities").setProperty("jcr:primaryType", "rep:Activities", Type.NAME);
            Namespaces.setupNamespaces(system);
        }
        NodeBuilder versionStorage = builder.child("jcr:system").child("jcr:versionStorage");
        if (this.prePopulateVS && !this.isInitialized(versionStorage)) {
            this.createIntermediateNodes(versionStorage);
        }
        if (!builder.hasChildNode("oak:index")) {
            NodeBuilder index = IndexUtils.getOrCreateOakIndex(builder);
            IndexUtils.createIndexDefinition(index, "uuid", true, true, (Collection<String>)ImmutableList.of((Object)"jcr:uuid"), null);
            IndexUtils.createIndexDefinition(index, "nodetype", true, false, (Collection<String>)ImmutableList.of((Object)"jcr:primaryType", (Object)"jcr:mixinTypes"), null);
            IndexUtils.createReferenceIndex(index);
            index.child("counter").setProperty("jcr:primaryType", "oak:QueryIndexDefinition", Type.NAME).setProperty("type", "counter").setProperty("async", "async");
        }
        NodeState base = ModifiedNodeState.squeeze(builder.getNodeState());
        MemoryNodeStore store = new MemoryNodeStore(base);
        NodeTypeRegistry.registerBuiltIn(RootFactory.createSystemRoot(store, new EditorHook(new CompositeEditorProvider(new NamespaceEditorProvider(), new TypeEditorProvider())), null, null, null, null));
        NodeState target = store.getRoot();
        target.compareAgainstBaseState(base, new ApplyDiff(builder));
    }

    public InitialContent withPrePopulatedVersionStore() {
        this.prePopulateVS = true;
        return this;
    }

    private boolean isInitialized(NodeBuilder versionStorage) {
        PropertyState init = versionStorage.getProperty(":initialized");
        return init != null && init.getValue(Type.LONG) > 0L;
    }

    private void createIntermediateNodes(NodeBuilder versionStorage) {
        String fmt = "%02x";
        versionStorage.setProperty(":initialized", 1);
        for (int i = 0; i < 255; ++i) {
            NodeBuilder c = this.storageChild(versionStorage, String.format(fmt, i));
            for (int j = 0; j < 255; ++j) {
                this.storageChild(c, String.format(fmt, j));
            }
        }
    }

    private NodeBuilder storageChild(NodeBuilder node, String name) {
        NodeBuilder c = node.child(name);
        if (!c.hasProperty("jcr:primaryType")) {
            c.setProperty("jcr:primaryType", "rep:versionStorage", Type.NAME);
        }
        return c;
    }
}

