/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.observation.filter;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.plugins.observation.filter.ConstantFilter;
import org.apache.jackrabbit.oak.plugins.observation.filter.EventFilter;
import org.apache.jackrabbit.oak.spi.state.NodeState;

public final class Filters {
    private Filters() {
    }

    @Nonnull
    public static EventFilter not(final @Nonnull EventFilter filter) {
        return new EventFilter(){

            @Override
            public boolean includeAdd(PropertyState after) {
                return !filter.includeAdd(after);
            }

            @Override
            public boolean includeChange(PropertyState before, PropertyState after) {
                return !filter.includeChange(before, after);
            }

            @Override
            public boolean includeDelete(PropertyState before) {
                return !filter.includeDelete(before);
            }

            @Override
            public boolean includeAdd(String name, NodeState after) {
                return !filter.includeAdd(name, after);
            }

            @Override
            public boolean includeDelete(String name, NodeState before) {
                return !filter.includeDelete(name, before);
            }

            @Override
            public boolean includeMove(String sourcePath, String name, NodeState moved) {
                return !filter.includeMove(sourcePath, name, moved);
            }

            @Override
            public boolean includeReorder(String destName, String name, NodeState reordered) {
                return !filter.includeReorder(destName, name, reordered);
            }

            @Override
            public EventFilter create(String name, NodeState before, NodeState after) {
                EventFilter childFilter = filter.create(name, before, after);
                return childFilter == null ? ConstantFilter.INCLUDE_ALL : Filters.not(childFilter);
            }
        };
    }

    @Nonnull
    public static EventFilter any(EventFilter ... filters) {
        return Filters.any(Lists.newArrayList((Object[])((Object[])Preconditions.checkNotNull((Object)filters))));
    }

    @Nonnull
    public static EventFilter all(EventFilter ... filters) {
        return Filters.all(Lists.newArrayList((Object[])((Object[])Preconditions.checkNotNull((Object)filters))));
    }

    @Nonnull
    public static EventFilter includeAll() {
        return ConstantFilter.INCLUDE_ALL;
    }

    @Nonnull
    public static EventFilter excludeAll() {
        return ConstantFilter.EXCLUDE_ALL;
    }

    @Nonnull
    public static EventFilter any(final @Nonnull List<EventFilter> filters) {
        if (((List)Preconditions.checkNotNull(filters)).isEmpty()) {
            return ConstantFilter.EXCLUDE_ALL;
        }
        if (filters.size() == 1) {
            return filters.get(0);
        }
        return new EventFilter(){

            @Override
            public boolean includeAdd(PropertyState after) {
                for (EventFilter filter : filters) {
                    if (!filter.includeAdd(after)) continue;
                    return true;
                }
                return false;
            }

            @Override
            public boolean includeChange(PropertyState before, PropertyState after) {
                for (EventFilter filter : filters) {
                    if (!filter.includeChange(before, after)) continue;
                    return true;
                }
                return false;
            }

            @Override
            public boolean includeDelete(PropertyState before) {
                for (EventFilter filter : filters) {
                    if (!filter.includeDelete(before)) continue;
                    return true;
                }
                return false;
            }

            @Override
            public boolean includeAdd(String name, NodeState after) {
                for (EventFilter filter : filters) {
                    if (!filter.includeAdd(name, after)) continue;
                    return true;
                }
                return false;
            }

            @Override
            public boolean includeDelete(String name, NodeState before) {
                for (EventFilter filter : filters) {
                    if (!filter.includeDelete(name, before)) continue;
                    return true;
                }
                return false;
            }

            @Override
            public boolean includeMove(String sourcePath, String name, NodeState moved) {
                for (EventFilter filter : filters) {
                    if (!filter.includeMove(sourcePath, name, moved)) continue;
                    return true;
                }
                return false;
            }

            @Override
            public boolean includeReorder(String destName, String name, NodeState reordered) {
                for (EventFilter filter : filters) {
                    if (!filter.includeReorder(destName, name, reordered)) continue;
                    return true;
                }
                return false;
            }

            @Override
            public EventFilter create(String name, NodeState before, NodeState after) {
                ArrayList childFilters = Lists.newArrayList();
                for (EventFilter filter : filters) {
                    EventFilter childFilter = filter.create(name, before, after);
                    if (childFilter == null) continue;
                    childFilters.add(childFilter);
                }
                return Filters.any(childFilters);
            }
        };
    }

    @Nonnull
    public static EventFilter all(final @Nonnull List<EventFilter> filters) {
        if (((List)Preconditions.checkNotNull(filters)).isEmpty()) {
            return ConstantFilter.INCLUDE_ALL;
        }
        if (filters.size() == 1) {
            return filters.get(0);
        }
        return new EventFilter(){

            @Override
            public boolean includeAdd(PropertyState after) {
                for (EventFilter filter : filters) {
                    if (filter.includeAdd(after)) continue;
                    return false;
                }
                return true;
            }

            @Override
            public boolean includeChange(PropertyState before, PropertyState after) {
                for (EventFilter filter : filters) {
                    if (filter.includeChange(before, after)) continue;
                    return false;
                }
                return true;
            }

            @Override
            public boolean includeDelete(PropertyState before) {
                for (EventFilter filter : filters) {
                    if (filter.includeDelete(before)) continue;
                    return false;
                }
                return true;
            }

            @Override
            public boolean includeAdd(String name, NodeState after) {
                for (EventFilter filter : filters) {
                    if (filter.includeAdd(name, after)) continue;
                    return false;
                }
                return true;
            }

            @Override
            public boolean includeDelete(String name, NodeState before) {
                for (EventFilter filter : filters) {
                    if (filter.includeDelete(name, before)) continue;
                    return false;
                }
                return true;
            }

            @Override
            public boolean includeMove(String sourcePath, String name, NodeState moved) {
                for (EventFilter filter : filters) {
                    if (filter.includeMove(sourcePath, name, moved)) continue;
                    return false;
                }
                return true;
            }

            @Override
            public boolean includeReorder(String destName, String name, NodeState reordered) {
                for (EventFilter filter : filters) {
                    if (filter.includeReorder(destName, name, reordered)) continue;
                    return false;
                }
                return true;
            }

            @Override
            public EventFilter create(String name, NodeState before, NodeState after) {
                ArrayList childFilters = Lists.newArrayList();
                for (EventFilter filter : filters) {
                    EventFilter childFilter = filter.create(name, before, after);
                    if (childFilter == null) {
                        return null;
                    }
                    childFilters.add(childFilter);
                }
                return Filters.all(childFilters);
            }
        };
    }
}

