/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.segment;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.hash.Hashing;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.jackrabbit.oak.api.Blob;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.IOUtils;
import org.apache.jackrabbit.oak.plugins.memory.BinaryPropertyState;
import org.apache.jackrabbit.oak.plugins.memory.EmptyNodeState;
import org.apache.jackrabbit.oak.plugins.memory.MultiBinaryPropertyState;
import org.apache.jackrabbit.oak.plugins.memory.PropertyStates;
import org.apache.jackrabbit.oak.plugins.segment.CompactionMap;
import org.apache.jackrabbit.oak.plugins.segment.RecordId;
import org.apache.jackrabbit.oak.plugins.segment.SegmentBlob;
import org.apache.jackrabbit.oak.plugins.segment.SegmentNodeBuilder;
import org.apache.jackrabbit.oak.plugins.segment.SegmentNodeState;
import org.apache.jackrabbit.oak.plugins.segment.SegmentWriter;
import org.apache.jackrabbit.oak.spi.state.ApplyDiff;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Compactor {
    private static final Logger log = LoggerFactory.getLogger(Compactor.class);
    private final SegmentWriter writer;
    private final CompactionMap map;
    private final Map<String, List<RecordId>> binaries = Maps.newHashMap();
    private final boolean cloneBinaries;

    static long[] recordAsKey(RecordId r) {
        return new long[]{r.getSegmentId().getMostSignificantBits(), r.getSegmentId().getLeastSignificantBits(), r.getOffset()};
    }

    public Compactor(SegmentWriter writer) {
        this(writer, false);
    }

    public Compactor(SegmentWriter writer, boolean cloneBinaries) {
        this.writer = writer;
        this.map = new CompactionMap(100000, writer.getTracker());
        this.cloneBinaries = cloneBinaries;
    }

    protected SegmentNodeBuilder process(NodeState before, NodeState after) {
        SegmentNodeBuilder builder = new SegmentNodeBuilder(this.writer.writeNode(before), this.writer);
        after.compareAgainstBaseState(before, new CompactDiff(builder));
        return builder;
    }

    public SegmentNodeState compact(NodeState before, NodeState after) {
        SegmentNodeState compacted = this.process(before, after).getNodeState();
        this.writer.flush();
        return compacted;
    }

    public CompactionMap getCompactionMap() {
        this.map.compress();
        return this.map;
    }

    private PropertyState compact(PropertyState property) {
        String name = property.getName();
        Type<?> type = property.getType();
        if (type == Type.BINARY) {
            Blob blob = this.compact(property.getValue(Type.BINARY));
            return BinaryPropertyState.binaryProperty(name, blob);
        }
        if (type == Type.BINARIES) {
            ArrayList<Blob> blobs = new ArrayList<Blob>();
            for (Blob blob : property.getValue(Type.BINARIES)) {
                blobs.add(this.compact(blob));
            }
            return MultiBinaryPropertyState.binaryPropertyFromBlob(name, blobs);
        }
        Object value = property.getValue(type);
        return PropertyStates.createProperty(name, value, type);
    }

    private Blob compact(Blob blob) {
        if (blob instanceof SegmentBlob) {
            SegmentBlob sb = (SegmentBlob)blob;
            try {
                RecordId id = sb.getRecordId();
                RecordId compactedId = this.map.get(id);
                if (compactedId != null) {
                    return new SegmentBlob(compactedId);
                }
                if (sb.isExternal() || sb.length() < 16512L) {
                    SegmentBlob clone = sb.clone(this.writer, this.cloneBinaries);
                    this.map.put(id, clone.getRecordId());
                    return clone;
                }
                String key = Compactor.getBlobKey(blob);
                ArrayList ids = this.binaries.get(key);
                if (ids != null) {
                    for (RecordId duplicateId : ids) {
                        if (!new SegmentBlob(duplicateId).equals(sb)) continue;
                        this.map.put(id, duplicateId);
                        return new SegmentBlob(duplicateId);
                    }
                }
                sb = sb.clone(this.writer, this.cloneBinaries);
                this.map.put(id, sb.getRecordId());
                if (ids == null) {
                    ids = Lists.newArrayList();
                    this.binaries.put(key, ids);
                }
                ids.add(sb.getRecordId());
                return sb;
            }
            catch (IOException e) {
                log.warn("Failed to compact a blob", (Throwable)e);
            }
        }
        return blob;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getBlobKey(Blob blob) throws IOException {
        InputStream stream = blob.getNewStream();
        try {
            byte[] buffer = new byte[4096];
            int n = IOUtils.readFully(stream, buffer, 0, buffer.length);
            String string = blob.length() + ":" + Hashing.sha1().hashBytes(buffer, 0, n);
            return string;
        }
        finally {
            stream.close();
        }
    }

    private class CompactDiff
    extends ApplyDiff {
        CompactDiff(NodeBuilder builder) {
            super(builder);
        }

        @Override
        public boolean propertyAdded(PropertyState after) {
            return super.propertyAdded(Compactor.this.compact(after));
        }

        @Override
        public boolean propertyChanged(PropertyState before, PropertyState after) {
            return super.propertyChanged(before, Compactor.this.compact(after));
        }

        @Override
        public boolean childNodeAdded(String name, NodeState after) {
            NodeBuilder child;
            boolean success;
            RecordId id = null;
            if (after instanceof SegmentNodeState) {
                id = ((SegmentNodeState)after).getRecordId();
                RecordId compactedId = Compactor.this.map.get(id);
                if (compactedId != null) {
                    this.builder.setChildNode(name, new SegmentNodeState(compactedId));
                    return true;
                }
            }
            if (success = EmptyNodeState.compareAgainstEmptyState(after, new CompactDiff(child = EmptyNodeState.EMPTY_NODE.builder()))) {
                SegmentNodeState state = Compactor.this.writer.writeNode(child.getNodeState());
                this.builder.setChildNode(name, state);
                if (id != null) {
                    Compactor.this.map.put(id, state.getRecordId());
                }
            }
            return success;
        }

        @Override
        public boolean childNodeChanged(String name, NodeState before, NodeState after) {
            NodeBuilder child;
            boolean success;
            RecordId id = null;
            if (after instanceof SegmentNodeState) {
                id = ((SegmentNodeState)after).getRecordId();
                RecordId compactedId = Compactor.this.map.get(id);
                if (compactedId != null) {
                    this.builder.setChildNode(name, new SegmentNodeState(compactedId));
                    return true;
                }
            }
            if (success = after.compareAgainstBaseState(before, new CompactDiff(child = this.builder.getChildNode(name)))) {
                RecordId compactedId = Compactor.this.writer.writeNode(child.getNodeState()).getRecordId();
                if (id != null) {
                    Compactor.this.map.put(id, compactedId);
                }
            }
            return success;
        }
    }
}

