/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.segment;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.plugins.memory.AbstractPropertyState;
import org.apache.jackrabbit.oak.plugins.segment.ListRecord;
import org.apache.jackrabbit.oak.plugins.segment.PropertyTemplate;
import org.apache.jackrabbit.oak.plugins.segment.Record;
import org.apache.jackrabbit.oak.plugins.segment.RecordId;
import org.apache.jackrabbit.oak.plugins.segment.Segment;
import org.apache.jackrabbit.oak.plugins.segment.SegmentBlob;
import org.apache.jackrabbit.oak.plugins.value.Conversions;

public class SegmentPropertyState
extends Record
implements PropertyState {
    private final PropertyTemplate template;

    public SegmentPropertyState(RecordId id, PropertyTemplate template) {
        super(id);
        this.template = (PropertyTemplate)Preconditions.checkNotNull((Object)template);
    }

    private ListRecord getValueList(Segment segment) {
        RecordId listId = this.getRecordId();
        int size = 1;
        if (this.isArray() && (size = segment.readInt(this.getOffset())) > 0) {
            listId = segment.readRecordId(this.getOffset(4));
        }
        return new ListRecord(listId, size);
    }

    Map<String, RecordId> getValueRecords() {
        if (this.getType().tag() == 2) {
            return Collections.emptyMap();
        }
        HashMap map = Maps.newHashMap();
        Segment segment = this.getSegment();
        ListRecord values = this.getValueList(segment);
        for (int i = 0; i < values.size(); ++i) {
            RecordId valueId = values.getEntry(i);
            String value = segment.readString(valueId);
            map.put(value, valueId);
        }
        return map;
    }

    @Override
    @Nonnull
    public String getName() {
        return this.template.getName();
    }

    @Override
    public Type<?> getType() {
        return this.template.getType();
    }

    @Override
    public boolean isArray() {
        return this.getType().isArray();
    }

    @Override
    public int count() {
        if (this.isArray()) {
            return this.getSegment().readInt(this.getOffset());
        }
        return 1;
    }

    @Override
    @Nonnull
    public <T> T getValue(Type<T> type) {
        Segment segment = this.getSegment();
        if (this.isArray()) {
            Preconditions.checkState((boolean)type.isArray());
            ListRecord values = this.getValueList(segment);
            if (values.size() == 0) {
                return (T)Collections.emptyList();
            }
            if (values.size() == 1) {
                return (T)Collections.singletonList(this.getValue(segment, values.getEntry(0), type.getBaseType()));
            }
            Type<?> base = type.getBaseType();
            ArrayList list = Lists.newArrayListWithCapacity((int)values.size());
            for (RecordId id : values.getEntries()) {
                list.add(this.getValue(segment, id, base));
            }
            return (T)list;
        }
        RecordId id = this.getRecordId();
        if (type.isArray()) {
            return (T)Collections.singletonList(this.getValue(segment, id, type.getBaseType()));
        }
        return this.getValue(segment, id, type);
    }

    @Override
    public long size() {
        return this.size(0);
    }

    @Override
    @Nonnull
    public <T> T getValue(Type<T> type, int index) {
        Preconditions.checkNotNull(type);
        Preconditions.checkArgument((!type.isArray() ? 1 : 0) != 0, (Object)"Type must not be an array type");
        Segment segment = this.getSegment();
        ListRecord values = this.getValueList(segment);
        Preconditions.checkElementIndex((int)index, (int)values.size());
        return this.getValue(segment, values.getEntry(index), type);
    }

    private <T> T getValue(Segment segment, RecordId id, Type<T> type) {
        if (type == Type.BINARY) {
            return (T)new SegmentBlob(id);
        }
        String value = segment.readString(id);
        if (type == Type.STRING || type == Type.URI || type == Type.DATE || type == Type.NAME || type == Type.PATH || type == Type.REFERENCE || type == Type.WEAKREFERENCE) {
            return (T)value;
        }
        Type<?> base = this.getType();
        if (base.isArray()) {
            base = base.getBaseType();
        }
        Conversions.Converter converter = Conversions.convert(value, base);
        if (type == Type.BOOLEAN) {
            return (T)Boolean.valueOf(converter.toBoolean());
        }
        if (type == Type.DECIMAL) {
            return (T)converter.toDecimal();
        }
        if (type == Type.DOUBLE) {
            return (T)Double.valueOf(converter.toDouble());
        }
        if (type == Type.LONG) {
            return (T)Long.valueOf(converter.toLong());
        }
        throw new UnsupportedOperationException("Unknown type: " + type);
    }

    @Override
    public long size(int index) {
        Segment segment = this.getSegment();
        ListRecord values = this.getValueList(segment);
        Preconditions.checkElementIndex((int)index, (int)values.size());
        return segment.readLength(values.getEntry(0));
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof SegmentPropertyState) {
            SegmentPropertyState that = (SegmentPropertyState)object;
            if (!this.template.equals(that.template)) {
                return false;
            }
            if (this.getRecordId().equals(that.getRecordId())) {
                return true;
            }
        }
        return object instanceof PropertyState && AbstractPropertyState.equal(this, (PropertyState)object);
    }

    @Override
    public int hashCode() {
        return AbstractPropertyState.hashCode(this);
    }

    @Override
    public String toString() {
        return AbstractPropertyState.toString(this);
    }
}

