/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.segment.compaction;

import org.apache.jackrabbit.oak.plugins.segment.CompactionMap;
import org.apache.jackrabbit.oak.plugins.segment.compaction.CompactionStrategy;
import org.apache.jackrabbit.oak.plugins.segment.compaction.CompactionStrategyMBean;

public class DefaultCompactionStrategyMBean
implements CompactionStrategyMBean {
    private final CompactionStrategy strategy;

    public DefaultCompactionStrategyMBean(CompactionStrategy strategy) {
        this.strategy = strategy;
    }

    @Override
    public boolean isCloneBinaries() {
        return this.strategy.cloneBinaries();
    }

    @Override
    public void setCloneBinaries(boolean cloneBinaries) {
        this.strategy.setCloneBinaries(cloneBinaries);
    }

    @Override
    public boolean isPausedCompaction() {
        return this.strategy.isPaused();
    }

    @Override
    public void setPausedCompaction(boolean pausedCompaction) {
        this.strategy.setPaused(pausedCompaction);
    }

    @Override
    public String getCleanupStrategy() {
        return this.strategy.getCleanupType();
    }

    @Override
    public void setCleanupStrategy(String cleanup) {
        this.strategy.setCleanupType(CompactionStrategy.CleanupType.valueOf(cleanup));
    }

    @Override
    public long getOlderThan() {
        return this.strategy.getOlderThan();
    }

    @Override
    public void setOlderThan(long olderThan) {
        this.strategy.setOlderThan(olderThan);
    }

    @Override
    public byte getMemoryThreshold() {
        return this.strategy.getMemoryThreshold();
    }

    @Override
    public void setMemoryThreshold(byte memory) {
        this.strategy.setMemoryThreshold(memory);
    }

    @Override
    public String getCompactionMapStats() {
        CompactionMap cm = this.strategy.getCompactionMap();
        if (cm != null) {
            return cm.getCompactionStats();
        }
        return "";
    }
}

