/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.segment.file;

import com.google.common.hash.BloomFilter;
import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import java.io.File;
import java.util.UUID;
import org.apache.jackrabbit.oak.api.Blob;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.plugins.segment.RecordIdSet;
import org.apache.jackrabbit.oak.plugins.segment.SegmentBlob;
import org.apache.jackrabbit.oak.plugins.segment.SegmentId;
import org.apache.jackrabbit.oak.plugins.segment.SegmentNodeState;
import org.apache.jackrabbit.oak.plugins.segment.SegmentPropertyState;
import org.apache.jackrabbit.oak.plugins.segment.file.TarEntryVisitor;
import org.apache.jackrabbit.oak.plugins.segment.file.TarReader;
import org.apache.jackrabbit.oak.spi.state.ChildNodeEntry;

class CompactionGainEstimate
implements TarEntryVisitor {
    public static final int UUID_SAMPLING_RATE = Integer.getInteger("compaction.estimate.sampling.rate", 1);
    private static final Funnel<UUID> UUID_FUNNEL = new Funnel<UUID>(){

        public void funnel(UUID from, PrimitiveSink into) {
            into.putLong(from.getMostSignificantBits());
            into.putLong(from.getLeastSignificantBits());
        }
    };
    private final BloomFilter<UUID> uuids;
    private long totalSize = 0L;
    private long reachableSize = 0L;

    CompactionGainEstimate(SegmentNodeState node, int estimatedBulkCount) {
        this.uuids = BloomFilter.create(UUID_FUNNEL, (int)estimatedBulkCount);
        this.collectReferencedSegments(node, new RecordIdSet());
    }

    private void collectReferencedSegments(SegmentNodeState node, RecordIdSet visited) {
        if (visited.addIfNotPresent(node.getRecordId())) {
            this.collectUUID(CompactionGainEstimate.asUUID(node.getRecordId().getSegmentId()));
            for (PropertyState propertyState : node.getProperties()) {
                if (propertyState instanceof SegmentPropertyState) {
                    this.collectUUID(CompactionGainEstimate.asUUID(((SegmentPropertyState)propertyState).getRecordId().getSegmentId()));
                }
                for (Blob blob : propertyState.getValue(Type.BINARIES)) {
                    for (SegmentId id : SegmentBlob.getBulkSegmentIds(blob)) {
                        this.collectUUID(CompactionGainEstimate.asUUID(id));
                    }
                }
            }
            for (ChildNodeEntry childNodeEntry : node.getChildNodeEntries()) {
                this.collectReferencedSegments((SegmentNodeState)childNodeEntry.getNodeState(), visited);
            }
        }
    }

    private void collectUUID(UUID uuid) {
        if (CompactionGainEstimate.includeUUID(uuid)) {
            this.uuids.put((Object)uuid);
        }
    }

    private static boolean includeUUID(UUID uuid) {
        return uuid.getLeastSignificantBits() % (long)UUID_SAMPLING_RATE == 0L;
    }

    private static UUID asUUID(SegmentId id) {
        return new UUID(id.getMostSignificantBits(), id.getLeastSignificantBits());
    }

    public long estimateCompactionGain() {
        if (this.totalSize == 0L) {
            return 0L;
        }
        return 100L * (this.totalSize - this.reachableSize) / this.totalSize;
    }

    public long getTotalSize() {
        return this.totalSize;
    }

    public long getReachableSize() {
        return this.reachableSize;
    }

    @Override
    public void visit(long msb, long lsb, File file, int offset, int size) {
        UUID uuid = new UUID(msb, lsb);
        if (CompactionGainEstimate.includeUUID(uuid)) {
            int entrySize = TarReader.getEntrySize(size);
            this.totalSize += (long)entrySize;
            if (this.uuids.mightContain((Object)uuid)) {
                this.reachableSize += (long)entrySize;
            }
        }
    }
}

