/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.segment.file;

import com.google.common.base.Charsets;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.CRC32;
import org.apache.commons.io.FileUtils;
import org.apache.jackrabbit.oak.plugins.segment.CompactionMap;
import org.apache.jackrabbit.oak.plugins.segment.Segment;
import org.apache.jackrabbit.oak.plugins.segment.SegmentId;
import org.apache.jackrabbit.oak.plugins.segment.file.FileAccess;
import org.apache.jackrabbit.oak.plugins.segment.file.TarEntry;
import org.apache.jackrabbit.oak.plugins.segment.file.TarEntryVisitor;
import org.apache.jackrabbit.oak.plugins.segment.file.TarWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TarReader {
    private static final Logger log = LoggerFactory.getLogger(TarReader.class);
    private static final Logger GC_LOG = LoggerFactory.getLogger((String)(TarReader.class.getName() + "-GC"));
    private static final int INDEX_MAGIC = 170937098;
    private static final Pattern NAME_PATTERN = Pattern.compile("([0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12})(\\.([0-9a-f]{8}))?(\\..*)?");
    private static final int BLOCK_SIZE = 512;
    private final File file;
    private final FileAccess access;
    private final ByteBuffer index;

    static int getEntrySize(int size) {
        return 512 + size + TarWriter.getPaddingSize(size);
    }

    static TarReader open(File file, boolean memoryMapping) throws IOException {
        TarReader reader = TarReader.openFirstFileWithValidIndex(Collections.singletonList(file), memoryMapping);
        if (reader != null) {
            return reader;
        }
        throw new IOException("Failed to open tar file " + file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static TarReader open(Map<Character, File> files, boolean memoryMapping) throws IOException {
        TreeMap sorted = Maps.newTreeMap();
        sorted.putAll(files);
        ArrayList list = Lists.newArrayList(sorted.values());
        Collections.reverse(list);
        TarReader reader = TarReader.openFirstFileWithValidIndex(list, memoryMapping);
        if (reader != null) {
            return reader;
        }
        log.warn("Could not find a valid tar index in {}, recovering...", (Object)list);
        LinkedHashMap entries = Maps.newLinkedHashMap();
        for (File file : sorted.values()) {
            log.info("Recovering segments from tar file {}", (Object)file);
            try {
                RandomAccessFile access = new RandomAccessFile(file, "r");
                try {
                    TarReader.recoverEntries(file, access, entries);
                }
                finally {
                    access.close();
                }
            }
            catch (IOException e) {
                log.warn("Could not read tar file " + file + ", skipping...", (Throwable)e);
            }
            TarReader.backupSafely(file);
        }
        File file = (File)sorted.values().iterator().next();
        log.info("Regenerating tar file " + file);
        TarWriter writer = new TarWriter(file);
        for (Map.Entry entry : entries.entrySet()) {
            UUID uuid = (UUID)entry.getKey();
            byte[] data = (byte[])entry.getValue();
            writer.writeEntry(uuid.getMostSignificantBits(), uuid.getLeastSignificantBits(), data, 0, data.length);
        }
        writer.close();
        reader = TarReader.openFirstFileWithValidIndex(Collections.singletonList(file), memoryMapping);
        if (reader != null) {
            return reader;
        }
        throw new IOException("Failed to open recovered tar file " + file);
    }

    private static void backupSafely(File file) throws IOException {
        File parent = file.getParentFile();
        String name = file.getName();
        File backup = new File(parent, name + ".bak");
        int i = 2;
        while (backup.exists()) {
            backup = new File(parent, name + "." + i + ".bak");
            ++i;
        }
        log.info("Backing up " + file + " to " + backup.getName());
        if (!file.renameTo(backup)) {
            log.warn("Renaming failed, so using copy to backup {}", (Object)file);
            FileUtils.copyFile((File)file, (File)backup);
            if (!file.delete()) {
                throw new IOException("Could not remove broken tar file " + file);
            }
        }
    }

    /*
     * Exception decompiling
     */
    private static TarReader openFirstFileWithValidIndex(List<File> files, boolean memoryMapping) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK], 6[CATCHBLOCK], 0[TRYBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static ByteBuffer loadAndValidateIndex(RandomAccessFile file, String name) throws IOException {
        long length = file.length();
        if (length % 512L != 0L || length < 3072L || length > Integer.MAX_VALUE) {
            log.warn("Unexpected size {} of tar file {}", (Object)length, (Object)name);
            return null;
        }
        ByteBuffer meta = ByteBuffer.allocate(16);
        file.seek(length - 1024L - 16L);
        file.readFully(meta.array());
        int crc32 = meta.getInt();
        int count = meta.getInt();
        int bytes = meta.getInt();
        int magic = meta.getInt();
        if (magic != 170937098) {
            return null;
        }
        if (count < 1 || bytes < count * 24 + 16 || bytes % 512 != 0) {
            log.warn("Invalid index metadata in tar file {}", (Object)name);
            return null;
        }
        ByteBuffer index = ByteBuffer.allocate(count * 24);
        file.seek(length - 1024L - 16L - (long)(count * 24));
        file.readFully(index.array());
        index.mark();
        CRC32 checksum = new CRC32();
        long limit = length - 1024L - (long)bytes - 512L;
        long lastmsb = Long.MIN_VALUE;
        long lastlsb = Long.MIN_VALUE;
        byte[] entry = new byte[24];
        for (int i = 0; i < count; ++i) {
            index.get(entry);
            checksum.update(entry);
            ByteBuffer buffer = ByteBuffer.wrap(entry);
            long msb = buffer.getLong();
            long lsb = buffer.getLong();
            int offset = buffer.getInt();
            int size = buffer.getInt();
            if (lastmsb > msb || lastmsb == msb && lastlsb > lsb) {
                log.warn("Incorrect index ordering in tar file {}", (Object)name);
                return null;
            }
            if (lastmsb == msb && lastlsb == lsb && i > 0) {
                log.warn("Duplicate index entry in tar file {}", (Object)name);
                return null;
            }
            if (offset < 0 || offset % 512 != 0) {
                log.warn("Invalid index entry offset in tar file {}", (Object)name);
                return null;
            }
            if (size < 1 || (long)(offset + size) > limit) {
                log.warn("Invalid index entry size in tar file {}", (Object)name);
                return null;
            }
            lastmsb = msb;
            lastlsb = lsb;
        }
        if (crc32 != (int)checksum.getValue()) {
            log.warn("Invalid index checksum in tar file {}", (Object)name);
            return null;
        }
        index.reset();
        return index;
    }

    private static void recoverEntries(File file, RandomAccessFile access, LinkedHashMap<UUID, byte[]> entries) throws IOException {
        byte[] header = new byte[512];
        while (access.getFilePointer() + 512L <= access.length()) {
            int i;
            access.readFully(header);
            int sum = 0;
            for (i = 0; i < 512; ++i) {
                sum += header[i] & 0xFF;
            }
            if (sum == 0 && access.getFilePointer() + 1024L == access.length()) {
                return;
            }
            for (i = 148; i < 156; ++i) {
                sum -= header[i] & 0xFF;
                sum += 32;
            }
            byte[] checkbytes = String.format("%06o\u0000 ", sum).getBytes(Charsets.UTF_8);
            for (int i2 = 0; i2 < checkbytes.length; ++i2) {
                if (checkbytes[i2] == header[148 + i2]) continue;
                log.warn("Invalid entry checksum at offset {} in tar file {}, skipping...", (Object)(access.getFilePointer() - 512L), (Object)file);
            }
            ByteBuffer buffer = ByteBuffer.wrap(header);
            String name = TarReader.readString(buffer, 100);
            buffer.position(124);
            int size = TarReader.readNumber(buffer, 12);
            if (access.getFilePointer() + (long)size > access.length()) {
                log.warn("Partial entry {} in tar file {}, ignoring...", (Object)name, (Object)file);
                return;
            }
            Matcher matcher = NAME_PATTERN.matcher(name);
            if (matcher.matches()) {
                UUID id = UUID.fromString(matcher.group(1));
                String checksum = matcher.group(3);
                if (checksum == null && entries.containsKey(id)) continue;
                byte[] data = new byte[size];
                access.readFully(data);
                long position = access.getFilePointer();
                long remainder = position % 512L;
                if (remainder != 0L) {
                    access.seek(position + (512L - remainder));
                }
                if (checksum != null) {
                    CRC32 crc = new CRC32();
                    crc.update(data);
                    if (crc.getValue() != Long.parseLong(checksum, 16)) {
                        log.warn("Checksum mismatch in entry {} of tar file {}, skipping...", (Object)name, (Object)file);
                        continue;
                    }
                }
                entries.put(id, data);
                continue;
            }
            if (name.equals(file.getName() + ".idx")) continue;
            log.warn("Unexpected entry {} in tar file {}, skipping...", (Object)name, (Object)file);
            long position = access.getFilePointer() + (long)size;
            long remainder = position % 512L;
            if (remainder != 0L) {
                position += 512L - remainder;
            }
            access.seek(position);
        }
    }

    private TarReader(File file, FileAccess access, ByteBuffer index) {
        this.file = file;
        this.access = access;
        this.index = index;
    }

    long size() {
        return this.file.length();
    }

    int count() {
        return this.index.capacity() / 24;
    }

    void accept(TarEntryVisitor visitor) {
        for (int position = this.index.position(); position < this.index.limit(); position += 24) {
            visitor.visit(this.index.getLong(position), this.index.getLong(position + 8), this.file, this.index.getInt(position + 16), this.index.getInt(position + 20));
        }
    }

    Set<UUID> getUUIDs() {
        HashSet uuids = Sets.newHashSetWithExpectedSize((int)(this.index.remaining() / 24));
        for (int position = this.index.position(); position < this.index.limit(); position += 24) {
            uuids.add(new UUID(this.index.getLong(position), this.index.getLong(position + 8)));
        }
        return uuids;
    }

    boolean containsEntry(long msb, long lsb) {
        return this.findEntry(msb, lsb) != -1;
    }

    ByteBuffer readEntry(long msb, long lsb) throws IOException {
        int position = this.findEntry(msb, lsb);
        if (position != -1) {
            return this.access.read(this.index.getInt(position + 16), this.index.getInt(position + 20));
        }
        return null;
    }

    private int findEntry(long msb, long lsb) {
        int lowIndex = 0;
        int highIndex = this.index.remaining() / 24 - 1;
        float lowValue = -9.223372E18f;
        float highValue = 9.223372E18f;
        float targetValue = msb;
        while (lowIndex <= highIndex) {
            int guessIndex = lowIndex + Math.round((float)(highIndex - lowIndex) * (targetValue - lowValue) / (highValue - lowValue));
            int position = this.index.position() + guessIndex * 24;
            long m = this.index.getLong(position);
            if (msb < m) {
                highIndex = guessIndex - 1;
                highValue = m;
                continue;
            }
            if (msb > m) {
                lowIndex = guessIndex + 1;
                lowValue = m;
                continue;
            }
            long l = this.index.getLong(position + 8);
            if (lsb < l) {
                highIndex = guessIndex - 1;
                highValue = m;
                continue;
            }
            if (lsb > l) {
                lowIndex = guessIndex + 1;
                lowValue = m;
                continue;
            }
            return position;
        }
        return -1;
    }

    synchronized TarReader cleanup(Set<UUID> referencedIds, CompactionMap cm) throws IOException {
        int pos;
        HashSet cleaned = Sets.newHashSet();
        Map<UUID, List<UUID>> graph = this.getGraph();
        TarEntry[] sorted = new TarEntry[this.index.remaining() / 24];
        int position = this.index.position();
        int i = 0;
        while (position < this.index.limit()) {
            sorted[i] = new TarEntry(this.index.getLong(position), this.index.getLong(position + 8), this.index.getInt(position + 16), this.index.getInt(position + 20));
            position += 24;
            ++i;
        }
        Arrays.sort(sorted, TarEntry.OFFSET_ORDER);
        int size = 0;
        int count = 0;
        for (int i2 = sorted.length - 1; i2 >= 0; --i2) {
            TarEntry entry = sorted[i2];
            UUID id = new UUID(entry.msb(), entry.lsb());
            if (!referencedIds.remove(id)) {
                cleaned.add(id);
                sorted[i2] = null;
                continue;
            }
            if (SegmentId.isDataSegmentId(entry.lsb())) {
                size += TarReader.getEntrySize(entry.size());
                ++count;
                if (graph != null) {
                    List<UUID> refids = graph.get(id);
                    if (refids == null) continue;
                    for (UUID r : refids) {
                        if (SegmentId.isDataSegmentId(r.getLeastSignificantBits())) {
                            referencedIds.add(r);
                            continue;
                        }
                        if (cm != null && cm.wasCompacted(id)) continue;
                        referencedIds.add(r);
                    }
                    continue;
                }
                ByteBuffer segment = this.access.read(entry.offset(), Math.min(entry.size(), 4096));
                int pos2 = segment.position();
                int refcount = segment.get(pos2 + Segment.REF_COUNT_OFFSET) & 0xFF;
                int refend = pos2 + 16 * (refcount + 1);
                for (int refpos = pos2 + 16; refpos < refend; refpos += 16) {
                    UUID r = new UUID(segment.getLong(refpos), segment.getLong(refpos + 8));
                    if (SegmentId.isDataSegmentId(r.getLeastSignificantBits())) {
                        referencedIds.add(r);
                        continue;
                    }
                    if (cm != null && cm.wasCompacted(id)) continue;
                    referencedIds.add(r);
                }
                continue;
            }
            if (cm != null && cm.wasCompacted(id)) {
                cleaned.add(id);
                sorted[i2] = null;
                continue;
            }
            size += TarReader.getEntrySize(entry.size());
            ++count;
        }
        size += TarReader.getEntrySize(24 * count + 16);
        size += 1024;
        if (count == 0) {
            this.logCleanedSegments(cleaned);
            return null;
        }
        if (size >= this.access.length() * 3 / 4 && graph != null) {
            return this;
        }
        String name = this.file.getName();
        char generation = name.charAt(pos = name.length() - "a.tar".length());
        if (generation == 'z') {
            return this;
        }
        File newFile = new File(this.file.getParentFile(), name.substring(0, pos) + (char)(generation + '\u0001') + ".tar");
        TarWriter writer = new TarWriter(newFile);
        for (int i3 = 0; i3 < sorted.length; ++i3) {
            TarEntry entry = sorted[i3];
            if (entry == null) continue;
            byte[] data = new byte[entry.size()];
            this.access.read(entry.offset(), entry.size()).get(data);
            writer.writeEntry(entry.msb(), entry.lsb(), data, 0, entry.size());
        }
        writer.close();
        TarReader reader = TarReader.openFirstFileWithValidIndex(Collections.singletonList(newFile), this.access.isMemoryMapped());
        if (reader != null) {
            this.logCleanedSegments(cleaned);
            return reader;
        }
        log.warn("Failed to open cleaned up tar file {}", (Object)this.file);
        return this;
    }

    private void logCleanedSegments(Set<UUID> cleaned) {
        StringBuilder uuids = new StringBuilder();
        String newLine = System.getProperty("line.separator", "\n") + "        ";
        int c = 0;
        String sep = "";
        for (UUID uuid : cleaned) {
            uuids.append(sep);
            if (c++ % 4 == 0) {
                uuids.append(newLine);
            }
            uuids.append(uuid);
            sep = ", ";
        }
        GC_LOG.info("Cleaned segments from {}: {}", (Object)this.file.getName(), (Object)uuids);
    }

    File close() throws IOException {
        this.access.close();
        return this.file;
    }

    Map<UUID, List<UUID>> getGraph() throws IOException {
        ByteBuffer graph = this.loadGraph();
        if (graph == null) {
            return null;
        }
        return TarReader.parseGraph(graph);
    }

    private ByteBuffer loadGraph() throws IOException {
        int pos = this.access.length() - 1024 - TarReader.getEntrySize(this.index.remaining());
        ByteBuffer meta = this.access.read(pos - 16, 16);
        int crc32 = meta.getInt();
        int count = meta.getInt();
        int bytes = meta.getInt();
        int magic = meta.getInt();
        if (magic != 170936074) {
            return null;
        }
        if (count < 0 || bytes < count * 16 + 16 || 512 + bytes > pos) {
            log.warn("Invalid graph metadata in tar file {}", (Object)this.file);
            return null;
        }
        ByteBuffer graph = this.access.read(pos - bytes, bytes);
        byte[] b = new byte[bytes - 16];
        graph.mark();
        graph.get(b);
        graph.reset();
        CRC32 checksum = new CRC32();
        checksum.update(b);
        if (crc32 != (int)checksum.getValue()) {
            log.warn("Invalid graph checksum in tar file {}", (Object)this.file);
            return null;
        }
        return graph;
    }

    private static Map<UUID, List<UUID>> parseGraph(ByteBuffer graphByteBuffer) {
        int count = graphByteBuffer.getInt(graphByteBuffer.limit() - 12);
        ByteBuffer buffer = graphByteBuffer.duplicate();
        buffer.limit(graphByteBuffer.limit() - 16);
        ArrayList uuids = Lists.newArrayListWithCapacity((int)count);
        for (int i = 0; i < count; ++i) {
            uuids.add(new UUID(buffer.getLong(), buffer.getLong()));
        }
        HashMap graph = Maps.newHashMap();
        while (buffer.hasRemaining()) {
            UUID uuid = (UUID)uuids.get(buffer.getInt());
            ArrayList list = Lists.newArrayList();
            int refid = buffer.getInt();
            while (refid != -1) {
                list.add(uuids.get(refid));
                refid = buffer.getInt();
            }
            graph.put(uuid, list);
        }
        return graph;
    }

    private static String readString(ByteBuffer buffer, int fieldSize) {
        int n;
        byte[] b = new byte[fieldSize];
        buffer.get(b);
        for (n = 0; n < fieldSize && b[n] != 0; ++n) {
        }
        return new String(b, 0, n, Charsets.UTF_8);
    }

    private static int readNumber(ByteBuffer buffer, int fieldSize) {
        int digit;
        byte[] b = new byte[fieldSize];
        buffer.get(b);
        int number = 0;
        for (int i = 0; i < fieldSize && 48 <= (digit = b[i] & 0xFF) && digit <= 55; ++i) {
            number = number * 8 + digit - 48;
        }
        return number;
    }

    File getFile() {
        return this.file;
    }

    public String toString() {
        return this.file.toString();
    }
}

