/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.tree.impl;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.plugins.tree.impl.AbstractTree;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.ReadOnlyBuilder;

public final class ImmutableTree
extends AbstractTree {
    private final NodeBuilder nodeBuilder;
    private final String name;
    private final ParentProvider parentProvider;
    private String path;

    public ImmutableTree(@Nonnull NodeState rootState) {
        this(ParentProvider.ROOT_PROVIDER, "", rootState);
    }

    public ImmutableTree(@Nonnull ImmutableTree parent, @Nonnull String name, @Nonnull NodeState state) {
        this(new DefaultParentProvider(parent), name, state);
    }

    public ImmutableTree(@Nonnull ParentProvider parentProvider, @Nonnull String name, @Nonnull NodeState state) {
        this.nodeBuilder = new ReadOnlyBuilder(state);
        this.name = name;
        this.parentProvider = (ParentProvider)Preconditions.checkNotNull((Object)parentProvider);
    }

    @Override
    @Nonnull
    protected ImmutableTree createChild(@Nonnull String name) {
        return new ImmutableTree(this, name, this.nodeBuilder.getNodeState().getChildNode(name));
    }

    @Override
    @CheckForNull
    protected AbstractTree getParentOrNull() {
        return this.parentProvider.getParent();
    }

    @Override
    @Nonnull
    protected NodeBuilder getNodeBuilder() {
        return this.nodeBuilder;
    }

    @Override
    protected boolean isHidden(String name) {
        return false;
    }

    @Override
    @Nonnull
    protected String[] getInternalNodeNames() {
        return new String[0];
    }

    @Override
    @Nonnull
    public String getName() {
        return this.name;
    }

    @Override
    @Nonnull
    public String getPath() {
        if (this.path == null) {
            this.path = super.getPath();
        }
        return this.path;
    }

    @Override
    @Nonnull
    public ImmutableTree getChild(@Nonnull String name) throws IllegalArgumentException {
        return this.createChild(name);
    }

    @Override
    public boolean remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Nonnull
    public Tree addChild(@Nonnull String name) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setOrderableChildren(boolean enable) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean orderBefore(@Nullable String name) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setProperty(@Nonnull PropertyState property) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> void setProperty(@Nonnull String name, @Nonnull T value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> void setProperty(@Nonnull String name, @Nonnull T value, @Nonnull Type<T> type) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeProperty(@Nonnull String name) {
        throw new UnsupportedOperationException();
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.getName(), this.nodeBuilder.getNodeState()});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ImmutableTree) {
            ImmutableTree other = (ImmutableTree)o;
            return this.getName().equals(other.getName()) && this.nodeBuilder.getNodeState().equals(other.nodeBuilder.getNodeState());
        }
        return false;
    }

    public static final class DefaultParentProvider
    implements ParentProvider {
        private final ImmutableTree parent;

        DefaultParentProvider(@Nonnull ImmutableTree parent) {
            this.parent = (ImmutableTree)Preconditions.checkNotNull((Object)parent);
        }

        @Override
        public ImmutableTree getParent() {
            return this.parent;
        }
    }

    public static interface ParentProvider {
        public static final ParentProvider UNSUPPORTED = new ParentProvider(){

            @Override
            public ImmutableTree getParent() {
                throw new UnsupportedOperationException("not supported.");
            }
        };
        public static final ParentProvider ROOT_PROVIDER = new ParentProvider(){

            @Override
            public ImmutableTree getParent() {
                return null;
            }
        };

        @CheckForNull
        public ImmutableTree getParent();
    }
}

