/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.version;

import com.google.common.base.Preconditions;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.plugins.identifier.IdentifierManager;
import org.apache.jackrabbit.oak.plugins.nodetype.ReadOnlyNodeTypeManager;
import org.apache.jackrabbit.oak.util.TreeUtil;

public abstract class ReadOnlyVersionManager {
    @Nonnull
    protected abstract Tree getVersionStorage();

    @Nonnull
    protected abstract Root getWorkspaceRoot();

    @Nonnull
    protected abstract ReadOnlyNodeTypeManager getNodeTypeManager();

    public boolean isCheckedOut(@Nonnull Tree tree) {
        PropertyState p;
        if (((Tree)Preconditions.checkNotNull((Object)tree)).exists() && (p = tree.getProperty("jcr:isCheckedOut")) != null) {
            return p.getValue(Type.BOOLEAN);
        }
        if (tree.isRoot()) {
            return true;
        }
        return this.isCheckedOut(tree.getParent());
    }

    @CheckForNull
    public Tree getVersionHistory(@Nonnull Tree versionable) throws UnsupportedRepositoryOperationException, RepositoryException {
        this.checkVersionable(versionable);
        String uuid = versionable.getProperty("jcr:uuid").getValue(Type.STRING);
        return TreeUtil.getTree(this.getVersionStorage(), this.getVersionHistoryPath(uuid));
    }

    @CheckForNull
    public Tree getVersion(@Nonnull String uuid) {
        return this.getIdentifierManager().getTree(uuid);
    }

    @Nonnull
    public String getVersionHistoryPath(@Nonnull String uuid) {
        String relPath = "";
        for (int i = 0; i < 3; ++i) {
            String name = uuid.substring(i * 2, i * 2 + 2);
            relPath = PathUtils.concat(relPath, name);
        }
        return PathUtils.concat(relPath, uuid);
    }

    @CheckForNull
    public Tree getBaseVersion(@Nonnull Tree versionable) throws UnsupportedRepositoryOperationException, RepositoryException {
        this.checkVersionable(versionable);
        PropertyState p = versionable.getProperty("jcr:baseVersion");
        if (p == null) {
            return null;
        }
        return this.getIdentifierManager().getTree(p.getValue(Type.STRING));
    }

    protected IdentifierManager getIdentifierManager() {
        return new IdentifierManager(this.getWorkspaceRoot());
    }

    @Nonnull
    protected Tree checkVersionable(@Nonnull Tree tree) throws UnsupportedRepositoryOperationException, RepositoryException {
        if (!this.isVersionable((Tree)Preconditions.checkNotNull((Object)tree))) {
            throw new UnsupportedRepositoryOperationException("Node at " + tree.getPath() + " is not versionable");
        }
        return tree;
    }

    protected boolean isVersionable(@Nonnull Tree tree) {
        return this.getNodeTypeManager().isNodeType((Tree)Preconditions.checkNotNull((Object)tree), "mix:versionable");
    }
}

