/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.version;

import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Service;
import org.apache.jackrabbit.oak.plugins.version.VersionEditor;
import org.apache.jackrabbit.oak.plugins.version.VersionStorageEditor;
import org.apache.jackrabbit.oak.spi.commit.CommitInfo;
import org.apache.jackrabbit.oak.spi.commit.CompositeEditor;
import org.apache.jackrabbit.oak.spi.commit.Editor;
import org.apache.jackrabbit.oak.spi.commit.EditorProvider;
import org.apache.jackrabbit.oak.spi.commit.SubtreeEditor;
import org.apache.jackrabbit.oak.spi.commit.VisibleEditor;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;

@Component
@Service(value={EditorProvider.class})
public class VersionEditorProvider
implements EditorProvider {
    @Override
    public Editor getRootEditor(NodeState before, NodeState after, NodeBuilder builder, CommitInfo info) {
        if (!builder.hasChildNode("jcr:system")) {
            return null;
        }
        NodeBuilder system = builder.child("jcr:system");
        if (!system.hasChildNode("jcr:versionStorage")) {
            return null;
        }
        NodeBuilder versionStorage = system.child("jcr:versionStorage");
        return new VisibleEditor(new CompositeEditor(new VersionEditor(versionStorage, builder, info), new SubtreeEditor((Editor)new VersionStorageEditor(versionStorage, builder), "jcr:system", "jcr:versionStorage")));
    }
}

