/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.version;

import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.plugins.memory.EmptyNodeState;
import org.apache.jackrabbit.oak.plugins.tree.impl.ImmutableTree;
import org.apache.jackrabbit.oak.plugins.version.ReadWriteVersionManager;
import org.apache.jackrabbit.oak.plugins.version.VersionConstants;
import org.apache.jackrabbit.oak.spi.commit.CommitHook;
import org.apache.jackrabbit.oak.spi.commit.CommitInfo;
import org.apache.jackrabbit.oak.spi.state.DefaultNodeStateDiff;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;

public class VersionablePathHook
implements CommitHook {
    private final String workspaceName;

    public VersionablePathHook(String workspaceName) {
        this.workspaceName = workspaceName;
    }

    @Override
    @Nonnull
    public NodeState processCommit(NodeState before, NodeState after, CommitInfo info) throws CommitFailedException {
        NodeBuilder rootBuilder = after.builder();
        NodeBuilder vsRoot = rootBuilder.child("jcr:system").child("jcr:versionStorage");
        ReadWriteVersionManager vMgr = new ReadWriteVersionManager(vsRoot, rootBuilder);
        ArrayList exceptions = new ArrayList();
        after.compareAgainstBaseState(before, new Diff(vMgr, new Node(rootBuilder), exceptions));
        if (!exceptions.isEmpty()) {
            throw (CommitFailedException)exceptions.get(0);
        }
        return rootBuilder.getNodeState();
    }

    public String toString() {
        return "VersionablePathHook : workspaceName = " + this.workspaceName;
    }

    private static final class Node {
        private final String path;
        private final NodeBuilder builder;

        private Node(NodeBuilder rootBuilder) {
            this.path = "/";
            this.builder = rootBuilder;
        }

        private Node(Node parent, String name) {
            this.builder = parent.builder.child(name);
            this.path = PathUtils.concat(parent.path, name);
        }

        private boolean isVersionable(ReadWriteVersionManager versionManager) {
            ImmutableTree tree = new ImmutableTree(ImmutableTree.ParentProvider.UNSUPPORTED, PathUtils.getName(this.path), this.builder.getNodeState());
            return versionManager.isVersionable(tree);
        }
    }

    private final class Diff
    extends DefaultNodeStateDiff
    implements VersionConstants {
        private final ReadWriteVersionManager versionManager;
        private final Node nodeAfter;
        private final List<CommitFailedException> exceptions;

        private Diff(@Nonnull ReadWriteVersionManager versionManager, @Nonnull Node node, List<CommitFailedException> exceptions) {
            this.versionManager = versionManager;
            this.nodeAfter = node;
            this.exceptions = exceptions;
        }

        @Override
        public boolean propertyAdded(PropertyState after) {
            return this.setVersionablePath(after);
        }

        @Override
        public boolean propertyChanged(PropertyState before, PropertyState after) {
            return this.setVersionablePath(after);
        }

        @Override
        public boolean childNodeAdded(String name, NodeState after) {
            return this.childNodeChanged(name, EmptyNodeState.EMPTY_NODE, after);
        }

        @Override
        public boolean childNodeChanged(String name, NodeState before, NodeState after) {
            Node node = new Node(this.nodeAfter, name);
            return after.compareAgainstBaseState(before, new Diff(this.versionManager, node, this.exceptions));
        }

        private boolean setVersionablePath(PropertyState after) {
            if ("jcr:versionHistory".equals(after.getName()) && this.nodeAfter.isVersionable(this.versionManager)) {
                NodeBuilder vhBuilder;
                try {
                    vhBuilder = this.versionManager.getOrCreateVersionHistory(this.nodeAfter.builder, Collections.EMPTY_MAP);
                }
                catch (CommitFailedException e) {
                    this.exceptions.add(e);
                    return false;
                }
                if (!vhBuilder.hasProperty("jcr:mixinTypes")) {
                    vhBuilder.setProperty("jcr:mixinTypes", ImmutableSet.of((Object)"rep:VersionablePaths"), Type.NAMES);
                }
                String versionablePath = this.nodeAfter.path;
                vhBuilder.setProperty(VersionablePathHook.this.workspaceName, versionablePath, Type.PATH);
            }
            return true;
        }
    }
}

