/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.query.ast;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.PropertyValue;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.plugins.memory.PropertyBuilder;
import org.apache.jackrabbit.oak.query.QueryImpl;
import org.apache.jackrabbit.oak.query.ast.AndImpl;
import org.apache.jackrabbit.oak.query.ast.AstVisitor;
import org.apache.jackrabbit.oak.query.ast.ColumnImpl;
import org.apache.jackrabbit.oak.query.ast.ConstraintImpl;
import org.apache.jackrabbit.oak.query.ast.JoinConditionImpl;
import org.apache.jackrabbit.oak.query.ast.Operator;
import org.apache.jackrabbit.oak.query.ast.SourceImpl;
import org.apache.jackrabbit.oak.query.fulltext.FullTextExpression;
import org.apache.jackrabbit.oak.query.index.FilterImpl;
import org.apache.jackrabbit.oak.query.plan.ExecutionPlan;
import org.apache.jackrabbit.oak.query.plan.SelectorExecutionPlan;
import org.apache.jackrabbit.oak.spi.query.Cursor;
import org.apache.jackrabbit.oak.spi.query.Cursors;
import org.apache.jackrabbit.oak.spi.query.IndexRow;
import org.apache.jackrabbit.oak.spi.query.PropertyValues;
import org.apache.jackrabbit.oak.spi.query.QueryIndex;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectorImpl
extends SourceImpl {
    private static final Logger LOG = LoggerFactory.getLogger(SelectorImpl.class);
    private SelectorExecutionPlan plan;
    private ConstraintImpl queryConstraint;
    private JoinConditionImpl joinCondition;
    private final NodeState nodeType;
    private final String selectorName;
    private final String nodeTypeName;
    private final boolean matchesAllTypes;
    private final Set<String> supertypes;
    private final Set<String> primaryTypes;
    private final Set<String> mixinTypes;
    private boolean isParent;
    private boolean outerJoinLeftHandSide;
    private boolean outerJoinRightHandSide;
    private ArrayList<JoinConditionImpl> allJoinConditions = new ArrayList();
    private final List<ConstraintImpl> selectorConstraints = Lists.newArrayList();
    private Cursor cursor;
    private IndexRow currentRow;
    private int scanCount;
    private Tree lastTree;
    private String lastPath;

    public SelectorImpl(NodeState nodeType, String selectorName) {
        this.nodeType = (NodeState)Preconditions.checkNotNull((Object)nodeType);
        this.selectorName = (String)Preconditions.checkNotNull((Object)selectorName);
        this.nodeTypeName = nodeType.getName("jcr:nodeTypeName");
        this.matchesAllTypes = "nt:base".equals(this.nodeTypeName);
        if (!this.matchesAllTypes) {
            this.supertypes = Sets.newHashSet(nodeType.getNames("rep:supertypes"));
            this.supertypes.add(this.nodeTypeName);
            this.primaryTypes = Sets.newHashSet(nodeType.getNames("rep:primarySubtypes"));
            this.mixinTypes = Sets.newHashSet(nodeType.getNames("rep:mixinSubtypes"));
            if (nodeType.getBoolean("jcr:isMixin")) {
                this.mixinTypes.add(this.nodeTypeName);
            } else {
                this.primaryTypes.add(this.nodeTypeName);
            }
        } else {
            this.supertypes = ImmutableSet.of();
            this.primaryTypes = ImmutableSet.of();
            this.mixinTypes = ImmutableSet.of();
        }
    }

    public String getSelectorName() {
        return this.selectorName;
    }

    public boolean matchesAllTypes() {
        return this.matchesAllTypes;
    }

    @Nonnull
    public Set<String> getSupertypes() {
        return this.supertypes;
    }

    @Nonnull
    public Set<String> getPrimaryTypes() {
        return this.primaryTypes;
    }

    @Nonnull
    public Set<String> getMixinTypes() {
        return this.mixinTypes;
    }

    public Iterable<String> getWildcardColumns() {
        return this.nodeType.getNames("rep:namedSingleValuedProperties");
    }

    @Override
    boolean accept(AstVisitor v) {
        return v.visit(this);
    }

    public String toString() {
        return this.quote(this.nodeTypeName) + " as " + this.quote(this.selectorName);
    }

    public boolean isPrepared() {
        return this.plan != null;
    }

    @Override
    public void unprepare() {
        this.plan = null;
        this.selectorConstraints.clear();
        this.isParent = false;
        this.joinCondition = null;
        this.allJoinConditions.clear();
    }

    @Override
    public void prepare(ExecutionPlan p) {
        if (!(p instanceof SelectorExecutionPlan)) {
            throw new IllegalArgumentException("Not a selector plan");
        }
        SelectorExecutionPlan selectorPlan = (SelectorExecutionPlan)p;
        if (selectorPlan.getSelector() != this) {
            throw new IllegalArgumentException("Not a plan for this selector");
        }
        this.pushDown();
        this.plan = selectorPlan;
    }

    private void pushDown() {
        if (this.queryConstraint != null) {
            this.queryConstraint.restrictPushDown(this);
        }
        if (!this.outerJoinLeftHandSide && !this.outerJoinRightHandSide) {
            for (JoinConditionImpl c : this.allJoinConditions) {
                c.restrictPushDown(this);
            }
        }
    }

    @Override
    public ExecutionPlan prepare() {
        if (this.plan != null) {
            return this.plan;
        }
        this.pushDown();
        this.plan = this.query.getBestSelectorExecutionPlan(this.createFilter(true));
        return this.plan;
    }

    public SelectorExecutionPlan getExecutionPlan() {
        return this.plan;
    }

    @Override
    public void setQueryConstraint(ConstraintImpl queryConstraint) {
        this.queryConstraint = queryConstraint;
    }

    @Override
    public void setOuterJoin(boolean outerJoinLeftHandSide, boolean outerJoinRightHandSide) {
        this.outerJoinLeftHandSide = outerJoinLeftHandSide;
        this.outerJoinRightHandSide = outerJoinRightHandSide;
    }

    @Override
    public void addJoinCondition(JoinConditionImpl joinCondition, boolean forThisSelector) {
        if (forThisSelector) {
            this.joinCondition = joinCondition;
        }
        this.allJoinConditions.add(joinCondition);
        if (joinCondition.isParent(this)) {
            this.isParent = true;
        }
    }

    @Override
    public void execute(NodeState rootState) {
        QueryIndex index = this.plan.getIndex();
        if (index == null) {
            this.cursor = Cursors.newPathCursor(new ArrayList<String>(), this.query.getSettings());
            return;
        }
        QueryIndex.IndexPlan p = this.plan.getIndexPlan();
        if (p != null) {
            p.setFilter(this.createFilter(false));
            QueryIndex.AdvancedQueryIndex adv = (QueryIndex.AdvancedQueryIndex)((Object)index);
            this.cursor = adv.query(p, rootState);
        } else {
            this.cursor = index.query(this.createFilter(false), rootState);
        }
    }

    @Override
    public String getPlan(NodeState rootState) {
        StringBuilder buff = new StringBuilder();
        buff.append(this.toString());
        buff.append(" /* ");
        QueryIndex index = this.getIndex();
        if (index != null) {
            if (index instanceof QueryIndex.AdvancedQueryIndex) {
                QueryIndex.AdvancedQueryIndex adv = (QueryIndex.AdvancedQueryIndex)((Object)index);
                QueryIndex.IndexPlan p = this.plan.getIndexPlan();
                buff.append(adv.getPlanDescription(p, rootState));
            } else {
                buff.append(index.getPlan(this.createFilter(true), rootState));
            }
        } else {
            buff.append("no-index");
        }
        if (!this.selectorConstraints.isEmpty()) {
            buff.append(" where ").append(new AndImpl(this.selectorConstraints).toString());
        }
        buff.append(" */");
        return buff.toString();
    }

    @Override
    public FilterImpl createFilter(boolean preparing) {
        FilterImpl f = new FilterImpl(this, this.query.getStatement(), this.query.getSettings());
        f.setPreparing(preparing);
        if (this.joinCondition != null) {
            this.joinCondition.restrict(f);
        }
        for (ColumnImpl c : this.query.getColumns()) {
            if (!c.getSelector().equals(this) || !c.getColumnName().equals("rep:excerpt")) continue;
            f.restrictProperty("rep:excerpt", Operator.NOT_EQUAL, null);
        }
        if (this.queryConstraint != null) {
            this.queryConstraint.restrict(f);
            FullTextExpression ft = this.queryConstraint.getFullTextConstraint(this);
            f.setFullTextConstraint(ft);
        }
        for (ConstraintImpl constraint : this.selectorConstraints) {
            constraint.restrict(f);
        }
        return f;
    }

    @Override
    public boolean next() {
        while (this.cursor != null && this.cursor.hasNext()) {
            Tree tree;
            ++this.scanCount;
            this.currentRow = this.cursor.next();
            if (!this.isParent && ((tree = this.getTree(this.currentRow.getPath())) == null || !tree.exists()) || !this.evaluateCurrentRow()) continue;
            return true;
        }
        this.cursor = null;
        this.currentRow = null;
        return false;
    }

    private boolean evaluateCurrentRow() {
        if (!this.matchesAllTypes && !this.evaluateTypeMatch()) {
            return false;
        }
        for (ConstraintImpl constraint : this.selectorConstraints) {
            if (constraint.evaluate()) continue;
            if (constraint.evaluateStop()) {
                this.cursor = null;
            }
            return false;
        }
        return this.joinCondition == null || this.joinCondition.evaluate();
    }

    private boolean evaluateTypeMatch() {
        String name;
        Tree tree = this.getTree(this.currentRow.getPath());
        if (tree == null || !tree.exists()) {
            return false;
        }
        PropertyState primary = tree.getProperty("jcr:primaryType");
        if (primary != null && primary.getType() == Type.NAME && this.primaryTypes.contains(name = primary.getValue(Type.NAME))) {
            return true;
        }
        PropertyState mixins = tree.getProperty("jcr:mixinTypes");
        if (mixins != null && mixins.getType() == Type.NAMES) {
            for (String name2 : mixins.getValue(Type.NAMES)) {
                if (!this.mixinTypes.contains(name2)) continue;
                return true;
            }
        }
        return false;
    }

    public String currentPath() {
        return this.cursor == null ? null : this.currentRow.getPath();
    }

    public Tree currentTree() {
        String path = this.currentPath();
        if (path == null) {
            return null;
        }
        return this.getTree(path);
    }

    Tree getTree(String path) {
        if (this.lastPath == null || !path.equals(this.lastPath)) {
            this.lastTree = this.query.getTree(path);
            this.lastPath = path;
        }
        return this.lastTree;
    }

    public PropertyValue currentProperty(String propertyName) {
        String pn = this.normalizePropertyName(propertyName);
        return this.currentOakProperty(pn);
    }

    public PropertyValue currentProperty(String propertyName, int propertyType) {
        String pn = this.normalizePropertyName(propertyName);
        return this.currentOakProperty(pn, propertyType);
    }

    public PropertyValue currentOakProperty(String oakPropertyName) {
        return this.currentOakProperty(oakPropertyName, null);
    }

    private PropertyValue currentOakProperty(String oakPropertyName, Integer propertyType) {
        boolean asterisk;
        boolean bl = asterisk = oakPropertyName.indexOf(42) >= 0;
        if (asterisk) {
            Tree t = this.currentTree();
            if (t != null) {
                LOG.trace("currentOakProperty() - '*' case. looking for '{}' in '{}'", (Object)oakPropertyName, (Object)t.getPath());
            }
            ArrayList<PropertyValue> list = new ArrayList<PropertyValue>();
            this.readOakProperties(list, t, oakPropertyName, propertyType);
            if (list.size() == 0) {
                return null;
            }
            if (list.size() == 1) {
                return list.get(0);
            }
            Type<Object> type = list.get(0).getType();
            for (int i = 1; i < list.size(); ++i) {
                Type<?> t2 = list.get(i).getType();
                if (t2 == type) continue;
                type = Type.STRING;
                break;
            }
            if (type == Type.STRING) {
                ArrayList<String> strings = new ArrayList<String>();
                for (PropertyValue p : list) {
                    Iterables.addAll(strings, p.getValue(Type.STRINGS));
                }
                return PropertyValues.newString(strings);
            }
            Type<?> baseType = type.isArray() ? type.getBaseType() : type;
            PropertyBuilder<?> builder = PropertyBuilder.array(baseType);
            builder.setName("");
            for (PropertyValue v : list) {
                if (type.isArray()) {
                    for (Object value : (Iterable)v.getValue(type)) {
                        builder.addValue(value);
                    }
                    continue;
                }
                builder.addValue(v.getValue(type));
            }
            PropertyState s = builder.getPropertyState();
            return PropertyValues.create(s);
        }
        boolean relative = oakPropertyName.indexOf(47) >= 0;
        Tree t = this.currentTree();
        if (relative) {
            for (String p : PathUtils.elements(PathUtils.getParentPath(oakPropertyName))) {
                if (t == null) {
                    return null;
                }
                if (p.equals("..")) {
                    t = t.isRoot() ? null : t.getParent();
                    continue;
                }
                if (p.equals(".")) continue;
                t = t.getChild(p);
            }
            oakPropertyName = PathUtils.getName(oakPropertyName);
        }
        return this.currentOakProperty(t, oakPropertyName, propertyType);
    }

    private PropertyValue currentOakProperty(Tree t, String oakPropertyName, Integer propertyType) {
        PropertyValue result;
        if (t == null || !t.exists()) {
            return null;
        }
        if (oakPropertyName.equals("jcr:path")) {
            String path = this.currentPath();
            String local = this.getLocalPath(path);
            if (local == null) {
                return null;
            }
            result = PropertyValues.newString(local);
        } else {
            result = oakPropertyName.equals("jcr:score") ? this.currentRow.getValue("jcr:score") : (oakPropertyName.equals("rep:excerpt") ? this.currentRow.getValue("rep:excerpt") : (oakPropertyName.equals("rep:spellcheck()") ? this.currentRow.getValue("rep:spellcheck()") : (oakPropertyName.equals("rep:suggest()") ? this.currentRow.getValue("rep:suggest()") : PropertyValues.create(t.getProperty(oakPropertyName)))));
        }
        if (result == null) {
            return null;
        }
        if (propertyType != null && result.getType().tag() != propertyType.intValue()) {
            return null;
        }
        return result;
    }

    private void readOakProperties(ArrayList<PropertyValue> target, Tree t, String oakPropertyName, Integer propertyType) {
        boolean skipCurrentNode = false;
        while (!skipCurrentNode) {
            if (t == null || !t.exists()) {
                return;
            }
            LOG.trace("readOakProperties() - reading '{}' for '{}'", (Object)t.getPath(), (Object)oakPropertyName);
            int slash = oakPropertyName.indexOf(47);
            if (slash < 0) break;
            String string = oakPropertyName.substring(0, slash);
            oakPropertyName = oakPropertyName.substring(slash + 1);
            if (string.equals("..")) {
                t = t.isRoot() ? null : t.getParent();
                continue;
            }
            if (string.equals(".")) continue;
            if (string.equals("*")) {
                for (Tree child : t.getChildren()) {
                    this.readOakProperties(target, child, oakPropertyName, propertyType);
                }
                skipCurrentNode = true;
                continue;
            }
            t = t.getChild(string);
        }
        if (skipCurrentNode) {
            return;
        }
        if (!"*".equals(oakPropertyName)) {
            PropertyValue value = this.currentOakProperty(t, oakPropertyName, propertyType);
            if (value != null) {
                LOG.trace("readOakProperties() - adding: '{}' from '{}'", (Object)value, (Object)t.getPath());
                target.add(value);
            }
            return;
        }
        for (PropertyState propertyState : t.getProperties()) {
            if (propertyType != null && propertyState.getType().tag() != propertyType.intValue()) continue;
            PropertyValue v = PropertyValues.create(propertyState);
            target.add(v);
        }
    }

    @Override
    public SelectorImpl getSelector(String selectorName) {
        if (selectorName.equals(this.selectorName)) {
            return this;
        }
        return null;
    }

    public long getScanCount() {
        return this.scanCount;
    }

    public void restrictSelector(ConstraintImpl constraint) {
        this.selectorConstraints.add(constraint);
    }

    public List<ConstraintImpl> getSelectorConstraints() {
        return this.selectorConstraints;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(this instanceof SelectorImpl)) {
            return false;
        }
        return this.selectorName.equals(((SelectorImpl)other).selectorName);
    }

    public int hashCode() {
        return this.selectorName.hashCode();
    }

    QueryIndex getIndex() {
        return this.plan == null ? null : this.plan.getIndex();
    }

    public ArrayList<SourceImpl> getInnerJoinSelectors() {
        ArrayList<SourceImpl> list = new ArrayList<SourceImpl>();
        list.add(this);
        return list;
    }

    @Override
    public boolean isOuterJoinRightHandSide() {
        return this.outerJoinRightHandSide;
    }

    public QueryImpl getQuery() {
        return this.query;
    }
}

