/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.authorization.accesscontrol;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.security.Principal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.jcr.AccessDeniedException;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.Value;
import javax.jcr.security.AccessControlEntry;
import javax.jcr.security.AccessControlException;
import javax.jcr.security.AccessControlPolicy;
import javax.jcr.security.AccessControlPolicyIterator;
import javax.jcr.security.NamedAccessControlPolicy;
import javax.jcr.security.Privilege;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlList;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlPolicy;
import org.apache.jackrabbit.api.security.authorization.PrivilegeManager;
import org.apache.jackrabbit.api.security.principal.ItemBasedPrincipal;
import org.apache.jackrabbit.api.security.principal.PrincipalManager;
import org.apache.jackrabbit.commons.iterator.AccessControlPolicyIteratorAdapter;
import org.apache.jackrabbit.commons.jackrabbit.authorization.AccessControlUtils;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.QueryEngine;
import org.apache.jackrabbit.oak.api.Result;
import org.apache.jackrabbit.oak.api.ResultRow;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.namepath.NamePathMapper;
import org.apache.jackrabbit.oak.plugins.memory.PropertyBuilder;
import org.apache.jackrabbit.oak.plugins.nodetype.ReadOnlyNodeTypeManager;
import org.apache.jackrabbit.oak.security.authorization.accesscontrol.ACL;
import org.apache.jackrabbit.oak.security.authorization.accesscontrol.Util;
import org.apache.jackrabbit.oak.security.authorization.restriction.PrincipalRestrictionProvider;
import org.apache.jackrabbit.oak.spi.security.SecurityProvider;
import org.apache.jackrabbit.oak.spi.security.authorization.accesscontrol.ACE;
import org.apache.jackrabbit.oak.spi.security.authorization.accesscontrol.AbstractAccessControlList;
import org.apache.jackrabbit.oak.spi.security.authorization.accesscontrol.AbstractAccessControlManager;
import org.apache.jackrabbit.oak.spi.security.authorization.accesscontrol.ImmutableACL;
import org.apache.jackrabbit.oak.spi.security.authorization.accesscontrol.PolicyOwner;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.PermissionConstants;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.Restriction;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.RestrictionProvider;
import org.apache.jackrabbit.oak.spi.security.principal.AdminPrincipal;
import org.apache.jackrabbit.oak.spi.security.principal.PrincipalConfiguration;
import org.apache.jackrabbit.oak.spi.security.principal.PrincipalImpl;
import org.apache.jackrabbit.oak.spi.security.privilege.PrivilegeBits;
import org.apache.jackrabbit.oak.spi.security.privilege.PrivilegeBitsProvider;
import org.apache.jackrabbit.oak.util.NodeUtil;
import org.apache.jackrabbit.oak.util.TreeUtil;
import org.apache.jackrabbit.util.ISO9075;
import org.apache.jackrabbit.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccessControlManagerImpl
extends AbstractAccessControlManager
implements PolicyOwner {
    private static final Logger log = LoggerFactory.getLogger(AccessControlManagerImpl.class);
    private final PrivilegeBitsProvider bitsProvider;
    private final ReadOnlyNodeTypeManager ntMgr;
    private final PrincipalManager principalManager;
    private final RestrictionProvider restrictionProvider;
    private final Set<String> readPaths;

    public AccessControlManagerImpl(@Nonnull Root root, @Nonnull NamePathMapper namePathMapper, @Nonnull SecurityProvider securityProvider) {
        super(root, namePathMapper, securityProvider);
        this.bitsProvider = new PrivilegeBitsProvider(root);
        this.ntMgr = ReadOnlyNodeTypeManager.getInstance(root, namePathMapper);
        this.principalManager = securityProvider.getConfiguration(PrincipalConfiguration.class).getPrincipalManager(root, namePathMapper);
        this.restrictionProvider = this.getConfig().getRestrictionProvider();
        this.readPaths = this.getConfig().getParameters().getConfigValue("readPaths", PermissionConstants.DEFAULT_READ_PATHS);
    }

    @Nonnull
    public AccessControlPolicy[] getPolicies(@Nullable String absPath) throws RepositoryException {
        String oakPath = this.getOakPath(absPath);
        Tree tree = this.getTree(oakPath, 128L, true);
        JackrabbitAccessControlList policy = this.createACL(oakPath, tree, false);
        ArrayList<JackrabbitAccessControlList> policies = new ArrayList<JackrabbitAccessControlList>(2);
        if (policy != null) {
            policies.add(policy);
        }
        if (this.readPaths.contains(oakPath)) {
            policies.add((JackrabbitAccessControlList)ReadPolicy.INSTANCE);
        }
        return policies.toArray(new AccessControlPolicy[policies.size()]);
    }

    @Nonnull
    public AccessControlPolicy[] getEffectivePolicies(@Nullable String absPath) throws RepositoryException {
        String oakPath = this.getOakPath(absPath);
        Tree tree = this.getTree(oakPath, 128L, true);
        Root r = this.getRoot().getContentSession().getLatestRoot();
        tree = r.getTree(tree.getPath());
        ArrayList<JackrabbitAccessControlList> effective = new ArrayList<JackrabbitAccessControlList>();
        JackrabbitAccessControlList policy = this.createACL(oakPath, tree, true);
        if (policy != null) {
            effective.add(policy);
        }
        if (oakPath != null) {
            String parentPath = Text.getRelativeParent(oakPath, 1);
            while (!parentPath.isEmpty()) {
                Tree t = r.getTree(parentPath);
                JackrabbitAccessControlList plc = this.createACL(parentPath, t, true);
                if (plc != null) {
                    effective.add(plc);
                }
                parentPath = PathUtils.denotesRoot(parentPath) ? "" : Text.getRelativeParent(parentPath, 1);
            }
        }
        if (this.readPaths.contains(oakPath)) {
            effective.add((JackrabbitAccessControlList)ReadPolicy.INSTANCE);
        }
        return effective.toArray(new AccessControlPolicy[effective.size()]);
    }

    @Nonnull
    public AccessControlPolicyIterator getApplicablePolicies(@Nullable String absPath) throws RepositoryException {
        String oakPath = this.getOakPath(absPath);
        Tree tree = this.getTree(oakPath, 128L, true);
        NodeACL policy = null;
        Tree aclTree = this.getAclTree(oakPath, tree);
        if (aclTree == null) {
            if (tree.hasChild(Util.getAclName(oakPath))) {
                log.warn("Colliding policy child without node being access controllable ({}).", (Object)absPath);
            } else {
                String mixinName = Util.getMixinName(oakPath);
                if (this.ntMgr.isNodeType(tree, mixinName) || this.ntMgr.getEffectiveNodeType(tree).supportsMixin(mixinName)) {
                    policy = new NodeACL(oakPath);
                } else {
                    log.warn("Node {} cannot be made access controllable.", (Object)absPath);
                }
            }
        }
        if (policy == null) {
            return AccessControlPolicyIteratorAdapter.EMPTY;
        }
        return new AccessControlPolicyIteratorAdapter(Collections.singleton(policy));
    }

    public void setPolicy(@Nullable String absPath, @Nonnull AccessControlPolicy policy) throws RepositoryException {
        String oakPath = this.getOakPath(absPath);
        Util.checkValidPolicy(oakPath, policy);
        if (policy instanceof PrincipalACL) {
            this.setPrincipalBasedAcl((PrincipalACL)policy);
        } else {
            Tree tree = this.getTree(oakPath, 256L, true);
            this.setNodeBasedAcl(oakPath, tree, (ACL)policy);
        }
    }

    private void setPrincipalBasedAcl(PrincipalACL principalAcl) throws RepositoryException {
        ACL acl;
        Tree tree;
        String path;
        JackrabbitAccessControlPolicy[] plcs = this.getPolicies(principalAcl.principal);
        PrincipalACL existing = plcs.length == 0 ? null : (PrincipalACL)plcs[0];
        ArrayList toAdd = Lists.newArrayList(principalAcl.getEntries());
        List<Object> toRemove = Collections.emptyList();
        if (existing != null) {
            toAdd.removeAll(existing.getEntries());
            toRemove = existing.getEntries();
            toRemove.removeAll(principalAcl.getEntries());
        }
        for (ACE aCE : toAdd) {
            path = this.getNodePath(aCE);
            acl = (ACL)this.createACL(path, tree = this.getTree(path, 256L, true), false);
            if (acl == null) {
                acl = new NodeACL(path);
            }
            HashMap<String, Value> restrictions = new HashMap<String, Value>();
            for (String name : aCE.getRestrictionNames()) {
                if ("rep:nodePath".equals(name)) continue;
                restrictions.put(name, aCE.getRestriction(name));
            }
            acl.addEntry(aCE.getPrincipal(), aCE.getPrivileges(), aCE.isAllow(), restrictions);
            this.setNodeBasedAcl(path, tree, acl);
        }
        for (ACE aCE : toRemove) {
            path = this.getNodePath(aCE);
            acl = (ACL)this.createACL(path, tree = this.getTree(path, 256L, true), false);
            if (acl != null) {
                acl.removeAccessControlEntry(aCE);
                this.setNodeBasedAcl(path, tree, acl);
                continue;
            }
            log.debug("Missing ACL at {}; cannot remove entry {}", (Object)path, (Object)aCE);
        }
    }

    private void setNodeBasedAcl(@Nullable String oakPath, @Nonnull Tree tree, @Nonnull ACL acl) throws RepositoryException {
        Tree aclTree = this.getAclTree(oakPath, tree);
        if (aclTree != null) {
            for (Tree aceTree : aclTree.getChildren()) {
                aceTree.remove();
            }
        } else {
            aclTree = this.createAclTree(oakPath, tree);
        }
        aclTree.setOrderableChildren(true);
        for (ACE ace : acl.getEntries()) {
            boolean isAllow = ace.isAllow();
            String nodeName = Util.generateAceName(aclTree, isAllow);
            String ntName = isAllow ? "rep:GrantACE" : "rep:DenyACE";
            NodeUtil aceNode = new NodeUtil(aclTree).addChild(nodeName, ntName);
            aceNode.setString("rep:principalName", ace.getPrincipal().getName());
            aceNode.setNames("rep:privileges", AccessControlUtils.namesFromPrivileges(ace.getPrivileges()));
            Set<Restriction> restrictions = ace.getRestrictions();
            this.restrictionProvider.writeRestrictions(oakPath, aceNode.getTree(), restrictions);
        }
    }

    public void removePolicy(@Nullable String absPath, @Nonnull AccessControlPolicy policy) throws RepositoryException {
        String oakPath = this.getOakPath(absPath);
        Util.checkValidPolicy(oakPath, policy);
        if (policy instanceof PrincipalACL) {
            PrincipalACL principalAcl = (PrincipalACL)policy;
            for (ACE ace : principalAcl.getEntries()) {
                Tree tree;
                String path = this.getNodePath(ace);
                Tree aclTree = this.getAclTree(path, tree = this.getTree(path, 256L, true));
                if (aclTree == null) {
                    throw new AccessControlException("Unable to retrieve policy node at " + path);
                }
                for (Tree child : aclTree.getChildren()) {
                    if (!ace.equals(this.createACE(path, child, principalAcl.rProvider))) continue;
                    child.remove();
                }
                if (aclTree.getChildren().iterator().hasNext()) continue;
                aclTree.remove();
            }
        } else {
            Tree tree = this.getTree(oakPath, 256L, true);
            Tree aclTree = this.getAclTree(oakPath, tree);
            if (aclTree != null) {
                aclTree.remove();
            } else {
                throw new AccessControlException("No policy to remove at " + absPath);
            }
        }
    }

    @Override
    @Nonnull
    public JackrabbitAccessControlPolicy[] getApplicablePolicies(@Nonnull Principal principal) throws RepositoryException {
        Util.checkValidPrincipal(principal, this.principalManager, true);
        String oakPath = principal instanceof ItemBasedPrincipal ? ((ItemBasedPrincipal)principal).getPath() : null;
        JackrabbitAccessControlList policy = this.createPrincipalACL(oakPath, principal);
        if (policy != null) {
            return new JackrabbitAccessControlPolicy[0];
        }
        return new JackrabbitAccessControlPolicy[]{new PrincipalACL(oakPath, principal)};
    }

    @Override
    @Nonnull
    public JackrabbitAccessControlPolicy[] getPolicies(@Nonnull Principal principal) throws RepositoryException {
        Util.checkValidPrincipal(principal, this.principalManager, true);
        String oakPath = principal instanceof ItemBasedPrincipal ? ((ItemBasedPrincipal)principal).getPath() : null;
        JackrabbitAccessControlList policy = this.createPrincipalACL(oakPath, principal);
        if (policy != null) {
            return new JackrabbitAccessControlPolicy[]{policy};
        }
        return new JackrabbitAccessControlPolicy[0];
    }

    @Override
    @Nonnull
    public AccessControlPolicy[] getEffectivePolicies(@Nonnull Set<Principal> principals) throws RepositoryException {
        Util.checkValidPrincipals(principals, this.principalManager);
        Root r = this.getLatestRoot();
        Result aceResult = AccessControlManagerImpl.searchAces(principals, r);
        ArrayList<JackrabbitAccessControlList> effective = new ArrayList<JackrabbitAccessControlList>();
        for (ResultRow resultRow : aceResult.getRows()) {
            String acePath = resultRow.getPath();
            String aclName = Text.getName(Text.getRelativeParent(acePath, 1));
            Tree accessControlledTree = r.getTree(Text.getRelativeParent(acePath, 2));
            if (aclName.isEmpty() || !accessControlledTree.exists()) {
                log.debug("Isolated access control entry -> ignore query result at " + acePath);
                continue;
            }
            String path = "rep:repoPolicy".equals(aclName) ? null : accessControlledTree.getPath();
            JackrabbitAccessControlList policy = this.createACL(path, accessControlledTree, true);
            if (policy == null) continue;
            effective.add(policy);
        }
        return effective.toArray(new AccessControlPolicy[effective.size()]);
    }

    @Override
    public boolean defines(String absPath, @Nonnull AccessControlPolicy accessControlPolicy) {
        try {
            return Util.isValidPolicy(this.getOakPath(absPath), accessControlPolicy);
        }
        catch (RepositoryException e) {
            log.warn("Invalid absolute path: " + absPath, (Object)e.getMessage());
            return false;
        }
    }

    @CheckForNull
    private Tree getAclTree(@Nullable String oakPath, @Nonnull Tree accessControlledTree) {
        String aclName;
        Tree policyTree;
        if (Util.isAccessControlled(oakPath, accessControlledTree, this.ntMgr) && (policyTree = accessControlledTree.getChild(aclName = Util.getAclName(oakPath))).exists()) {
            return policyTree;
        }
        return null;
    }

    @Nonnull
    private Tree createAclTree(@Nullable String oakPath, @Nonnull Tree tree) throws AccessDeniedException {
        if (!Util.isAccessControlled(oakPath, tree, this.ntMgr)) {
            PropertyState mixins = tree.getProperty("jcr:mixinTypes");
            String mixinName = Util.getMixinName(oakPath);
            if (mixins == null) {
                tree.setProperty("jcr:mixinTypes", Collections.singleton(mixinName), Type.NAMES);
            } else {
                PropertyBuilder<String> pb = PropertyBuilder.copy(Type.NAME, mixins);
                pb.addValue(mixinName);
                tree.setProperty(pb.getPropertyState());
            }
        }
        String aclName = Util.getAclName(oakPath);
        return new NodeUtil(tree).addChild(aclName, "rep:ACL").getTree();
    }

    @CheckForNull
    private JackrabbitAccessControlList createACL(@Nullable String oakPath, @Nonnull Tree accessControlledTree, boolean isEffectivePolicy) throws RepositoryException {
        Tree aclTree;
        AbstractAccessControlList acl = null;
        String aclName = Util.getAclName(oakPath);
        if (accessControlledTree.exists() && Util.isAccessControlled(oakPath, accessControlledTree, this.ntMgr) && (aclTree = accessControlledTree.getChild(aclName)).exists()) {
            ArrayList<ACE> entries = new ArrayList<ACE>();
            for (Tree child : aclTree.getChildren()) {
                if (!Util.isACE(child, this.ntMgr)) continue;
                entries.add(this.createACE(oakPath, child, this.restrictionProvider));
            }
            acl = isEffectivePolicy ? new ImmutableACL(oakPath, entries, this.restrictionProvider, this.getNamePathMapper()) : new NodeACL(oakPath, entries);
        }
        return acl;
    }

    @Nullable
    private JackrabbitAccessControlList createPrincipalACL(@Nullable String oakPath, @Nonnull Principal principal) throws RepositoryException {
        Root root = this.getRoot();
        Result aceResult = AccessControlManagerImpl.searchAces(Collections.singleton(principal), root);
        PrincipalRestrictionProvider restrProvider = new PrincipalRestrictionProvider(this.restrictionProvider);
        ArrayList<ACE> entries = new ArrayList<ACE>();
        for (ResultRow resultRow : aceResult.getRows()) {
            Tree aceTree = root.getTree(resultRow.getPath());
            if (!Util.isACE(aceTree, this.ntMgr)) continue;
            String aclPath = Text.getRelativeParent(aceTree.getPath(), 1);
            String path = aclPath.endsWith("rep:repoPolicy") ? null : Text.getRelativeParent(aclPath, 1);
            entries.add(this.createACE(path, aceTree, restrProvider));
        }
        if (entries.isEmpty()) {
            return null;
        }
        return new PrincipalACL(oakPath, principal, entries, restrProvider);
    }

    @Nonnull
    private ACE createACE(@Nullable String oakPath, @Nonnull Tree aceTree, @Nonnull RestrictionProvider restrictionProvider) throws RepositoryException {
        boolean isAllow = "rep:GrantACE".equals(TreeUtil.getPrimaryTypeName(aceTree));
        Set<Restriction> restrictions = restrictionProvider.readRestrictions(oakPath, aceTree);
        Iterable privNames = (Iterable)Preconditions.checkNotNull(TreeUtil.getStrings(aceTree, "rep:privileges"));
        return new Entry(this.getPrincipal(aceTree), this.bitsProvider.getBits(privNames), isAllow, restrictions, this.getNamePathMapper());
    }

    @Nonnull
    private static Result searchAces(@Nonnull Set<Principal> principals, @Nonnull Root root) throws RepositoryException {
        StringBuilder stmt = new StringBuilder("/jcr:root");
        stmt.append("//element(*,");
        stmt.append("rep:ACE");
        stmt.append(")[");
        int i = 0;
        for (Principal principal : principals) {
            if (i > 0) {
                stmt.append(" or ");
            }
            stmt.append('@');
            stmt.append(ISO9075.encode("rep:principalName"));
            stmt.append("='");
            stmt.append(principal.getName().replaceAll("'", "''"));
            stmt.append('\'');
            ++i;
        }
        stmt.append(']');
        stmt.append(" order by jcr:path");
        try {
            QueryEngine queryEngine = root.getQueryEngine();
            return queryEngine.executeQuery(stmt.toString(), "xpath", Long.MAX_VALUE, 0L, QueryEngine.NO_BINDINGS, QueryEngine.NO_MAPPINGS);
        }
        catch (ParseException e) {
            String msg = "Error while collecting effective policies.";
            log.error(msg, (Object)e.getMessage());
            throw new RepositoryException(msg, (Throwable)e);
        }
    }

    @Nonnull
    private Principal getPrincipal(@Nonnull Tree aceTree) {
        String principalName = (String)Preconditions.checkNotNull((Object)TreeUtil.getString(aceTree, "rep:principalName"));
        Principal principal = this.principalManager.getPrincipal(principalName);
        if (principal == null) {
            log.debug("Unknown principal " + principalName);
            principal = new PrincipalImpl(principalName);
        }
        return principal;
    }

    private String getNodePath(ACE principalBasedAce) throws RepositoryException {
        Value v = principalBasedAce.getRestriction("rep:nodePath");
        if (v == null) {
            throw new AccessControlException("Missing mandatory restriction rep:nodePath");
        }
        return this.getOakPath(v.getString());
    }

    private static final class ReadPolicy
    implements NamedAccessControlPolicy {
        private static final NamedAccessControlPolicy INSTANCE = new ReadPolicy();

        private ReadPolicy() {
        }

        public String getName() {
            return "Grants read access on configured trees.";
        }
    }

    private final class Entry
    extends ACE {
        private Entry(Principal principal, PrivilegeBits privilegeBits, boolean isAllow, Set<Restriction> restrictions, NamePathMapper namePathMapper) throws AccessControlException {
            super(principal, privilegeBits, isAllow, restrictions, namePathMapper);
        }

        public Privilege[] getPrivileges() {
            HashSet<Privilege> privileges = new HashSet<Privilege>();
            for (String name : AccessControlManagerImpl.this.bitsProvider.getPrivilegeNames(this.getPrivilegeBits())) {
                try {
                    privileges.add(AccessControlManagerImpl.this.getPrivilegeManager().getPrivilege(name));
                }
                catch (RepositoryException e) {
                    log.warn("Unable to get privilege with name : " + name, (Throwable)e);
                }
            }
            return privileges.toArray(new Privilege[privileges.size()]);
        }
    }

    private final class PrincipalACL
    extends ACL {
        private final Principal principal;
        private final RestrictionProvider rProvider;

        private PrincipalACL(@Nonnull String oakPath, Principal principal) {
            this(oakPath, principal, null, new PrincipalRestrictionProvider(accessControlManagerImpl.restrictionProvider));
        }

        private PrincipalACL(@Nonnull String oakPath, @Nullable Principal principal, @Nonnull List<ACE> entries, RestrictionProvider restrictionProvider) {
            super(oakPath, entries, AccessControlManagerImpl.this.getNamePathMapper());
            this.principal = principal;
            this.rProvider = restrictionProvider;
        }

        @Override
        @Nonnull
        public RestrictionProvider getRestrictionProvider() {
            return this.rProvider;
        }

        @Override
        ACE createACE(Principal principal, PrivilegeBits privilegeBits, boolean isAllow, Set<Restriction> restrictions) throws RepositoryException {
            return new Entry(principal, privilegeBits, isAllow, restrictions, this.getNamePathMapper());
        }

        @Override
        boolean checkValidPrincipal(Principal principal) throws AccessControlException {
            Util.checkValidPrincipal(principal, AccessControlManagerImpl.this.principalManager, true);
            return true;
        }

        @Override
        PrivilegeManager getPrivilegeManager() {
            return AccessControlManagerImpl.this.getPrivilegeManager();
        }

        @Override
        PrivilegeBits getPrivilegeBits(Privilege[] privileges) {
            return AccessControlManagerImpl.this.bitsProvider.getBits(privileges, this.getNamePathMapper());
        }

        @Override
        public void orderBefore(AccessControlEntry srcEntry, AccessControlEntry destEntry) throws RepositoryException {
            throw new UnsupportedRepositoryOperationException("reordering is not supported");
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof PrincipalACL) {
                PrincipalACL other = (PrincipalACL)obj;
                return Objects.equal((Object)this.getOakPath(), (Object)other.getOakPath()) && this.getEntries().equals(other.getEntries());
            }
            return false;
        }

        public int hashCode() {
            return 0;
        }
    }

    private class NodeACL
    extends ACL {
        NodeACL(String oakPath) {
            this(oakPath, null);
        }

        NodeACL(@Nullable String oakPath, List<ACE> entries) {
            super(oakPath, entries, AccessControlManagerImpl.this.getNamePathMapper());
        }

        @Override
        @Nonnull
        public RestrictionProvider getRestrictionProvider() {
            return AccessControlManagerImpl.this.restrictionProvider;
        }

        @Override
        ACE createACE(Principal principal, PrivilegeBits privilegeBits, boolean isAllow, Set<Restriction> restrictions) throws RepositoryException {
            return new Entry(principal, privilegeBits, isAllow, restrictions, this.getNamePathMapper());
        }

        @Override
        boolean checkValidPrincipal(Principal principal) throws AccessControlException {
            int importBehavior = Util.getImportBehavior(AccessControlManagerImpl.this.getConfig());
            Util.checkValidPrincipal(principal, AccessControlManagerImpl.this.principalManager, 2 != importBehavior);
            if (principal instanceof AdminPrincipal) {
                log.warn("Attempt to create an ACE for the admin principal which always has full access.");
                switch (Util.getImportBehavior(AccessControlManagerImpl.this.getConfig())) {
                    case 3: {
                        throw new AccessControlException("Attempt to create an ACE for the admin principal which always has full access.");
                    }
                    case 1: {
                        return false;
                    }
                    case 2: {
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Invalid import behavior" + importBehavior);
                    }
                }
            }
            return true;
        }

        @Override
        PrivilegeManager getPrivilegeManager() {
            return AccessControlManagerImpl.this.getPrivilegeManager();
        }

        @Override
        PrivilegeBits getPrivilegeBits(Privilege[] privileges) {
            return AccessControlManagerImpl.this.bitsProvider.getBits(privileges, this.getNamePathMapper());
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof NodeACL) {
                NodeACL other = (NodeACL)obj;
                return Objects.equal((Object)this.getOakPath(), (Object)other.getOakPath()) && this.getEntries().equals(other.getEntries());
            }
            return false;
        }

        public int hashCode() {
            return 0;
        }
    }
}

