/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.authorization.composite;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.jcr.security.AccessControlManager;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.namepath.NamePathMapper;
import org.apache.jackrabbit.oak.security.authorization.composite.CompositeAccessControlManager;
import org.apache.jackrabbit.oak.security.authorization.composite.CompositePermissionProvider;
import org.apache.jackrabbit.oak.spi.security.CompositeConfiguration;
import org.apache.jackrabbit.oak.spi.security.SecurityProvider;
import org.apache.jackrabbit.oak.spi.security.authorization.AuthorizationConfiguration;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.AggregatedPermissionProvider;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.PermissionProvider;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.CompositeRestrictionProvider;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.RestrictionProvider;

public class CompositeAuthorizationConfiguration
extends CompositeConfiguration<AuthorizationConfiguration>
implements AuthorizationConfiguration {
    public CompositeAuthorizationConfiguration(@Nonnull SecurityProvider securityProvider) {
        super("org.apache.jackrabbit.oak.authorization", securityProvider);
    }

    @Override
    @Nonnull
    public AccessControlManager getAccessControlManager(final @Nonnull Root root, final @Nonnull NamePathMapper namePathMapper) {
        List configurations = this.getConfigurations();
        switch (configurations.size()) {
            case 0: {
                throw new IllegalStateException();
            }
            case 1: {
                return ((AuthorizationConfiguration)configurations.get(0)).getAccessControlManager(root, namePathMapper);
            }
        }
        List mgrs = Lists.transform(configurations, (Function)new Function<AuthorizationConfiguration, AccessControlManager>(){

            public AccessControlManager apply(AuthorizationConfiguration authorizationConfiguration) {
                return authorizationConfiguration.getAccessControlManager(root, namePathMapper);
            }
        });
        return new CompositeAccessControlManager(root, namePathMapper, this.getSecurityProvider(), mgrs);
    }

    @Override
    @Nonnull
    public RestrictionProvider getRestrictionProvider() {
        return CompositeRestrictionProvider.newInstance(Lists.transform(this.getConfigurations(), (Function)new Function<AuthorizationConfiguration, RestrictionProvider>(){

            public RestrictionProvider apply(AuthorizationConfiguration authorizationConfiguration) {
                return authorizationConfiguration.getRestrictionProvider();
            }
        }));
    }

    @Override
    @Nonnull
    public PermissionProvider getPermissionProvider(@Nonnull Root root, @Nonnull String workspaceName, @Nonnull Set<Principal> principals) {
        List configurations = this.getConfigurations();
        switch (configurations.size()) {
            case 0: {
                throw new IllegalStateException();
            }
            case 1: {
                return ((AuthorizationConfiguration)configurations.get(0)).getPermissionProvider(root, workspaceName, principals);
            }
        }
        ArrayList aggrPermissionProviders = Lists.newArrayListWithCapacity((int)configurations.size());
        for (AuthorizationConfiguration conf : configurations) {
            PermissionProvider pProvider = conf.getPermissionProvider(root, workspaceName, principals);
            if (!(pProvider instanceof AggregatedPermissionProvider)) continue;
            aggrPermissionProviders.add((AggregatedPermissionProvider)pProvider);
        }
        if (aggrPermissionProviders.size() == 1) {
            return (PermissionProvider)aggrPermissionProviders.get(0);
        }
        return new CompositePermissionProvider(root, aggrPermissionProviders);
    }
}

