/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.authorization.permission;

import java.security.Principal;
import java.util.Collections;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.plugins.tree.RootFactory;
import org.apache.jackrabbit.oak.plugins.tree.TreeLocation;
import org.apache.jackrabbit.oak.plugins.tree.impl.ImmutableTree;
import org.apache.jackrabbit.oak.plugins.version.VersionConstants;
import org.apache.jackrabbit.oak.security.authorization.permission.AllPermissions;
import org.apache.jackrabbit.oak.security.authorization.permission.CompiledPermissionImpl;
import org.apache.jackrabbit.oak.security.authorization.permission.CompiledPermissions;
import org.apache.jackrabbit.oak.spi.security.authorization.AuthorizationConfiguration;
import org.apache.jackrabbit.oak.spi.security.authorization.accesscontrol.AccessControlConstants;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.AggregatedPermissionProvider;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.PermissionConstants;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.PermissionProvider;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.Permissions;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.RepositoryPermission;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.TreePermission;
import org.apache.jackrabbit.oak.spi.security.principal.AdminPrincipal;
import org.apache.jackrabbit.oak.spi.security.principal.SystemPrincipal;
import org.apache.jackrabbit.oak.spi.security.privilege.PrivilegeBits;

public class PermissionProviderImpl
implements PermissionProvider,
AccessControlConstants,
PermissionConstants,
AggregatedPermissionProvider {
    private final Root root;
    private final String workspaceName;
    private final AuthorizationConfiguration acConfig;
    private final CompiledPermissions compiledPermissions;
    private Root immutableRoot;

    public PermissionProviderImpl(@Nonnull Root root, @Nonnull String workspaceName, @Nonnull Set<Principal> principals, @Nonnull AuthorizationConfiguration acConfig) {
        this.root = root;
        this.workspaceName = workspaceName;
        this.acConfig = acConfig;
        this.immutableRoot = RootFactory.createReadOnlyRoot(root);
        this.compiledPermissions = principals.contains(SystemPrincipal.INSTANCE) || this.isAdmin(principals) ? AllPermissions.getInstance() : CompiledPermissionImpl.create(this.immutableRoot, workspaceName, principals, acConfig);
    }

    @Override
    public void refresh() {
        this.immutableRoot = RootFactory.createReadOnlyRoot(this.root);
        this.compiledPermissions.refresh(this.immutableRoot, this.workspaceName);
    }

    @Override
    @Nonnull
    public Set<String> getPrivileges(@Nullable Tree tree) {
        return this.compiledPermissions.getPrivileges(this.getImmutableTree(tree));
    }

    @Override
    public boolean hasPrivileges(@Nullable Tree tree, String ... privilegeNames) {
        return this.compiledPermissions.hasPrivileges(this.getImmutableTree(tree), privilegeNames);
    }

    @Override
    @Nonnull
    public RepositoryPermission getRepositoryPermission() {
        return this.compiledPermissions.getRepositoryPermission();
    }

    @Override
    @Nonnull
    public TreePermission getTreePermission(@Nonnull Tree tree, @Nonnull TreePermission parentPermission) {
        return this.compiledPermissions.getTreePermission(this.getImmutableTree(tree), parentPermission);
    }

    @Override
    public boolean isGranted(@Nonnull Tree tree, @Nullable PropertyState property, long permissions) {
        return this.compiledPermissions.isGranted(this.getImmutableTree(tree), property, permissions);
    }

    @Override
    public boolean isGranted(@Nonnull String oakPath, @Nonnull String jcrActions) {
        Tree tree;
        TreeLocation location = TreeLocation.create(this.immutableRoot, oakPath);
        boolean isAcContent = this.acConfig.getContext().definesLocation(location);
        long permissions = Permissions.getPermissions(jcrActions, location, isAcContent);
        boolean isGranted = false;
        PropertyState property = location.getProperty();
        Tree tree2 = tree = property == null ? location.getTree() : location.getParent().getTree();
        if (tree != null) {
            isGranted = this.isGranted(tree, property, permissions);
        } else if (!PermissionProviderImpl.isVersionStorePath(oakPath)) {
            isGranted = this.compiledPermissions.isGranted(oakPath, permissions);
        }
        return isGranted;
    }

    @Override
    public boolean handles(@Nonnull String path, @Nonnull String jcrAction) {
        return true;
    }

    @Override
    public boolean handles(@Nonnull Tree tree, @Nonnull PrivilegeBits privilegeBits) {
        return true;
    }

    @Override
    public boolean handles(@Nonnull Tree tree, long permission) {
        return true;
    }

    @Override
    public boolean handles(@Nonnull TreePermission treePermission, long permission) {
        return true;
    }

    @Override
    public boolean handlesRepositoryPermissions() {
        return true;
    }

    private boolean isAdmin(Set<Principal> principals) {
        Set adminNames = this.acConfig.getParameters().getConfigValue("administrativePrincipals", Collections.EMPTY_SET);
        for (Principal principal : principals) {
            if (!(principal instanceof AdminPrincipal) && !adminNames.contains(principal.getName())) continue;
            return true;
        }
        return false;
    }

    private ImmutableTree getImmutableTree(@Nullable Tree tree) {
        if (tree instanceof ImmutableTree) {
            return (ImmutableTree)tree;
        }
        return tree == null ? null : (ImmutableTree)this.immutableRoot.getTree(tree.getPath());
    }

    private static boolean isVersionStorePath(@Nonnull String oakPath) {
        if (oakPath.indexOf("jcr:system") == 1) {
            for (String p : VersionConstants.SYSTEM_PATHS) {
                if (!oakPath.startsWith(p)) continue;
                return true;
            }
        }
        return false;
    }
}

