/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.authorization.restriction;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.jcr.security.AccessControlException;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.RestrictionPattern;
import org.apache.jackrabbit.util.Text;

final class GlobPattern
implements RestrictionPattern {
    private static final char WILDCARD_CHAR = '*';
    private static final int MAX_WILDCARD = 20;
    private final String path;
    private final String restriction;
    private final Pattern pattern;

    private GlobPattern(@Nonnull String path, @Nonnull String restriction) {
        this.path = (String)Preconditions.checkNotNull((Object)path);
        this.restriction = restriction;
        if (restriction.length() > 0) {
            StringBuilder b = new StringBuilder(path);
            b.append(restriction);
            int lastPos = restriction.lastIndexOf(42);
            if (lastPos >= 0) {
                String end = lastPos != restriction.length() - 1 ? restriction.substring(lastPos + 1) : null;
                this.pattern = new WildcardPattern(b.toString(), end);
            } else {
                this.pattern = new PathPattern(b.toString());
            }
        } else {
            this.pattern = new PathPattern(restriction);
        }
    }

    static GlobPattern create(@Nonnull String nodePath, @Nonnull String restrictions) {
        return new GlobPattern(nodePath, restrictions);
    }

    static void validate(@Nonnull String restriction) throws AccessControlException {
        int cnt = 0;
        for (int i = 0; i < restriction.length(); ++i) {
            if ('*' == restriction.charAt(i)) {
                ++cnt;
            }
            if (cnt <= 20) continue;
            throw new AccessControlException("Number of wildcards in rep:glob exceeds allowed complexity.");
        }
    }

    @Override
    public boolean matches(@Nonnull Tree tree, @Nullable PropertyState property) {
        String itemPath = property == null ? tree.getPath() : PathUtils.concat(tree.getPath(), property.getName());
        return this.matches(itemPath);
    }

    @Override
    public boolean matches(@Nonnull String path) {
        return this.pattern.matches(path);
    }

    @Override
    public boolean matches() {
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.path, this.restriction});
    }

    public String toString() {
        return this.path + " : " + this.restriction;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof GlobPattern) {
            GlobPattern other = (GlobPattern)obj;
            return this.path.equals(other.path) && this.restriction.equals(other.restriction);
        }
        return false;
    }

    private final class WildcardPattern
    extends Pattern {
        private final String patternEnd;
        private final char[] patternChars;

        private WildcardPattern(@Nullable String patternStr, String patternEnd) {
            this.patternChars = patternStr.toCharArray();
            this.patternEnd = patternEnd;
        }

        @Override
        boolean matches(@Nonnull String toMatch) {
            if (this.patternEnd != null && !toMatch.endsWith(this.patternEnd)) {
                return false;
            }
            char[] tm = toMatch.endsWith("/") ? toMatch.substring(0, toMatch.length() - 1).toCharArray() : toMatch.toCharArray();
            return this.matches(this.patternChars, 0, tm, 0, 20);
        }

        private boolean matches(char[] pattern, int pOff, char[] s, int sOff, int cnt) {
            if (cnt <= 0) {
                throw new IllegalArgumentException("Illegal glob pattern " + GlobPattern.this);
            }
            int pLength = pattern.length;
            int sLength = s.length;
            while (pOff < pLength) {
                if (sOff >= sLength && pattern[pOff] != '*') {
                    return false;
                }
                if (pattern[pOff] == '*') {
                    if (++pOff >= pLength) {
                        return true;
                    }
                    --cnt;
                    while (true) {
                        if (this.matches(pattern, pOff, s, sOff, cnt)) {
                            return true;
                        }
                        if (sOff >= sLength) {
                            return false;
                        }
                        ++sOff;
                    }
                }
                if (pOff < pLength && sOff < sLength && pattern[pOff] != s[sOff]) {
                    return false;
                }
                ++pOff;
                ++sOff;
            }
            return sOff >= sLength;
        }
    }

    private final class PathPattern
    extends Pattern {
        private final String patternStr;

        private PathPattern(String patternStr) {
            this.patternStr = patternStr;
        }

        @Override
        boolean matches(@Nonnull String toMatch) {
            if (this.patternStr.isEmpty()) {
                return GlobPattern.this.path.equals(toMatch);
            }
            return Text.isDescendantOrEqual(this.patternStr, toMatch);
        }
    }

    private abstract class Pattern {
        private Pattern() {
        }

        abstract boolean matches(@Nonnull String var1);
    }
}

