/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.user.query;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.Iterators;
import java.text.ParseException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.Query;
import org.apache.jackrabbit.api.security.user.QueryBuilder;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.jackrabbit.oak.api.QueryEngine;
import org.apache.jackrabbit.oak.api.Result;
import org.apache.jackrabbit.oak.api.ResultRow;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.namepath.NamePathMapper;
import org.apache.jackrabbit.oak.security.user.query.Condition;
import org.apache.jackrabbit.oak.security.user.query.GroupPredicate;
import org.apache.jackrabbit.oak.security.user.query.QueryUtil;
import org.apache.jackrabbit.oak.security.user.query.ResultIterator;
import org.apache.jackrabbit.oak.security.user.query.ResultRowToAuthorizable;
import org.apache.jackrabbit.oak.security.user.query.XPathConditionVisitor;
import org.apache.jackrabbit.oak.security.user.query.XPathQueryBuilder;
import org.apache.jackrabbit.oak.spi.security.ConfigurationParameters;
import org.apache.jackrabbit.oak.spi.security.user.AuthorizableType;
import org.apache.jackrabbit.util.ISO9075;
import org.apache.jackrabbit.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserQueryManager {
    private static final Logger log = LoggerFactory.getLogger(UserQueryManager.class);
    private final UserManager userManager;
    private final NamePathMapper namePathMapper;
    private final ConfigurationParameters config;
    private final Root root;

    public UserQueryManager(UserManager userManager, NamePathMapper namePathMapper, ConfigurationParameters config, Root root) {
        this.userManager = userManager;
        this.namePathMapper = namePathMapper;
        this.config = config;
        this.root = root;
    }

    @Nonnull
    public Iterator<Authorizable> findAuthorizables(Query query) throws RepositoryException {
        XPathQueryBuilder builder = new XPathQueryBuilder();
        query.build(builder);
        if (builder.getMaxCount() == 0L) {
            return Iterators.emptyIterator();
        }
        String statement = this.buildXPathStatement(builder);
        final String groupId = builder.getGroupID();
        if (groupId == null || "everyone".equals(groupId)) {
            long offset = builder.getOffset();
            Value bound = builder.getBound();
            if (bound != null && offset > 0L) {
                log.warn("Found bound {} and offset {} in limit. Discarding offset.", (Object)builder.getBound(), (Object)offset);
                offset = 0L;
            }
            Iterator<Authorizable> result = this.findAuthorizables(statement, builder.getMaxCount(), offset, null);
            if (groupId == null) {
                return result;
            }
            return Iterators.filter(result, (Predicate)new Predicate<Authorizable>(){

                public boolean apply(@Nullable Authorizable authorizable) {
                    try {
                        return authorizable != null && !groupId.equals(authorizable.getID());
                    }
                    catch (RepositoryException e) {
                        return false;
                    }
                }
            });
        }
        Iterator<Authorizable> result = this.findAuthorizables(statement, Long.MAX_VALUE, 0L, null);
        GroupPredicate groupFilter = new GroupPredicate(this.userManager, groupId, builder.isDeclaredMembersOnly());
        return ResultIterator.create(builder.getOffset(), builder.getMaxCount(), Iterators.filter(result, (Predicate)groupFilter));
    }

    @Nonnull
    public Iterator<Authorizable> findAuthorizables(@Nonnull String relPath, @Nullable String value, @Nonnull AuthorizableType authorizableType) throws RepositoryException {
        return this.findAuthorizables(relPath, value, authorizableType, true);
    }

    @Nonnull
    public Iterator<Authorizable> findAuthorizables(@Nonnull String relPath, @Nullable String value, @Nonnull AuthorizableType authorizableType, boolean exact) throws RepositoryException {
        String statement = this.buildXPathStatement(relPath, value, authorizableType, exact);
        return this.findAuthorizables(statement, Long.MAX_VALUE, 0L, authorizableType);
    }

    @Nonnull
    private String buildXPathStatement(@Nonnull String relPath, @Nullable String value, @Nonnull AuthorizableType type, boolean exact) {
        String ntName;
        String path;
        String propName;
        StringBuilder stmt = new StringBuilder();
        String searchRoot = this.namePathMapper.getJcrPath(QueryUtil.getSearchRoot(type, this.config));
        if (!"/".equals(searchRoot)) {
            stmt.append(searchRoot);
        }
        if (relPath.indexOf(47) == -1) {
            propName = relPath;
            path = null;
            ntName = null;
        } else {
            propName = Text.getName(relPath);
            String[] segments = Text.explode(relPath, 47, false);
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < segments.length - 1; ++i) {
                if (PathUtils.denotesCurrent(segments[i])) continue;
                if (i > 0) {
                    sb.append('/');
                }
                sb.append(segments[i]);
            }
            path = Strings.emptyToNull((String)sb.toString());
            ntName = this.namePathMapper.getJcrName(QueryUtil.getNodeTypeName(type));
        }
        stmt.append("//");
        if (path != null) {
            stmt.append(path);
        } else if (ntName != null) {
            stmt.append("element(*,").append(ntName).append(')');
        } else {
            stmt.append("element(*)");
        }
        if (value == null) {
            stmt.append("[@").append(propName).append(']');
        } else {
            stmt.append('[');
            stmt.append(exact ? "@" : "jcr:like(@");
            stmt.append(ISO9075.encode(propName));
            if (exact) {
                stmt.append("='");
                stmt.append(value.replaceAll("'", "''"));
                stmt.append('\'');
            } else {
                stmt.append(",'%");
                stmt.append(QueryUtil.escapeForQuery(value));
                stmt.append("%')");
            }
            stmt.append(']');
        }
        return stmt.toString();
    }

    @Nonnull
    private String buildXPathStatement(@Nonnull XPathQueryBuilder builder) throws RepositoryException {
        Condition condition = builder.getCondition();
        String sortCol = builder.getSortProperty();
        QueryBuilder.Direction sortDir = builder.getSortDirection();
        Value bound = builder.getBound();
        if (bound != null) {
            if (sortCol == null) {
                log.warn("Ignoring bound {} since no sort order is specified");
            } else {
                Condition boundCondition = builder.property(sortCol, QueryUtil.getCollation(sortDir), bound);
                condition = condition == null ? boundCondition : builder.and(condition, boundCondition);
            }
        }
        StringBuilder statement = new StringBuilder();
        XPathConditionVisitor visitor = new XPathConditionVisitor(statement, this.namePathMapper, this.userManager);
        String searchRoot = this.namePathMapper.getJcrPath(QueryUtil.getSearchRoot(builder.getSelectorType(), this.config));
        String ntName = this.namePathMapper.getJcrName(QueryUtil.getNodeTypeName(builder.getSelectorType()));
        statement.append(searchRoot).append("//element(*,").append(ntName).append(')');
        if (condition != null) {
            statement.append('[');
            condition.accept(visitor);
            statement.append(']');
        }
        if (sortCol != null) {
            boolean ignoreCase = builder.getSortIgnoreCase();
            statement.append(" order by ");
            if (ignoreCase) {
                statement.append("fn:lower-case(").append(sortCol).append(')');
            } else {
                statement.append(sortCol);
            }
            statement.append(' ').append(sortDir.getDirection());
        }
        return statement.toString();
    }

    @Nonnull
    private Iterator<Authorizable> findAuthorizables(@Nonnull String statement, long limit, long offset, @Nullable AuthorizableType type) throws RepositoryException {
        try {
            Result query = this.root.getQueryEngine().executeQuery(statement, "xpath", limit, offset, QueryEngine.NO_BINDINGS, this.namePathMapper.getSessionLocalMappings());
            Iterable<? extends ResultRow> resultRows = query.getRows();
            Iterator authorizables = Iterators.transform(resultRows.iterator(), (Function)new ResultRowToAuthorizable(this.userManager, this.root, type));
            return Iterators.filter((Iterator)authorizables, (Predicate)new UniqueResultPredicate());
        }
        catch (ParseException e) {
            log.warn("Invalid user query: " + statement, (Throwable)e);
            throw new RepositoryException((Throwable)e);
        }
    }

    private static final class UniqueResultPredicate
    implements Predicate<Authorizable> {
        private final Set<String> authorizableIds = new HashSet<String>();

        private UniqueResultPredicate() {
        }

        public boolean apply(@Nullable Authorizable input) {
            try {
                if (input != null && !this.authorizableIds.contains(input.getID())) {
                    this.authorizableIds.add(input.getID());
                    return true;
                }
            }
            catch (RepositoryException e) {
                log.debug("Failed to retrieve authorizable ID " + e.getMessage());
            }
            return false;
        }
    }
}

