/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.lifecycle;

import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.plugins.index.IndexEditorProvider;
import org.apache.jackrabbit.oak.plugins.index.IndexUpdateProvider;
import org.apache.jackrabbit.oak.spi.commit.CommitInfo;
import org.apache.jackrabbit.oak.spi.commit.EditorHook;
import org.apache.jackrabbit.oak.spi.lifecycle.RepositoryInitializer;
import org.apache.jackrabbit.oak.spi.lifecycle.WorkspaceInitializer;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeStore;

public final class OakInitializer {
    private OakInitializer() {
    }

    public static void initialize(@Nonnull NodeStore store, @Nonnull RepositoryInitializer initializer, @Nonnull IndexEditorProvider indexEditor) {
        try {
            NodeBuilder builder = store.getRoot().builder();
            initializer.initialize(builder);
            EditorHook hook = new EditorHook(new IndexUpdateProvider(indexEditor));
            CommitInfo info = new CommitInfo("OakInitializer", null);
            store.merge(builder, hook, info);
        }
        catch (CommitFailedException e) {
            throw new RuntimeException(e);
        }
    }

    public static void initialize(@Nonnull Iterable<WorkspaceInitializer> initializer, @Nonnull NodeStore store, @Nonnull String workspaceName, @Nonnull IndexEditorProvider indexEditor) {
        NodeBuilder builder = store.getRoot().builder();
        for (WorkspaceInitializer wspInit : initializer) {
            wspInit.initialize(builder, workspaceName);
        }
        try {
            EditorHook hook = new EditorHook(new IndexUpdateProvider(indexEditor));
            CommitInfo info = new CommitInfo("OakInitializer", null);
            store.merge(builder, hook, info);
        }
        catch (CommitFailedException e) {
            throw new RuntimeException(e);
        }
    }
}

