/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.stats;

import javax.management.openmbean.CompositeData;
import org.apache.jackrabbit.api.stats.RepositoryStatistics;
import org.apache.jackrabbit.api.stats.TimeSeries;
import org.apache.jackrabbit.oak.api.jmx.RepositoryStatsMBean;
import org.apache.jackrabbit.stats.TimeSeriesStatsUtil;

public class RepositoryStats
implements RepositoryStatsMBean {
    private final RepositoryStatistics repoStats;
    private final TimeSeries maxQueueLength;

    public RepositoryStats(RepositoryStatistics repoStats, TimeSeries maxQueueLength) {
        this.repoStats = repoStats;
        this.maxQueueLength = maxQueueLength;
    }

    @Override
    public CompositeData getSessionCount() {
        return this.asCompositeData(RepositoryStatistics.Type.SESSION_COUNT);
    }

    @Override
    public CompositeData getSessionLogin() {
        return this.asCompositeData(RepositoryStatistics.Type.SESSION_LOGIN_COUNTER);
    }

    @Override
    public CompositeData getSessionReadCount() {
        return this.asCompositeData(RepositoryStatistics.Type.SESSION_READ_COUNTER);
    }

    @Override
    public CompositeData getSessionReadDuration() {
        return this.asCompositeData(RepositoryStatistics.Type.SESSION_READ_DURATION);
    }

    @Override
    public CompositeData getSessionReadAverage() {
        return this.asCompositeData(RepositoryStatistics.Type.SESSION_READ_AVERAGE);
    }

    @Override
    public CompositeData getSessionWriteCount() {
        return this.asCompositeData(RepositoryStatistics.Type.SESSION_WRITE_COUNTER);
    }

    @Override
    public CompositeData getSessionWriteDuration() {
        return this.asCompositeData(RepositoryStatistics.Type.SESSION_WRITE_DURATION);
    }

    @Override
    public CompositeData getSessionWriteAverage() {
        return this.asCompositeData(RepositoryStatistics.Type.SESSION_WRITE_AVERAGE);
    }

    @Override
    public CompositeData getQueryCount() {
        return this.asCompositeData(RepositoryStatistics.Type.QUERY_COUNT);
    }

    @Override
    public CompositeData getQueryDuration() {
        return this.asCompositeData(RepositoryStatistics.Type.QUERY_DURATION);
    }

    @Override
    public CompositeData getQueryAverage() {
        return this.asCompositeData(RepositoryStatistics.Type.QUERY_AVERAGE);
    }

    @Override
    public CompositeData getObservationEventCount() {
        return this.asCompositeData(RepositoryStatistics.Type.OBSERVATION_EVENT_COUNTER);
    }

    @Override
    public CompositeData getObservationEventDuration() {
        return this.asCompositeData(RepositoryStatistics.Type.OBSERVATION_EVENT_DURATION);
    }

    @Override
    public CompositeData getObservationEventAverage() {
        return this.asCompositeData(RepositoryStatistics.Type.OBSERVATION_EVENT_AVERAGE);
    }

    @Override
    public CompositeData getObservationQueueMaxLength() {
        return TimeSeriesStatsUtil.asCompositeData(this.maxQueueLength, "maximal length of observation queue");
    }

    private TimeSeries getTimeSeries(RepositoryStatistics.Type type) {
        return this.repoStats.getTimeSeries(type);
    }

    private CompositeData asCompositeData(RepositoryStatistics.Type type) {
        return TimeSeriesStatsUtil.asCompositeData(this.getTimeSeries(type), type.name());
    }
}

