/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.util;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Calendar;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.jcr.AccessDeniedException;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.namepath.NameMapper;
import org.apache.jackrabbit.oak.namepath.NamePathMapper;
import org.apache.jackrabbit.oak.plugins.memory.PropertyStates;
import org.apache.jackrabbit.oak.util.TreeUtil;
import org.apache.jackrabbit.util.ISO8601;
import org.apache.jackrabbit.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeUtil {
    private static final Logger log = LoggerFactory.getLogger(NodeUtil.class);
    private final NameMapper mapper;
    private final Tree tree;

    public NodeUtil(Tree tree, NameMapper mapper) {
        this.mapper = (NameMapper)Preconditions.checkNotNull((Object)mapper);
        this.tree = (Tree)Preconditions.checkNotNull((Object)tree);
    }

    public NodeUtil(Tree tree) {
        this(tree, NamePathMapper.DEFAULT);
    }

    @Nonnull
    public Tree getTree() {
        return this.tree;
    }

    @Nonnull
    public String getName() {
        return this.mapper.getJcrName(this.tree.getName());
    }

    @Nonnull
    public NodeUtil getParent() {
        return new NodeUtil(this.tree.getParent(), this.mapper);
    }

    public boolean hasChild(String name) {
        return this.tree.hasChild(name);
    }

    @CheckForNull
    public NodeUtil getChild(String name) {
        Tree child = this.tree.getChild(name);
        return child.exists() ? new NodeUtil(child, this.mapper) : null;
    }

    @Nonnull
    public NodeUtil addChild(String name, String primaryTypeName) throws AccessDeniedException {
        Tree child = this.tree.addChild(name);
        if (!child.exists()) {
            throw new AccessDeniedException();
        }
        NodeUtil childUtil = new NodeUtil(child, this.mapper);
        childUtil.setName("jcr:primaryType", primaryTypeName);
        return childUtil;
    }

    @Nonnull
    public NodeUtil getOrAddChild(String name, String primaryTypeName) throws AccessDeniedException {
        NodeUtil child = this.getChild(name);
        return child != null ? child : this.addChild(name, primaryTypeName);
    }

    @Nonnull
    public NodeUtil getOrAddTree(String relativePath, String primaryTypeName) throws AccessDeniedException {
        if (relativePath.indexOf(47) == -1) {
            return this.getOrAddChild(relativePath, primaryTypeName);
        }
        Tree t = TreeUtil.getTree(this.tree, relativePath);
        if (t == null || !t.exists()) {
            NodeUtil target = this;
            for (String segment : Text.explode(relativePath, 47)) {
                if (PathUtils.denotesParent(segment)) {
                    target = target.getParent();
                    continue;
                }
                if (target.hasChild(segment)) {
                    target = target.getChild(segment);
                    continue;
                }
                if (PathUtils.denotesCurrent(segment)) continue;
                target = target.addChild(segment, primaryTypeName);
            }
            if (target == null) {
                throw new AccessDeniedException();
            }
            return target;
        }
        return new NodeUtil(t);
    }

    public void removeProperty(String name) {
        this.tree.removeProperty(name);
    }

    public void setBoolean(String name, boolean value) {
        this.tree.setProperty(name, value);
    }

    @CheckForNull
    public String getString(String name, @Nullable String defaultValue) {
        String str = TreeUtil.getString(this.tree, name);
        return str != null ? str : defaultValue;
    }

    public void setString(String name, String value) {
        this.tree.setProperty(name, value);
    }

    public void setStrings(String name, String ... values) {
        this.tree.setProperty(name, Arrays.asList(values), Type.STRINGS);
    }

    @CheckForNull
    public String getName(String name, @Nullable String defaultValue) {
        PropertyState property = this.tree.getProperty(name);
        if (property != null && !property.isArray()) {
            return this.mapper.getJcrName(property.getValue(Type.STRING));
        }
        return defaultValue;
    }

    public void setName(String propertyName, String value) {
        String oakName = this.getOakName(value);
        this.tree.setProperty(propertyName, oakName, Type.NAME);
    }

    public void setNames(String propertyName, String ... values) {
        this.tree.setProperty(propertyName, Lists.transform(Arrays.asList(values), (Function)new Function<String, String>(){

            public String apply(String jcrName) {
                return NodeUtil.this.getOakName(jcrName);
            }
        }), Type.NAMES);
    }

    public void setDate(String name, long time) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(time);
        this.tree.setProperty(name, ISO8601.format(calendar), Type.DATE);
    }

    public long getLong(String name, long defaultValue) {
        PropertyState property = this.tree.getProperty(name);
        if (property != null && !property.isArray()) {
            return property.getValue(Type.LONG);
        }
        return defaultValue;
    }

    public void setValues(String name, Value[] values) {
        try {
            this.tree.setProperty(PropertyStates.createProperty(name, Arrays.asList(values)));
        }
        catch (RepositoryException e) {
            log.warn("Unable to convert values", (Throwable)e);
        }
    }

    @Nonnull
    private String getOakName(String jcrName) {
        String oakName;
        String string = oakName = jcrName == null ? null : this.mapper.getOakNameOrNull(jcrName);
        if (oakName == null) {
            throw new IllegalArgumentException(new RepositoryException("Invalid name:" + jcrName));
        }
        return oakName;
    }
}

