/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.stats;

import org.apache.jackrabbit.api.stats.TimeSeries;

public class TimeSeriesMax
implements TimeSeries {
    private final MaxValue max = new MaxValue(0L);
    private final long[] perSecond = new long[60];
    private final long[] perMinute = new long[60];
    private final long[] perHour = new long[168];
    private final long[] perWeek = new long[156];
    private int seconds;
    private int minutes;
    private int hours;
    private int weeks;

    public void recordValue(long value) {
        this.max.setIfMaximal(value);
    }

    public synchronized void recordOneSecond() {
        this.perSecond[this.seconds++] = this.max.getAndSetValue(0L);
        if (this.seconds == this.perSecond.length) {
            this.seconds = 0;
            this.perMinute[this.minutes++] = TimeSeriesMax.max(this.perSecond);
        }
        if (this.minutes == this.perMinute.length) {
            this.minutes = 0;
            this.perHour[this.hours++] = TimeSeriesMax.max(this.perMinute);
        }
        if (this.hours == this.perHour.length) {
            this.hours = 0;
            this.perWeek[this.weeks++] = TimeSeriesMax.max(this.perHour);
        }
        if (this.weeks == this.perWeek.length) {
            this.weeks = 0;
        }
    }

    @Override
    public synchronized long[] getValuePerSecond() {
        return TimeSeriesMax.cyclicCopyFrom(this.perSecond, this.seconds);
    }

    @Override
    public synchronized long[] getValuePerMinute() {
        return TimeSeriesMax.cyclicCopyFrom(this.perMinute, this.minutes);
    }

    @Override
    public synchronized long[] getValuePerHour() {
        return TimeSeriesMax.cyclicCopyFrom(this.perHour, this.hours);
    }

    @Override
    public synchronized long[] getValuePerWeek() {
        return TimeSeriesMax.cyclicCopyFrom(this.perWeek, this.weeks);
    }

    private static long max(long[] array) {
        long max = Long.MIN_VALUE;
        for (long v : array) {
            if (v <= max) continue;
            max = v;
        }
        return max;
    }

    private static long[] cyclicCopyFrom(long[] array, int pos) {
        long[] reverse = new long[array.length];
        for (int i = 0; i < array.length; ++i) {
            reverse[i] = array[(pos + i) % array.length];
        }
        return reverse;
    }

    private static class MaxValue {
        private long value;

        public MaxValue(long value) {
            this.value = value;
        }

        public synchronized long getAndSetValue(long value) {
            long v = this.value;
            this.value = value;
            return v;
        }

        public synchronized void setIfMaximal(long value) {
            if (value > this.value) {
                this.value = value;
            }
        }
    }
}

