/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.sling.oak;

import java.lang.reflect.Field;
import java.util.concurrent.ExecutorService;
import javax.jcr.Credentials;
import javax.jcr.LoginException;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import javax.jcr.Value;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Service;
import org.apache.jackrabbit.api.JackrabbitRepository;
import org.apache.jackrabbit.oak.Oak;
import org.apache.jackrabbit.oak.jcr.Jcr;
import org.apache.sling.jcr.api.SlingRepository;
import org.apache.sling.testing.mock.sling.oak.ExtraSlingContent;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@Service(value={SlingRepository.class})
public final class OakMockSlingRepository
implements SlingRepository {
    private static final String ADMIN_NAME = "admin";
    private static final String ADMIN_PASSWORD = "admin";
    private Oak oak;
    private Repository repository;
    private static final Logger log = LoggerFactory.getLogger(OakMockSlingRepository.class);

    @Activate
    protected void activate(ComponentContext componentContext) {
        this.oak = new Oak();
        Jcr jcr = new Jcr(this.oak).with(new ExtraSlingContent());
        this.repository = jcr.createRepository();
    }

    @Deactivate
    protected void deactivate(ComponentContext componentContext) {
        ((JackrabbitRepository)this.repository).shutdown();
        this.shutdownExecutorService("executor");
        this.shutdownExecutorService("scheduledExecutor");
    }

    private void shutdownExecutorService(String fieldName) {
        try {
            Field executorField = Oak.class.getDeclaredField(fieldName);
            executorField.setAccessible(true);
            ExecutorService executor = (ExecutorService)executorField.get(this.oak);
            executor.shutdownNow();
        }
        catch (Throwable ex) {
            log.error("Potential Memory leak: Unable to shutdown executor service from field '" + fieldName + "' in " + this.oak, ex);
        }
    }

    public String getDescriptor(String key) {
        return this.repository.getDescriptor(key);
    }

    public String[] getDescriptorKeys() {
        return this.repository.getDescriptorKeys();
    }

    public String getDefaultWorkspace() {
        return "default";
    }

    public Session login() throws LoginException, RepositoryException {
        return this.repository.login();
    }

    public Session login(Credentials credentials, String workspaceName) throws LoginException, NoSuchWorkspaceException, RepositoryException {
        return this.repository.login(credentials, workspaceName == null ? this.getDefaultWorkspace() : workspaceName);
    }

    public Session login(Credentials credentials) throws LoginException, RepositoryException {
        return this.repository.login(credentials);
    }

    public Session login(String workspaceName) throws LoginException, NoSuchWorkspaceException, RepositoryException {
        return this.repository.login(workspaceName == null ? this.getDefaultWorkspace() : workspaceName);
    }

    public Session loginAdministrative(String workspaceName) throws RepositoryException {
        SimpleCredentials credentials = new SimpleCredentials("admin", "admin".toCharArray());
        return this.login((Credentials)credentials, workspaceName == null ? this.getDefaultWorkspace() : workspaceName);
    }

    public Session loginService(String subServiceName, String workspaceName) throws LoginException, RepositoryException {
        return this.loginAdministrative(workspaceName);
    }

    public Value getDescriptorValue(String key) {
        return this.repository.getDescriptorValue(key);
    }

    public Value[] getDescriptorValues(String key) {
        return this.repository.getDescriptorValues(key);
    }

    public boolean isSingleValueDescriptor(String key) {
        return this.repository.isSingleValueDescriptor(key);
    }

    public boolean isStandardDescriptor(String key) {
        return this.repository.isStandardDescriptor(key);
    }
}

