/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.api.jmx;

import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.management.openmbean.CompositeData;
import org.apache.jackrabbit.oak.commons.jmx.Description;
import org.apache.jackrabbit.oak.commons.jmx.Name;

public interface RepositoryManagementMBean {
    public static final String TYPE = "RepositoryManagement";

    @Nonnull
    public CompositeData startBackup();

    @Nonnull
    public CompositeData getBackupStatus();

    @Nonnull
    public CompositeData startRestore();

    @Nonnull
    public CompositeData getRestoreStatus();

    @Nonnull
    public CompositeData startDataStoreGC(@Name(value="markOnly") @Description(value="Set to true to only mark references and not sweep in the mark and sweep operation. This mode is to be used when the underlying BlobStore is shared between multiple different repositories. For all other cases set it to false to perform full garbage collection") boolean var1);

    @Nonnull
    public CompositeData getDataStoreGCStatus();

    @Nonnull
    public CompositeData startRevisionGC();

    @Nonnull
    public CompositeData getRevisionGCStatus();

    @Deprecated
    @CheckForNull
    public String checkpoint(long var1);

    @Nonnull
    public CompositeData startPropertyIndexAsyncReindex();

    @Nonnull
    public CompositeData getPropertyIndexAsyncReindexStatus();

    public static enum StatusCode {
        UNAVAILABLE("Operation not available"),
        NONE("Status not available"),
        INITIATED("Operation initiated"),
        RUNNING("Operation running"),
        SUCCEEDED("Operation succeeded"),
        FAILED("Operation failed");

        public final String name;

        private StatusCode(String name) {
            this.name = name;
        }
    }
}

