/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.namepath;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.namepath.NameMapper;
import org.apache.jackrabbit.oak.plugins.memory.EmptyNodeState;
import org.apache.jackrabbit.oak.plugins.name.Namespaces;
import org.apache.jackrabbit.oak.plugins.tree.RootFactory;
import org.apache.jackrabbit.oak.plugins.tree.TreeFactory;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;

public class GlobalNameMapper
implements NameMapper {
    protected final Tree namespaces;
    protected final Tree nsdata;

    protected static boolean isHiddenName(String name) {
        return name.startsWith(":");
    }

    protected static boolean isExpandedName(String name) {
        if (name.startsWith("{")) {
            int brace = name.indexOf(125, 1);
            return brace != -1 && name.substring(1, brace).indexOf(58) != -1;
        }
        return false;
    }

    public GlobalNameMapper(Root root) {
        this.namespaces = root.getTree("/jcr:system/rep:namespaces");
        this.nsdata = this.namespaces.getChild("rep:nsdata");
    }

    public GlobalNameMapper(NodeState root) {
        this(RootFactory.createReadOnlyRoot(root));
    }

    public GlobalNameMapper(Map<String, String> mappings) {
        NodeBuilder forward = EmptyNodeState.EMPTY_NODE.builder();
        NodeBuilder reverse = EmptyNodeState.EMPTY_NODE.builder();
        for (Map.Entry<String, String> entry : mappings.entrySet()) {
            String prefix = entry.getKey();
            if (prefix.isEmpty()) continue;
            String uri = entry.getValue();
            forward.setProperty(prefix, uri);
            reverse.setProperty(Namespaces.encodeUri(uri), prefix);
        }
        reverse.setProperty("rep:prefixes", mappings.keySet(), Type.STRINGS);
        reverse.setProperty("rep:uris", mappings.values(), Type.STRINGS);
        this.namespaces = TreeFactory.createReadOnlyTree(forward.getNodeState());
        this.nsdata = TreeFactory.createReadOnlyTree(reverse.getNodeState());
    }

    @Override
    @Nonnull
    public String getJcrName(@Nonnull String oakName) {
        Preconditions.checkNotNull((Object)oakName);
        Preconditions.checkArgument((!GlobalNameMapper.isHiddenName(oakName) ? 1 : 0) != 0, (Object)oakName);
        Preconditions.checkArgument((!GlobalNameMapper.isExpandedName(oakName) ? 1 : 0) != 0, (Object)oakName);
        return oakName;
    }

    @Override
    @CheckForNull
    public String getOakNameOrNull(@Nonnull String jcrName) {
        if (jcrName.startsWith("{")) {
            return this.getOakNameFromExpanded(jcrName);
        }
        return jcrName;
    }

    @Override
    @Nonnull
    public String getOakName(@Nonnull String jcrName) throws RepositoryException {
        String oakName = this.getOakNameOrNull(jcrName);
        if (oakName == null) {
            throw new RepositoryException("Invalid jcr name " + jcrName);
        }
        return oakName;
    }

    @Override
    @Nonnull
    public Map<String, String> getSessionLocalMappings() {
        return Collections.emptyMap();
    }

    @CheckForNull
    protected String getOakNameFromExpanded(String expandedName) {
        Preconditions.checkArgument((boolean)expandedName.startsWith("{"));
        int brace = expandedName.indexOf(125, 1);
        if (brace > 0) {
            String uri = expandedName.substring(1, brace);
            if (uri.isEmpty()) {
                return expandedName.substring(2);
            }
            if (uri.indexOf(58) != -1) {
                String oakPrefix = this.getOakPrefixOrNull(uri);
                if (oakPrefix != null) {
                    return oakPrefix + ':' + expandedName.substring(brace + 1);
                }
                return null;
            }
        }
        return expandedName;
    }

    @CheckForNull
    protected synchronized String getOakPrefixOrNull(String uri) {
        if (uri.isEmpty()) {
            return uri;
        }
        PropertyState mapping = this.nsdata.getProperty(Namespaces.encodeUri(uri));
        if (mapping != null && mapping.getType() == Type.STRING) {
            return mapping.getValue(Type.STRING);
        }
        return null;
    }

    @CheckForNull
    protected synchronized String getOakURIOrNull(String prefix) {
        if (prefix.isEmpty()) {
            return prefix;
        }
        PropertyState mapping = this.namespaces.getProperty(prefix);
        if (mapping != null && mapping.getType() == Type.STRING) {
            return mapping.getValue(Type.STRING);
        }
        return null;
    }
}

