/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.atomic;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import java.util.UUID;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.spi.commit.DefaultEditor;
import org.apache.jackrabbit.oak.spi.commit.Editor;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtomicCounterEditor
extends DefaultEditor {
    public static final String PROP_INCREMENT = "oak:increment";
    public static final String PROP_COUNTER = "oak:counter";
    public static final String PREFIX_PROP_COUNTER = ":oak-counter-";
    private static final Logger LOG = LoggerFactory.getLogger(AtomicCounterEditor.class);
    private final NodeBuilder builder;
    private final String path;
    private boolean update;

    public AtomicCounterEditor(@Nonnull NodeBuilder builder) {
        this("", (NodeBuilder)Preconditions.checkNotNull((Object)builder));
    }

    private AtomicCounterEditor(String path, NodeBuilder builder) {
        this.builder = (NodeBuilder)Preconditions.checkNotNull((Object)builder);
        this.path = path;
    }

    private static boolean shallWeProcessProperty(PropertyState property, String path, NodeBuilder builder) {
        boolean process = false;
        PropertyState mixin = ((NodeBuilder)Preconditions.checkNotNull((Object)builder)).getProperty("jcr:mixinTypes");
        if (mixin != null && PROP_INCREMENT.equals(property.getName()) && Iterators.contains(mixin.getValue(Type.NAMES).iterator(), (Object)"mix:atomicCounter")) {
            if (Type.LONG.equals(property.getType())) {
                process = true;
            } else {
                LOG.warn("although the {} property is set is not of the right value: LONG. Not processing node: {}.", (Object)PROP_INCREMENT, (Object)path);
            }
        }
        return process;
    }

    public static void consolidateCount(@Nonnull NodeBuilder builder) {
        long count = builder.hasProperty(PROP_COUNTER) ? builder.getProperty(PROP_COUNTER).getValue(Type.LONG) : 0L;
        for (PropertyState propertyState : builder.getProperties()) {
            if (!propertyState.getName().startsWith(PREFIX_PROP_COUNTER)) continue;
            count += propertyState.getValue(Type.LONG).longValue();
            builder.removeProperty(propertyState.getName());
        }
        builder.setProperty(PROP_COUNTER, count);
    }

    private void setUniqueCounter(long value) {
        this.update = true;
        this.builder.setProperty(PREFIX_PROP_COUNTER + UUID.randomUUID(), value, Type.LONG);
    }

    @Override
    public void propertyAdded(PropertyState after) throws CommitFailedException {
        if (AtomicCounterEditor.shallWeProcessProperty(after, this.path, this.builder)) {
            this.setUniqueCounter(after.getValue(Type.LONG));
            this.builder.removeProperty(PROP_INCREMENT);
        }
    }

    @Override
    public Editor childNodeAdded(String name, NodeState after) throws CommitFailedException {
        return new AtomicCounterEditor(this.path + '/' + name, this.builder.getChildNode(name));
    }

    @Override
    public Editor childNodeChanged(String name, NodeState before, NodeState after) throws CommitFailedException {
        return new AtomicCounterEditor(this.path + '/' + name, this.builder.getChildNode(name));
    }

    @Override
    public void leave(NodeState before, NodeState after) throws CommitFailedException {
        if (this.update) {
            AtomicCounterEditor.consolidateCount(this.builder);
        }
    }
}

