/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.blob;

import com.google.common.base.Preconditions;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import javax.annotation.Nonnull;
import javax.management.openmbean.CompositeData;
import org.apache.jackrabbit.oak.management.ManagementOperation;
import org.apache.jackrabbit.oak.plugins.blob.BlobGCMBean;
import org.apache.jackrabbit.oak.plugins.blob.BlobGarbageCollector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlobGC
implements BlobGCMBean {
    private static final Logger log = LoggerFactory.getLogger(BlobGC.class);
    public static final String OP_NAME = "Blob garbage collection";
    private final BlobGarbageCollector blobGarbageCollector;
    private final Executor executor;
    private ManagementOperation<String> gcOp = ManagementOperation.done("Blob garbage collection", "");

    public BlobGC(@Nonnull BlobGarbageCollector blobGarbageCollector, @Nonnull Executor executor) {
        this.blobGarbageCollector = (BlobGarbageCollector)Preconditions.checkNotNull((Object)blobGarbageCollector);
        this.executor = (Executor)Preconditions.checkNotNull((Object)executor);
    }

    @Override
    @Nonnull
    public CompositeData startBlobGC(final boolean markOnly) {
        if (this.gcOp.isDone()) {
            this.gcOp = ManagementOperation.newManagementOperation(OP_NAME, new Callable<String>(){

                @Override
                public String call() throws Exception {
                    long t0 = System.nanoTime();
                    BlobGC.this.blobGarbageCollector.collectGarbage(markOnly);
                    return "Blob gc completed in " + ManagementOperation.Status.formatTime(System.nanoTime() - t0);
                }
            });
            this.executor.execute(this.gcOp);
        }
        return this.getBlobGCStatus();
    }

    @Override
    @Nonnull
    public CompositeData getBlobGCStatus() {
        return this.gcOp.getStatus().toCompositeData();
    }
}

