/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.blob;

import com.google.common.cache.Weigher;
import org.apache.jackrabbit.oak.cache.CacheLIRS;
import org.apache.jackrabbit.oak.spi.blob.AbstractBlobStore;

public abstract class CachingBlobStore
extends AbstractBlobStore {
    protected static final long DEFAULT_CACHE_SIZE = 0x1000000L;
    protected final CacheLIRS<String, byte[]> cache;
    protected final long blobCacheSize;

    public CachingBlobStore(long cacheSize) {
        this.blobCacheSize = cacheSize;
        this.cache = CacheLIRS.newBuilder().maximumWeight(cacheSize).averageWeight(this.getBlockSize() / 2).weigher(new Weigher<String, byte[]>(){

            public int weigh(String key, byte[] value) {
                return value.length;
            }
        }).build();
    }

    public CachingBlobStore() {
        this(0x1000000L);
    }

    @Override
    public void clearCache() {
        this.cache.invalidateAll();
    }

    public long getBlobCacheSize() {
        return this.blobCacheSize;
    }
}

