/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.blob;

import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.base.StandardSystemProperty;
import com.google.common.base.Stopwatch;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.PeekingIterator;
import com.google.common.io.Closeables;
import com.google.common.io.Files;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.LineIterator;
import org.apache.jackrabbit.core.data.DataRecord;
import org.apache.jackrabbit.core.data.DataStoreException;
import org.apache.jackrabbit.oak.commons.IOUtils;
import org.apache.jackrabbit.oak.plugins.blob.BlobGarbageCollector;
import org.apache.jackrabbit.oak.plugins.blob.BlobReferenceRetriever;
import org.apache.jackrabbit.oak.plugins.blob.GarbageCollectorFileState;
import org.apache.jackrabbit.oak.plugins.blob.ReferenceCollector;
import org.apache.jackrabbit.oak.plugins.blob.SharedDataStore;
import org.apache.jackrabbit.oak.plugins.blob.datastore.SharedDataStoreUtils;
import org.apache.jackrabbit.oak.spi.blob.GarbageCollectableBlobStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MarkSweepGarbageCollector
implements BlobGarbageCollector {
    public static final Logger LOG = LoggerFactory.getLogger(MarkSweepGarbageCollector.class);
    public static final String NEWLINE = StandardSystemProperty.LINE_SEPARATOR.value();
    public static final String TEMP_DIR = StandardSystemProperty.JAVA_IO_TMPDIR.value();
    public static final int DEFAULT_BATCH_COUNT = 2048;
    private final long maxLastModifiedInterval;
    private final GarbageCollectableBlobStore blobStore;
    private final BlobReferenceRetriever marker;
    private final GarbageCollectorFileState fs;
    private final Executor executor;
    private final int batchCount;
    private String repoId;
    private State state = State.NOT_RUNNING;

    public MarkSweepGarbageCollector(BlobReferenceRetriever marker, GarbageCollectableBlobStore blobStore, Executor executor, String root, int batchCount, long maxLastModifiedInterval, @Nullable String repositoryId) throws IOException {
        this.executor = executor;
        this.blobStore = blobStore;
        this.marker = marker;
        this.batchCount = batchCount;
        this.maxLastModifiedInterval = maxLastModifiedInterval;
        this.repoId = repositoryId;
        this.fs = new GarbageCollectorFileState(root);
    }

    public MarkSweepGarbageCollector(BlobReferenceRetriever marker, GarbageCollectableBlobStore blobStore, Executor executor, @Nullable String repositoryId) throws IOException {
        this(marker, blobStore, executor, TEMP_DIR, 2048, TimeUnit.HOURS.toMillis(24L), repositoryId);
    }

    public MarkSweepGarbageCollector(BlobReferenceRetriever marker, GarbageCollectableBlobStore blobStore, Executor executor, long maxLastModifiedInterval, @Nullable String repositoryId) throws IOException {
        this(marker, blobStore, executor, TEMP_DIR, 2048, maxLastModifiedInterval, repositoryId);
    }

    @Override
    public void collectGarbage(boolean markOnly) throws Exception {
        this.markAndSweep(markOnly);
    }

    public State getState() {
        return this.state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void markAndSweep(boolean markOnly) throws Exception {
        boolean threw = true;
        try {
            Stopwatch sw = Stopwatch.createStarted();
            LOG.info("Starting Blob garbage collection");
            this.mark();
            if (!markOnly) {
                int deleteCount = this.sweep();
                threw = false;
                LOG.info("Blob garbage collection completed in {}. Number of blobs deleted [{}]", (Object)sw.toString(), (Object)deleteCount);
            }
        }
        finally {
            if (!LOG.isTraceEnabled()) {
                Closeables.close((Closeable)this.fs, (boolean)threw);
            }
            this.state = State.NOT_RUNNING;
        }
    }

    private void mark() throws IOException, DataStoreException {
        this.state = State.MARKING;
        LOG.debug("Starting mark phase of the garbage collector");
        this.iterateNodeTree();
        GarbageCollectionType.get(this.blobStore).addMarked(this.blobStore, this.fs, this.repoId);
        LOG.debug("Ending mark phase of the garbage collector");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void difference() throws IOException {
        LOG.debug("Starting difference phase of the garbage collector");
        FileLineDifferenceIterator iter = new FileLineDifferenceIterator(this.fs.getMarkedRefs(), this.fs.getAvailableRefs());
        BufferedWriter bufferWriter = null;
        try {
            bufferWriter = Files.newWriter((File)this.fs.getGcCandidates(), (Charset)Charsets.UTF_8);
            ArrayList expiredSet = Lists.newArrayList();
            int numCandidates = 0;
            while (iter.hasNext()) {
                expiredSet.add(iter.next());
                if (expiredSet.size() <= this.getBatchCount()) continue;
                numCandidates += expiredSet.size();
                MarkSweepGarbageCollector.saveBatchToFile(expiredSet, bufferWriter);
            }
            if (!expiredSet.isEmpty()) {
                numCandidates += expiredSet.size();
                MarkSweepGarbageCollector.saveBatchToFile(expiredSet, bufferWriter);
            }
            LOG.debug("Found GC candidates - " + numCandidates);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(bufferWriter);
            IOUtils.closeQuietly(iter);
            throw throwable;
        }
        IOUtils.closeQuietly(bufferWriter);
        IOUtils.closeQuietly(iter);
        LOG.debug("Ending difference phase of the garbage collector");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int sweep() throws Exception {
        long earliestRefAvailTime;
        try {
            earliestRefAvailTime = GarbageCollectionType.get(this.blobStore).mergeAllMarkedReferences(this.blobStore, this.fs);
        }
        catch (Exception e) {
            return 0;
        }
        new BlobIdRetriever().call();
        this.difference();
        int count = 0;
        this.state = State.SWEEPING;
        LOG.debug("Starting sweep phase of the garbage collector");
        LOG.debug("Sweeping blobs with modified time > than the configured max deleted time ({}). " + MarkSweepGarbageCollector.timestampToString(this.getLastMaxModifiedTime(earliestRefAvailTime)));
        ConcurrentLinkedQueue<String> exceptionQueue = new ConcurrentLinkedQueue<String>();
        LineIterator iterator = FileUtils.lineIterator((File)this.fs.getGcCandidates(), (String)Charsets.UTF_8.name());
        ArrayList ids = Lists.newArrayList();
        while (iterator.hasNext()) {
            ids.add(iterator.next());
            if (ids.size() <= this.getBatchCount()) continue;
            count += ids.size();
            this.executor.execute(new Sweeper(ids, exceptionQueue, earliestRefAvailTime));
            ids = Lists.newArrayList();
        }
        if (!ids.isEmpty()) {
            count += ids.size();
            this.executor.execute(new Sweeper(ids, exceptionQueue, earliestRefAvailTime));
        }
        count -= exceptionQueue.size();
        BufferedWriter writer = null;
        try {
            if (!exceptionQueue.isEmpty()) {
                writer = Files.newWriter((File)this.fs.getGarbage(), (Charset)Charsets.UTF_8);
                MarkSweepGarbageCollector.saveBatchToFile(Lists.newArrayList(exceptionQueue), writer);
            }
        }
        finally {
            LineIterator.closeQuietly((LineIterator)iterator);
            IOUtils.closeQuietly(writer);
        }
        if (!exceptionQueue.isEmpty()) {
            LOG.warn("Unable to delete some blobs entries from the blob store. This may happen if blob modified time is > than the max deleted time ({}). Details around such blob entries can be found in [{}]", (Object)MarkSweepGarbageCollector.timestampToString(this.getLastMaxModifiedTime(earliestRefAvailTime)), (Object)this.fs.getGarbage().getAbsolutePath());
        }
        GarbageCollectionType.get(this.blobStore).removeAllMarkedReferences(this.blobStore);
        LOG.debug("Ending sweep phase of the garbage collector");
        return count;
    }

    private int getBatchCount() {
        return this.batchCount;
    }

    private long getLastMaxModifiedTime(long maxModified) {
        return this.maxLastModifiedInterval > 0L ? (maxModified <= 0L ? System.currentTimeMillis() : maxModified) - this.maxLastModifiedInterval : 0L;
    }

    static void saveBatchToFile(List<String> ids, BufferedWriter writer) throws IOException {
        writer.append(Joiner.on((String)NEWLINE).join(ids));
        writer.append(NEWLINE);
        ids.clear();
        writer.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void iterateNodeTree() throws IOException {
        final BufferedWriter writer = Files.newWriter((File)this.fs.getMarkedRefs(), (Charset)Charsets.UTF_8);
        final AtomicInteger count = new AtomicInteger();
        try {
            this.marker.collectReferences(new ReferenceCollector(){
                private final List<String> idBatch;
                private final boolean debugMode;
                {
                    this.idBatch = Lists.newArrayListWithCapacity((int)MarkSweepGarbageCollector.this.getBatchCount());
                    this.debugMode = LOG.isTraceEnabled();
                }

                @Override
                public void addReference(String blobId) {
                    if (this.debugMode) {
                        LOG.trace("BlobId : {}", (Object)blobId);
                    }
                    try {
                        Iterator<String> idIter = MarkSweepGarbageCollector.this.blobStore.resolveChunks(blobId);
                        while (idIter.hasNext()) {
                            String id = idIter.next();
                            this.idBatch.add(id);
                            if (this.idBatch.size() >= MarkSweepGarbageCollector.this.getBatchCount()) {
                                MarkSweepGarbageCollector.saveBatchToFile(this.idBatch, writer);
                                this.idBatch.clear();
                            }
                            if (this.debugMode) {
                                LOG.trace("chunkId : {}", (Object)id);
                            }
                            count.getAndIncrement();
                        }
                        if (!this.idBatch.isEmpty()) {
                            MarkSweepGarbageCollector.saveBatchToFile(this.idBatch, writer);
                            this.idBatch.clear();
                        }
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Error in retrieving references", e);
                    }
                }
            });
            LOG.info("Number of valid blob references marked under mark phase of Blob garbage collection [{}]", (Object)count.get());
            GarbageCollectorFileState.sort(this.fs.getMarkedRefs());
        }
        finally {
            IOUtils.closeQuietly(writer);
        }
    }

    private static String timestampToString(long timestamp) {
        return (new Timestamp(timestamp) + "00").substring(0, 23);
    }

    static enum GarbageCollectionType {
        SHARED{

            @Override
            void removeAllMarkedReferences(GarbageCollectableBlobStore blobStore) {
                ((SharedDataStore)((Object)blobStore)).deleteAllMetadataRecords(SharedDataStoreUtils.SharedStoreRecordType.REFERENCES.getType());
            }

            @Override
            long mergeAllMarkedReferences(GarbageCollectableBlobStore blobStore, GarbageCollectorFileState fs) throws IOException, DataStoreException {
                List<DataRecord> refFiles = ((SharedDataStore)((Object)blobStore)).getAllMetadataRecords(SharedDataStoreUtils.SharedStoreRecordType.REFERENCES.getType());
                List<DataRecord> repoFiles = ((SharedDataStore)((Object)blobStore)).getAllMetadataRecords(SharedDataStoreUtils.SharedStoreRecordType.REPOSITORY.getType());
                Set<String> unAvailRepos = SharedDataStoreUtils.refsNotAvailableFromRepos(repoFiles, refFiles);
                if (unAvailRepos.isEmpty()) {
                    ArrayList files = Lists.newArrayList();
                    for (DataRecord refFile : refFiles) {
                        File file = GarbageCollectorFileState.copy(refFile.getStream());
                        files.add(file);
                    }
                    GarbageCollectorFileState.merge(files, fs.getMarkedRefs());
                    return SharedDataStoreUtils.getEarliestRecord(refFiles).getLastModified();
                }
                LOG.error("Not all repositories have marked references available : {}", unAvailRepos);
                throw new IOException("Not all repositories have marked references available");
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            void addMarked(GarbageCollectableBlobStore blobStore, GarbageCollectorFileState fs, String repoId) throws DataStoreException, IOException {
                FileInputStream is = new FileInputStream(fs.getMarkedRefs());
                try {
                    ((SharedDataStore)((Object)blobStore)).addMetadataRecord(is, SharedDataStoreUtils.SharedStoreRecordType.REFERENCES.getNameFromId(repoId));
                }
                finally {
                    Closeables.close((Closeable)is, (boolean)false);
                }
            }
        }
        ,
        DEFAULT;


        void removeAllMarkedReferences(GarbageCollectableBlobStore blobStore) {
        }

        void addMarked(GarbageCollectableBlobStore blobStore, GarbageCollectorFileState fs, String repoId) throws DataStoreException, IOException {
        }

        long mergeAllMarkedReferences(GarbageCollectableBlobStore blobStore, GarbageCollectorFileState fs) throws IOException, DataStoreException {
            if (!fs.getMarkedRefs().exists() || fs.getMarkedRefs().length() == 0L) {
                throw new IOException("Marked references not available");
            }
            return fs.getMarkedRefs().lastModified();
        }

        public static GarbageCollectionType get(GarbageCollectableBlobStore blobStore) {
            if (SharedDataStoreUtils.isShared(blobStore)) {
                return SHARED;
            }
            return DEFAULT;
        }
    }

    static class FileLineDifferenceIterator
    extends AbstractIterator<String>
    implements Closeable {
        private final PeekingIterator<String> peekMarked;
        private final LineIterator marked;
        private final LineIterator all;

        public FileLineDifferenceIterator(File marked, File available) throws IOException {
            this(FileUtils.lineIterator((File)marked), FileUtils.lineIterator((File)available));
        }

        public FileLineDifferenceIterator(LineIterator marked, LineIterator available) throws IOException {
            this.marked = marked;
            this.peekMarked = Iterators.peekingIterator((Iterator)marked);
            this.all = available;
        }

        protected String computeNext() {
            String diff = this.computeNextDiff();
            if (diff == null) {
                this.close();
                return (String)this.endOfData();
            }
            return diff;
        }

        @Override
        public void close() {
            LineIterator.closeQuietly((LineIterator)this.marked);
            LineIterator.closeQuietly((LineIterator)this.all);
        }

        private String computeNextDiff() {
            if (!this.all.hasNext()) {
                return null;
            }
            if (!this.peekMarked.hasNext()) {
                return this.all.next();
            }
            String diff = null;
            block0: while (this.all.hasNext() && diff == null) {
                diff = this.all.next();
                while (this.peekMarked.hasNext()) {
                    String marked = (String)this.peekMarked.peek();
                    int comparisonResult = diff.compareTo(marked);
                    if (comparisonResult > 0) {
                        this.peekMarked.next();
                        continue;
                    }
                    if (comparisonResult == 0) {
                        this.peekMarked.next();
                        diff = null;
                        continue block0;
                    }
                    return diff;
                }
            }
            return diff;
        }
    }

    private class BlobIdRetriever
    implements Callable<Integer> {
        private BlobIdRetriever() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Integer call() throws Exception {
            LOG.debug("Starting retrieve of all blobs");
            BufferedWriter bufferWriter = null;
            int blobsCount = 0;
            try {
                bufferWriter = new BufferedWriter(new FileWriter(MarkSweepGarbageCollector.this.fs.getAvailableRefs()));
                Iterator<String> idsIter = MarkSweepGarbageCollector.this.blobStore.getAllChunkIds(0L);
                ArrayList ids = Lists.newArrayList();
                while (idsIter.hasNext()) {
                    ids.add(idsIter.next());
                    if (ids.size() <= MarkSweepGarbageCollector.this.getBatchCount()) continue;
                    MarkSweepGarbageCollector.saveBatchToFile(ids, bufferWriter);
                    LOG.debug("retrieved {} blobs", (Object)(blobsCount += ids.size()));
                }
                if (!ids.isEmpty()) {
                    MarkSweepGarbageCollector.saveBatchToFile(ids, bufferWriter);
                    LOG.debug("retrieved {} blobs", (Object)(blobsCount += ids.size()));
                }
                GarbageCollectorFileState.sort(MarkSweepGarbageCollector.this.fs.getAvailableRefs());
                LOG.debug("Number of blobs present in BlobStore : [{}] ", (Object)blobsCount);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(bufferWriter);
                throw throwable;
            }
            IOUtils.closeQuietly(bufferWriter);
            return blobsCount;
        }
    }

    class Sweeper
    implements Runnable {
        private final ConcurrentLinkedQueue<String> exceptionQueue;
        private final List<String> ids;
        private final long maxModified;

        public Sweeper(List<String> ids, ConcurrentLinkedQueue<String> exceptionQueue, long maxModified) {
            this.exceptionQueue = exceptionQueue;
            this.ids = ids;
            this.maxModified = maxModified;
        }

        @Override
        public void run() {
            try {
                LOG.debug("Blob ids to be deleted {}", this.ids);
                boolean deleted = MarkSweepGarbageCollector.this.blobStore.deleteChunks(this.ids, MarkSweepGarbageCollector.this.getLastMaxModifiedTime(this.maxModified));
                if (!deleted) {
                    LOG.debug("Some blobs were not deleted from the batch : [{}]", this.ids);
                }
            }
            catch (Exception e) {
                LOG.warn("Error occurred while deleting blob with ids [{}]", this.ids, (Object)e);
                this.exceptionQueue.addAll(this.ids);
            }
        }
    }

    public static enum State {
        NOT_RUNNING,
        MARKING,
        SWEEPING;

    }
}

