/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.blob.datastore;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Map;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.core.data.DataStore;
import org.apache.jackrabbit.core.data.DataStoreException;
import org.apache.jackrabbit.oak.commons.PropertiesUtil;
import org.apache.jackrabbit.oak.plugins.blob.datastore.DataStoreBlobStore;
import org.apache.jackrabbit.oak.spi.blob.BlobStore;
import org.apache.jackrabbit.oak.spi.blob.GarbageCollectableBlobStore;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDataStoreService {
    private static final String PROP_HOME = "repository.home";
    public static final String PROP_ENCODE_LENGTH = "encodeLengthInId";
    public static final String PROP_CACHE_SIZE = "cacheSizeInMB";
    private static final String DESCRIPTION = "oak.blobstore.description";
    private ServiceRegistration reg;
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private DataStore dataStore;

    protected void activate(ComponentContext context, Map<String, Object> config) throws RepositoryException {
        DataStore ds = this.createDataStore(context, config);
        boolean encodeLengthInId = PropertiesUtil.toBoolean(config.get(PROP_ENCODE_LENGTH), true);
        int cacheSizeInMB = PropertiesUtil.toInteger(config.get(PROP_CACHE_SIZE), 16);
        String homeDir = AbstractDataStoreService.lookup(context, PROP_HOME);
        if (homeDir != null) {
            this.log.info("Initializing the DataStore with homeDir [{}]", (Object)homeDir);
        }
        PropertiesUtil.populate(ds, config, false);
        ds.init(homeDir);
        this.dataStore = new DataStoreBlobStore(ds, encodeLengthInId, cacheSizeInMB);
        PropertiesUtil.populate(this.dataStore, config, false);
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        ((Dictionary)props).put("service.pid", ds.getClass().getName());
        ((Dictionary)props).put(DESCRIPTION, this.getDescription());
        this.reg = context.getBundleContext().registerService(new String[]{BlobStore.class.getName(), GarbageCollectableBlobStore.class.getName()}, (Object)this.dataStore, props);
    }

    protected void deactivate() throws DataStoreException {
        if (this.reg != null) {
            this.reg.unregister();
        }
        this.dataStore.close();
    }

    protected abstract DataStore createDataStore(ComponentContext var1, Map<String, Object> var2);

    protected String[] getDescription() {
        return new String[]{"type=unknown"};
    }

    protected static String lookup(ComponentContext context, String property) {
        if (context.getBundleContext().getProperty(property) != null) {
            return context.getBundleContext().getProperty(property);
        }
        if (context.getProperties().get(property) != null) {
            return context.getProperties().get(property).toString();
        }
        return null;
    }
}

