/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document;

import com.google.common.base.Preconditions;
import java.lang.management.ManagementFactory;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.UUID;
import org.apache.jackrabbit.oak.commons.StringUtils;
import org.apache.jackrabbit.oak.plugins.document.ClusterNodeInfoDocument;
import org.apache.jackrabbit.oak.plugins.document.Collection;
import org.apache.jackrabbit.oak.plugins.document.Document;
import org.apache.jackrabbit.oak.plugins.document.DocumentStore;
import org.apache.jackrabbit.oak.plugins.document.DocumentStoreException;
import org.apache.jackrabbit.oak.plugins.document.UpdateOp;
import org.apache.jackrabbit.oak.stats.Clock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterNodeInfo {
    private static final Logger LOG = LoggerFactory.getLogger(ClusterNodeInfo.class);
    private static final String RANDOM_PREFIX = "random:";
    private static final String MACHINE_ID_KEY = "machine";
    private static final String INSTANCE_ID_KEY = "instance";
    public static final String LEASE_END_KEY = "leaseEnd";
    public static final String STATE = "state";
    public static final String REV_RECOVERY_LOCK = "recoveryLock";
    private static final String INFO_KEY = "info";
    private static final String READ_WRITE_MODE_KEY = "readWriteMode";
    private static final String MACHINE_ID = ClusterNodeInfo.getMachineId();
    private static final long PROCESS_ID = ClusterNodeInfo.getProcessId();
    private static final String WORKING_DIR = System.getProperty("user.dir", "");
    private static Clock clock = Clock.SIMPLE;
    public static final int DEFAULT_LEASE_DURATION_MILLIS = 60000;
    private long leaseTime = 60000L;
    private final int id;
    private final String machineId;
    private final String instanceId;
    private final DocumentStore store;
    private final long startTime;
    private final String uuid = UUID.randomUUID().toString();
    private long leaseEndTime;
    private String readWriteMode;
    private ClusterNodeState state;
    private RecoverLockState revRecoveryLock;
    private boolean newEntry;

    private ClusterNodeInfo(int id, DocumentStore store, String machineId, String instanceId, ClusterNodeState state, RecoverLockState revRecoveryLock, Long leaseEnd, boolean newEntry) {
        this.id = id;
        this.startTime = ClusterNodeInfo.getCurrentTime();
        this.leaseEndTime = leaseEnd == null ? this.startTime : leaseEnd;
        this.store = store;
        this.machineId = machineId;
        this.instanceId = instanceId;
        this.state = state;
        this.revRecoveryLock = revRecoveryLock;
        this.newEntry = newEntry;
    }

    public int getId() {
        return this.id;
    }

    public static ClusterNodeInfo getInstance(DocumentStore store) {
        return ClusterNodeInfo.getInstance(store, MACHINE_ID, WORKING_DIR, false);
    }

    public static ClusterNodeInfo getInstance(DocumentStore store, String machineId, String instanceId) {
        return ClusterNodeInfo.getInstance(store, machineId, instanceId, true);
    }

    public static ClusterNodeInfo getInstance(DocumentStore store, String machineId, String instanceId, boolean updateLease) {
        if (machineId == null) {
            machineId = MACHINE_ID;
        }
        if (instanceId == null) {
            instanceId = WORKING_DIR;
        }
        for (int i = 0; i < 10; ++i) {
            boolean success;
            ClusterNodeInfo clusterNode = ClusterNodeInfo.createInstance(store, machineId, instanceId);
            UpdateOp update = new UpdateOp("" + clusterNode.id, true);
            update.set("_id", String.valueOf(clusterNode.id));
            update.set(MACHINE_ID_KEY, clusterNode.machineId);
            update.set(INSTANCE_ID_KEY, clusterNode.instanceId);
            if (updateLease) {
                update.set(LEASE_END_KEY, ClusterNodeInfo.getCurrentTime() + clusterNode.leaseTime);
            } else {
                update.set(LEASE_END_KEY, clusterNode.leaseEndTime);
            }
            update.set(INFO_KEY, clusterNode.toString());
            update.set(STATE, clusterNode.state.name());
            update.set(REV_RECOVERY_LOCK, clusterNode.revRecoveryLock.name());
            if (clusterNode.newEntry) {
                success = store.create(Collection.CLUSTER_NODES, Collections.singletonList(update));
            } else {
                store.createOrUpdate(Collection.CLUSTER_NODES, update);
                success = true;
            }
            if (!success) continue;
            return clusterNode;
        }
        throw new DocumentStoreException("Could not get cluster node info");
    }

    private static ClusterNodeInfo createInstance(DocumentStore store, String machineId, String instanceId) {
        long now = ClusterNodeInfo.getCurrentTime();
        List<ClusterNodeInfoDocument> list = ClusterNodeInfoDocument.all(store);
        int clusterNodeId = 0;
        int maxId = 0;
        ClusterNodeState state = ClusterNodeState.NONE;
        Long prevLeaseEnd = null;
        boolean newEntry = false;
        for (Document document : list) {
            int id;
            String key = document.getId();
            try {
                id = Integer.parseInt(key);
            }
            catch (Exception e) {
                continue;
            }
            maxId = Math.max(maxId, id);
            Long leaseEnd = (Long)document.get(LEASE_END_KEY);
            if (leaseEnd != null && leaseEnd > now) continue;
            String mId = "" + document.get(MACHINE_ID_KEY);
            String iId = "" + document.get(INSTANCE_ID_KEY);
            if (machineId.startsWith(RANDOM_PREFIX)) {
                store.remove(Collection.CLUSTER_NODES, key);
                continue;
            }
            if (!mId.equals(machineId) || !iId.equals(instanceId) || clusterNodeId != 0 && id >= clusterNodeId) continue;
            clusterNodeId = id;
            state = ClusterNodeState.fromString((String)document.get(STATE));
            prevLeaseEnd = leaseEnd;
        }
        if (clusterNodeId == 0) {
            clusterNodeId = maxId + 1;
            newEntry = true;
        }
        return new ClusterNodeInfo(clusterNodeId, store, machineId, instanceId, state, RecoverLockState.NONE, prevLeaseEnd, newEntry);
    }

    public boolean renewLease() {
        long now = ClusterNodeInfo.getCurrentTime();
        if (now + this.leaseTime / 2L < this.leaseEndTime) {
            return false;
        }
        UpdateOp update = new UpdateOp("" + this.id, true);
        this.leaseEndTime = now + this.leaseTime;
        update.set(LEASE_END_KEY, this.leaseEndTime);
        update.set(STATE, ClusterNodeState.ACTIVE.name());
        ClusterNodeInfoDocument doc = this.store.createOrUpdate(Collection.CLUSTER_NODES, update);
        String mode = (String)doc.get(READ_WRITE_MODE_KEY);
        if (mode != null && !mode.equals(this.readWriteMode)) {
            this.readWriteMode = mode;
            this.store.setReadWriteMode(mode);
        }
        return true;
    }

    public void setLeaseTime(long leaseTime) {
        this.leaseTime = leaseTime;
    }

    public long getLeaseTime() {
        return this.leaseTime;
    }

    public void dispose() {
        UpdateOp update = new UpdateOp("" + this.id, true);
        update.set(LEASE_END_KEY, null);
        update.set(STATE, null);
        update.set(REV_RECOVERY_LOCK, null);
        this.store.createOrUpdate(Collection.CLUSTER_NODES, update);
    }

    public String toString() {
        return "id: " + this.id + ",\n" + "startTime: " + this.startTime + ",\n" + "machineId: " + this.machineId + ",\n" + "instanceId: " + this.instanceId + ",\n" + "pid: " + PROCESS_ID + ",\n" + "uuid: " + this.uuid + ",\n" + "readWriteMode: " + this.readWriteMode + ",\n" + "state: " + (Object)((Object)this.state) + ",\n" + "revLock: " + (Object)((Object)this.revRecoveryLock);
    }

    static void setClock(Clock c) {
        Preconditions.checkNotNull((Object)c);
        clock = c;
    }

    static void resetClockToDefault() {
        clock = Clock.SIMPLE;
    }

    private static long getProcessId() {
        try {
            String name = ManagementFactory.getRuntimeMXBean().getName();
            return Long.parseLong(name.substring(0, name.indexOf(64)));
        }
        catch (Exception e) {
            LOG.warn("Could not get process id", (Throwable)e);
            return 0L;
        }
    }

    private static String getMachineId() {
        Exception exception = null;
        try {
            ArrayList<String> list = new ArrayList<String>();
            Enumeration<NetworkInterface> e = NetworkInterface.getNetworkInterfaces();
            while (e.hasMoreElements()) {
                NetworkInterface ni = e.nextElement();
                try {
                    byte[] mac = ni.getHardwareAddress();
                    if (mac == null) continue;
                    String x = StringUtils.convertBytesToHex(mac);
                    list.add(x);
                }
                catch (Exception e2) {
                    exception = e2;
                }
            }
            if (list.size() > 0) {
                Collections.sort(list);
                return "mac:" + (String)list.get(0);
            }
        }
        catch (Exception e) {
            exception = e;
        }
        if (exception != null) {
            LOG.warn("Error getting the machine id; using a UUID", (Throwable)exception);
        }
        return RANDOM_PREFIX + UUID.randomUUID().toString();
    }

    private static long getCurrentTime() {
        return clock.getTime();
    }

    public static enum RecoverLockState {
        NONE,
        ACQUIRED;


        static RecoverLockState fromString(String state) {
            if (state == null) {
                return NONE;
            }
            return RecoverLockState.valueOf(state);
        }
    }

    public static enum ClusterNodeState {
        NONE,
        ACTIVE;


        static ClusterNodeState fromString(String state) {
            if (state == null) {
                return NONE;
            }
            return ClusterNodeState.valueOf(state);
        }
    }
}

