/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document;

import com.google.common.base.Preconditions;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.Weigher;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.MoreExecutors;
import com.mongodb.DB;
import java.io.InputStream;
import java.util.HashSet;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.sql.DataSource;
import org.apache.jackrabbit.mk.api.MicroKernel;
import org.apache.jackrabbit.mk.api.MicroKernelException;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.cache.CacheLIRS;
import org.apache.jackrabbit.oak.cache.CacheValue;
import org.apache.jackrabbit.oak.cache.EmpiricalWeigher;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.commons.json.JsopReader;
import org.apache.jackrabbit.oak.commons.json.JsopStream;
import org.apache.jackrabbit.oak.commons.json.JsopTokenizer;
import org.apache.jackrabbit.oak.plugins.document.ClusterNodeInfo;
import org.apache.jackrabbit.oak.plugins.document.Commit;
import org.apache.jackrabbit.oak.plugins.document.DiffCache;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeState;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeStore;
import org.apache.jackrabbit.oak.plugins.document.DocumentStore;
import org.apache.jackrabbit.oak.plugins.document.DocumentStoreException;
import org.apache.jackrabbit.oak.plugins.document.LocalDiffCache;
import org.apache.jackrabbit.oak.plugins.document.MemoryDiffCache;
import org.apache.jackrabbit.oak.plugins.document.NodeDocument;
import org.apache.jackrabbit.oak.plugins.document.PathRev;
import org.apache.jackrabbit.oak.plugins.document.Revision;
import org.apache.jackrabbit.oak.plugins.document.VersionGCSupport;
import org.apache.jackrabbit.oak.plugins.document.memory.MemoryDocumentStore;
import org.apache.jackrabbit.oak.plugins.document.mongo.MongoBlobStore;
import org.apache.jackrabbit.oak.plugins.document.mongo.MongoDiffCache;
import org.apache.jackrabbit.oak.plugins.document.mongo.MongoDocumentStore;
import org.apache.jackrabbit.oak.plugins.document.mongo.MongoVersionGCSupport;
import org.apache.jackrabbit.oak.plugins.document.persistentCache.CacheType;
import org.apache.jackrabbit.oak.plugins.document.persistentCache.PersistentCache;
import org.apache.jackrabbit.oak.plugins.document.rdb.RDBBlobStore;
import org.apache.jackrabbit.oak.plugins.document.rdb.RDBDocumentStore;
import org.apache.jackrabbit.oak.plugins.document.rdb.RDBOptions;
import org.apache.jackrabbit.oak.plugins.document.util.StringValue;
import org.apache.jackrabbit.oak.spi.blob.BlobStore;
import org.apache.jackrabbit.oak.spi.blob.GarbageCollectableBlobStore;
import org.apache.jackrabbit.oak.spi.blob.MemoryBlobStore;
import org.apache.jackrabbit.oak.stats.Clock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocumentMK
implements MicroKernel {
    static final Logger LOG = LoggerFactory.getLogger(DocumentMK.class);
    static final String DEFAULT_PERSISTENT_CACHE_URI = System.getProperty("oak.documentMK.persCache");
    static final int MANY_CHILDREN_THRESHOLD = Integer.getInteger("oak.documentMK.manyChildren", 50);
    static final boolean LIRS_CACHE = Boolean.parseBoolean(System.getProperty("oak.documentMK.lirsCache", "false"));
    static final boolean FAST_DIFF = Boolean.parseBoolean(System.getProperty("oak.documentMK.fastDiff", "true"));
    static final int CACHE_CONCURRENCY = Integer.getInteger("oak.documentMK.cacheConcurrency", 16);
    protected final DocumentNodeStore nodeStore;
    protected final DocumentStore store;

    DocumentMK(Builder builder) {
        this.nodeStore = builder.getNodeStore();
        this.store = this.nodeStore.getDocumentStore();
    }

    public void dispose() {
        this.nodeStore.dispose();
    }

    void backgroundRead() {
        this.nodeStore.backgroundRead(true);
    }

    void backgroundWrite() {
        this.nodeStore.backgroundWrite();
    }

    void runBackgroundOperations() {
        this.nodeStore.runBackgroundOperations();
    }

    public DocumentNodeStore getNodeStore() {
        return this.nodeStore;
    }

    ClusterNodeInfo getClusterInfo() {
        return this.nodeStore.getClusterInfo();
    }

    int getPendingWriteCount() {
        return this.nodeStore.getPendingWriteCount();
    }

    @Override
    public String getHeadRevision() throws MicroKernelException {
        return this.nodeStore.getHeadRevision().toString();
    }

    @Override
    @Nonnull
    public String checkpoint(long lifetime) throws MicroKernelException {
        try {
            return this.nodeStore.checkpoint(lifetime);
        }
        catch (DocumentStoreException e) {
            throw new MicroKernelException(e);
        }
    }

    @Override
    public String getRevisionHistory(long since, int maxEntries, String path) throws MicroKernelException {
        throw new MicroKernelException("Not implemented");
    }

    @Override
    public String waitForCommit(String oldHeadRevisionId, long timeout) throws MicroKernelException, InterruptedException {
        throw new MicroKernelException("Not implemented");
    }

    @Override
    public String getJournal(String fromRevisionId, String toRevisionId, String path) throws MicroKernelException {
        throw new MicroKernelException("Not implemented");
    }

    @Override
    public String diff(String fromRevisionId, String toRevisionId, String path, int depth) throws MicroKernelException {
        if (depth != 0) {
            throw new MicroKernelException("Only depth 0 is supported, depth is " + depth);
        }
        if (path == null || path.equals("")) {
            path = "/";
        }
        try {
            return this.nodeStore.diff(fromRevisionId, toRevisionId, path);
        }
        catch (DocumentStoreException e) {
            throw new MicroKernelException(e);
        }
    }

    @Override
    public boolean nodeExists(String path, String revisionId) throws MicroKernelException {
        DocumentNodeState n;
        if (!PathUtils.isAbsolute(path)) {
            throw new MicroKernelException("Path is not absolute: " + path);
        }
        revisionId = revisionId != null ? revisionId : this.nodeStore.getHeadRevision().toString();
        Revision rev = Revision.fromString(revisionId);
        try {
            n = this.nodeStore.getNode(path, rev);
        }
        catch (DocumentStoreException e) {
            throw new MicroKernelException(e);
        }
        return n != null;
    }

    @Override
    public long getChildNodeCount(String path, String revisionId) throws MicroKernelException {
        throw new MicroKernelException("Not implemented");
    }

    @Override
    public String getNodes(String path, String revisionId, int depth, long offset, int maxChildNodes, String filter) throws MicroKernelException {
        if (depth != 0) {
            throw new MicroKernelException("Only depth 0 is supported, depth is " + depth);
        }
        revisionId = revisionId != null ? revisionId : this.nodeStore.getHeadRevision().toString();
        Revision rev = Revision.fromString(revisionId);
        try {
            int max;
            DocumentNodeState n = this.nodeStore.getNode(path, rev);
            if (n == null) {
                return null;
            }
            JsopStream json = new JsopStream();
            boolean includeId = filter != null && filter.contains(":id");
            boolean bl = filter != null && filter.contains(":hash");
            json.object();
            n.append(json, includeId |= bl);
            if (maxChildNodes == -1) {
                max = Integer.MAX_VALUE;
                maxChildNodes = Integer.MAX_VALUE;
            } else {
                long m = (long)maxChildNodes + offset;
                max = (int)Math.min(m, Integer.MAX_VALUE);
            }
            DocumentNodeState.Children c = this.nodeStore.getChildren(n, null, max);
            for (long i = offset; i < (long)c.children.size() && maxChildNodes-- > 0; ++i) {
                String name = c.children.get((int)i);
                json.key(name).object().endObject();
            }
            if (c.hasMore) {
                json.key(":childNodeCount").value(Long.MAX_VALUE);
            } else {
                json.key(":childNodeCount").value(c.children.size());
            }
            json.endObject();
            return json.toString();
        }
        catch (DocumentStoreException e) {
            throw new MicroKernelException(e);
        }
    }

    @Override
    public String commit(String rootPath, String jsonDiff, String baseRevId, String message) throws MicroKernelException {
        Revision rev;
        boolean success = false;
        boolean isBranch = false;
        Commit commit = this.nodeStore.newCommit(baseRevId != null ? Revision.fromString(baseRevId) : null, null);
        try {
            Revision baseRev = commit.getBaseRevision();
            isBranch = baseRev != null && baseRev.isBranch();
            this.parseJsonDiff(commit, jsonDiff, rootPath);
            rev = commit.apply();
            success = true;
        }
        catch (DocumentStoreException e) {
            throw new MicroKernelException(e);
        }
        finally {
            if (!success) {
                this.nodeStore.canceled(commit);
            } else {
                this.nodeStore.done(commit, isBranch, null);
            }
        }
        return rev.toString();
    }

    @Override
    public String branch(@Nullable String trunkRevisionId) throws MicroKernelException {
        Revision revision = trunkRevisionId != null ? Revision.fromString(trunkRevisionId) : this.nodeStore.getHeadRevision();
        return revision.asBranchRevision().toString();
    }

    @Override
    public String merge(String branchRevisionId, String message) throws MicroKernelException {
        Revision revision = Revision.fromString(branchRevisionId);
        if (!revision.isBranch()) {
            throw new MicroKernelException("Not a branch: " + branchRevisionId);
        }
        try {
            return this.nodeStore.merge(revision, null).toString();
        }
        catch (DocumentStoreException e) {
            throw new MicroKernelException(e);
        }
        catch (CommitFailedException e) {
            throw new MicroKernelException(e);
        }
    }

    @Override
    @Nonnull
    public String rebase(@Nonnull String branchRevisionId, @Nullable String newBaseRevisionId) throws MicroKernelException {
        Revision r = Revision.fromString(branchRevisionId);
        Revision base = newBaseRevisionId != null ? Revision.fromString(newBaseRevisionId) : this.nodeStore.getHeadRevision();
        return this.nodeStore.rebase(r, base).toString();
    }

    @Override
    @Nonnull
    public String reset(@Nonnull String branchRevisionId, @Nonnull String ancestorRevisionId) throws MicroKernelException {
        Revision branch = Revision.fromString(branchRevisionId);
        if (!branch.isBranch()) {
            throw new MicroKernelException("Not a branch revision: " + branchRevisionId);
        }
        Revision ancestor = Revision.fromString(ancestorRevisionId);
        if (!ancestor.isBranch()) {
            throw new MicroKernelException("Not a branch revision: " + ancestorRevisionId);
        }
        try {
            return this.nodeStore.reset(branch, ancestor, null).toString();
        }
        catch (DocumentStoreException e) {
            throw new MicroKernelException(e);
        }
    }

    @Override
    public long getLength(String blobId) throws MicroKernelException {
        try {
            return this.nodeStore.getBlobStore().getBlobLength(blobId);
        }
        catch (Exception e) {
            throw new MicroKernelException(e);
        }
    }

    @Override
    public int read(String blobId, long pos, byte[] buff, int off, int length) throws MicroKernelException {
        try {
            int read = this.nodeStore.getBlobStore().readBlob(blobId, pos, buff, off, length);
            return read < 0 ? 0 : read;
        }
        catch (Exception e) {
            throw new MicroKernelException(e);
        }
    }

    @Override
    public String write(InputStream in) throws MicroKernelException {
        try {
            return this.nodeStore.getBlobStore().writeBlob(in);
        }
        catch (Exception e) {
            throw new MicroKernelException(e);
        }
    }

    public DocumentStore getDocumentStore() {
        return this.store;
    }

    private void parseJsonDiff(Commit commit, String json, String rootPath) {
        int r;
        Revision baseRev = commit.getBaseRevision();
        String baseRevId = baseRev != null ? baseRev.toString() : null;
        HashSet added = Sets.newHashSet();
        JsopTokenizer t = new JsopTokenizer(json);
        block7: while ((r = t.read()) != 0) {
            String path = PathUtils.concat(rootPath, t.readString());
            switch (r) {
                case 43: {
                    t.read(58);
                    t.read(123);
                    this.parseAddNode(commit, t, path);
                    added.add(path);
                    continue block7;
                }
                case 45: {
                    DocumentNodeState toRemove = this.nodeStore.getNode(path, commit.getBaseRevision());
                    if (toRemove == null) {
                        throw new MicroKernelException("Node not found: " + path + " in revision " + baseRevId);
                    }
                    commit.removeNode(path);
                    this.nodeStore.markAsDeleted(toRemove, commit, true);
                    commit.removeNodeDiff(path);
                    continue block7;
                }
                case 94: {
                    t.read(58);
                    String value = t.matches(5) ? null : t.readRawValue().trim();
                    String p = PathUtils.getParentPath(path);
                    if (!added.contains(p) && this.nodeStore.getNode(p, commit.getBaseRevision()) == null) {
                        throw new DocumentStoreException("Node not found: " + path + " in revision " + baseRevId);
                    }
                    String propertyName = PathUtils.getName(path);
                    commit.updateProperty(p, propertyName, value);
                    commit.updatePropertyDiff(p, propertyName, value);
                    continue block7;
                }
                case 62: {
                    DocumentNodeState source;
                    t.read(58);
                    String targetPath = t.readString();
                    if (!PathUtils.isAbsolute(targetPath)) {
                        targetPath = PathUtils.concat(rootPath, targetPath);
                    }
                    if ((source = this.nodeStore.getNode(path, baseRev)) == null) {
                        throw new MicroKernelException("Node not found: " + path + " in revision " + baseRevId);
                    }
                    if (this.nodeExists(targetPath, baseRevId)) {
                        throw new MicroKernelException("Node already exists: " + targetPath + " in revision " + baseRevId);
                    }
                    commit.moveNode(path, targetPath);
                    this.nodeStore.moveNode(source, targetPath, commit);
                    continue block7;
                }
                case 42: {
                    DocumentNodeState source;
                    t.read(58);
                    String targetPath = t.readString();
                    if (!PathUtils.isAbsolute(targetPath)) {
                        targetPath = PathUtils.concat(rootPath, targetPath);
                    }
                    if ((source = this.nodeStore.getNode(path, baseRev)) == null) {
                        throw new MicroKernelException("Node not found: " + path + " in revision " + baseRevId);
                    }
                    if (this.nodeExists(targetPath, baseRevId)) {
                        throw new MicroKernelException("Node already exists: " + targetPath + " in revision " + baseRevId);
                    }
                    commit.copyNode(path, targetPath);
                    this.nodeStore.copyNode(source, targetPath, commit);
                    continue block7;
                }
            }
            throw new MicroKernelException("token: " + (char)t.getTokenType());
        }
    }

    private void parseAddNode(Commit commit, JsopReader t, String path) {
        DocumentNodeState n = new DocumentNodeState(this.nodeStore, path, commit.getRevision());
        if (!t.matches(125)) {
            do {
                String key = t.readString();
                t.read(58);
                if (t.matches(123)) {
                    String childPath = PathUtils.concat(path, key);
                    this.parseAddNode(commit, t, childPath);
                    continue;
                }
                String value = t.readRawValue().trim();
                n.setProperty(key, value);
            } while (t.matches(44));
            t.read(125);
        }
        commit.addNode(n);
        commit.addNodeDiff(n);
    }

    public static class Builder {
        private static final long DEFAULT_MEMORY_CACHE_SIZE = 0x10000000L;
        public static final int DEFAULT_NODE_CACHE_PERCENTAGE = 25;
        public static final int DEFAULT_CHILDREN_CACHE_PERCENTAGE = 10;
        public static final int DEFAULT_DIFF_CACHE_PERCENTAGE = 5;
        public static final int DEFAULT_DOC_CHILDREN_CACHE_PERCENTAGE = 3;
        private DocumentNodeStore nodeStore;
        private DocumentStore documentStore;
        private DiffCache diffCache;
        private LocalDiffCache localDiffCache;
        private BlobStore blobStore;
        private int clusterId = Integer.getInteger("oak.documentMK.clusterId", 0);
        private int asyncDelay = 1000;
        private boolean timing;
        private boolean logging;
        private boolean disableLocalDiffCache = Boolean.getBoolean("oak.documentMK.disableLocalDiffCache");
        private Weigher<CacheValue, CacheValue> weigher = new EmpiricalWeigher();
        private long memoryCacheSize = 0x10000000L;
        private int nodeCachePercentage = 25;
        private int childrenCachePercentage = 10;
        private int diffCachePercentage = 5;
        private int docChildrenCachePercentage = 3;
        private boolean useSimpleRevision;
        private long splitDocumentAgeMillis = 300000L;
        private long offHeapCacheSize = -1L;
        private long maxReplicationLagMillis = TimeUnit.HOURS.toMillis(6L);
        private boolean disableBranches;
        private Clock clock = Clock.SIMPLE;
        private Executor executor;
        private String persistentCacheURI = DEFAULT_PERSISTENT_CACHE_URI;
        private PersistentCache persistentCache;

        public Builder setMongoDB(DB db, int changesSizeMB, int blobCacheSizeMB) {
            if (db != null) {
                if (this.documentStore == null) {
                    this.documentStore = new MongoDocumentStore(db, this);
                }
                if (this.blobStore == null) {
                    GarbageCollectableBlobStore s = new MongoBlobStore(db, (long)(blobCacheSizeMB * 1024) * 1024L);
                    PersistentCache p = this.getPersistentCache();
                    if (p != null) {
                        s = p.wrapBlobStore(s);
                    }
                    this.blobStore = s;
                }
                if (this.diffCache == null) {
                    this.diffCache = new MongoDiffCache(db, changesSizeMB, this);
                }
            }
            return this;
        }

        public Builder setMongoDB(DB db) {
            return this.setMongoDB(db, 8, 16);
        }

        public Builder setRDBConnection(DataSource ds) {
            this.documentStore = new RDBDocumentStore(ds, this);
            if (this.blobStore == null) {
                this.blobStore = new RDBBlobStore(ds);
            }
            return this;
        }

        public Builder setRDBConnection(DataSource ds, RDBOptions options) {
            this.documentStore = new RDBDocumentStore(ds, this, options);
            if (this.blobStore == null) {
                this.blobStore = new RDBBlobStore(ds, options);
            }
            return this;
        }

        public Builder setPersistentCache(String persistentCache) {
            this.persistentCacheURI = persistentCache;
            return this;
        }

        public Builder setRDBConnection(DataSource documentStoreDataSource, DataSource blobStoreDataSource) {
            this.documentStore = new RDBDocumentStore(documentStoreDataSource, this);
            this.blobStore = new RDBBlobStore(blobStoreDataSource);
            return this;
        }

        public Builder setTiming(boolean timing) {
            this.timing = timing;
            return this;
        }

        public boolean getTiming() {
            return this.timing;
        }

        public Builder setLogging(boolean logging) {
            this.logging = logging;
            return this;
        }

        public boolean getLogging() {
            return this.logging;
        }

        public Builder setDocumentStore(DocumentStore documentStore) {
            this.documentStore = documentStore;
            return this;
        }

        public DocumentStore getDocumentStore() {
            if (this.documentStore == null) {
                this.documentStore = new MemoryDocumentStore();
            }
            return this.documentStore;
        }

        public DocumentNodeStore getNodeStore() {
            if (this.nodeStore == null) {
                this.nodeStore = new DocumentNodeStore(this);
            }
            return this.nodeStore;
        }

        public DiffCache getDiffCache() {
            if (this.diffCache == null) {
                this.diffCache = new MemoryDiffCache(this);
            }
            return this.diffCache;
        }

        public LocalDiffCache getLocalDiffCache() {
            if (this.localDiffCache == null && !this.disableLocalDiffCache) {
                this.localDiffCache = new LocalDiffCache(this);
            }
            return this.localDiffCache;
        }

        public Builder setDisableLocalDiffCache(boolean disableLocalDiffCache) {
            this.disableLocalDiffCache = disableLocalDiffCache;
            return this;
        }

        public Builder setDiffCache(DiffCache diffCache) {
            this.diffCache = diffCache;
            return this;
        }

        public Builder setBlobStore(BlobStore blobStore) {
            this.blobStore = blobStore;
            return this;
        }

        public BlobStore getBlobStore() {
            if (this.blobStore == null) {
                this.blobStore = new MemoryBlobStore();
            }
            return this.blobStore;
        }

        public Builder setClusterId(int clusterId) {
            this.clusterId = clusterId;
            return this;
        }

        public int getClusterId() {
            return this.clusterId;
        }

        public Builder setAsyncDelay(int asyncDelay) {
            this.asyncDelay = asyncDelay;
            return this;
        }

        public int getAsyncDelay() {
            return this.asyncDelay;
        }

        public Weigher<CacheValue, CacheValue> getWeigher() {
            return this.weigher;
        }

        public Builder withWeigher(Weigher<CacheValue, CacheValue> weigher) {
            this.weigher = weigher;
            return this;
        }

        public Builder memoryCacheSize(long memoryCacheSize) {
            this.memoryCacheSize = memoryCacheSize;
            return this;
        }

        public Builder memoryCacheDistribution(int nodeCachePercentage, int childrenCachePercentage, int docChildrenCachePercentage, int diffCachePercentage) {
            Preconditions.checkArgument((nodeCachePercentage >= 0 ? 1 : 0) != 0);
            Preconditions.checkArgument((childrenCachePercentage >= 0 ? 1 : 0) != 0);
            Preconditions.checkArgument((docChildrenCachePercentage >= 0 ? 1 : 0) != 0);
            Preconditions.checkArgument((diffCachePercentage >= 0 ? 1 : 0) != 0);
            Preconditions.checkArgument((nodeCachePercentage + childrenCachePercentage + docChildrenCachePercentage + diffCachePercentage < 100 ? 1 : 0) != 0);
            this.nodeCachePercentage = nodeCachePercentage;
            this.childrenCachePercentage = childrenCachePercentage;
            this.docChildrenCachePercentage = docChildrenCachePercentage;
            this.diffCachePercentage = diffCachePercentage;
            return this;
        }

        public long getNodeCacheSize() {
            return this.memoryCacheSize * (long)this.nodeCachePercentage / 100L;
        }

        public long getChildrenCacheSize() {
            return this.memoryCacheSize * (long)this.childrenCachePercentage / 100L;
        }

        public long getDocumentCacheSize() {
            return this.memoryCacheSize - this.getNodeCacheSize() - this.getChildrenCacheSize() - this.getDiffCacheSize() - this.getDocChildrenCacheSize();
        }

        public long getDocChildrenCacheSize() {
            return this.memoryCacheSize * (long)this.docChildrenCachePercentage / 100L;
        }

        public long getDiffCacheSize() {
            return this.memoryCacheSize * (long)this.diffCachePercentage / 100L;
        }

        public Builder setUseSimpleRevision(boolean useSimpleRevision) {
            this.useSimpleRevision = useSimpleRevision;
            return this;
        }

        public boolean isUseSimpleRevision() {
            return this.useSimpleRevision;
        }

        public Builder setSplitDocumentAgeMillis(long splitDocumentAgeMillis) {
            this.splitDocumentAgeMillis = splitDocumentAgeMillis;
            return this;
        }

        public long getSplitDocumentAgeMillis() {
            return this.splitDocumentAgeMillis;
        }

        public boolean useOffHeapCache() {
            return this.offHeapCacheSize > 0L;
        }

        public long getOffHeapCacheSize() {
            return this.offHeapCacheSize;
        }

        public Builder offHeapCacheSize(long offHeapCacheSize) {
            this.offHeapCacheSize = offHeapCacheSize;
            return this;
        }

        public Executor getExecutor() {
            if (this.executor == null) {
                return MoreExecutors.sameThreadExecutor();
            }
            return this.executor;
        }

        public Builder setExecutor(Executor executor) {
            this.executor = executor;
            return this;
        }

        public Builder clock(Clock clock) {
            this.clock = clock;
            return this;
        }

        public Clock getClock() {
            return this.clock;
        }

        public Builder setMaxReplicationLag(long duration, TimeUnit unit) {
            this.maxReplicationLagMillis = unit.toMillis(duration);
            return this;
        }

        public long getMaxReplicationLagMillis() {
            return this.maxReplicationLagMillis;
        }

        public Builder disableBranches() {
            this.disableBranches = true;
            return this;
        }

        public boolean isDisableBranches() {
            return this.disableBranches;
        }

        VersionGCSupport createVersionGCSupport() {
            DocumentStore store = this.getDocumentStore();
            if (store instanceof MongoDocumentStore) {
                return new MongoVersionGCSupport((MongoDocumentStore)store);
            }
            return new VersionGCSupport(store);
        }

        public DocumentMK open() {
            return new DocumentMK(this);
        }

        public Cache<PathRev, DocumentNodeState> buildNodeCache(DocumentNodeStore store) {
            return this.buildCache(CacheType.NODE, this.getNodeCacheSize(), store, null);
        }

        public Cache<PathRev, DocumentNodeState.Children> buildChildrenCache() {
            return this.buildCache(CacheType.CHILDREN, this.getChildrenCacheSize(), null, null);
        }

        public Cache<StringValue, NodeDocument.Children> buildDocChildrenCache() {
            return this.buildCache(CacheType.DOC_CHILDREN, this.getDocChildrenCacheSize(), null, null);
        }

        public Cache<PathRev, StringValue> buildDiffCache() {
            return this.buildCache(CacheType.DIFF, this.getDiffCacheSize(), null, null);
        }

        public Cache<StringValue, LocalDiffCache.ConsolidatedDiff> buildConsolidatedDiffCache() {
            return this.buildCache(CacheType.CONSOLIDATED_DIFF, this.getDiffCacheSize(), null, null);
        }

        public Cache<CacheValue, NodeDocument> buildDocumentCache(DocumentStore docStore) {
            return this.buildCache(CacheType.DOCUMENT, this.getDocumentCacheSize(), null, docStore);
        }

        private <K extends CacheValue, V extends CacheValue> Cache<K, V> buildCache(CacheType cacheType, long maxWeight, DocumentNodeStore docNodeStore, DocumentStore docStore) {
            Cache<K, V> cache = this.buildCache(maxWeight);
            PersistentCache p = this.getPersistentCache();
            if (p != null) {
                if (docNodeStore != null) {
                    docNodeStore.setPersistentCache(p);
                }
                cache = p.wrap(docNodeStore, docStore, cache, cacheType);
            }
            return cache;
        }

        private PersistentCache getPersistentCache() {
            if (this.persistentCacheURI == null) {
                return null;
            }
            if (this.persistentCache == null) {
                try {
                    this.persistentCache = new PersistentCache(this.persistentCacheURI);
                }
                catch (Throwable e) {
                    LOG.warn("Persistent cache not available; please disable the configuration", e);
                    throw new IllegalArgumentException(e);
                }
            }
            return this.persistentCache;
        }

        private <K extends CacheValue, V extends CacheValue> Cache<K, V> buildCache(long maxWeight) {
            if (LIRS_CACHE || this.persistentCacheURI != null) {
                return CacheLIRS.newBuilder().weigher(this.weigher).averageWeight(2000).maximumWeight(maxWeight).recordStats().build();
            }
            return CacheBuilder.newBuilder().concurrencyLevel(CACHE_CONCURRENCY).weigher(this.weigher).maximumWeight(maxWeight).recordStats().build();
        }
    }
}

