/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.cache.Cache;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TimeZone;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.management.NotCompliantMBeanException;
import org.apache.jackrabbit.oak.api.Blob;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.cache.CacheStats;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.commons.jmx.AnnotatedStandardMBean;
import org.apache.jackrabbit.oak.commons.json.JsopStream;
import org.apache.jackrabbit.oak.commons.json.JsopTokenizer;
import org.apache.jackrabbit.oak.commons.json.JsopWriter;
import org.apache.jackrabbit.oak.json.BlobSerializer;
import org.apache.jackrabbit.oak.plugins.blob.BlobStoreBlob;
import org.apache.jackrabbit.oak.plugins.blob.MarkSweepGarbageCollector;
import org.apache.jackrabbit.oak.plugins.document.BackgroundWriteStats;
import org.apache.jackrabbit.oak.plugins.document.BatchCommitQueue;
import org.apache.jackrabbit.oak.plugins.document.BlobReferenceIterator;
import org.apache.jackrabbit.oak.plugins.document.Branch;
import org.apache.jackrabbit.oak.plugins.document.Checkpoints;
import org.apache.jackrabbit.oak.plugins.document.ClusterNodeInfo;
import org.apache.jackrabbit.oak.plugins.document.ClusterNodeInfoDocument;
import org.apache.jackrabbit.oak.plugins.document.Collection;
import org.apache.jackrabbit.oak.plugins.document.Commit;
import org.apache.jackrabbit.oak.plugins.document.CommitQueue;
import org.apache.jackrabbit.oak.plugins.document.DiffCache;
import org.apache.jackrabbit.oak.plugins.document.DocumentBlobReferenceRetriever;
import org.apache.jackrabbit.oak.plugins.document.DocumentMK;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeState;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeStoreBranch;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeStoreMBean;
import org.apache.jackrabbit.oak.plugins.document.DocumentRootBuilder;
import org.apache.jackrabbit.oak.plugins.document.DocumentStore;
import org.apache.jackrabbit.oak.plugins.document.DocumentStoreException;
import org.apache.jackrabbit.oak.plugins.document.LastRevRecoveryAgent;
import org.apache.jackrabbit.oak.plugins.document.LastRevTracker;
import org.apache.jackrabbit.oak.plugins.document.LocalDiffCache;
import org.apache.jackrabbit.oak.plugins.document.MergeCommit;
import org.apache.jackrabbit.oak.plugins.document.NodeDocument;
import org.apache.jackrabbit.oak.plugins.document.PathRev;
import org.apache.jackrabbit.oak.plugins.document.ResetDiff;
import org.apache.jackrabbit.oak.plugins.document.Revision;
import org.apache.jackrabbit.oak.plugins.document.RevisionContext;
import org.apache.jackrabbit.oak.plugins.document.UnmergedBranches;
import org.apache.jackrabbit.oak.plugins.document.UnsavedModifications;
import org.apache.jackrabbit.oak.plugins.document.UpdateOp;
import org.apache.jackrabbit.oak.plugins.document.VersionGarbageCollector;
import org.apache.jackrabbit.oak.plugins.document.cache.CacheInvalidationStats;
import org.apache.jackrabbit.oak.plugins.document.mongo.MongoBlobReferenceIterator;
import org.apache.jackrabbit.oak.plugins.document.mongo.MongoDocumentStore;
import org.apache.jackrabbit.oak.plugins.document.persistentCache.PersistentCache;
import org.apache.jackrabbit.oak.plugins.document.util.LoggingDocumentStoreWrapper;
import org.apache.jackrabbit.oak.plugins.document.util.StringValue;
import org.apache.jackrabbit.oak.plugins.document.util.TimingDocumentStoreWrapper;
import org.apache.jackrabbit.oak.plugins.document.util.Utils;
import org.apache.jackrabbit.oak.plugins.observation.ContentChangeInfo;
import org.apache.jackrabbit.oak.plugins.observation.ContentChangeInfoProvider;
import org.apache.jackrabbit.oak.spi.blob.BlobStore;
import org.apache.jackrabbit.oak.spi.blob.GarbageCollectableBlobStore;
import org.apache.jackrabbit.oak.spi.commit.ChangeDispatcher;
import org.apache.jackrabbit.oak.spi.commit.CommitHook;
import org.apache.jackrabbit.oak.spi.commit.CommitInfo;
import org.apache.jackrabbit.oak.spi.commit.Observable;
import org.apache.jackrabbit.oak.spi.commit.Observer;
import org.apache.jackrabbit.oak.spi.state.AbstractNodeState;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStateDiff;
import org.apache.jackrabbit.oak.spi.state.NodeStore;
import org.apache.jackrabbit.oak.stats.Clock;
import org.apache.jackrabbit.oak.util.PerfLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DocumentNodeStore
implements NodeStore,
RevisionContext,
Observable {
    private static final Logger LOG = LoggerFactory.getLogger(DocumentNodeStore.class);
    private static final PerfLogger PERFLOG = new PerfLogger(LoggerFactory.getLogger((String)(DocumentNodeStore.class.getName() + ".perf")));
    static final int NUM_CHILDREN_CACHE_LIMIT = Integer.getInteger("oak.documentMK.childrenCacheLimit", 16384);
    private static final int WARN_REVISION_AGE = Integer.getInteger("oak.documentMK.revisionAge", 60000);
    private boolean enableConcurrentAddRemove = Boolean.getBoolean("oak.enableConcurrentAddRemove");
    private boolean fairBackgroundOperationLock = Boolean.getBoolean("oak.fairBackgroundOperationLock");
    static final int REMEMBER_REVISION_ORDER_MILLIS = 3600000;
    protected final DocumentStore store;
    protected final DocumentNodeState missing;
    protected final CommitQueue commitQueue;
    protected final BatchCommitQueue batchCommitQueue;
    protected final ChangeDispatcher dispatcher;
    protected int asyncDelay = 1000;
    protected int maxBackOffMillis = this.asyncDelay * 2;
    private final AtomicBoolean isDisposed = new AtomicBoolean();
    private final ClusterNodeInfo clusterNodeInfo;
    private final int clusterId;
    private final ConcurrentMap<Integer, Long> inactiveClusterNodes = new ConcurrentHashMap<Integer, Long>();
    private final ConcurrentMap<Integer, Long> activeClusterNodes = new ConcurrentHashMap<Integer, Long>();
    private final Revision.RevisionComparator revisionComparator;
    private final UnmergedBranches branches;
    private final UnsavedModifications unsavedLastRevisions = new UnsavedModifications();
    private final Map<String, String> splitCandidates = Maps.newConcurrentMap();
    private final Map<Integer, Revision> lastKnownRevision = new ConcurrentHashMap<Integer, Revision>();
    private volatile Revision headRevision;
    private Thread backgroundReadThread;
    private Thread backgroundUpdateThread;
    private Thread leaseUpdateThread;
    private final ReadWriteLock backgroundOperationLock = new ReentrantReadWriteLock(this.fairBackgroundOperationLock);
    private final ReadWriteLock mergeLock = new ReentrantReadWriteLock();
    private AtomicInteger simpleRevisionCounter;
    private final Cache<PathRev, DocumentNodeState> nodeCache;
    private final CacheStats nodeCacheStats;
    private final Cache<PathRev, DocumentNodeState.Children> nodeChildrenCache;
    private final CacheStats nodeChildrenCacheStats;
    private final Cache<StringValue, NodeDocument.Children> docChildrenCache;
    private final CacheStats docChildrenCacheStats;
    private final DiffCache diffCache;
    private final LocalDiffCache localDiffCache;
    private final BlobStore blobStore;
    private final BlobSerializer blobSerializer = new BlobSerializer(){

        @Override
        public String serialize(Blob blob) {
            String id;
            if (blob instanceof BlobStoreBlob) {
                return ((BlobStoreBlob)blob).getBlobId();
            }
            String reference = blob.getReference();
            if (reference != null && (id = DocumentNodeStore.this.blobStore.getBlobId(reference)) != null) {
                return id;
            }
            try {
                id = DocumentNodeStore.this.createBlob(blob.getNewStream()).getBlobId();
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
            return id;
        }
    };
    private final Clock clock;
    private final Checkpoints checkpoints;
    private final VersionGarbageCollector versionGarbageCollector;
    private final Executor executor;
    private final LastRevRecoveryAgent lastRevRecoveryAgent;
    private final boolean disableBranches;
    private PersistentCache persistentCache;
    private final DocumentNodeStoreMBean mbean;

    public DocumentNodeStore(DocumentMK.Builder builder) {
        this.blobStore = builder.getBlobStore();
        if (builder.isUseSimpleRevision()) {
            this.simpleRevisionCounter = new AtomicInteger(0);
        }
        DocumentStore s = builder.getDocumentStore();
        if (builder.getTiming()) {
            s = new TimingDocumentStoreWrapper(s);
        }
        if (builder.getLogging()) {
            s = new LoggingDocumentStoreWrapper(s);
        }
        this.store = s;
        this.executor = builder.getExecutor();
        this.clock = builder.getClock();
        int cid = builder.getClusterId();
        if ((cid = Integer.getInteger("oak.documentMK.clusterId", cid).intValue()) == 0) {
            this.clusterNodeInfo = ClusterNodeInfo.getInstance(this.store);
            cid = this.clusterNodeInfo.getId();
        } else {
            this.clusterNodeInfo = null;
        }
        this.clusterId = cid;
        this.revisionComparator = new Revision.RevisionComparator(this.clusterId);
        this.branches = new UnmergedBranches(this.getRevisionComparator());
        this.asyncDelay = builder.getAsyncDelay();
        this.versionGarbageCollector = new VersionGarbageCollector(this, builder.createVersionGCSupport());
        this.lastRevRecoveryAgent = new LastRevRecoveryAgent(this);
        this.disableBranches = builder.isDisableBranches();
        this.missing = new DocumentNodeState(this, "MISSING", new Revision(0L, 0, 0)){

            @Override
            public int getMemory() {
                return 8;
            }
        };
        this.nodeCache = builder.buildNodeCache(this);
        this.nodeCacheStats = new CacheStats(this.nodeCache, "Document-NodeState", builder.getWeigher(), builder.getNodeCacheSize());
        this.nodeChildrenCache = builder.buildChildrenCache();
        this.nodeChildrenCacheStats = new CacheStats(this.nodeChildrenCache, "Document-NodeChildren", builder.getWeigher(), builder.getChildrenCacheSize());
        this.docChildrenCache = builder.buildDocChildrenCache();
        this.docChildrenCacheStats = new CacheStats(this.docChildrenCache, "Document-DocChildren", builder.getWeigher(), builder.getDocChildrenCacheSize());
        this.diffCache = builder.getDiffCache();
        this.localDiffCache = builder.getLocalDiffCache();
        this.checkpoints = new Checkpoints(this);
        if (this.store.find(Collection.NODES, Utils.getIdFromPath("/")) == null) {
            Revision head = this.newRevision();
            Commit commit = new Commit(this, head, null, null);
            DocumentNodeState n = new DocumentNodeState(this, "/", head);
            commit.addNode(n);
            commit.applyToDocumentStore();
            commit.applyToCache(new Revision(0L, 0, this.clusterId), false);
            this.setHeadRevision(commit.getRevision());
            this.backgroundWrite();
        } else {
            this.branches.init(this.store, this);
            this.backgroundRead(false);
            if (this.headRevision == null) {
                this.setHeadRevision(this.newRevision());
            }
        }
        this.getRevisionComparator().add(this.headRevision, Revision.newRevision(0));
        this.dispatcher = new ChangeDispatcher(this.getRoot());
        this.commitQueue = new CommitQueue(this, this.dispatcher);
        this.batchCommitQueue = new BatchCommitQueue(this.store, this.revisionComparator);
        this.backgroundReadThread = new Thread((Runnable)new BackgroundReadOperation(this, this.isDisposed), "DocumentNodeStore background read thread");
        this.backgroundReadThread.setDaemon(true);
        this.backgroundUpdateThread = new Thread((Runnable)new BackgroundOperation(this, this.isDisposed), "DocumentNodeStore background update thread");
        this.backgroundUpdateThread.setDaemon(true);
        this.checkLastRevRecovery();
        this.renewClusterIdLease();
        this.backgroundReadThread.start();
        this.backgroundUpdateThread.start();
        if (this.clusterNodeInfo != null) {
            this.leaseUpdateThread = new Thread((Runnable)new BackgroundLeaseUpdate(this, this.isDisposed), "DocumentNodeStore lease update thread");
            this.leaseUpdateThread.setDaemon(true);
            this.leaseUpdateThread.start();
        }
        this.mbean = this.createMBean();
        LOG.info("Initialized DocumentNodeStore with clusterNodeId: {}", (Object)this.clusterId);
    }

    private void checkLastRevRecovery() {
        this.lastRevRecoveryAgent.recover(this.clusterId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        if (this.isDisposed.getAndSet(true)) {
            return;
        }
        AtomicBoolean atomicBoolean = this.isDisposed;
        synchronized (atomicBoolean) {
            this.isDisposed.notifyAll();
        }
        try {
            this.backgroundReadThread.join();
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        try {
            this.backgroundUpdateThread.join();
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        this.internalRunBackgroundUpdateOperations();
        if (this.leaseUpdateThread != null) {
            try {
                this.leaseUpdateThread.join();
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        if (this.clusterNodeInfo != null) {
            this.clusterNodeInfo.dispose();
        }
        this.store.dispose();
        if (this.blobStore instanceof Closeable) {
            try {
                ((Closeable)((Object)this.blobStore)).close();
            }
            catch (IOException ex) {
                LOG.debug("Error closing blob store " + this.blobStore, (Throwable)ex);
            }
        }
        if (this.persistentCache != null) {
            this.persistentCache.close();
        }
        LOG.info("Disposed DocumentNodeStore with clusterNodeId: {}", (Object)this.clusterId);
    }

    Revision setHeadRevision(@Nonnull Revision newHead) {
        Preconditions.checkArgument((!newHead.isBranch() ? 1 : 0) != 0);
        Revision previous = this.headRevision;
        if (!((Revision)Preconditions.checkNotNull((Object)newHead)).equals(previous)) {
            this.headRevision = newHead;
        }
        return previous;
    }

    @Nonnull
    public DocumentStore getDocumentStore() {
        return this.store;
    }

    @Nonnull
    Revision newRevision() {
        if (this.simpleRevisionCounter != null) {
            return new Revision(this.simpleRevisionCounter.getAndIncrement(), 0, this.clusterId);
        }
        return Revision.newRevision(this.clusterId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    Commit newCommit(@Nullable Revision base, @Nullable DocumentNodeStoreBranch branch) {
        Commit c;
        if (base == null) {
            base = this.headRevision;
        }
        this.backgroundOperationLock.readLock().lock();
        boolean success = false;
        try {
            this.checkOpen();
            c = new Commit(this, this.commitQueue.createRevision(), base, branch);
            success = true;
        }
        finally {
            if (!success) {
                this.backgroundOperationLock.readLock().unlock();
            }
        }
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    MergeCommit newMergeCommit(@Nullable Revision base, int numBranchCommits) {
        MergeCommit c;
        if (base == null) {
            base = this.headRevision;
        }
        this.backgroundOperationLock.readLock().lock();
        boolean success = false;
        try {
            this.checkOpen();
            c = new MergeCommit(this, base, this.commitQueue.createRevisions(numBranchCommits));
            success = true;
        }
        finally {
            if (!success) {
                this.backgroundOperationLock.readLock().unlock();
            }
        }
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void done(@Nonnull Commit c, boolean isBranch, @Nullable CommitInfo info) {
        try {
            this.commitQueue.done(c, isBranch, info);
        }
        finally {
            this.backgroundOperationLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void canceled(Commit c) {
        try {
            this.commitQueue.canceled(c.getRevision());
        }
        finally {
            this.backgroundOperationLock.readLock().unlock();
        }
    }

    public void setAsyncDelay(int delay) {
        this.asyncDelay = delay;
    }

    public int getAsyncDelay() {
        return this.asyncDelay;
    }

    public void setMaxBackOffMillis(int time) {
        this.maxBackOffMillis = time;
    }

    public int getMaxBackOffMillis() {
        return this.maxBackOffMillis;
    }

    void setEnableConcurrentAddRemove(boolean b) {
        this.enableConcurrentAddRemove = b;
    }

    boolean getEnableConcurrentAddRemove() {
        return this.enableConcurrentAddRemove;
    }

    @CheckForNull
    public ClusterNodeInfo getClusterInfo() {
        return this.clusterNodeInfo;
    }

    public CacheStats getNodeCacheStats() {
        return this.nodeCacheStats;
    }

    public CacheStats getNodeChildrenCacheStats() {
        return this.nodeChildrenCacheStats;
    }

    public CacheStats getDocChildrenCacheStats() {
        return this.docChildrenCacheStats;
    }

    void invalidateDocChildrenCache() {
        this.docChildrenCache.invalidateAll();
    }

    void invalidateNodeChildrenCache() {
        this.nodeChildrenCache.invalidateAll();
    }

    void invalidateNodeCache(String path, Revision revision) {
        this.nodeCache.invalidate((Object)new PathRev(path, revision));
    }

    public int getPendingWriteCount() {
        return this.unsavedLastRevisions.getPaths().size();
    }

    public boolean isDisableBranches() {
        return this.disableBranches;
    }

    boolean isRevisionNewer(@Nonnull Revision x, @Nonnull Revision previous) {
        return this.getRevisionComparator().compare(x, previous) > 0;
    }

    void addSplitCandidate(String id) {
        this.splitCandidates.put(id, id);
    }

    void copyNode(DocumentNodeState source, String targetPath, Commit commit) {
        this.moveOrCopyNode(false, source, targetPath, commit);
    }

    void moveNode(DocumentNodeState source, String targetPath, Commit commit) {
        this.moveOrCopyNode(true, source, targetPath, commit);
    }

    void markAsDeleted(DocumentNodeState node, Commit commit, boolean subTreeAlso) {
        commit.removeNode(node.getPath());
        if (subTreeAlso) {
            for (DocumentNodeState child : this.getChildNodes(node, null, Integer.MAX_VALUE)) {
                this.markAsDeleted(child, commit, true);
            }
        }
    }

    @CheckForNull
    DocumentNodeState getNode(final @Nonnull String path, final @Nonnull Revision rev) {
        this.checkRevisionAge((Revision)Preconditions.checkNotNull((Object)rev), (String)Preconditions.checkNotNull((Object)path));
        long start = PERFLOG.start();
        try {
            PathRev key = new PathRev(path, rev);
            DocumentNodeState node = (DocumentNodeState)this.nodeCache.get((Object)key, (Callable)new Callable<DocumentNodeState>(){

                @Override
                public DocumentNodeState call() throws Exception {
                    boolean nodeDoesNotExist = DocumentNodeStore.this.checkNodeNotExistsFromChildrenCache(path, rev);
                    if (nodeDoesNotExist) {
                        return DocumentNodeStore.this.missing;
                    }
                    DocumentNodeState n = DocumentNodeStore.this.readNode(path, rev);
                    if (n == null) {
                        n = DocumentNodeStore.this.missing;
                    }
                    return n;
                }
            });
            DocumentNodeState result = node == this.missing || node.equals(this.missing) ? null : node;
            PERFLOG.end(start, 1L, "getNode: path={}, rev={}", (Object)path, (Object)rev);
            return result;
        }
        catch (UncheckedExecutionException e) {
            throw DocumentStoreException.convert(e.getCause());
        }
        catch (ExecutionException e) {
            throw DocumentStoreException.convert(e.getCause());
        }
    }

    DocumentNodeState.Children getChildren(final @Nonnull DocumentNodeState parent, final @Nullable String name, final int limit) throws DocumentStoreException {
        if (((DocumentNodeState)Preconditions.checkNotNull((Object)parent)).hasNoChildren()) {
            return DocumentNodeState.NO_CHILDREN;
        }
        String path = ((DocumentNodeState)Preconditions.checkNotNull((Object)parent)).getPath();
        Revision readRevision = parent.getLastRevision();
        try {
            PathRev key = DocumentNodeStore.childNodeCacheKey(path, readRevision, name);
            DocumentNodeState.Children children = (DocumentNodeState.Children)this.nodeChildrenCache.get((Object)key, (Callable)new Callable<DocumentNodeState.Children>(){

                @Override
                public DocumentNodeState.Children call() throws Exception {
                    return DocumentNodeStore.this.readChildren(parent, name, limit);
                }
            });
            if (children.children.size() < limit && children.hasMore) {
                children = this.readChildren(parent, name, limit);
                this.nodeChildrenCache.put((Object)key, (Object)children);
            }
            return children;
        }
        catch (UncheckedExecutionException e) {
            throw DocumentStoreException.convert(e.getCause(), "Error occurred while fetching children for path " + path);
        }
        catch (ExecutionException e) {
            throw DocumentStoreException.convert(e.getCause(), "Error occurred while fetching children for path " + path);
        }
    }

    DocumentNodeState.Children readChildren(DocumentNodeState parent, String name, int limit) {
        int numReturned;
        String queriedName = name;
        String path = parent.getPath();
        Revision rev = parent.getLastRevision();
        LOG.trace("Reading children for [{}] ast rev [{}]", (Object)path, (Object)rev);
        DocumentNodeState.Children c = new DocumentNodeState.Children();
        int rawLimit = (int)Math.min(Integer.MAX_VALUE, (long)limit + 1L);
        do {
            Iterable<NodeDocument> docs = this.readChildDocs(path, name, rawLimit);
            numReturned = 0;
            for (NodeDocument doc : docs) {
                ++numReturned;
                String p = doc.getPath();
                name = PathUtils.getName(p);
                DocumentNodeState child = this.getNode(p, rev);
                if (child == null) continue;
                if (c.children.size() < limit) {
                    c.children.add(Utils.unshareString(PathUtils.getName(p)));
                    continue;
                }
                c.hasMore = true;
                return c;
            }
        } while (numReturned >= rawLimit);
        c.hasMore = false;
        if (queriedName == null) {
            Collections.sort(c.children);
        }
        return c;
    }

    @Nonnull
    private Iterable<NodeDocument> readChildDocs(final @Nonnull String path, @Nullable String name, final int limit) {
        Iterable it;
        final String to = Utils.getKeyUpperLimit((String)Preconditions.checkNotNull((Object)path));
        String from = name != null ? Utils.getIdFromPath(PathUtils.concat(path, name)) : Utils.getKeyLowerLimit(path);
        if (name != null || limit > NUM_CHILDREN_CACHE_LIMIT) {
            return this.store.query(Collection.NODES, from, to, limit);
        }
        final StringValue key = new StringValue(path);
        NodeDocument.Children c = (NodeDocument.Children)this.docChildrenCache.getIfPresent((Object)key);
        if (c == null) {
            c = new NodeDocument.Children();
            List<NodeDocument> docs = this.store.query(Collection.NODES, from, to, limit);
            for (NodeDocument doc : docs) {
                String p = doc.getPath();
                c.childNames.add(PathUtils.getName(p));
            }
            c.isComplete = docs.size() < limit;
            this.docChildrenCache.put((Object)key, (Object)c);
            return docs;
        }
        if (c.childNames.size() < limit && !c.isComplete) {
            String lastName = c.childNames.get(c.childNames.size() - 1);
            String lastPath = PathUtils.concat(path, lastName);
            String low = Utils.getIdFromPath(lastPath);
            int remainingLimit = limit - c.childNames.size();
            List<NodeDocument> docs = this.store.query(Collection.NODES, low, to, remainingLimit);
            NodeDocument.Children clone = c.clone();
            for (NodeDocument doc : docs) {
                String p = doc.getPath();
                clone.childNames.add(PathUtils.getName(p));
            }
            clone.isComplete = docs.size() < remainingLimit;
            this.docChildrenCache.put((Object)key, (Object)clone);
            c = clone;
        }
        Iterable head = Iterables.filter((Iterable)Iterables.transform(c.childNames, (Function)new Function<String, NodeDocument>(){

            public NodeDocument apply(String name) {
                String p = PathUtils.concat(path, name);
                NodeDocument doc = DocumentNodeStore.this.store.find(Collection.NODES, Utils.getIdFromPath(p));
                if (doc == null) {
                    DocumentNodeStore.this.docChildrenCache.invalidate((Object)key);
                }
                return doc;
            }
        }), (Predicate)Predicates.notNull());
        if (c.isComplete) {
            it = head;
        } else {
            final String last = Utils.getIdFromPath(PathUtils.concat(path, c.childNames.get(c.childNames.size() - 1)));
            Iterable<NodeDocument> tail = new Iterable<NodeDocument>(){

                @Override
                public Iterator<NodeDocument> iterator() {
                    return DocumentNodeStore.this.store.query(Collection.NODES, last, to, limit).iterator();
                }
            };
            it = Iterables.concat((Iterable)head, (Iterable)tail);
        }
        return Iterables.limit((Iterable)it, (int)limit);
    }

    @Nonnull
    Iterable<DocumentNodeState> getChildNodes(final @Nonnull DocumentNodeState parent, @Nullable String name, int limit) {
        if (((DocumentNodeState)Preconditions.checkNotNull((Object)parent)).hasNoChildren()) {
            return Collections.emptyList();
        }
        final Revision readRevision = parent.getLastRevision();
        return Iterables.transform(this.getChildren((DocumentNodeState)parent, (String)name, (int)limit).children, (Function)new Function<String, DocumentNodeState>(){

            public DocumentNodeState apply(String input) {
                String p = PathUtils.concat(parent.getPath(), input);
                DocumentNodeState result = DocumentNodeStore.this.getNode(p, readRevision);
                if (result == null) {
                    throw new DocumentStoreException("DocumentNodeState is null for revision " + readRevision + " of " + p + " (aborting getChildNodes())");
                }
                return result;
            }
        });
    }

    @CheckForNull
    DocumentNodeState readNode(String path, Revision readRevision) {
        long start = PERFLOG.start();
        String id = Utils.getIdFromPath(path);
        Revision lastRevision = this.getPendingModifications().get(path);
        NodeDocument doc = this.store.find(Collection.NODES, id);
        if (doc == null) {
            PERFLOG.end(start, 1L, "readNode: (document not found) path={}, readRevision={}", (Object)path, (Object)readRevision);
            return null;
        }
        DocumentNodeState result = doc.getNodeAtRevision(this, readRevision, lastRevision);
        PERFLOG.end(start, 1L, "readNode: path={}, readRevision={}", (Object)path, (Object)readRevision);
        return result;
    }

    public void applyChanges(Revision rev, String path, boolean isNew, List<String> added, List<String> removed, List<String> changed, DiffCache.Entry cacheEntry) {
        StringValue docChildrenKey;
        NodeDocument.Children docChildren;
        if (isNew && !added.isEmpty()) {
            DocumentNodeState.Children c = new DocumentNodeState.Children();
            TreeSet set = Sets.newTreeSet();
            for (String p : added) {
                set.add(Utils.unshareString(PathUtils.getName(p)));
            }
            c.children.addAll(set);
            PathRev key = DocumentNodeStore.childNodeCacheKey(path, rev, null);
            this.nodeChildrenCache.put((Object)key, (Object)c);
        }
        JsopStream w = new JsopStream();
        for (String p : added) {
            w.tag('+').key(PathUtils.getName(p)).object().endObject().newline();
        }
        for (String p : removed) {
            w.tag('-').value(PathUtils.getName(p)).newline();
        }
        for (String p : changed) {
            w.tag('^').key(PathUtils.getName(p)).object().endObject().newline();
        }
        cacheEntry.append(path, ((Object)w).toString());
        if (!added.isEmpty() && (docChildren = (NodeDocument.Children)this.docChildrenCache.getIfPresent((Object)(docChildrenKey = new StringValue(path)))) != null) {
            int currentSize = docChildren.childNames.size();
            TreeSet names = Sets.newTreeSet(docChildren.childNames);
            if (!docChildren.isComplete) {
                for (String childPath : added) {
                    String name = PathUtils.getName(childPath);
                    if (names.higher(name) == null) continue;
                    names.add(Utils.unshareString(name));
                }
            } else {
                for (String childPath : added) {
                    names.add(Utils.unshareString(PathUtils.getName(childPath)));
                }
            }
            if (names.size() != currentSize) {
                boolean complete = docChildren.isComplete;
                docChildren = new NodeDocument.Children();
                docChildren.isComplete = complete;
                docChildren.childNames.addAll(names);
                this.docChildrenCache.put((Object)docChildrenKey, (Object)docChildren);
            }
        }
    }

    @CheckForNull
    NodeDocument updateCommitRoot(UpdateOp commit) throws DocumentStoreException {
        boolean batch = true;
        for (Map.Entry<UpdateOp.Key, UpdateOp.Operation> op : commit.getChanges().entrySet()) {
            String name = op.getKey().getName();
            if (NodeDocument.isRevisionsEntry(name) || "_modified".equals(name) || "_collisions".equals(name)) continue;
            batch = false;
            break;
        }
        if (batch) {
            return this.batchUpdateCommitRoot(commit);
        }
        return this.store.findAndUpdate(Collection.NODES, commit);
    }

    private NodeDocument batchUpdateCommitRoot(UpdateOp commit) throws DocumentStoreException {
        try {
            return this.batchCommitQueue.updateDocument(commit).call();
        }
        catch (InterruptedException e) {
            throw DocumentStoreException.convert(e, "Interrupted while updating commit root document");
        }
        catch (Exception e) {
            throw DocumentStoreException.convert(e, "Update of commit root document failed");
        }
    }

    @Nonnull
    DocumentNodeState getRoot(@Nonnull Revision revision) {
        DocumentNodeState root = this.getNode("/", revision);
        if (root == null) {
            throw new IllegalStateException("root node does not exist at revision " + revision);
        }
        return root;
    }

    @Nonnull
    DocumentNodeStoreBranch createBranch(DocumentNodeState base) {
        DocumentNodeStoreBranch b = DocumentNodeStoreBranch.getCurrentBranch();
        if (b != null) {
            return b;
        }
        return new DocumentNodeStoreBranch(this, base, this.mergeLock);
    }

    @Nonnull
    Revision rebase(@Nonnull Revision branchHead, @Nonnull Revision base) {
        Preconditions.checkNotNull((Object)branchHead);
        Preconditions.checkNotNull((Object)base);
        if (this.disableBranches) {
            return branchHead;
        }
        Branch b = this.getBranches().getBranch(branchHead);
        if (b == null) {
            return base.asBranchRevision();
        }
        if (b.getBase(branchHead).equals(base)) {
            return branchHead;
        }
        Revision head = this.newRevision().asBranchRevision();
        b.rebase(head, base);
        return head;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    Revision reset(@Nonnull Revision branchHead, @Nonnull Revision ancestor, @Nullable DocumentNodeStoreBranch branch) {
        Preconditions.checkNotNull((Object)branchHead);
        Preconditions.checkNotNull((Object)ancestor);
        Branch b = this.getBranches().getBranch(branchHead);
        if (b == null) {
            throw new DocumentStoreException("Empty branch cannot be reset");
        }
        if (!b.getCommits().last().equals(branchHead)) {
            throw new DocumentStoreException(branchHead + " is not the head " + "of a branch");
        }
        if (!b.containsCommit(ancestor)) {
            throw new DocumentStoreException(ancestor + " is not " + "an ancestor revision of " + branchHead);
        }
        if (branchHead.equals(ancestor)) {
            return branchHead;
        }
        boolean success = false;
        Commit commit = this.newCommit(branchHead, branch);
        try {
            Iterator it = b.getCommits().tailSet(ancestor).iterator();
            Revision base = (Revision)it.next();
            HashMap operations = Maps.newHashMap();
            while (it.hasNext()) {
                Revision reset = (Revision)it.next();
                this.getRoot(reset).compareAgainstBaseState(this.getRoot(base), new ResetDiff(reset.asTrunkRevision(), operations));
                UpdateOp rootOp = (UpdateOp)operations.get("/");
                if (rootOp == null) {
                    rootOp = new UpdateOp(Utils.getIdFromPath("/"), false);
                    NodeDocument.setModified(rootOp, commit.getRevision());
                    operations.put("/", rootOp);
                }
                NodeDocument.removeCollision(rootOp, reset.asTrunkRevision());
                NodeDocument.removeRevision(rootOp, reset.asTrunkRevision());
            }
            if (this.store.findAndUpdate(Collection.NODES, (UpdateOp)operations.get("/")) != null) {
                ArrayList revs = Lists.newArrayList(b.getCommits().tailSet(ancestor));
                for (Revision r : revs.subList(1, revs.size())) {
                    b.removeCommit(r);
                }
                success = true;
            }
            operations.remove("/");
            for (UpdateOp op : operations.values()) {
                this.store.findAndUpdate(Collection.NODES, op);
            }
        }
        finally {
            if (!success) {
                this.canceled(commit);
            } else {
                this.done(commit, true, null);
            }
        }
        return ancestor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    Revision merge(@Nonnull Revision branchHead, @Nullable CommitInfo info) throws CommitFailedException {
        Branch b = this.getBranches().getBranch(branchHead);
        Revision base = branchHead;
        if (b != null) {
            base = b.getBase(branchHead);
        }
        int numBranchCommits = b != null ? b.getCommits().size() : 1;
        boolean success = false;
        MergeCommit commit = this.newMergeCommit(base, numBranchCommits);
        try {
            UpdateOp op = new UpdateOp(Utils.getIdFromPath("/"), false);
            NodeDocument.setModified(op, commit.getRevision());
            if (b != null) {
                Iterator mergeCommits = commit.getMergeRevisions().iterator();
                for (Revision rev : b.getCommits()) {
                    rev = rev.asTrunkRevision();
                    String commitTag = "c-" + mergeCommits.next();
                    NodeDocument.setRevision(op, rev, commitTag);
                    op.containsMapEntry("_collisions", rev, false);
                }
                if (this.store.findAndUpdate(Collection.NODES, op) != null) {
                    b.applyTo(this.getPendingModifications(), commit.getRevision());
                    this.getBranches().remove(b);
                } else {
                    throw new CommitFailedException("Merge", 2, "Conflicting concurrent change. Update operation failed: " + op);
                }
            }
            success = true;
        }
        finally {
            if (!success) {
                this.canceled(commit);
            } else {
                this.done(commit, false, info);
            }
        }
        return commit.getRevision();
    }

    boolean compare(final @Nonnull DocumentNodeState node, final @Nonnull DocumentNodeState base, @Nonnull NodeStateDiff diff) {
        if (!AbstractNodeState.comparePropertiesAgainstBaseState(node, base, diff)) {
            return false;
        }
        if (node.hasNoChildren() && base.hasNoChildren()) {
            return true;
        }
        String jsop = this.getJsopDiffIfLocalChange(diff, node);
        boolean useReadRevision = true;
        if (jsop == null && (jsop = this.diffCache.getChanges(base.getRevision(), node.getRevision(), node.getPath(), null)) == null) {
            useReadRevision = false;
            jsop = this.diffCache.getChanges(base.getLastRevision(), node.getLastRevision(), node.getPath(), new DiffCache.Loader(){

                @Override
                public String call() {
                    return DocumentNodeStore.this.diffImpl(base, node);
                }
            });
        }
        return this.dispatch(jsop, node, base, diff, useReadRevision);
    }

    @CheckForNull
    private String getJsopDiffIfLocalChange(NodeStateDiff diff, DocumentNodeState nodeState) {
        ContentChangeInfo info;
        if (this.localDiffCache == null) {
            return null;
        }
        if (diff instanceof ContentChangeInfoProvider && (info = ((ContentChangeInfoProvider)((Object)diff)).getChangeInfo()).isLocalChange() && info.getAfter() instanceof DocumentNodeState) {
            DocumentNodeState rootAfterState = (DocumentNodeState)info.getAfter();
            DocumentNodeState rootBeforeState = (DocumentNodeState)info.getBefore();
            String jsopDiff = this.localDiffCache.getChanges(rootBeforeState.getRevision(), rootAfterState.getRevision(), nodeState.getPath(), null);
            if (jsopDiff != null) {
                LOG.trace("Got diff from local cache for path {}", (Object)nodeState.getPath());
                return jsopDiff;
            }
        }
        return null;
    }

    String diff(@Nonnull String fromRevisionId, @Nonnull String toRevisionId, @Nonnull String path) throws DocumentStoreException {
        int r;
        if (fromRevisionId.equals(toRevisionId)) {
            return "";
        }
        Revision fromRev = Revision.fromString(fromRevisionId);
        Revision toRev = Revision.fromString(toRevisionId);
        final DocumentNodeState from = this.getNode(path, fromRev);
        final DocumentNodeState to = this.getNode(path, toRev);
        if (from == null || to == null) {
            String msg = String.format("Diff is only supported if the node exists in both cases. Node [%s], fromRev [%s] -> %s, toRev [%s] -> %s", path, fromRev, from != null, toRev, to != null);
            throw new DocumentStoreException(msg);
        }
        String compactDiff = this.diffCache.getChanges(fromRev, toRev, path, new DiffCache.Loader(){

            @Override
            public String call() {
                return DocumentNodeStore.this.diffImpl(from, to);
            }
        });
        JsopStream writer = new JsopStream();
        DocumentNodeStore.diffProperties(from, to, writer);
        JsopTokenizer t = new JsopTokenizer(compactDiff);
        do {
            r = t.read();
            switch (r) {
                case 43: 
                case 94: {
                    String name = t.readString();
                    t.read(58);
                    t.read(123);
                    t.read(125);
                    writer.tag((char)r).key(PathUtils.concat(path, name));
                    writer.object().endObject().newline();
                    break;
                }
                case 45: {
                    String name = t.readString();
                    writer.tag('-').value(PathUtils.concat(path, name));
                    writer.newline();
                }
            }
        } while (r != 0);
        return ((Object)writer).toString();
    }

    LastRevTracker createTracker(final @Nonnull Revision r, boolean isBranchCommit) {
        if (isBranchCommit && !this.disableBranches) {
            Revision branchRev = r.asBranchRevision();
            return this.branches.getBranchCommit(branchRev);
        }
        return new LastRevTracker(){

            @Override
            public void track(String path) {
                DocumentNodeStore.this.unsavedLastRevisions.put(path, r);
            }
        };
    }

    @Override
    public Closeable addObserver(Observer observer) {
        return this.dispatcher.addObserver(observer);
    }

    @Override
    @Nonnull
    public DocumentNodeState getRoot() {
        return this.getRoot(this.headRevision);
    }

    @Override
    @Nonnull
    public NodeState merge(@Nonnull NodeBuilder builder, @Nonnull CommitHook commitHook, @Nonnull CommitInfo info) throws CommitFailedException {
        return DocumentNodeStore.asDocumentRootBuilder(builder).merge(commitHook, info);
    }

    @Override
    @Nonnull
    public NodeState rebase(@Nonnull NodeBuilder builder) {
        return DocumentNodeStore.asDocumentRootBuilder(builder).rebase();
    }

    @Override
    public NodeState reset(@Nonnull NodeBuilder builder) {
        return DocumentNodeStore.asDocumentRootBuilder(builder).reset();
    }

    @Override
    public BlobStoreBlob createBlob(InputStream inputStream) throws IOException {
        return new BlobStoreBlob(this.blobStore, this.blobStore.writeBlob(inputStream));
    }

    @Override
    public Blob getBlob(String reference) {
        String blobId = this.blobStore.getBlobId(reference);
        if (blobId != null) {
            return new BlobStoreBlob(this.blobStore, blobId);
        }
        LOG.debug("No blobId found matching reference [{}]", (Object)reference);
        return null;
    }

    public Blob getBlobFromBlobId(String blobId) {
        return new BlobStoreBlob(this.blobStore, blobId);
    }

    @Override
    @Nonnull
    public String checkpoint(long lifetime, @Nonnull Map<String, String> properties) {
        return this.checkpoints.create(lifetime, properties).toString();
    }

    @Override
    @Nonnull
    public String checkpoint(long lifetime) {
        Map<String, String> empty = Collections.emptyMap();
        return this.checkpoint(lifetime, empty);
    }

    @Override
    @Nonnull
    public Map<String, String> checkpointInfo(@Nonnull String checkpoint) {
        Revision r = Revision.fromString(checkpoint);
        Checkpoints.Info info = (Checkpoints.Info)this.checkpoints.getCheckpoints().get(r);
        if (info == null) {
            return Collections.emptyMap();
        }
        return info.get();
    }

    @Override
    @CheckForNull
    public NodeState retrieve(@Nonnull String checkpoint) {
        Revision r = Revision.fromString(checkpoint);
        SortedMap<Revision, Checkpoints.Info> checkpoints = this.checkpoints.getCheckpoints();
        if (checkpoints != null && checkpoints.containsKey(r)) {
            return this.getRoot(r);
        }
        return null;
    }

    @Override
    public boolean release(@Nonnull String checkpoint) {
        this.checkpoints.release(checkpoint);
        return true;
    }

    @Override
    public UnmergedBranches getBranches() {
        return this.branches;
    }

    @Override
    public UnsavedModifications getPendingModifications() {
        return this.unsavedLastRevisions;
    }

    public Revision.RevisionComparator getRevisionComparator() {
        return this.revisionComparator;
    }

    @Override
    public int getClusterId() {
        return this.clusterId;
    }

    @Override
    @Nonnull
    public Revision getHeadRevision() {
        return this.headRevision;
    }

    public void runBackgroundOperations() {
        this.runBackgroundUpdateOperations();
        this.runBackgroundReadOperations();
    }

    private void runBackgroundUpdateOperations() {
        if (this.isDisposed.get()) {
            return;
        }
        try {
            this.internalRunBackgroundUpdateOperations();
        }
        catch (RuntimeException e) {
            if (this.isDisposed.get()) {
                LOG.warn("Background update operation failed: " + e.toString(), (Throwable)e);
                return;
            }
            throw e;
        }
    }

    private synchronized void internalRunBackgroundUpdateOperations() {
        long start;
        long time = start = this.clock.getTime();
        this.cleanOrphanedBranches();
        this.cleanCollisions();
        long cleanTime = this.clock.getTime() - time;
        time = this.clock.getTime();
        this.backgroundSplit();
        long splitTime = this.clock.getTime() - time;
        BackgroundWriteStats stats = this.backgroundWrite();
        stats.split = splitTime;
        stats.clean = cleanTime;
        String msg = "Background operations stats ({})";
        if (this.clock.getTime() - start > TimeUnit.SECONDS.toMillis(10L)) {
            LOG.info(msg, (Object)stats);
        } else {
            LOG.debug(msg, (Object)stats);
        }
    }

    private void runBackgroundReadOperations() {
        if (this.isDisposed.get()) {
            return;
        }
        try {
            this.internalRunBackgroundReadOperations();
        }
        catch (RuntimeException e) {
            if (this.isDisposed.get()) {
                LOG.warn("Background read operation failed: " + e.toString(), (Throwable)e);
                return;
            }
            throw e;
        }
    }

    private synchronized void internalRunBackgroundReadOperations() {
        long start = this.clock.getTime();
        BackgroundReadStats readStats = this.backgroundRead(true);
        long readTime = this.clock.getTime() - start;
        String msg = "Background read operations stats (read:{} {})";
        if (this.clock.getTime() - start > TimeUnit.SECONDS.toMillis(10L)) {
            LOG.info(msg, (Object)readTime, (Object)readStats);
        } else {
            LOG.debug(msg, (Object)readTime, (Object)readStats);
        }
    }

    boolean renewClusterIdLease() {
        return this.clusterNodeInfo != null && this.clusterNodeInfo.renewLease();
    }

    void updateClusterState() {
        long now = this.clock.getTime();
        HashSet inactive = Sets.newHashSet();
        for (ClusterNodeInfoDocument doc : ClusterNodeInfoDocument.all(this.store)) {
            int cId = doc.getClusterId();
            if (cId != this.clusterId && !doc.isActive()) {
                inactive.add(cId);
                continue;
            }
            this.activeClusterNodes.put(cId, doc.getLeaseEndTime());
        }
        this.activeClusterNodes.keySet().removeAll(inactive);
        this.inactiveClusterNodes.keySet().retainAll(inactive);
        for (Integer clusterId : inactive) {
            this.inactiveClusterNodes.putIfAbsent(clusterId, now);
        }
    }

    Map<Integer, Long> getInactiveClusterNodes() {
        return new HashMap<Integer, Long>(this.inactiveClusterNodes);
    }

    Map<Integer, Long> getActiveClusterNodes() {
        return new HashMap<Integer, Long>(this.activeClusterNodes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BackgroundReadStats backgroundRead(boolean dispatchChange) {
        BackgroundReadStats stats = new BackgroundReadStats();
        long time = this.clock.getTime();
        String id = Utils.getIdFromPath("/");
        NodeDocument doc = this.store.find(Collection.NODES, id, this.asyncDelay);
        if (doc == null) {
            return stats;
        }
        Map<Integer, Revision> lastRevMap = doc.getLastRev();
        Revision.RevisionComparator revisionComparator = this.getRevisionComparator();
        Revision headSeen = Revision.newRevision(0);
        Revision otherSeen = Revision.newRevision(0);
        HashMap externalChanges = Maps.newHashMap();
        for (Map.Entry<Integer, Revision> entry : lastRevMap.entrySet()) {
            int machineId = entry.getKey();
            if (machineId == this.clusterId) continue;
            Revision r = entry.getValue();
            Revision last = this.lastKnownRevision.get(machineId);
            if (last != null && r.compareRevisionTime(last) <= 0) continue;
            this.lastKnownRevision.put(machineId, r);
            if (last == null && r.getTimestamp() <= DocumentNodeStore.revisionPurgeMillis()) continue;
            externalChanges.put(r, otherSeen);
        }
        stats.readHead = this.clock.getTime() - time;
        time = this.clock.getTime();
        if (!externalChanges.isEmpty()) {
            stats.cacheStats = this.store.invalidateCache();
            this.docChildrenCache.invalidateAll();
            stats.cacheInvalidationTime = this.clock.getTime() - time;
            time = this.clock.getTime();
            this.backgroundOperationLock.writeLock().lock();
            try {
                stats.lock = this.clock.getTime() - time;
                time = this.clock.getTime();
                revisionComparator.add(this.newRevision(), headSeen);
                for (Map.Entry<Integer, Revision> entry : externalChanges.entrySet()) {
                    revisionComparator.add((Revision)((Object)entry.getKey()), entry.getValue());
                }
                this.setHeadRevision(this.newRevision());
                if (dispatchChange) {
                    this.dispatcher.contentChanged(this.getRoot(), null);
                }
            }
            finally {
                this.backgroundOperationLock.writeLock().unlock();
            }
            stats.dispatchChanges = this.clock.getTime() - time;
            time = this.clock.getTime();
        }
        revisionComparator.purge(DocumentNodeStore.revisionPurgeMillis());
        stats.purge = this.clock.getTime() - time;
        return stats;
    }

    private static long revisionPurgeMillis() {
        return Revision.getCurrentTimestamp() - 3600000L;
    }

    private void cleanOrphanedBranches() {
        Branch b;
        while ((b = this.branches.pollOrphanedBranch()) != null) {
            LOG.debug("Cleaning up orphaned branch with base revision: {}, commits: {}", (Object)b.getBase(), b.getCommits());
            UpdateOp op = new UpdateOp(Utils.getIdFromPath("/"), false);
            for (Revision r : b.getCommits()) {
                r = r.asTrunkRevision();
                NodeDocument.removeRevision(op, r);
            }
            this.store.findAndUpdate(Collection.NODES, op);
        }
    }

    private void cleanCollisions() {
        String id = Utils.getIdFromPath("/");
        NodeDocument root = this.store.find(Collection.NODES, id);
        if (root == null) {
            return;
        }
        Revision head = this.getHeadRevision();
        SortedMap<Revision, String> map = root.getLocalMap("_collisions");
        UpdateOp op = new UpdateOp(id, false);
        for (Revision r : map.keySet()) {
            if (r.getClusterId() != this.clusterId || this.branches.getBranchCommit(r) != null || !this.isRevisionNewer(head, r)) continue;
            NodeDocument.removeCollision(op, r);
        }
        if (op.hasChanges()) {
            LOG.debug("Removing collisions {}", op.getChanges().keySet());
            this.store.findAndUpdate(Collection.NODES, op);
        }
    }

    private void backgroundSplit() {
        Iterator<String> it = this.splitCandidates.keySet().iterator();
        while (it.hasNext()) {
            String id = it.next();
            NodeDocument doc = this.store.find(Collection.NODES, id);
            if (doc == null) continue;
            for (UpdateOp op : doc.split(this)) {
                NodeDocument before = this.store.createOrUpdate(Collection.NODES, op);
                if (before != null) {
                    NodeDocument after;
                    if (!LOG.isDebugEnabled() || (after = this.store.find(Collection.NODES, op.getId())) == null) continue;
                    LOG.debug("Split operation on {}. Size before: {}, after: {}", new Object[]{id, before.getMemory(), after.getMemory()});
                    continue;
                }
                LOG.debug("Split operation created {}", (Object)op.getId());
            }
            it.remove();
        }
    }

    BackgroundWriteStats backgroundWrite() {
        return this.unsavedLastRevisions.persist(this, this.backgroundOperationLock.writeLock());
    }

    private void checkOpen() throws IllegalStateException {
        if (this.isDisposed.get()) {
            throw new IllegalStateException("This DocumentNodeStore is disposed");
        }
    }

    private boolean dispatch(@Nonnull String jsonDiff, @Nonnull DocumentNodeState node, @Nonnull DocumentNodeState base, @Nonnull NodeStateDiff diff, boolean useReadRevision) {
        int r;
        if (jsonDiff.trim().isEmpty()) {
            return true;
        }
        Revision nodeRev = useReadRevision ? node.getRevision() : node.getLastRevision();
        Revision baseRev = useReadRevision ? base.getRevision() : base.getLastRevision();
        JsopTokenizer t = new JsopTokenizer(jsonDiff);
        boolean continueComparison = true;
        block5: while (continueComparison && (r = t.read()) != 0) {
            switch (r) {
                case 43: {
                    String name = Utils.unshareString(t.readString());
                    t.read(58);
                    t.read(123);
                    while (t.read() != 125) {
                    }
                    continueComparison = diff.childNodeAdded(name, node.getChildNode(name, nodeRev));
                    continue block5;
                }
                case 45: {
                    String name = Utils.unshareString(t.readString());
                    continueComparison = diff.childNodeDeleted(name, base.getChildNode(name, baseRev));
                    continue block5;
                }
                case 94: {
                    String name = Utils.unshareString(t.readString());
                    t.read(58);
                    if (t.matches(123)) {
                        t.read(125);
                        continueComparison = diff.childNodeChanged(name, base.getChildNode(name, baseRev), node.getChildNode(name, nodeRev));
                        continue block5;
                    }
                    if (t.matches(91)) {
                        while (t.read() != 93) {
                        }
                        continue block5;
                    }
                    t.read();
                    continue block5;
                }
            }
            throw new IllegalArgumentException("jsonDiff: illegal token '" + t.getToken() + "' at pos: " + t.getLastPos() + ' ' + jsonDiff);
        }
        return continueComparison;
    }

    private boolean checkNodeNotExistsFromChildrenCache(String path, Revision rev) {
        if (PathUtils.denotesRoot(path)) {
            return false;
        }
        String parentPath = PathUtils.getParentPath(path);
        PathRev key = DocumentNodeStore.childNodeCacheKey(parentPath, rev, null);
        DocumentNodeState.Children children = (DocumentNodeState.Children)this.nodeChildrenCache.getIfPresent((Object)key);
        String lookupChildName = PathUtils.getName(path);
        if (children == null) {
            return false;
        }
        if (children.hasMore) {
            return false;
        }
        int childPosition = Collections.binarySearch(children.children, lookupChildName);
        if (childPosition < 0) {
            LOG.trace("Child node as per path {} does not exist at revision {}", (Object)path, (Object)rev);
            return true;
        }
        return false;
    }

    private static void diffProperties(DocumentNodeState from, DocumentNodeState to, JsopWriter w) {
        for (PropertyState propertyState : from.getProperties()) {
            String name;
            PropertyState toValue;
            if (propertyState.equals(toValue = to.getProperty(name = propertyState.getName()))) continue;
            w.tag('^').key(PathUtils.concat(from.getPath(), name));
            if (toValue == null) {
                w.value(null);
                continue;
            }
            w.encodedValue(to.getPropertyAsString(name)).newline();
        }
        for (String string : to.getPropertyNames()) {
            if (from.hasProperty(string)) continue;
            w.tag('^').key(PathUtils.concat(from.getPath(), string)).encodedValue(to.getPropertyAsString(string)).newline();
        }
    }

    private String diffImpl(DocumentNodeState from, DocumentNodeState to) throws DocumentStoreException {
        String diffAlgo;
        long getChildrenDoneIn;
        JsopStream w = new JsopStream();
        int max = DocumentMK.MANY_CHILDREN_THRESHOLD;
        boolean debug = LOG.isDebugEnabled();
        long start = debug ? DocumentNodeStore.now() : 0L;
        DocumentNodeState.Children fromChildren = this.getChildren(from, null, max);
        DocumentNodeState.Children toChildren = this.getChildren(to, null, max);
        long l = getChildrenDoneIn = debug ? DocumentNodeStore.now() : 0L;
        if (!fromChildren.hasMore && !toChildren.hasMore) {
            diffAlgo = "diffFewChildren";
            this.diffFewChildren(w, from.getPath(), fromChildren, from.getLastRevision(), toChildren, to.getLastRevision());
        } else if (DocumentMK.FAST_DIFF) {
            diffAlgo = "diffManyChildren";
            this.diffManyChildren(w, from.getPath(), from.getLastRevision(), to.getLastRevision());
        } else {
            diffAlgo = "diffAllChildren";
            max = Integer.MAX_VALUE;
            fromChildren = this.getChildren(from, null, max);
            toChildren = this.getChildren(to, null, max);
            this.diffFewChildren(w, from.getPath(), fromChildren, from.getLastRevision(), toChildren, to.getLastRevision());
        }
        if (debug) {
            long end = DocumentNodeStore.now();
            LOG.debug("Diff performed via '{}' at [{}] between revisions [{}] => [{}] took {} ms ({} ms)", new Object[]{diffAlgo, from.getPath(), from.getLastRevision(), to.getLastRevision(), end - start, getChildrenDoneIn - start});
        }
        return ((Object)w).toString();
    }

    private void diffManyChildren(JsopWriter w, String path, Revision fromRev, Revision toRev) {
        long minTimestamp = Math.min(this.revisionComparator.getMinimumTimestamp(fromRev, this.inactiveClusterNodes), this.revisionComparator.getMinimumTimestamp(toRev, this.inactiveClusterNodes));
        long minValue = NodeDocument.getModifiedInSecs(minTimestamp);
        String fromKey = Utils.getKeyLowerLimit(path);
        String toKey = Utils.getKeyUpperLimit(path);
        HashSet paths = Sets.newHashSet();
        LOG.debug("diffManyChildren: path: {}, fromRev: {}, toRev: {}", new Object[]{path, fromRev, toRev});
        for (NodeDocument doc : this.store.query(Collection.NODES, fromKey, toKey, "_modified", minValue, Integer.MAX_VALUE)) {
            paths.add(doc.getPath());
        }
        LOG.debug("diffManyChildren: Affected paths: {}", (Object)paths.size());
        Revision minRev = new Revision(minTimestamp, 0, this.getClusterId());
        DocumentNodeStore.addPathsForDiff(path, paths, this.getPendingModifications().getPaths(minRev));
        for (Revision r : new Revision[]{fromRev, toRev}) {
            Branch.BranchCommit c;
            if (!r.isBranch() || (c = this.getBranches().getBranchCommit(r)) == null) continue;
            DocumentNodeStore.addPathsForDiff(path, paths, c.getModifiedPaths());
        }
        for (String p : paths) {
            DocumentNodeState fromNode = this.getNode(p, fromRev);
            DocumentNodeState toNode = this.getNode(p, toRev);
            String name = PathUtils.getName(p);
            LOG.trace("diffManyChildren: Changed Path {}", (Object)path);
            if (fromNode != null) {
                if (toNode != null) {
                    Revision a = fromNode.getLastRevision();
                    Revision b = toNode.getLastRevision();
                    if (a == null && b == null || a != null && b != null && a.equals(b)) continue;
                    w.tag('^').key(name).object().endObject().newline();
                    continue;
                }
                w.tag('-').value(name).newline();
                continue;
            }
            if (toNode == null) continue;
            w.tag('+').key(name).object().endObject().newline();
        }
    }

    private static void addPathsForDiff(String path, Set<String> paths, Iterable<String> modified) {
        for (String p : modified) {
            String parent;
            if (PathUtils.denotesRoot(p) || !path.equals(parent = PathUtils.getParentPath(p))) continue;
            paths.add(p);
        }
    }

    private void diffFewChildren(JsopWriter w, String parentPath, DocumentNodeState.Children fromChildren, Revision fromRev, DocumentNodeState.Children toChildren, Revision toRev) {
        HashSet childrenSet = Sets.newHashSet(toChildren.children);
        for (String n : fromChildren.children) {
            if (!childrenSet.contains(n)) {
                w.tag('-').value(n).newline();
                continue;
            }
            String path = PathUtils.concat(parentPath, n);
            DocumentNodeState n1 = this.getNode(path, fromRev);
            DocumentNodeState n2 = this.getNode(path, toRev);
            Preconditions.checkNotNull((Object)n1, (String)"Node at [%s] not found for fromRev [%s]", (Object[])new Object[]{path, fromRev});
            Preconditions.checkNotNull((Object)n2, (String)"Node at [%s] not found for toRev [%s]", (Object[])new Object[]{path, toRev});
            if (n1.getLastRevision().equals(n2.getLastRevision())) continue;
            w.tag('^').key(n).object().endObject().newline();
        }
        childrenSet = Sets.newHashSet(fromChildren.children);
        for (String n : toChildren.children) {
            if (childrenSet.contains(n)) continue;
            w.tag('+').key(n).object().endObject().newline();
        }
    }

    private static PathRev childNodeCacheKey(@Nonnull String path, @Nonnull Revision readRevision, @Nullable String name) {
        String p = (name == null ? "" : name) + path;
        return new PathRev(p, readRevision);
    }

    private static DocumentRootBuilder asDocumentRootBuilder(NodeBuilder builder) throws IllegalArgumentException {
        if (!(builder instanceof DocumentRootBuilder)) {
            throw new IllegalArgumentException("builder must be a " + DocumentRootBuilder.class.getName());
        }
        return (DocumentRootBuilder)builder;
    }

    private static long now() {
        return System.currentTimeMillis();
    }

    private void moveOrCopyNode(boolean move, DocumentNodeState source, String targetPath, Commit commit) {
        DocumentNodeState newNode = new DocumentNodeState(this, targetPath, commit.getRevision());
        source.copyTo(newNode);
        commit.addNode(newNode);
        if (move) {
            this.markAsDeleted(source, commit, false);
        }
        for (DocumentNodeState child : this.getChildNodes(source, null, Integer.MAX_VALUE)) {
            String childName = PathUtils.getName(child.getPath());
            String destChildPath = PathUtils.concat(targetPath, childName);
            this.moveOrCopyNode(move, child, destChildPath, commit);
        }
    }

    private void checkRevisionAge(Revision r, String path) {
        if (LOG.isDebugEnabled() && "/".equals(path) && this.headRevision.getTimestamp() - r.getTimestamp() > (long)WARN_REVISION_AGE) {
            LOG.debug("Requesting an old revision for path " + path + ", " + (this.headRevision.getTimestamp() - r.getTimestamp()) / 1000L + " seconds old");
        }
    }

    @CheckForNull
    public MarkSweepGarbageCollector createBlobGarbageCollector(long blobGcMaxAgeInSecs, String repositoryId) {
        MarkSweepGarbageCollector blobGC = null;
        if (this.blobStore instanceof GarbageCollectableBlobStore) {
            try {
                blobGC = new MarkSweepGarbageCollector(new DocumentBlobReferenceRetriever(this), (GarbageCollectableBlobStore)this.blobStore, this.executor, TimeUnit.SECONDS.toMillis(blobGcMaxAgeInSecs), repositoryId);
            }
            catch (IOException e) {
                throw new RuntimeException("Error occurred while initializing the MarkSweepGarbageCollector", e);
            }
        }
        return blobGC;
    }

    public DocumentNodeStoreMBean getMBean() {
        return this.mbean;
    }

    private DocumentNodeStoreMBean createMBean() {
        try {
            return new MBeanImpl();
        }
        catch (NotCompliantMBeanException e) {
            throw new IllegalStateException(e);
        }
    }

    public BlobStore getBlobStore() {
        return this.blobStore;
    }

    BlobSerializer getBlobSerializer() {
        return this.blobSerializer;
    }

    public Iterator<Blob> getReferencedBlobsIterator() {
        if (this.store instanceof MongoDocumentStore) {
            return new MongoBlobReferenceIterator(this, (MongoDocumentStore)this.store);
        }
        return new BlobReferenceIterator(this);
    }

    public DiffCache getDiffCache() {
        return this.diffCache;
    }

    public DiffCache getLocalDiffCache() {
        if (this.localDiffCache != null) {
            return this.localDiffCache;
        }
        return this.diffCache;
    }

    public Clock getClock() {
        return this.clock;
    }

    public Checkpoints getCheckpoints() {
        return this.checkpoints;
    }

    @Nonnull
    public VersionGarbageCollector getVersionGarbageCollector() {
        return this.versionGarbageCollector;
    }

    @Nonnull
    public LastRevRecoveryAgent getLastRevRecoveryAgent() {
        return this.lastRevRecoveryAgent;
    }

    public void setPersistentCache(PersistentCache persistentCache) {
        this.persistentCache = persistentCache;
    }

    static class BackgroundLeaseUpdate
    extends NodeStoreTask {
        BackgroundLeaseUpdate(DocumentNodeStore nodeStore, AtomicBoolean isDisposed) {
            super(nodeStore, isDisposed);
        }

        @Override
        protected void execute(@Nonnull DocumentNodeStore nodeStore) {
            if (nodeStore.renewClusterIdLease()) {
                nodeStore.updateClusterState();
            }
        }
    }

    static class BackgroundReadOperation
    extends NodeStoreTask {
        BackgroundReadOperation(DocumentNodeStore nodeStore, AtomicBoolean isDisposed) {
            super(nodeStore, isDisposed);
        }

        @Override
        protected void execute(@Nonnull DocumentNodeStore nodeStore) {
            nodeStore.runBackgroundReadOperations();
        }
    }

    static class BackgroundOperation
    extends NodeStoreTask {
        BackgroundOperation(DocumentNodeStore nodeStore, AtomicBoolean isDisposed) {
            super(nodeStore, isDisposed);
        }

        @Override
        protected void execute(@Nonnull DocumentNodeStore nodeStore) {
            nodeStore.runBackgroundUpdateOperations();
        }
    }

    static abstract class NodeStoreTask
    implements Runnable {
        final WeakReference<DocumentNodeStore> ref;
        private final AtomicBoolean isDisposed;
        private int delay;

        NodeStoreTask(DocumentNodeStore nodeStore, AtomicBoolean isDisposed) {
            this.ref = new WeakReference<DocumentNodeStore>(nodeStore);
            this.delay = nodeStore.getAsyncDelay();
            this.isDisposed = isDisposed;
        }

        protected abstract void execute(@Nonnull DocumentNodeStore var1);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (this.delay != 0 && !this.isDisposed.get()) {
                AtomicBoolean atomicBoolean = this.isDisposed;
                synchronized (atomicBoolean) {
                    try {
                        this.isDisposed.wait(this.delay);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                }
                DocumentNodeStore nodeStore = (DocumentNodeStore)this.ref.get();
                if (nodeStore == null) break;
                try {
                    this.execute(nodeStore);
                }
                catch (Throwable t) {
                    LOG.warn("Background operation failed: " + t.toString(), t);
                }
                this.delay = nodeStore.getAsyncDelay();
            }
        }
    }

    private class MBeanImpl
    extends AnnotatedStandardMBean
    implements DocumentNodeStoreMBean {
        private final String ISO_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSS zzz";
        private final TimeZone TZ_UTC;

        protected MBeanImpl() throws NotCompliantMBeanException {
            super(DocumentNodeStoreMBean.class);
            this.ISO_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSS zzz";
            this.TZ_UTC = TimeZone.getTimeZone("UTC");
        }

        @Override
        public String getRevisionComparatorState() {
            return DocumentNodeStore.this.revisionComparator.toString();
        }

        @Override
        public String getHead() {
            return DocumentNodeStore.this.headRevision.toString();
        }

        @Override
        public int getClusterId() {
            return DocumentNodeStore.this.clusterId;
        }

        @Override
        public int getUnmergedBranchCount() {
            return DocumentNodeStore.this.branches.size();
        }

        @Override
        public String[] getInactiveClusterNodes() {
            return (String[])Iterables.toArray((Iterable)Iterables.transform(DocumentNodeStore.this.inactiveClusterNodes.entrySet(), (Function)new Function<Map.Entry<Integer, Long>, String>(){

                public String apply(Map.Entry<Integer, Long> input) {
                    return input.toString();
                }
            }), String.class);
        }

        @Override
        public String[] getActiveClusterNodes() {
            return (String[])Iterables.toArray((Iterable)Iterables.transform(DocumentNodeStore.this.activeClusterNodes.entrySet(), (Function)new Function<Map.Entry<Integer, Long>, String>(){

                public String apply(Map.Entry<Integer, Long> input) {
                    return input.toString();
                }
            }), String.class);
        }

        @Override
        public String[] getLastKnownRevisions() {
            return (String[])Iterables.toArray((Iterable)Iterables.transform(DocumentNodeStore.this.lastKnownRevision.entrySet(), (Function)new Function<Map.Entry<Integer, Revision>, String>(){

                public String apply(Map.Entry<Integer, Revision> input) {
                    return input.toString();
                }
            }), String.class);
        }

        @Override
        public String formatRevision(String rev, boolean utc) {
            Revision r = Revision.fromString(rev);
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS zzz");
            if (utc) {
                sdf.setTimeZone(this.TZ_UTC);
            }
            return sdf.format(r.getTimestamp());
        }
    }

    private static class BackgroundReadStats {
        CacheInvalidationStats cacheStats;
        long readHead;
        long cacheInvalidationTime;
        long lock;
        long dispatchChanges;
        long purge;

        private BackgroundReadStats() {
        }

        public String toString() {
            String cacheStatsMsg = "NOP";
            if (this.cacheStats != null) {
                cacheStatsMsg = this.cacheStats.summaryReport();
            }
            return "ReadStats{cacheStats:" + cacheStatsMsg + ", head:" + this.readHead + ", cache:" + this.cacheInvalidationTime + ", lock:" + this.lock + ", dispatch:" + this.dispatchChanges + ", purge:" + this.purge + '}';
        }
    }
}

