/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.plugins.document.Commit;
import org.apache.jackrabbit.oak.plugins.document.CommitDiff;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeState;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeStore;
import org.apache.jackrabbit.oak.plugins.document.Revision;
import org.apache.jackrabbit.oak.spi.commit.ChangeDispatcher;
import org.apache.jackrabbit.oak.spi.commit.CommitHook;
import org.apache.jackrabbit.oak.spi.commit.CommitInfo;
import org.apache.jackrabbit.oak.spi.state.ConflictAnnotatingRebaseDiff;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStoreBranch;
import org.apache.jackrabbit.oak.util.PerfLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DocumentNodeStoreBranch
implements NodeStoreBranch {
    private static final Logger LOG = LoggerFactory.getLogger(DocumentNodeStoreBranch.class);
    private static final PerfLogger perfLogger = new PerfLogger(LoggerFactory.getLogger((String)(DocumentNodeStoreBranch.class.getName() + ".perf")));
    private static final int MAX_LOCK_TRY_TIME_MULTIPLIER = Integer.getInteger("oak.maxLockTryTimeMultiplier", 3);
    private static final ConcurrentMap<Thread, DocumentNodeStoreBranch> BRANCHES = Maps.newConcurrentMap();
    private static final Random RANDOM = new Random();
    private static final long MIN_BACKOFF = 50L;
    protected final DocumentNodeStore store;
    protected final ChangeDispatcher dispatcher;
    protected final long maximumBackoff;
    protected final long maxLockTryTimeMS;
    private final ReadWriteLock mergeLock;
    private BranchState branchState;

    DocumentNodeStoreBranch(DocumentNodeStore store, DocumentNodeState base, ReadWriteLock mergeLock) {
        this.store = (DocumentNodeStore)Preconditions.checkNotNull((Object)store);
        this.dispatcher = new ChangeDispatcher(store.getRoot());
        this.branchState = new Unmodified((DocumentNodeState)Preconditions.checkNotNull((Object)base));
        this.maximumBackoff = Math.max((long)store.getMaxBackOffMillis(), 50L);
        this.maxLockTryTimeMS = store.getMaxBackOffMillis() * MAX_LOCK_TRY_TIME_MULTIPLIER;
        this.mergeLock = mergeLock;
    }

    public boolean move(String source, String target) {
        if (PathUtils.isAncestor((String)Preconditions.checkNotNull((Object)source), (String)Preconditions.checkNotNull((Object)target))) {
            return false;
        }
        if (source.equals(target)) {
            return true;
        }
        if (!this.getNode(source).exists()) {
            return false;
        }
        NodeState destParent = this.getNode(PathUtils.getParentPath(target));
        if (!destParent.exists()) {
            return false;
        }
        if (destParent.getChildNode(PathUtils.getName(target)).exists()) {
            return false;
        }
        this.branchState.persist().move(source, target);
        return true;
    }

    public boolean copy(String source, String target) {
        if (!this.getNode((String)Preconditions.checkNotNull((Object)source)).exists()) {
            return false;
        }
        NodeState destParent = this.getNode(PathUtils.getParentPath((String)Preconditions.checkNotNull((Object)target)));
        if (!destParent.exists()) {
            return false;
        }
        if (destParent.getChildNode(PathUtils.getName(target)).exists()) {
            return false;
        }
        this.branchState.persist().copy(source, target);
        return true;
    }

    @Override
    @Nonnull
    public NodeState getBase() {
        return this.branchState.getBase();
    }

    @Override
    @Nonnull
    public NodeState getHead() {
        return this.branchState.getHead();
    }

    @Override
    public void setRoot(NodeState newRoot) {
        this.branchState.setRoot((NodeState)Preconditions.checkNotNull((Object)newRoot));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public NodeState merge(@Nonnull CommitHook hook, @Nonnull CommitInfo info) throws CommitFailedException {
        try {
            return this.merge0(hook, info);
        }
        catch (CommitFailedException e) {
            if (!e.isOfType("Merge")) {
                throw e;
            }
            Lock lock = null;
            try {
                lock = this.acquireMergeLock(true);
            }
            catch (InterruptedException e2) {
                // empty catch block
            }
            try {
                NodeState nodeState = this.merge0(hook, info);
                return nodeState;
            }
            finally {
                if (lock != null) {
                    lock.unlock();
                }
            }
        }
    }

    @Override
    public void rebase() {
        this.branchState.rebase();
    }

    public String toString() {
        return this.branchState.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nonnull
    private NodeState merge0(@Nonnull CommitHook hook, @Nonnull CommitInfo info) throws CommitFailedException {
        Throwable ex = null;
        long time = System.currentTimeMillis();
        int numRetries = 0;
        long backoff = 50L;
        while (true) {
            long start;
            if (backoff > this.maximumBackoff) {
                time = System.currentTimeMillis() - time;
                String msg = ex.getMessage() + " (retries " + numRetries + ", " + time + " ms)";
                throw new CommitFailedException(((CommitFailedException)ex).getSource(), ((CommitFailedException)ex).getType(), ((CommitFailedException)ex).getCode(), msg, ex.getCause());
            }
            if (ex != null) {
                try {
                    start = perfLogger.start();
                    Thread.sleep(backoff + (long)RANDOM.nextInt((int)Math.min(backoff, Integer.MAX_VALUE)));
                    perfLogger.end(start, 1L, "Merge - Retry attempt [{}]", (Object)(++numRetries));
                }
                catch (InterruptedException e) {
                    throw new CommitFailedException("Merge", 3, "Merge interrupted", e);
                }
            }
            try {
                start = perfLogger.start();
                Lock lock = this.acquireMergeLock(false);
                try {
                    perfLogger.end(start, 1L, "Merge - Acquired lock", new Object[0]);
                    NodeState nodeState = this.branchState.merge((CommitHook)Preconditions.checkNotNull((Object)hook), (CommitInfo)Preconditions.checkNotNull((Object)info));
                    return nodeState;
                }
                catch (CommitFailedException e) {
                    LOG.trace("Merge Error", (Throwable)e);
                    ex = e;
                    if (!e.isOfType("Merge")) {
                        throw e;
                    }
                }
                finally {
                    if (lock != null) {
                        lock.unlock();
                    }
                }
            }
            catch (InterruptedException e) {
                throw new CommitFailedException("Oak", 1, "Unable to acquire merge lock", e);
            }
            backoff *= 2L;
        }
    }

    @CheckForNull
    private Lock acquireMergeLock(boolean exclusive) throws InterruptedException {
        Lock lock = exclusive ? this.mergeLock.writeLock() : this.mergeLock.readLock();
        boolean acquired = lock.tryLock(this.maxLockTryTimeMS, TimeUnit.MILLISECONDS);
        if (!acquired) {
            String mode = exclusive ? "exclusive" : "shared";
            LOG.info("Time out while acquiring merge lock ({})", (Object)mode);
            lock = null;
        }
        return lock;
    }

    private DocumentNodeState persist(final NodeState toPersist, final DocumentNodeState base, CommitInfo info) {
        return this.persist(new Changes(){

            @Override
            public void with(Commit c) {
                toPersist.compareAgainstBaseState(base, new CommitDiff(DocumentNodeStoreBranch.this.store, c, DocumentNodeStoreBranch.this.store.getBlobSerializer()));
            }
        }, base, info);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DocumentNodeState persist(Changes op, DocumentNodeState base, CommitInfo info) {
        Revision rev;
        boolean success = false;
        Commit c = this.store.newCommit(base.getRevision(), this);
        try {
            op.with(c);
            if (c.isEmpty()) {
                DocumentNodeState documentNodeState = base;
                return documentNodeState;
            }
            rev = c.apply();
            success = true;
        }
        finally {
            if (success) {
                this.store.done(c, base.getRevision().isBranch(), info);
            } else {
                this.store.canceled(c);
            }
        }
        return this.store.getRoot(rev);
    }

    private NodeState getNode(String path) {
        NodeState node = this.getHead();
        for (String name : PathUtils.elements(path)) {
            node = node.getChildNode(name);
        }
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T withCurrentBranch(Callable<T> callable) throws Exception {
        Thread t = Thread.currentThread();
        DocumentNodeStoreBranch previous = BRANCHES.putIfAbsent(t, this);
        try {
            T t2 = callable.call();
            return t2;
        }
        finally {
            if (previous == null) {
                BRANCHES.remove(t, this);
            }
        }
    }

    @CheckForNull
    static DocumentNodeStoreBranch getCurrentBranch() {
        return (DocumentNodeStoreBranch)BRANCHES.get(Thread.currentThread());
    }

    private class ResetFailed
    extends BranchState {
        private final CommitFailedException ex;

        protected ResetFailed(DocumentNodeState base, CommitFailedException e) {
            super(base);
            this.ex = e;
        }

        @Override
        @Nonnull
        NodeState getHead() {
            throw new IllegalStateException("Branch with failed reset", this.ex);
        }

        @Override
        void setRoot(NodeState root) {
            throw new IllegalStateException("Branch with failed reset", this.ex);
        }

        @Override
        void rebase() {
            throw new IllegalStateException("Branch with failed reset", this.ex);
        }

        @Override
        @Nonnull
        NodeState merge(@Nonnull CommitHook hook, @Nonnull CommitInfo info) throws CommitFailedException {
            throw this.ex;
        }
    }

    private class Merged
    extends BranchState {
        protected Merged(DocumentNodeState base) {
            super(base);
        }

        public String toString() {
            return "Merged[" + this.base + ']';
        }

        @Override
        @Nonnull
        NodeState getHead() {
            throw new IllegalStateException("Branch has already been merged");
        }

        @Override
        void setRoot(NodeState root) {
            throw new IllegalStateException("Branch has already been merged");
        }

        @Override
        void rebase() {
            throw new IllegalStateException("Branch has already been merged");
        }

        @Override
        @Nonnull
        NodeState merge(@Nonnull CommitHook hook, @Nonnull CommitInfo info) {
            throw new IllegalStateException("Branch has already been merged");
        }
    }

    private class Persisted
    extends BranchState {
        private DocumentNodeState head;

        public String toString() {
            return "Persisted[" + this.base + ", " + this.head + ']';
        }

        Persisted(DocumentNodeState base) {
            super(base);
            this.head = this.createBranch(base);
        }

        Persisted(DocumentNodeState base, DocumentNodeState head) {
            super(base);
            this.createBranch(base);
            this.head = head;
        }

        final DocumentNodeState createBranch(DocumentNodeState state) {
            return DocumentNodeStoreBranch.this.store.getRoot(state.getRevision().asBranchRevision());
        }

        void move(String source, final String target) {
            final DocumentNodeState src = DocumentNodeStoreBranch.this.store.getNode(source, this.head.getRevision());
            Preconditions.checkNotNull((Object)src, (String)"Source node %s@%s does not exist", (Object[])new Object[]{source, this.head.getRevision()});
            this.head = DocumentNodeStoreBranch.this.persist(new Changes(){

                @Override
                public void with(Commit c) {
                    DocumentNodeStoreBranch.this.store.moveNode(src, target, c);
                }
            }, this.head, null);
        }

        void copy(String source, final String target) {
            final DocumentNodeState src = DocumentNodeStoreBranch.this.store.getNode(source, this.head.getRevision());
            Preconditions.checkNotNull((Object)src, (String)"Source node %s@%s does not exist", (Object[])new Object[]{source, this.head.getRevision()});
            this.head = DocumentNodeStoreBranch.this.persist(new Changes(){

                @Override
                public void with(Commit c) {
                    DocumentNodeStoreBranch.this.store.copyNode(src, target, c);
                }
            }, this.head, null);
        }

        @Override
        @Nonnull
        NodeState getHead() {
            return this.head;
        }

        @Override
        void setRoot(NodeState root) {
            if (!this.head.equals(root)) {
                this.persistTransientHead(root);
            }
        }

        @Override
        void rebase() {
            DocumentNodeState root = DocumentNodeStoreBranch.this.store.getRoot();
            this.head = DocumentNodeStoreBranch.this.store.getRoot(DocumentNodeStoreBranch.this.store.rebase(this.head.getRevision(), root.getRevision()));
            this.base = root;
        }

        @Override
        @Nonnull
        NodeState merge(final @Nonnull CommitHook hook, final @Nonnull CommitInfo info) throws CommitFailedException {
            boolean success = false;
            DocumentNodeState previousHead = this.head;
            try {
                this.rebase();
                previousHead = this.head;
                DocumentNodeStoreBranch.this.dispatcher.contentChanged(this.base, null);
                DocumentNodeState newRoot = (DocumentNodeState)DocumentNodeStoreBranch.this.withCurrentBranch(new Callable<DocumentNodeState>(){

                    @Override
                    public DocumentNodeState call() throws Exception {
                        NodeState toCommit = ((CommitHook)Preconditions.checkNotNull((Object)hook)).processCommit(Persisted.this.base, Persisted.this.head, info);
                        Persisted.this.head = DocumentNodeStoreBranch.this.persist(toCommit, Persisted.this.head, info);
                        return DocumentNodeStoreBranch.this.store.getRoot(DocumentNodeStoreBranch.this.store.merge(Persisted.this.head.getRevision(), info));
                    }
                });
                DocumentNodeStoreBranch.this.branchState = new Merged(this.base);
                success = true;
                DocumentNodeStoreBranch.this.dispatcher.contentChanged(newRoot, info);
                DocumentNodeState documentNodeState = newRoot;
                return documentNodeState;
            }
            catch (CommitFailedException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CommitFailedException("Merge", 1, "Failed to merge changes to the underlying store", e);
            }
            finally {
                if (!success) {
                    this.resetBranch(this.head, previousHead);
                }
                DocumentNodeStoreBranch.this.dispatcher.contentChanged(DocumentNodeStoreBranch.this.store.getRoot(), null);
            }
        }

        private void persistTransientHead(NodeState newHead) {
            this.head = DocumentNodeStoreBranch.this.persist(newHead, this.head, null);
        }

        private void resetBranch(DocumentNodeState branchHead, DocumentNodeState ancestor) {
            try {
                this.head = DocumentNodeStoreBranch.this.store.getRoot(DocumentNodeStoreBranch.this.store.reset(branchHead.getRevision(), ancestor.getRevision(), DocumentNodeStoreBranch.this));
            }
            catch (Exception e) {
                CommitFailedException ex = new CommitFailedException("Oak", 100, "Branch reset failed", e);
                DocumentNodeStoreBranch.this.branchState = new ResetFailed(this.base, ex);
            }
        }
    }

    private class InMemory
    extends BranchState {
        private NodeState head;

        public String toString() {
            return "InMemory[" + this.base + ", " + this.head + ']';
        }

        InMemory(DocumentNodeState base, NodeState head) {
            super(base);
            this.head = head;
        }

        @Override
        @Nonnull
        NodeState getHead() {
            return this.head;
        }

        @Override
        void setRoot(NodeState root) {
            if (this.base.equals(root)) {
                DocumentNodeStoreBranch.this.branchState = new Unmodified(this.base);
            } else if (!this.head.equals(root)) {
                this.head = root;
                this.persist();
            }
        }

        @Override
        void rebase() {
            DocumentNodeState root = DocumentNodeStoreBranch.this.store.getRoot();
            NodeBuilder builder = root.builder();
            this.head.compareAgainstBaseState(this.base, new ConflictAnnotatingRebaseDiff(builder));
            this.head = builder.getNodeState();
            this.base = root;
        }

        /*
         * Exception decompiling
         */
        @Override
        @Nonnull
        NodeState merge(@Nonnull CommitHook hook, @Nonnull CommitInfo info) throws CommitFailedException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }

    private class Unmodified
    extends BranchState {
        Unmodified(DocumentNodeState base) {
            super(base);
        }

        public String toString() {
            return "Unmodified[" + this.base + ']';
        }

        @Override
        @Nonnull
        NodeState getHead() {
            return this.base;
        }

        @Override
        void setRoot(NodeState root) {
            if (!this.base.equals(root)) {
                DocumentNodeStoreBranch.this.branchState = new InMemory(this.base, root);
            }
        }

        @Override
        void rebase() {
            this.base = DocumentNodeStoreBranch.this.store.getRoot();
        }

        @Override
        @Nonnull
        NodeState merge(@Nonnull CommitHook hook, @Nonnull CommitInfo info) {
            DocumentNodeStoreBranch.this.branchState = new Merged(this.base);
            return this.base;
        }
    }

    private abstract class BranchState {
        protected DocumentNodeState base;

        protected BranchState(DocumentNodeState base) {
            this.base = base;
        }

        Persisted persist() {
            Persisted p = new Persisted(this.base);
            p.persistTransientHead(this.getHead());
            DocumentNodeStoreBranch.this.branchState = p;
            return p;
        }

        DocumentNodeState getBase() {
            return this.base;
        }

        @Nonnull
        abstract NodeState getHead();

        abstract void setRoot(NodeState var1);

        abstract void rebase();

        @Nonnull
        abstract NodeState merge(@Nonnull CommitHook var1, @Nonnull CommitInfo var2) throws CommitFailedException;
    }

    private static interface Changes {
        public void with(Commit var1);
    }
}

