/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.jackrabbit.oak.plugins.document.Branch;
import org.apache.jackrabbit.oak.plugins.document.Revision;
import org.apache.jackrabbit.oak.plugins.document.util.Utils;

final class LastRevs {
    private final Map<Integer, Revision> revs;
    private final Revision readRevision;
    private final Branch branch;
    private Revision branchRev;

    LastRevs(Map<Integer, Revision> revs, Revision readRevision, Branch branch) {
        this.revs = new HashMap<Integer, Revision>(revs);
        this.readRevision = readRevision;
        this.branch = branch;
    }

    void update(@Nullable Revision rev) {
        if (rev == null) {
            return;
        }
        Revision r = this.revs.get(rev.getClusterId());
        if (r == null || rev.compareRevisionTime(r) > 0) {
            this.revs.put(rev.getClusterId(), rev);
        }
    }

    void updateBranch(@Nullable Revision rev) {
        if (rev == null) {
            return;
        }
        rev = rev.asBranchRevision();
        if (this.branch != null && this.branch.containsCommit(rev) && this.readRevision.compareRevisionTime(rev) >= 0) {
            this.branchRev = Utils.max(this.branchRev, rev);
        }
    }

    @CheckForNull
    Revision getBranchRevision() {
        return this.branchRev;
    }

    @Nonnull
    Map<Integer, Revision> get() {
        return this.revs;
    }
}

