/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.cache.Cache;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.jackrabbit.oak.cache.CacheStats;
import org.apache.jackrabbit.oak.cache.CacheValue;
import org.apache.jackrabbit.oak.plugins.document.DiffCache;
import org.apache.jackrabbit.oak.plugins.document.DocumentMK;
import org.apache.jackrabbit.oak.plugins.document.Revision;
import org.apache.jackrabbit.oak.plugins.document.util.StringValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalDiffCache
implements DiffCache {
    private static int MAX_ENTRY_SIZE = 0x1000000;
    private static final String NO_DIFF = "";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Cache<StringValue, ConsolidatedDiff> diffCache;
    private final CacheStats diffCacheStats;

    public LocalDiffCache(DocumentMK.Builder builder) {
        this.diffCache = builder.buildConsolidatedDiffCache();
        this.diffCacheStats = new CacheStats(this.diffCache, "Document-Diff2", builder.getWeigher(), builder.getDiffCacheSize());
    }

    @Override
    public String getChanges(@Nonnull Revision from, @Nonnull Revision to, @Nonnull String path, @Nullable DiffCache.Loader loader) {
        ConsolidatedDiff diff = (ConsolidatedDiff)this.diffCache.getIfPresent((Object)new StringValue(to.toString()));
        if (diff != null) {
            String result = diff.get(path);
            if (result == null) {
                return NO_DIFF;
            }
            return result;
        }
        this.log.debug("Did not got the diff for local change in the cache for change {} => {} ", (Object)from, (Object)to);
        return null;
    }

    ConsolidatedDiff getDiff(@Nonnull Revision from, @Nonnull Revision to) {
        return (ConsolidatedDiff)this.diffCache.getIfPresent((Object)new StringValue(to.toString()));
    }

    @Override
    @Nonnull
    public DiffCache.Entry newEntry(@Nonnull Revision from, final @Nonnull Revision to) {
        return new DiffCache.Entry(){
            private final Map<String, String> changesPerPath = Maps.newHashMap();
            private int size;

            @Override
            public void append(@Nonnull String path, @Nonnull String changes) {
                if (this.exceedsSize()) {
                    return;
                }
                this.size += LocalDiffCache.size(path) + LocalDiffCache.size(changes);
                this.changesPerPath.put(path, changes);
            }

            @Override
            public boolean done() {
                if (this.exceedsSize()) {
                    return false;
                }
                LocalDiffCache.this.diffCache.put((Object)new StringValue(to.toString()), (Object)new ConsolidatedDiff(this.changesPerPath, this.size));
                return true;
            }

            private boolean exceedsSize() {
                return this.size > MAX_ENTRY_SIZE;
            }
        };
    }

    public CacheStats getDiffCacheStats() {
        return this.diffCacheStats;
    }

    private static int size(String s) {
        return 56 + s.length() * 2;
    }

    public static final class ConsolidatedDiff
    implements CacheValue {
        static final Joiner.MapJoiner mapJoiner = Joiner.on((String)"//").withKeyValueSeparator("**");
        static final Splitter.MapSplitter splitter = Splitter.on((String)"//").withKeyValueSeparator("**");
        private final Map<String, String> changes;
        private int memory;

        public ConsolidatedDiff(Map<String, String> changes, int memory) {
            this.changes = changes;
            this.memory = memory;
        }

        public static ConsolidatedDiff fromString(String value) {
            if (value.isEmpty()) {
                return new ConsolidatedDiff(Collections.<String, String>emptyMap(), 0);
            }
            return new ConsolidatedDiff(splitter.split((CharSequence)value), 0);
        }

        public String asString() {
            return mapJoiner.join(this.changes);
        }

        @Override
        public int getMemory() {
            if (this.memory == 0) {
                int m = 0;
                for (Map.Entry<String, String> e : this.changes.entrySet()) {
                    m += LocalDiffCache.size(e.getKey()) + LocalDiffCache.size(e.getValue());
                }
                this.memory = m;
            }
            return this.memory;
        }

        public String toString() {
            return this.changes.toString();
        }

        String get(String path) {
            return this.changes.get(path);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ConsolidatedDiff that = (ConsolidatedDiff)o;
            return this.changes.equals(that.changes);
        }

        public int hashCode() {
            return this.changes.hashCode();
        }
    }
}

