/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document;

import com.google.common.base.Preconditions;
import com.google.common.cache.Cache;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.jackrabbit.oak.cache.CacheStats;
import org.apache.jackrabbit.oak.plugins.document.DiffCache;
import org.apache.jackrabbit.oak.plugins.document.DocumentMK;
import org.apache.jackrabbit.oak.plugins.document.PathRev;
import org.apache.jackrabbit.oak.plugins.document.Revision;
import org.apache.jackrabbit.oak.plugins.document.util.StringValue;

public class MemoryDiffCache
implements DiffCache {
    protected final Cache<PathRev, StringValue> diffCache;
    protected final CacheStats diffCacheStats;

    protected MemoryDiffCache(DocumentMK.Builder builder) {
        this.diffCache = builder.buildDiffCache();
        this.diffCacheStats = new CacheStats(this.diffCache, "Document-Diff", builder.getWeigher(), builder.getDiffCacheSize());
    }

    @Override
    @CheckForNull
    public String getChanges(@Nonnull Revision from, @Nonnull Revision to, @Nonnull String path, final @Nullable DiffCache.Loader loader) {
        StringValue diff;
        PathRev key = MemoryDiffCache.diffCacheKey(path, from, to);
        if (loader == null) {
            diff = (StringValue)this.diffCache.getIfPresent((Object)key);
        } else {
            try {
                diff = (StringValue)this.diffCache.get((Object)key, (Callable)new Callable<StringValue>(){

                    @Override
                    public StringValue call() throws Exception {
                        return new StringValue(loader.call());
                    }
                });
            }
            catch (ExecutionException e) {
                diff = new StringValue(loader.call());
            }
        }
        return diff != null ? diff.toString() : null;
    }

    @Override
    @Nonnull
    public DiffCache.Entry newEntry(@Nonnull Revision from, @Nonnull Revision to) {
        return new MemoryEntry(from, to);
    }

    public CacheStats getDiffCacheStats() {
        return this.diffCacheStats;
    }

    private static PathRev diffCacheKey(@Nonnull String path, @Nonnull Revision from, @Nonnull Revision to) {
        return new PathRev(from + path, to);
    }

    protected class MemoryEntry
    implements DiffCache.Entry {
        private final Revision from;
        private final Revision to;

        protected MemoryEntry(Revision from, Revision to) {
            this.from = (Revision)Preconditions.checkNotNull((Object)from);
            this.to = (Revision)Preconditions.checkNotNull((Object)to);
        }

        @Override
        public void append(@Nonnull String path, @Nonnull String changes) {
            PathRev key = MemoryDiffCache.diffCacheKey(path, this.from, this.to);
            MemoryDiffCache.this.diffCache.put((Object)key, (Object)new StringValue(changes));
        }

        @Override
        public boolean done() {
            return true;
        }
    }
}

