/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import com.google.common.collect.Queues;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Queue;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.jackrabbit.oak.cache.CacheValue;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.commons.json.JsopBuilder;
import org.apache.jackrabbit.oak.commons.json.JsopTokenizer;
import org.apache.jackrabbit.oak.commons.json.JsopWriter;
import org.apache.jackrabbit.oak.plugins.document.Branch;
import org.apache.jackrabbit.oak.plugins.document.CachedNodeDocument;
import org.apache.jackrabbit.oak.plugins.document.Collection;
import org.apache.jackrabbit.oak.plugins.document.CollisionHandler;
import org.apache.jackrabbit.oak.plugins.document.Document;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeState;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeStore;
import org.apache.jackrabbit.oak.plugins.document.DocumentStore;
import org.apache.jackrabbit.oak.plugins.document.LastRevs;
import org.apache.jackrabbit.oak.plugins.document.PropertyHistory;
import org.apache.jackrabbit.oak.plugins.document.Range;
import org.apache.jackrabbit.oak.plugins.document.Revision;
import org.apache.jackrabbit.oak.plugins.document.RevisionContext;
import org.apache.jackrabbit.oak.plugins.document.SplitOperations;
import org.apache.jackrabbit.oak.plugins.document.StableRevisionComparator;
import org.apache.jackrabbit.oak.plugins.document.UpdateOp;
import org.apache.jackrabbit.oak.plugins.document.ValueMap;
import org.apache.jackrabbit.oak.plugins.document.memory.MemoryDocumentStore;
import org.apache.jackrabbit.oak.plugins.document.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NodeDocument
extends Document
implements CachedNodeDocument {
    public static final NodeDocument NULL = new NodeDocument(new MemoryDocumentStore());
    static final Logger LOG;
    public static final String MIN_ID_VALUE = "0000000";
    public static final String MAX_ID_VALUE = ";";
    static final int SPLIT_CANDIDATE_THRESHOLD = 8192;
    static final int DOC_SIZE_THRESHOLD = 262144;
    static final int NUM_REVS_THRESHOLD = 100;
    static final float SPLIT_RATIO = 0.3f;
    static final int PREV_SPLIT_FACTOR = 10;
    public static final String COLLISIONS = "_collisions";
    public static final String MODIFIED_IN_SECS = "_modified";
    static final int MODIFIED_IN_SECS_RESOLUTION = 5;
    private static final NavigableMap<Revision, Range> EMPTY_RANGE_MAP;
    static final String COMMIT_ROOT = "_commitRoot";
    private static final String PREVIOUS = "_prev";
    private static final String DELETED = "_deleted";
    public static final String DELETED_ONCE = "_deletedOnce";
    static final String REVISIONS = "_revisions";
    private static final String LAST_REV = "_lastRev";
    private static final String CHILDREN_FLAG = "_children";
    public static final String PATH = "_path";
    public static final String HAS_BINARY_FLAG = "_bin";
    private static final String STALE_PREV = "_stalePrev";
    public static final String SD_TYPE = "_sdType";
    public static final String SD_MAX_REV_TIME_IN_SECS = "_sdMaxRevTime";
    public static final long HAS_BINARY_VAL = 1L;
    final DocumentStore store;
    private NavigableMap<Revision, Range> previous;
    private final AtomicLong lastCheckTime = new AtomicLong(System.currentTimeMillis());
    private final long creationTime;

    public static long getModifiedInSecs(long timestamp) {
        long timeInSec = TimeUnit.MILLISECONDS.toSeconds(timestamp);
        return timeInSec - timeInSec % 5L;
    }

    NodeDocument(@Nonnull DocumentStore store) {
        this(store, System.currentTimeMillis());
    }

    public NodeDocument(@Nonnull DocumentStore store, long creationTime) {
        this.store = (DocumentStore)Preconditions.checkNotNull((Object)store);
        this.creationTime = creationTime;
    }

    @Nonnull
    public Map<Revision, String> getValueMap(@Nonnull String key) {
        return ValueMap.create(this, key);
    }

    @Override
    public long getCreated() {
        return this.creationTime;
    }

    public boolean hasChildren() {
        Boolean childrenFlag = (Boolean)this.get(CHILDREN_FLAG);
        return childrenFlag != null && childrenFlag != false;
    }

    public boolean wasDeletedOnce() {
        Boolean deletedOnceFlag = (Boolean)this.get(DELETED_ONCE);
        return deletedOnceFlag != null && deletedOnceFlag != false;
    }

    public boolean hasBeenModifiedSince(long lastModifiedTime) {
        Long modified = (Long)this.get(MODIFIED_IN_SECS);
        return modified != null && modified > TimeUnit.MILLISECONDS.toSeconds(lastModifiedTime);
    }

    public boolean hasAllRevisionLessThan(long maxRevisionTime) {
        Long maxRevTimeStamp = (Long)this.get(SD_MAX_REV_TIME_IN_SECS);
        return maxRevTimeStamp != null && maxRevTimeStamp < TimeUnit.MILLISECONDS.toSeconds(maxRevisionTime);
    }

    public boolean isSplitDocument() {
        return this.getSplitDocType() != SplitDocType.NONE;
    }

    public SplitDocType getSplitDocType() {
        Object t = this.get(SD_TYPE);
        return t == null ? SplitDocType.valueOf((Integer)null) : SplitDocType.valueOf(((Number)t).intValue());
    }

    @Override
    public void markUpToDate(long checkTime) {
        this.lastCheckTime.set(checkTime);
    }

    @Override
    public boolean isUpToDate(long lastCheckTime) {
        return lastCheckTime <= this.lastCheckTime.get();
    }

    @Override
    public long getLastCheckTime() {
        return this.lastCheckTime.get();
    }

    public boolean hasBinary() {
        Number flag = (Number)this.get(HAS_BINARY_FLAG);
        if (flag == null) {
            return false;
        }
        return (long)flag.intValue() == 1L;
    }

    @Nonnull
    public String getMainPath() {
        String p = this.getPath();
        if (p.startsWith("p")) {
            if ((p = PathUtils.getAncestorPath(p, 2)).length() == 1) {
                return "/";
            }
            return p.substring(1);
        }
        return p;
    }

    @Nonnull
    public Map<Integer, Revision> getLastRev() {
        HashMap map = Maps.newHashMap();
        SortedMap<Revision, String> valueMap = this.getLocalMap(LAST_REV);
        for (Map.Entry e : valueMap.entrySet()) {
            int clusterId = ((Revision)e.getKey()).getClusterId();
            Revision rev = Revision.fromString((String)e.getValue());
            map.put(clusterId, rev);
        }
        return map;
    }

    public boolean isCommitted(@Nonnull Revision revision) {
        NodeDocument commitRootDoc = this.getCommitRoot((Revision)Preconditions.checkNotNull((Object)revision));
        if (commitRootDoc == null) {
            return false;
        }
        String value = (String)commitRootDoc.getLocalRevisions().get(revision);
        if (value != null) {
            return Utils.isCommitted(value);
        }
        for (NodeDocument prev : commitRootDoc.getPreviousDocs(REVISIONS, revision)) {
            if (!prev.containsRevision(revision)) continue;
            return prev.isCommitted(revision);
        }
        return false;
    }

    @CheckForNull
    public Revision getCommitRevision(@Nonnull Revision revision) {
        NodeDocument commitRoot = this.getCommitRoot((Revision)Preconditions.checkNotNull((Object)revision));
        if (commitRoot == null) {
            return null;
        }
        String value = commitRoot.getCommitValue(revision);
        if (Utils.isCommitted(value)) {
            return Utils.resolveCommitRevision(revision, value);
        }
        return null;
    }

    public boolean containsRevision(@Nonnull Revision revision) {
        if (this.getLocalRevisions().containsKey(revision)) {
            return true;
        }
        for (NodeDocument prev : this.getPreviousDocs(REVISIONS, revision)) {
            if (!prev.containsRevision(revision)) continue;
            return true;
        }
        return false;
    }

    int purgeUncommittedRevisions(RevisionContext context) {
        SortedMap<Revision, String> valueMap = this.getLocalRevisions();
        UpdateOp op = new UpdateOp(this.getId(), false);
        int purgeCount = 0;
        for (Map.Entry commit : valueMap.entrySet()) {
            Revision r;
            if (Utils.isCommitted((String)commit.getValue()) || (r = (Revision)commit.getKey()).getClusterId() != context.getClusterId()) continue;
            ++purgeCount;
            op.removeMapEntry(REVISIONS, r);
        }
        if (op.hasChanges()) {
            this.store.findAndUpdate(Collection.NODES, op);
        }
        return purgeCount;
    }

    int purgeCollisionMarkers(RevisionContext context) {
        SortedMap<Revision, String> valueMap = this.getLocalMap(COLLISIONS);
        UpdateOp op = new UpdateOp(this.getId(), false);
        int purgeCount = 0;
        for (Map.Entry commit : valueMap.entrySet()) {
            Revision r = (Revision)commit.getKey();
            if (r.getClusterId() != context.getClusterId()) continue;
            ++purgeCount;
            NodeDocument.removeCollision(op, r);
        }
        if (op.hasChanges()) {
            this.store.findAndUpdate(Collection.NODES, op);
        }
        return purgeCount;
    }

    @CheckForNull
    public String getCommitRootPath(Revision revision) {
        String depth = this.getCommitRootDepth(revision);
        if (depth != null) {
            return this.getPathAtDepth(depth);
        }
        return null;
    }

    @CheckForNull
    public Revision getNewestRevision(final RevisionContext context, final Revision changeRev, final CollisionHandler handler) {
        final HashMap validRevisions = Maps.newHashMap();
        Predicate<Revision> predicate = new Predicate<Revision>(){

            public boolean apply(Revision input) {
                if (input.equals(changeRev)) {
                    return false;
                }
                if (NodeDocument.this.isValidRevision(context, input, null, changeRev, validRevisions)) {
                    return true;
                }
                handler.concurrentModification(input);
                return false;
            }
        };
        Revision newestRev = null;
        SortedMap<Revision, String> revisions = this.getLocalRevisions();
        SortedMap<Revision, String> commitRoots = this.getLocalCommitRoot();
        Iterator it = Iterables.filter((Iterable)Iterables.mergeSorted((Iterable)ImmutableList.of(revisions.keySet(), commitRoots.keySet()), revisions.comparator()), (Predicate)predicate).iterator();
        if (it.hasNext()) {
            newestRev = (Revision)it.next();
        } else {
            it = Iterables.filter((Iterable)Iterables.mergeSorted((Iterable)ImmutableList.of(this.getValueMap(REVISIONS).keySet(), this.getValueMap(COMMIT_ROOT).keySet()), revisions.comparator()), (Predicate)predicate).iterator();
            if (it.hasNext()) {
                newestRev = (Revision)it.next();
            }
        }
        if (newestRev == null) {
            return null;
        }
        SortedMap<Revision, String> deleted = this.getLocalDeleted();
        String value = (String)deleted.get(newestRev);
        if (value == null && deleted.headMap(newestRev).isEmpty()) {
            return newestRev;
        }
        if (value == null) {
            value = this.getDeleted().get(newestRev);
        }
        if ("true".equals(value)) {
            return null;
        }
        return newestRev;
    }

    boolean isValidRevision(@Nonnull RevisionContext context, @Nonnull Revision rev, @Nullable String commitValue, @Nonnull Revision readRevision, @Nonnull Map<Revision, String> validRevisions) {
        if (validRevisions.containsKey(rev)) {
            return true;
        }
        NodeDocument doc = this.getCommitRoot(rev);
        if (doc == null) {
            return false;
        }
        if (doc.isCommitted(context, rev, commitValue, readRevision)) {
            validRevisions.put(rev, commitValue);
            return true;
        }
        return false;
    }

    @CheckForNull
    public DocumentNodeState getNodeAtRevision(@Nonnull DocumentNodeStore nodeStore, @Nonnull Revision readRevision, @Nullable Revision lastModified) {
        HashMap validRevisions = Maps.newHashMap();
        Branch branch = nodeStore.getBranches().getBranch(readRevision);
        LastRevs lastRevs = new LastRevs(this.getLastRev(), readRevision, branch);
        lastRevs.update(lastModified);
        Revision min = this.getLiveRevision(nodeStore, readRevision, validRevisions, lastRevs);
        if (min == null) {
            return null;
        }
        String path = this.getPath();
        DocumentNodeState n = new DocumentNodeState(nodeStore, path, readRevision, this.hasChildren());
        Revision lastRevision = min;
        for (String key : this.keySet()) {
            Revision newestPrev;
            Revision newest;
            SortedMap<Revision, String> local;
            if (!Utils.isPropertyName(key) || (local = this.getLocalMap(key)).isEmpty()) continue;
            Value value = this.getLatestValue(nodeStore, local, min, readRevision, validRevisions, lastRevs);
            if (!this.getPreviousRanges().isEmpty() && Utils.isRevisionNewer(nodeStore, newest = local.firstKey(), value.revision) && Utils.isRevisionNewer(nodeStore, newestPrev = (Revision)this.getPreviousRanges().firstKey(), value.revision)) {
                value = null;
            }
            if (value == null && !this.getPreviousRanges().isEmpty()) {
                value = this.getLatestValue(nodeStore, this.getValueMap(key), min, readRevision, validRevisions, lastRevs);
            }
            String propertyName = Utils.unescapePropertyName(key);
            String v = value != null ? value.value : null;
            n.setProperty(propertyName, v);
            if (value == null || !Utils.isRevisionNewer(nodeStore, value.revision, lastRevision)) continue;
            lastRevision = value.revision;
        }
        Revision branchBase = null;
        if (branch != null) {
            branchBase = branch.getBase(readRevision);
        }
        for (Revision r : lastRevs.get().values()) {
            if (Utils.isRevisionNewer(nodeStore, r, readRevision)) {
                lastRevision = readRevision;
                continue;
            }
            if (branchBase != null && Utils.isRevisionNewer(nodeStore, r, branchBase)) {
                r = branchBase;
            }
            if (NodeDocument.revisionAreAmbiguous(nodeStore, r, lastRevision)) {
                lastRevision = readRevision;
                continue;
            }
            if (!Utils.isRevisionNewer(nodeStore, r, lastRevision)) continue;
            lastRevision = r;
        }
        if (branch != null) {
            lastRevs.updateBranch(branch.getUnsavedLastRevision(path, readRevision));
            Revision r = lastRevs.getBranchRevision();
            if (r != null) {
                lastRevision = r;
            }
        }
        n.setLastRevision(lastRevision);
        return n;
    }

    @CheckForNull
    public Revision getLiveRevision(RevisionContext context, Revision maxRev, Map<Revision, String> validRevisions, LastRevs lastRevs) {
        Value value = this.getLatestValue(context, this.getLocalDeleted(), null, maxRev, validRevisions, lastRevs);
        if (value.value == null && !this.getPreviousRanges().isEmpty()) {
            value = this.getLatestValue(context, this.getDeleted(), null, maxRev, validRevisions, lastRevs);
        }
        return "false".equals(value.value) ? value.revision : null;
    }

    boolean isConflicting(@Nonnull UpdateOp op, @Nonnull Revision baseRevision, @Nonnull Revision commitRevision, @Nonnull RevisionContext context, boolean enableConcurrentAddRemove) {
        SortedMap<Revision, String> deleted = this.getLocalDeleted();
        boolean allowConflictingDeleteChange = enableConcurrentAddRemove && this.allowConflictingDeleteChange(op);
        for (Map.Entry entry : deleted.entrySet()) {
            if (((Revision)entry.getKey()).equals(commitRevision) || !Utils.isRevisionNewer(context, (Revision)entry.getKey(), baseRevision)) continue;
            boolean newerDeleted = Boolean.parseBoolean((String)entry.getValue());
            if (allowConflictingDeleteChange && op.isDelete() == newerDeleted) continue;
            return true;
        }
        for (Map.Entry<Object, Object> entry : op.getChanges().entrySet()) {
            if (((UpdateOp.Operation)entry.getValue()).type != UpdateOp.Operation.Type.SET_MAP_ENTRY) continue;
            String name = ((UpdateOp.Key)entry.getKey()).getName();
            if (DELETED.equals(name) && !allowConflictingDeleteChange) {
                return true;
            }
            if (!Utils.isPropertyName(name)) continue;
            for (Revision rev : this.getValueMap(name).keySet()) {
                if (rev.equals(commitRevision) || !Utils.isRevisionNewer(context, rev, baseRevision)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean allowConflictingDeleteChange(UpdateOp op) {
        String path = this.getPath();
        if (!Utils.isHiddenPath(path)) {
            return false;
        }
        if (!op.isNew() && !op.isDelete()) {
            return false;
        }
        for (UpdateOp.Key opKey : op.getChanges().keySet()) {
            String name = opKey.getName();
            if (!Utils.isPropertyName(name)) continue;
            return false;
        }
        for (String dataKey : this.keySet()) {
            if (!Utils.isPropertyName(dataKey)) continue;
            return false;
        }
        return true;
    }

    @Nonnull
    public Iterable<UpdateOp> split(@Nonnull RevisionContext context) {
        return SplitOperations.forDocument(this, context);
    }

    @Nonnull
    NavigableMap<Revision, Range> getPreviousRanges() {
        return this.getPreviousRanges(false);
    }

    @Nonnull
    NavigableMap<Revision, Range> getPreviousRanges(boolean includeStale) {
        if (includeStale) {
            return this.createPreviousRanges(true);
        }
        if (this.previous == null) {
            this.previous = this.createPreviousRanges(false);
        }
        return this.previous;
    }

    @Nonnull
    private NavigableMap<Revision, Range> createPreviousRanges(boolean includeStale) {
        NavigableMap ranges;
        SortedMap<Revision, String> map = this.getLocalMap(PREVIOUS);
        if (map.isEmpty()) {
            ranges = EMPTY_RANGE_MAP;
        } else {
            Map stale = Collections.emptyMap();
            if (!includeStale) {
                stale = this.getLocalMap(STALE_PREV);
            }
            TreeMap<Revision, Range> transformed = new TreeMap<Revision, Range>(StableRevisionComparator.REVERSE);
            for (Map.Entry entry : map.entrySet()) {
                Range r = Range.fromEntry((Revision)entry.getKey(), (String)entry.getValue());
                if (String.valueOf(r.height).equals(stale.get(r.high))) continue;
                transformed.put(r.high, r);
            }
            ranges = Maps.unmodifiableNavigableMap(transformed);
        }
        return ranges;
    }

    @Nonnull
    Iterable<NodeDocument> getPreviousDocs(final @Nonnull String property, final @Nullable Revision revision) {
        if (this.getPreviousRanges().isEmpty()) {
            return Collections.emptyList();
        }
        if (revision == null) {
            return new PropertyHistory(this, property);
        }
        String mainPath = this.getMainPath();
        Map.Entry<Revision, Range> entry = this.getPreviousRanges().floorEntry(revision);
        if (entry != null) {
            int h;
            Revision r = entry.getKey();
            String prevId = Utils.getPreviousIdFor(mainPath, r, h = entry.getValue().height);
            NodeDocument prev = this.getPreviousDocument(prevId);
            if (prev != null) {
                if (prev.getValueMap(property).containsKey(revision)) {
                    return Collections.singleton(prev);
                }
            } else {
                LOG.warn("Document with previous revisions not found: " + prevId);
            }
        }
        return Iterables.filter((Iterable)Iterables.transform(this.getPreviousRanges().headMap(revision).entrySet(), (Function)new Function<Map.Entry<Revision, Range>, NodeDocument>(){

            public NodeDocument apply(Map.Entry<Revision, Range> input) {
                if (input.getValue().includes(revision)) {
                    return NodeDocument.this.getPreviousDoc(input.getKey(), input.getValue());
                }
                return null;
            }
        }), (Predicate)new Predicate<NodeDocument>(){

            public boolean apply(@Nullable NodeDocument input) {
                return input != null && input.getValueMap(property).containsKey(revision);
            }
        });
    }

    NodeDocument getPreviousDocument(String prevId) {
        return this.store.find(Collection.NODES, prevId, Integer.MAX_VALUE);
    }

    @Nonnull
    Iterator<NodeDocument> getAllPreviousDocs() {
        if (this.getPreviousRanges().isEmpty()) {
            return Iterators.emptyIterator();
        }
        return new AbstractIterator<NodeDocument>(){
            private Queue<Map.Entry<Revision, Range>> previousRanges;
            {
                this.previousRanges = Queues.newArrayDeque(NodeDocument.this.getPreviousRanges().entrySet());
            }

            protected NodeDocument computeNext() {
                Map.Entry<Revision, Range> e;
                NodeDocument prev;
                if (!this.previousRanges.isEmpty() && (prev = NodeDocument.this.getPreviousDoc((e = this.previousRanges.remove()).getKey(), e.getValue())) != null) {
                    this.previousRanges.addAll(prev.getPreviousRanges().entrySet());
                    return prev;
                }
                return (NodeDocument)this.endOfData();
            }
        };
    }

    private NodeDocument getPreviousDoc(Revision rev, Range range) {
        int h = range.height;
        String prevId = Utils.getPreviousIdFor(this.getMainPath(), rev, h);
        NodeDocument prev = this.getPreviousDocument(prevId);
        if (prev != null) {
            return prev;
        }
        LOG.warn("Document with previous revisions not found: " + prevId);
        return null;
    }

    @Nullable
    NodeDocument findPrevReferencingDoc(Revision revision, int height) {
        for (Range range : this.getPreviousRanges().values()) {
            if (range.getHeight() == height && range.high.equals(revision)) {
                return this;
            }
            if (!range.includes(revision)) continue;
            String prevId = Utils.getPreviousIdFor(this.getMainPath(), range.high, range.height);
            NodeDocument prev = this.store.find(Collection.NODES, prevId);
            if (prev == null) {
                LOG.warn("Split document {} does not exist anymore. Main document is {}", (Object)prevId, (Object)Utils.getIdFromPath(this.getMainPath()));
                continue;
            }
            NodeDocument doc = prev.findPrevReferencingDoc(revision, height);
            if (doc == null) continue;
            return doc;
        }
        return null;
    }

    @Nonnull
    SortedMap<Revision, String> getLocalMap(String key) {
        SortedMap<Revision, String> map = (SortedMap<Revision, String>)this.data.get(key);
        if (map == null) {
            map = ValueMap.EMPTY;
        }
        return map;
    }

    @Nonnull
    SortedMap<Revision, String> getLocalRevisions() {
        return this.getLocalMap(REVISIONS);
    }

    @Nonnull
    SortedMap<Revision, String> getLocalCommitRoot() {
        return this.getLocalMap(COMMIT_ROOT);
    }

    @Nonnull
    SortedMap<Revision, String> getLocalDeleted() {
        return this.getLocalMap(DELETED);
    }

    @Nonnull
    SortedMap<Revision, String> getStalePrev() {
        return this.getLocalMap(STALE_PREV);
    }

    public static void setChildrenFlag(@Nonnull UpdateOp op, boolean hasChildNode) {
        ((UpdateOp)Preconditions.checkNotNull((Object)op)).set(CHILDREN_FLAG, hasChildNode);
    }

    public static void setModified(@Nonnull UpdateOp op, @Nonnull Revision revision) {
        ((UpdateOp)Preconditions.checkNotNull((Object)op)).max(MODIFIED_IN_SECS, Long.valueOf(NodeDocument.getModifiedInSecs(((Revision)Preconditions.checkNotNull((Object)revision)).getTimestamp())));
    }

    public static void setRevision(@Nonnull UpdateOp op, @Nonnull Revision revision, @Nonnull String commitValue) {
        ((UpdateOp)Preconditions.checkNotNull((Object)op)).setMapEntry(REVISIONS, (Revision)Preconditions.checkNotNull((Object)revision), (String)Preconditions.checkNotNull((Object)commitValue));
    }

    public static void unsetRevision(@Nonnull UpdateOp op, @Nonnull Revision revision) {
        ((UpdateOp)Preconditions.checkNotNull((Object)op)).unsetMapEntry(REVISIONS, (Revision)Preconditions.checkNotNull((Object)revision));
    }

    public static boolean isRevisionsEntry(String name) {
        return REVISIONS.equals(name);
    }

    public static boolean isCommitRootEntry(String name) {
        return COMMIT_ROOT.equals(name);
    }

    public static boolean isDeletedEntry(String name) {
        return DELETED.equals(name);
    }

    public static void removeRevision(@Nonnull UpdateOp op, @Nonnull Revision revision) {
        ((UpdateOp)Preconditions.checkNotNull((Object)op)).removeMapEntry(REVISIONS, (Revision)Preconditions.checkNotNull((Object)revision));
    }

    public static void addCollision(@Nonnull UpdateOp op, @Nonnull Revision revision) {
        ((UpdateOp)Preconditions.checkNotNull((Object)op)).setMapEntry(COLLISIONS, (Revision)Preconditions.checkNotNull((Object)revision), String.valueOf(true));
    }

    public static void removeCollision(@Nonnull UpdateOp op, @Nonnull Revision revision) {
        ((UpdateOp)Preconditions.checkNotNull((Object)op)).removeMapEntry(COLLISIONS, (Revision)Preconditions.checkNotNull((Object)revision));
    }

    public static void setLastRev(@Nonnull UpdateOp op, @Nonnull Revision revision) {
        ((UpdateOp)Preconditions.checkNotNull((Object)op)).setMapEntry(LAST_REV, new Revision(0L, 0, revision.getClusterId()), revision.toString());
    }

    public static void setCommitRoot(@Nonnull UpdateOp op, @Nonnull Revision revision, int commitRootDepth) {
        ((UpdateOp)Preconditions.checkNotNull((Object)op)).setMapEntry(COMMIT_ROOT, (Revision)Preconditions.checkNotNull((Object)revision), String.valueOf(commitRootDepth));
    }

    public static void removeCommitRoot(@Nonnull UpdateOp op, @Nonnull Revision revision) {
        ((UpdateOp)Preconditions.checkNotNull((Object)op)).removeMapEntry(COMMIT_ROOT, revision);
    }

    public static void setDeleted(@Nonnull UpdateOp op, @Nonnull Revision revision, boolean deleted) {
        if (deleted) {
            ((UpdateOp)Preconditions.checkNotNull((Object)op)).set(DELETED_ONCE, Boolean.TRUE);
        }
        ((UpdateOp)Preconditions.checkNotNull((Object)op)).setMapEntry(DELETED, (Revision)Preconditions.checkNotNull((Object)revision), String.valueOf(deleted));
    }

    public static void removeDeleted(@Nonnull UpdateOp op, @Nonnull Revision revision) {
        ((UpdateOp)Preconditions.checkNotNull((Object)op)).removeMapEntry(DELETED, revision);
    }

    public static void setPrevious(@Nonnull UpdateOp op, @Nonnull Range range) {
        ((UpdateOp)Preconditions.checkNotNull((Object)op)).setMapEntry(PREVIOUS, ((Range)Preconditions.checkNotNull((Object)range)).high, range.getLowValue());
    }

    public static void removePrevious(@Nonnull UpdateOp op, @Nonnull Range range) {
        NodeDocument.removePrevious(op, ((Range)Preconditions.checkNotNull((Object)range)).high);
    }

    public static void removePrevious(@Nonnull UpdateOp op, @Nonnull Revision revision) {
        ((UpdateOp)Preconditions.checkNotNull((Object)op)).removeMapEntry(PREVIOUS, (Revision)Preconditions.checkNotNull((Object)revision));
    }

    public static void setStalePrevious(@Nonnull UpdateOp op, @Nonnull Revision revision, int height) {
        ((UpdateOp)Preconditions.checkNotNull((Object)op)).setMapEntry(STALE_PREV, (Revision)Preconditions.checkNotNull((Object)revision), String.valueOf(height));
    }

    public static void removeStalePrevious(@Nonnull UpdateOp op, @Nonnull Revision revision) {
        ((UpdateOp)Preconditions.checkNotNull((Object)op)).removeMapEntry(STALE_PREV, (Revision)Preconditions.checkNotNull((Object)revision));
    }

    public static void setHasBinary(@Nonnull UpdateOp op) {
        ((UpdateOp)Preconditions.checkNotNull((Object)op)).set(HAS_BINARY_FLAG, 1L);
    }

    static boolean revisionAreAmbiguous(@Nonnull RevisionContext context, @Nonnull Revision r1, @Nonnull Revision r2) {
        if (r1.getClusterId() == r2.getClusterId()) {
            return false;
        }
        int c1 = context.getRevisionComparator().compare(r1, r2);
        int c2 = r1.compareTo(r2);
        if (c1 == 0) {
            return c2 == 0;
        }
        if (c1 < 0) {
            return c2 >= 0;
        }
        return c2 <= 0;
    }

    @CheckForNull
    private NodeDocument getCommitRoot(@Nonnull Revision rev) {
        String commitRootPath;
        if (this.getLocalRevisions().containsKey(rev)) {
            return this;
        }
        String depth = (String)this.getLocalCommitRoot().get(rev);
        if (depth != null) {
            commitRootPath = this.getPathAtDepth(depth);
        } else {
            if (this.containsRevision(rev)) {
                return this;
            }
            commitRootPath = this.getCommitRootPath(rev);
            if (commitRootPath == null) {
                return null;
            }
        }
        return this.store.find(Collection.NODES, Utils.getIdFromPath(commitRootPath));
    }

    @Nonnull
    private String getPathAtDepth(@Nonnull String depth) {
        if (((String)Preconditions.checkNotNull((Object)depth)).equals("0")) {
            return "/";
        }
        String p = this.getPath();
        return PathUtils.getAncestorPath(p, PathUtils.getDepth(p) - Integer.parseInt(depth));
    }

    @CheckForNull
    private String getCommitRootDepth(@Nonnull Revision revision) {
        String depth;
        block1: {
            NodeDocument prev;
            SortedMap<Revision, String> local = this.getLocalCommitRoot();
            depth = (String)local.get(revision);
            if (depth != null) break block1;
            Iterator<NodeDocument> i$ = this.getPreviousDocs(COMMIT_ROOT, revision).iterator();
            while (i$.hasNext() && (depth = (prev = i$.next()).getCommitRootDepth(revision)) == null) {
            }
        }
        return depth;
    }

    private boolean isCommitted(@Nonnull RevisionContext context, @Nonnull Revision revision, @Nullable String commitValue, @Nonnull Revision readRevision) {
        if (commitValue == null) {
            commitValue = this.getCommitValue(revision);
        }
        if (commitValue == null) {
            return false;
        }
        if (Utils.isCommitted(commitValue)) {
            if (context.getBranches().getBranch(readRevision) == null && !readRevision.isBranch()) {
                return !Utils.isRevisionNewer(context, revision = Utils.resolveCommitRevision(revision, commitValue), readRevision);
            }
            if (commitValue.equals(this.getCommitValue(readRevision.asTrunkRevision()))) {
                return !Utils.isRevisionNewer(context, revision, readRevision);
            }
        } else if (Revision.fromString(commitValue).getClusterId() != context.getClusterId()) {
            return false;
        }
        return NodeDocument.includeRevision(context, Utils.resolveCommitRevision(revision, commitValue), readRevision);
    }

    @CheckForNull
    private String getCommitValue(Revision revision) {
        String value;
        block1: {
            NodeDocument prev;
            value = (String)this.getLocalRevisions().get(revision);
            if (value != null) break block1;
            Iterator<NodeDocument> i$ = this.getPreviousDocs(REVISIONS, revision).iterator();
            while (i$.hasNext() && (value = (prev = i$.next()).getCommitValue(revision)) == null) {
            }
        }
        return value;
    }

    private static boolean includeRevision(RevisionContext context, Revision x, Revision requestRevision) {
        Branch b = context.getBranches().getBranch(x);
        if (b != null) {
            if (b.containsCommit(requestRevision)) {
                return x.equalsIgnoreBranch(requestRevision) || Utils.isRevisionNewer(context, requestRevision, x);
            }
            return false;
        }
        b = context.getBranches().getBranch(requestRevision);
        if (b != null) {
            requestRevision = b.getBase(requestRevision);
        }
        return context.getRevisionComparator().compare(requestRevision, x) >= 0;
    }

    @Nonnull
    private Value getLatestValue(@Nonnull RevisionContext context, @Nonnull Map<Revision, String> valueMap, @Nullable Revision min, @Nonnull Revision readRevision, @Nonnull Map<Revision, String> validRevisions, @Nonnull LastRevs lastRevs) {
        for (Map.Entry<Revision, String> entry : valueMap.entrySet()) {
            NodeDocument commitRoot;
            Revision propRev = entry.getKey();
            String commitValue = validRevisions.get(propRev);
            if (commitValue == null && ((commitRoot = this.getCommitRoot(propRev)) == null || (commitValue = commitRoot.getCommitValue(propRev)) == null)) continue;
            Revision commitRev = Utils.resolveCommitRevision(propRev, commitValue);
            if (Utils.isCommitted(commitValue)) {
                lastRevs.update(commitRev);
            } else {
                lastRevs.updateBranch(commitRev.asBranchRevision());
            }
            if (min != null && Utils.isRevisionNewer(context, min, commitRev) || !this.isValidRevision(context, propRev, commitValue, readRevision, validRevisions)) continue;
            return new Value(commitRev, entry.getValue());
        }
        Revision r = min != null ? min : readRevision;
        return new Value(r, null);
    }

    @Override
    public String getPath() {
        String p = (String)this.get(PATH);
        if (p != null) {
            return p;
        }
        return Utils.getPathFromId(this.getId());
    }

    @Nonnull
    private Map<Revision, String> getDeleted() {
        return ValueMap.create(this, DELETED);
    }

    public String asString() {
        JsopBuilder json = new JsopBuilder();
        NodeDocument.toJson(json, this.data);
        return ((Object)json).toString();
    }

    private static void toJson(JsopWriter json, Map<? extends Object, Object> map) {
        for (Map.Entry<? extends Object, Object> e : map.entrySet()) {
            json.key(e.getKey().toString());
            Object value = e.getValue();
            if (value == null) {
                json.value(null);
                continue;
            }
            if (value instanceof Boolean) {
                json.value((Boolean)value);
                continue;
            }
            if (value instanceof Long) {
                json.value((Long)value);
                continue;
            }
            if (value instanceof Integer) {
                json.value(((Integer)value).intValue());
                continue;
            }
            if (value instanceof Map) {
                json.object();
                NodeDocument.toJson(json, (Map)value);
                json.endObject();
                continue;
            }
            if (value instanceof Revision) {
                json.value(value.toString());
                continue;
            }
            json.value((String)value);
        }
    }

    public static NodeDocument fromString(DocumentStore store, String s) {
        JsopTokenizer json = new JsopTokenizer(s);
        NodeDocument doc = new NodeDocument(store);
        while (!json.matches(0)) {
            String k = json.readString();
            json.read(58);
            if (json.matches(0)) break;
            doc.put(k, NodeDocument.fromJson(json));
            json.matches(44);
        }
        return doc;
    }

    private static Object fromJson(JsopTokenizer json) {
        switch (json.read()) {
            case 5: {
                return null;
            }
            case 3: {
                return true;
            }
            case 4: {
                return false;
            }
            case 2: {
                return Long.parseLong(json.getToken());
            }
            case 1: {
                return json.getToken();
            }
            case 123: {
                TreeMap<Revision, Object> map = new TreeMap<Revision, Object>(StableRevisionComparator.REVERSE);
                while (!json.matches(125)) {
                    String k = json.readString();
                    json.read(58);
                    map.put(Revision.fromString(k), NodeDocument.fromJson(json));
                    json.matches(44);
                }
                return map;
            }
        }
        throw new IllegalArgumentException(json.readRawValue());
    }

    static {
        NULL.seal();
        LOG = LoggerFactory.getLogger(NodeDocument.class);
        EMPTY_RANGE_MAP = Maps.unmodifiableNavigableMap(new TreeMap());
    }

    private static final class Value {
        final Revision revision;
        final String value;

        Value(@Nonnull Revision revision, @Nullable String value) {
            this.revision = (Revision)Preconditions.checkNotNull((Object)revision);
            this.value = value;
        }
    }

    public static final class Children
    implements CacheValue,
    Cloneable {
        ArrayList<String> childNames = new ArrayList();
        boolean isComplete;

        @Override
        public int getMemory() {
            int size = 114;
            for (String name : this.childNames) {
                size += name.length() * 2 + 56;
            }
            return size;
        }

        public Children clone() {
            try {
                Children clone = (Children)super.clone();
                clone.childNames = (ArrayList)this.childNames.clone();
                return clone;
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException();
            }
        }

        public String asString() {
            JsopBuilder json = new JsopBuilder();
            if (this.isComplete) {
                json.key("isComplete").value(true);
            }
            if (this.childNames.size() > 0) {
                json.key("children").array();
                for (String c : this.childNames) {
                    json.value(c);
                }
                json.endArray();
            }
            return ((Object)json).toString();
        }

        public static Children fromString(String s) {
            JsopTokenizer json = new JsopTokenizer(s);
            Children children = new Children();
            while (!json.matches(0)) {
                String k = json.readString();
                json.read(58);
                if ("isComplete".equals(k)) {
                    children.isComplete = json.read() == 3;
                } else if ("children".equals(k)) {
                    json.read(91);
                    while (!json.matches(93)) {
                        String value = json.readString();
                        children.childNames.add(value);
                        json.matches(44);
                    }
                }
                if (json.matches(0)) break;
                json.read(44);
            }
            return children;
        }
    }

    public static enum SplitDocType {
        NONE(-1),
        DEFAULT(10),
        DEFAULT_NO_CHILD(20),
        PROP_COMMIT_ONLY(30),
        INTERMEDIATE(40),
        DEFAULT_LEAF(50),
        COMMIT_ROOT_ONLY(60);

        final int type;

        private SplitDocType(int type) {
            this.type = type;
        }

        public int typeCode() {
            return this.type;
        }

        static SplitDocType valueOf(Integer type) {
            if (type == null) {
                return NONE;
            }
            for (SplitDocType docType : SplitDocType.values()) {
                if (docType.type != type) continue;
                return docType;
            }
            throw new IllegalArgumentException("Not a valid SplitDocType :" + type);
        }
    }
}

