/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.plugins.document.util.Utils;
import org.apache.jackrabbit.oak.stats.Clock;

public class Revision {
    private static volatile long lastTimestamp;
    private static volatile long lastRevisionTimestamp;
    private static volatile int lastRevisionCount;
    private final long timestamp;
    private final int counter;
    private final int clusterId;
    private final boolean branch;
    private static Clock clock;

    static void setClock(Clock c) {
        Preconditions.checkNotNull((Object)c);
        clock = c;
    }

    static void resetClockToDefault() {
        clock = Clock.SIMPLE;
        lastTimestamp = clock.getTime();
        lastRevisionTimestamp = clock.getTime();
    }

    public Revision(long timestamp, int counter, int clusterId) {
        this(timestamp, counter, clusterId, false);
    }

    public Revision(long timestamp, int counter, int clusterId, boolean branch) {
        this.timestamp = timestamp;
        this.counter = counter;
        this.clusterId = clusterId;
        this.branch = branch;
    }

    int compareRevisionTime(Revision other) {
        int comp;
        if (this.clusterId != other.clusterId) {
            throw new IllegalArgumentException("Trying to compare revisions of different cluster ids: " + this + " and " + other);
        }
        int n = this.timestamp < other.timestamp ? -1 : (comp = this.timestamp > other.timestamp ? 1 : 0);
        if (comp == 0) {
            comp = this.counter < other.counter ? -1 : (this.counter > other.counter ? 1 : 0);
        }
        return comp;
    }

    int compareRevisionTimeThenClusterId(Revision other) {
        int comp;
        int n = this.timestamp < other.timestamp ? -1 : (comp = this.timestamp > other.timestamp ? 1 : 0);
        if (comp == 0) {
            int n2 = this.counter < other.counter ? -1 : (comp = this.counter > other.counter ? 1 : 0);
        }
        if (comp == 0) {
            comp = this.compareClusterId(other);
        }
        return comp;
    }

    int compareTo(Revision other) {
        int comp = this.compareRevisionTimeThenClusterId(other);
        if (comp == 0 && this.branch != other.branch) {
            return this.branch ? -1 : 1;
        }
        return comp;
    }

    int compareClusterId(Revision other) {
        return this.clusterId < other.clusterId ? -1 : (this.clusterId > other.clusterId ? 1 : 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Revision newRevision(int clusterId) {
        long timestamp = Revision.getCurrentTimestamp();
        Class<Revision> clazz = Revision.class;
        synchronized (Revision.class) {
            int c;
            if (timestamp < lastRevisionTimestamp) {
                timestamp = lastRevisionTimestamp;
            }
            if (timestamp == lastRevisionTimestamp) {
                c = ++lastRevisionCount;
            } else {
                lastRevisionTimestamp = timestamp;
                c = 0;
                lastRevisionCount = 0;
            }
            // ** MonitorExit[var4_2] (shouldn't be in output)
            return new Revision(timestamp, c, clusterId);
        }
    }

    public static long getCurrentTimestamp() {
        long timestamp = System.currentTimeMillis();
        if (clock != null) {
            timestamp = clock.getTime();
        }
        if (timestamp < lastTimestamp) {
            timestamp = lastTimestamp;
        } else if (timestamp > lastTimestamp) {
            lastTimestamp = timestamp;
        }
        return timestamp;
    }

    public static long getTimestampDifference(Revision r1, Revision r2) {
        return r1.getTimestamp() - r2.getTimestamp();
    }

    public static Revision fromString(String rev) {
        boolean isBranch = false;
        if (rev.startsWith("b")) {
            isBranch = true;
            rev = rev.substring(1);
        }
        if (!rev.startsWith("r")) {
            throw new IllegalArgumentException(rev);
        }
        int idxCount = rev.indexOf(45);
        if (idxCount < 0) {
            throw new IllegalArgumentException(rev);
        }
        int idxClusterId = rev.indexOf(45, idxCount + 1);
        if (idxClusterId < 0) {
            throw new IllegalArgumentException(rev);
        }
        String t = rev.substring(1, idxCount);
        long timestamp = Long.parseLong(t, 16);
        t = rev.substring(idxCount + 1, idxClusterId);
        int c = Integer.parseInt(t, 16);
        t = rev.substring(idxClusterId + 1);
        int clusterId = Integer.parseInt(t, 16);
        return new Revision(timestamp, c, clusterId, isBranch);
    }

    public String toString() {
        return this.toStringBuilder(new StringBuilder()).toString();
    }

    public StringBuilder toStringBuilder(StringBuilder sb) {
        if (this.branch) {
            sb.append('b');
        }
        sb.append('r');
        sb.append(Long.toHexString(this.timestamp)).append('-');
        if (this.counter < 10) {
            sb.append(this.counter);
        } else {
            sb.append(Integer.toHexString(this.counter));
        }
        sb.append('-');
        if (this.clusterId < 10) {
            sb.append(this.clusterId);
        } else {
            sb.append(Integer.toHexString(this.clusterId));
        }
        return sb;
    }

    public String toReadableString() {
        StringBuilder buff = new StringBuilder();
        buff.append("revision: \"").append(this.toString()).append("\"");
        buff.append(", clusterId: ").append(this.clusterId);
        buff.append(", time: \"").append(Utils.timestampToString(this.timestamp)).append("\"");
        if (this.counter > 0) {
            buff.append(", counter: ").append(this.counter);
        }
        if (this.branch) {
            buff.append(", branch: true");
        }
        return buff.toString();
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public int getCounter() {
        return this.counter;
    }

    public boolean isBranch() {
        return this.branch;
    }

    public Revision asBranchRevision() {
        if (this.isBranch()) {
            return this;
        }
        return new Revision(this.timestamp, this.counter, this.clusterId, true);
    }

    public Revision asTrunkRevision() {
        if (!this.isBranch()) {
            return this;
        }
        return new Revision(this.timestamp, this.counter, this.clusterId);
    }

    public int hashCode() {
        return (int)(this.timestamp >>> 32) ^ (int)this.timestamp ^ this.counter ^ this.clusterId;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (other.getClass() != this.getClass()) {
            return false;
        }
        Revision r = (Revision)other;
        return r.timestamp == this.timestamp && r.counter == this.counter && r.clusterId == this.clusterId && r.branch == this.branch;
    }

    public boolean equalsIgnoreBranch(Revision other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        return other.timestamp == this.timestamp && other.counter == this.counter && other.clusterId == this.clusterId;
    }

    public int getClusterId() {
        return this.clusterId;
    }

    public static class RevisionComparator
    implements Comparator<Revision> {
        static final Revision NEWEST = new Revision(Long.MAX_VALUE, 0, 0);
        static final Revision FUTURE = new Revision(Long.MAX_VALUE, Integer.MAX_VALUE, 0);
        private final ConcurrentMap<Integer, List<RevisionRange>> map = new ConcurrentHashMap<Integer, List<RevisionRange>>();
        private long oldestTimestamp;
        private final int currentClusterNodeId;

        RevisionComparator(int currentClusterNodId) {
            this.currentClusterNodeId = currentClusterNodId;
        }

        public void purge(long timestamp) {
            this.oldestTimestamp = timestamp;
            Iterator i$ = this.map.keySet().iterator();
            while (i$.hasNext()) {
                List list;
                List<RevisionRange> newList;
                int clusterId = (Integer)i$.next();
                while (!((newList = this.purge(list = (List)this.map.get(clusterId))) == null ? this.map.remove(clusterId, list) : newList == list || this.map.replace(clusterId, list, newList))) {
                }
            }
        }

        private List<RevisionRange> purge(List<RevisionRange> list) {
            int i;
            for (i = 0; i < list.size(); ++i) {
                RevisionRange r = list.get(i);
                if (r.seenAt.getTimestamp() > this.oldestTimestamp) break;
            }
            if (i > list.size() - 1) {
                return null;
            }
            if (i == 0) {
                return list;
            }
            return new ArrayList<RevisionRange>(list.subList(i, list.size()));
        }

        public void add(Revision r, Revision seenAt) {
            ArrayList<RevisionRange> newList;
            List list;
            int clusterId = r.getClusterId();
            do {
                if ((list = (List)this.map.get(clusterId)) == null) {
                    newList = new ArrayList<RevisionRange>();
                } else {
                    RevisionRange last = (RevisionRange)list.get(list.size() - 1);
                    if (last.seenAt.equals(seenAt)) {
                        if (r.compareRevisionTime(last.revision) > 0) {
                            last.revision = r;
                        }
                        return;
                    }
                    if (last.revision.compareRevisionTime(r) > 0) {
                        throw new IllegalArgumentException("Can not add an earlier revision: " + last.revision + " > " + r + "; current cluster node is " + this.currentClusterNodeId);
                    }
                    newList = new ArrayList(list);
                }
                RevisionRange range = new RevisionRange();
                range.seenAt = seenAt;
                range.revision = r;
                newList.add(range);
            } while (!(list == null ? this.map.putIfAbsent(clusterId, newList) == null : this.map.replace(clusterId, list, newList)));
        }

        public long getMinimumTimestamp(@Nonnull Revision revision, @Nonnull Map<Integer, Long> inactive) {
            long timestamp = ((Revision)Preconditions.checkNotNull((Object)revision)).getTimestamp();
            Revision seenAt = this.getRevisionSeen(revision);
            if (seenAt == null) {
                return timestamp;
            }
            block0: for (Map.Entry e : this.map.entrySet()) {
                if (revision.getClusterId() == this.currentClusterNodeId && (Integer)e.getKey() == this.currentClusterNodeId) continue;
                List list = (List)e.getValue();
                for (int i = list.size() - 1; i >= 0; --i) {
                    RevisionRange range = (RevisionRange)list.get(i);
                    if (range.seenAt.compareRevisionTimeThenClusterId(seenAt) > 0) continue;
                    Long inactiveSince = inactive.get(range.revision.getClusterId());
                    if (inactiveSince != null && revision.getTimestamp() > inactiveSince && range.revision.getTimestamp() < inactiveSince) continue block0;
                    timestamp = Math.min(timestamp, range.revision.getTimestamp());
                    continue block0;
                }
            }
            return timestamp;
        }

        @Override
        public int compare(Revision o1, Revision o2) {
            if (o1.getClusterId() == o2.getClusterId()) {
                return o1.compareRevisionTime(o2);
            }
            Revision range1 = this.getRevisionSeen(o1);
            Revision range2 = this.getRevisionSeen(o2);
            if (range1 == FUTURE && range2 == FUTURE) {
                return o1.compareTo(o2);
            }
            if (range1 == null && range2 == null) {
                return o1.compareTo(o2);
            }
            if (range1 == null) {
                return -1;
            }
            if (range2 == null) {
                return 1;
            }
            int comp = range1.compareTo(range2);
            if (comp != 0) {
                return comp;
            }
            return Integer.signum(o1.getClusterId() - o2.getClusterId());
        }

        Revision getRevisionSeen(Revision r) {
            List list = (List)this.map.get(r.getClusterId());
            if (list == null) {
                if (r.getTimestamp() <= this.oldestTimestamp) {
                    return null;
                }
                if (r.getClusterId() != this.currentClusterNodeId) {
                    return FUTURE;
                }
                return null;
            }
            RevisionRange range = null;
            for (int i = list.size() - 1; i >= 0; --i) {
                range = (RevisionRange)list.get(i);
                int compare = r.compareRevisionTime(range.revision);
                if (compare == 0) {
                    return range.seenAt;
                }
                if (compare <= 0) continue;
                if (i == list.size() - 1) {
                    if (r.getClusterId() == this.currentClusterNodeId) {
                        return NEWEST;
                    }
                    return FUTURE;
                }
                return ((RevisionRange)list.get((int)(i + 1))).seenAt;
            }
            if (range != null && r.getTimestamp() > this.oldestTimestamp) {
                return range.seenAt;
            }
            return null;
        }

        public String toString() {
            StringBuilder buff = new StringBuilder();
            Iterator i$ = new TreeSet(this.map.keySet()).iterator();
            while (i$.hasNext()) {
                int clusterId = (Integer)i$.next();
                int i = 0;
                buff.append(clusterId).append(":");
                for (RevisionRange r : (List)this.map.get(clusterId)) {
                    if (i++ % 4 == 0) {
                        buff.append('\n');
                    }
                    buff.append(" ").append(r);
                }
                buff.append("\n");
            }
            return buff.toString();
        }
    }

    static class RevisionRange {
        Revision revision;
        Revision seenAt;

        RevisionRange() {
        }

        public String toString() {
            return this.revision + ":" + this.seenAt;
        }
    }
}

