/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import com.google.common.collect.PeekingIterator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.plugins.document.BackgroundWriteStats;
import org.apache.jackrabbit.oak.plugins.document.Collection;
import org.apache.jackrabbit.oak.plugins.document.Commit;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeStore;
import org.apache.jackrabbit.oak.plugins.document.NodeDocument;
import org.apache.jackrabbit.oak.plugins.document.PathComparator;
import org.apache.jackrabbit.oak.plugins.document.Revision;
import org.apache.jackrabbit.oak.plugins.document.UpdateOp;
import org.apache.jackrabbit.oak.plugins.document.util.MapFactory;
import org.apache.jackrabbit.oak.plugins.document.util.Utils;
import org.apache.jackrabbit.oak.stats.Clock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class UnsavedModifications {
    private static final Logger LOG = LoggerFactory.getLogger(UnsavedModifications.class);
    static final int BACKGROUND_MULTI_UPDATE_LIMIT = 10000;
    private final ConcurrentMap<String, Revision> map = MapFactory.getInstance().create();

    UnsavedModifications() {
    }

    @CheckForNull
    public Revision put(@Nonnull String path, @Nonnull Revision revision) {
        block2: {
            Revision previous;
            Preconditions.checkNotNull((Object)path);
            Preconditions.checkNotNull((Object)revision);
            while (true) {
                if ((previous = (Revision)this.map.get(path)) == null) {
                    if (this.map.putIfAbsent(path, revision) != null) continue;
                    return null;
                }
                if (previous.compareRevisionTime(revision) >= 0) break block2;
                if (this.map.replace(path, previous, revision)) break;
            }
            return previous;
        }
        return null;
    }

    @CheckForNull
    public Revision get(String path) {
        return (Revision)this.map.get(path);
    }

    @Nonnull
    public java.util.Collection<String> getPaths() {
        return this.map.keySet();
    }

    @Nonnull
    public Iterable<String> getPaths(final @Nonnull Revision start) {
        if (this.map.isEmpty()) {
            return Collections.emptyList();
        }
        return Iterables.transform((Iterable)Iterables.filter(this.map.entrySet(), (Predicate)new Predicate<Map.Entry<String, Revision>>(){

            public boolean apply(Map.Entry<String, Revision> input) {
                return start.compareRevisionTime(input.getValue()) < 1;
            }
        }), (Function)new Function<Map.Entry<String, Revision>, String>(){

            public String apply(Map.Entry<String, Revision> input) {
                return input.getKey();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BackgroundWriteStats persist(@Nonnull DocumentNodeStore store, @Nonnull Lock lock) {
        TreeMap pending;
        BackgroundWriteStats stats = new BackgroundWriteStats();
        if (this.map.size() == 0) {
            return stats;
        }
        Preconditions.checkNotNull((Object)store);
        Preconditions.checkNotNull((Object)lock);
        Clock clock = store.getClock();
        long time = clock.getTime();
        lock.lock();
        stats.lock = clock.getTime() - time;
        time = clock.getTime();
        try {
            pending = Maps.newTreeMap(PathComparator.INSTANCE);
            pending.putAll(this.map);
        }
        finally {
            lock.unlock();
        }
        stats.num = pending.size();
        UpdateOp updateOp = null;
        Revision lastRev = null;
        PeekingIterator paths = Iterators.peekingIterator(pending.keySet().iterator());
        int i = 0;
        ArrayList<String> pathList = new ArrayList<String>();
        while (paths.hasNext()) {
            String p = (String)paths.peek();
            Revision r = (Revision)pending.get(p);
            int size = pathList.size();
            if (updateOp == null) {
                Commit commit = new Commit(store, r, null, null);
                updateOp = commit.getUpdateOperationForNode(p);
                NodeDocument.setLastRev(updateOp, r);
                lastRev = r;
                pathList.add(p);
                paths.next();
                ++i;
            } else if (r.equals(lastRev)) {
                pathList.add(p);
                paths.next();
                ++i;
            }
            if (i + 2 <= pending.size() && size != pathList.size() && pathList.size() < 10000) continue;
            ArrayList<String> ids = new ArrayList<String>();
            for (String path : pathList) {
                ids.add(Utils.getIdFromPath(path));
            }
            store.getDocumentStore().update(Collection.NODES, ids, updateOp);
            LOG.debug("Updated _lastRev to {} on {}", (Object)lastRev, ids);
            for (String path : pathList) {
                this.map.remove(path, lastRev);
            }
            pathList.clear();
            updateOp = null;
            lastRev = null;
        }
        stats.write = clock.getTime() - time;
        return stats;
    }

    public String toString() {
        return this.map.toString();
    }
}

