/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document.persistentCache;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.plugins.document.persistentCache.CacheMap;
import org.apache.jackrabbit.oak.plugins.document.persistentCache.MultiGenerationMap;
import org.apache.jackrabbit.oak.plugins.document.persistentCache.PersistentCache;
import org.apache.jackrabbit.oak.spi.blob.BlobStore;
import org.apache.jackrabbit.oak.spi.blob.GarbageCollectableBlobStore;
import org.h2.mvstore.MVMap;
import org.h2.mvstore.StreamStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlobCache
implements BlobStore,
GarbageCollectableBlobStore,
PersistentCache.GenerationCache {
    static final Logger LOG = LoggerFactory.getLogger(BlobCache.class);
    private final GarbageCollectableBlobStore base;
    private final PersistentCache cache;
    private final MultiGenerationMap<String, byte[]> meta;
    private MultiGenerationMap<Long, byte[]> data;
    private StreamStore streamStore;
    private long maxEntrySize;

    public BlobCache(PersistentCache cache, GarbageCollectableBlobStore base) {
        this.cache = cache;
        this.base = base;
        this.data = new MultiGenerationMap();
        this.meta = new MultiGenerationMap();
        this.maxEntrySize = cache.getMaxBinaryEntrySize();
    }

    @Override
    public void addGeneration(int generation, boolean readOnly) {
        CacheMap d = this.cache.openMap(generation, "data", new MVMap.Builder());
        this.data.addReadMap(generation, d);
        CacheMap m = this.cache.openMap(generation, "meta", new MVMap.Builder());
        this.meta.addReadMap(generation, m);
        if (!readOnly) {
            this.meta.setWriteMap(m);
            this.data.setWriteMap(d);
        }
        if (this.streamStore == null) {
            this.streamStore = new StreamStore(this.data);
        }
    }

    @Override
    public void removeGeneration(int generation) {
        this.data.removeReadMap(generation);
        this.meta.removeReadMap(generation);
    }

    @Override
    public InputStream getInputStream(String blobId) throws IOException {
        if (this.streamStore == null) {
            return this.base.getInputStream(blobId);
        }
        this.cache.switchGenerationIfNeeded();
        byte[] id = this.meta.get(blobId);
        if (id == null) {
            long length = this.base.getBlobLength(blobId);
            InputStream in = this.base.getInputStream(blobId);
            if (length < this.base.getBlockSizeMin()) {
                return in;
            }
            if (length > this.maxEntrySize) {
                return in;
            }
            id = this.streamStore.put(in);
            in.close();
            this.meta.put(blobId, id);
        }
        return this.streamStore.get(id);
    }

    @Override
    public String writeBlob(InputStream in) throws IOException {
        return this.base.writeBlob(in);
    }

    @Override
    public int readBlob(String blobId, long pos, byte[] buff, int off, int length) throws IOException {
        InputStream in = this.getInputStream(blobId);
        for (long remainingSkip = pos; remainingSkip > 0L; remainingSkip -= in.skip(remainingSkip)) {
        }
        return in.read(buff, off, length);
    }

    @Override
    public long getBlobLength(String blobId) throws IOException {
        return this.base.getBlobLength(blobId);
    }

    @Override
    @CheckForNull
    public String getBlobId(@Nonnull String reference) {
        return this.base.getBlobId(reference);
    }

    @Override
    @CheckForNull
    public String getReference(@Nonnull String blobId) {
        return this.base.getReference(blobId);
    }

    @Override
    public void clearCache() {
        this.base.clearCache();
    }

    @Override
    public void clearInUse() {
        this.base.clearInUse();
    }

    @Override
    public boolean deleteChunks(List<String> arg0, long arg1) throws Exception {
        return this.base.deleteChunks(arg0, arg1);
    }

    @Override
    public Iterator<String> getAllChunkIds(long arg0) throws Exception {
        return this.base.getAllChunkIds(arg0);
    }

    @Override
    public long getBlockSizeMin() {
        return this.base.getBlockSizeMin();
    }

    @Override
    public Iterator<String> resolveChunks(String arg0) throws IOException {
        return this.base.resolveChunks(arg0);
    }

    @Override
    public void setBlockSize(int arg0) {
        this.base.setBlockSize(arg0);
    }

    @Override
    public void startMark() throws IOException {
        this.base.startMark();
    }

    @Override
    public int sweep() throws IOException {
        return this.base.sweep();
    }

    @Override
    public String writeBlob(String arg0) throws IOException {
        return this.base.writeBlob(arg0);
    }
}

